/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.extractor.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJPlugin;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a&\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a&\u0010\u0017\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006\u001a8\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019\u001a\u000e\u0010$\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u000e\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0010\u001a&\u0010'\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*\u001a\u000e\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0010\u001a\u000e\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0010\u001a,\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u0002012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205\u001a\u001a\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u001a\u000e\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u0010\u001a\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u00104\u001a\u000205\u001a\u0016\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0006\u001a&\u0010@\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0018\u0010A\u001a\u00020\u000e*\u00020\u000e2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00120C\u001a'\u0010D\u001a\u0004\u0018\u0001HE\"\u0004\b\u0000\u0010E*\u0004\u0018\u0001HE2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00120C\u00a2\u0006\u0002\u0010F\u001a\n\u0010G\u001a\u00020\u000e*\u00020\u0006\u001a\n\u0010H\u001a\u00020\u000e*\u00020\u0006\u001a\n\u0010\u0013\u001a\u00020\u0010*\u000205\u001a\n\u0010\u0013\u001a\u00020\u0010*\u00020I\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006J"}, d2={"MAJOR_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "getMAJOR_VERSION_PATTERN", "()Ljava/util/regex/Pattern;", "collectJars", "", "Ljava/io/File;", "directory", "filter", "Ljava/util/function/Predicate;", "createPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "artifact", "validatePluginXml", "", "context", "", "debug", "", "logCategory", "message", "e", "", "error", "getIdeJvmArgs", "", "options", "Lorg/gradle/process/JavaForkOptions;", "arguments", "ideDirectory", "getIdeaSystemProperties", "", "configDirectory", "systemDirectory", "pluginsDirectory", "requirePluginIds", "ideBuildNumber", "ideaDir", "path", "info", "isDependencyOnPyCharm", "dependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "isKotlinRuntime", "name", "isPyCharmType", "type", "log", "level", "Lorg/gradle/api/logging/LogLevel;", "mainSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "project", "Lorg/gradle/api/Project;", "parsePluginXml", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "pluginXml", "releaseType", "version", "sourcePluginXmlFiles", "transformXml", "document", "Lorg/jdom2/Document;", "file", "warn", "ifFalse", "block", "Lkotlin/Function0;", "ifNull", "T", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isJar", "isZip", "Lorg/gradle/api/Task;", "gradle-intellij-plugin"})
@JvmName(name="Utils")
public final class Utils {
    @NotNull
    private static final Pattern MAJOR_VERSION_PATTERN;

    @NotNull
    public static final Pattern getMAJOR_VERSION_PATTERN() {
        return MAJOR_VERSION_PATTERN;
    }

    @NotNull
    public static final SourceSet mainSourceSet(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project\n    .convention.\u2026Set.MAIN_SOURCE_SET_NAME)");
        return (SourceSet)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> sourcePluginXmlFiles(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Set set = Utils.mainSourceSet(project).getResources().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"mainSourceSet(project).resources.srcDirs");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            File file2 = new File(it, "META-INF/plugin.xml");
            boolean bl3 = false;
            boolean bl4 = false;
            File file3 = file2;
            boolean bl5 = false;
            if ((file3.exists() && file3.length() > 0L ? file2 : null) == null) continue;
            file = file;
            boolean bl6 = false;
            boolean bl7 = false;
            File it$iv$iv = file;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PluginBean parsePluginXml(@NotNull File pluginXml, @Nullable String logCategory) {
        Intrinsics.checkParameterIsNotNull((Object)pluginXml, (String)"pluginXml");
        try {
            File file = pluginXml;
            boolean bl = false;
            Document document = JDOMUtil.loadDocument((InputStream)new FileInputStream(file));
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"loadDocument(pluginXml.inputStream())");
            Document document2 = document;
            return PluginBeanExtractor.INSTANCE.extractPluginBean(document2);
        }
        catch (SAXParseException e) {
            Utils.warn(logCategory, "Cannot read: " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        catch (JDOMException e) {
            Utils.warn(logCategory, "Cannot read: " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        catch (IOException e) {
            Utils.warn(logCategory, "Cannot read: " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transformXml(@NotNull Document document, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        XMLOutputter xmlOutput = new XMLOutputter();
        Object object = xmlOutput.getFormat();
        boolean bl = false;
        boolean bl2 = false;
        Format $this$transformXml_u24lambda_u2d2 = object;
        boolean bl3 = false;
        $this$transformXml_u24lambda_u2d2.setIndent("  ");
        $this$transformXml_u24lambda_u2d2.setOmitDeclaration(true);
        $this$transformXml_u24lambda_u2d2.setTextMode(Format.TextMode.TRIM);
        object = new StringWriter();
        bl = false;
        bl2 = false;
        Throwable throwable = null;
        try {
            StringWriter it = (StringWriter)object;
            boolean bl4 = false;
            xmlOutput.output(document, (Writer)it);
            String string = it.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Map<String, String> getIdeaSystemProperties(@NotNull File configDirectory, @NotNull File systemDirectory, @NotNull File pluginsDirectory, @NotNull List<String> requirePluginIds) {
        Intrinsics.checkParameterIsNotNull((Object)configDirectory, (String)"configDirectory");
        Intrinsics.checkParameterIsNotNull((Object)systemDirectory, (String)"systemDirectory");
        Intrinsics.checkParameterIsNotNull((Object)pluginsDirectory, (String)"pluginsDirectory");
        Intrinsics.checkParameterIsNotNull(requirePluginIds, (String)"requirePluginIds");
        Object object = new Pair[]{TuplesKt.to((Object)"idea.config.path", (Object)configDirectory.getAbsolutePath()), TuplesKt.to((Object)"idea.system.path", (Object)systemDirectory.getAbsolutePath()), TuplesKt.to((Object)"idea.plugins.path", (Object)pluginsDirectory.getAbsolutePath())};
        Map result2 = MapsKt.mapOf((Pair[])object);
        object = requirePluginIds;
        boolean bl = false;
        if (!object.isEmpty()) {
            return MapsKt.plus((Map)result2, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"idea.required.plugins.id", (Object)CollectionsKt.joinToString$default((Iterable)requirePluginIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))));
        }
        return result2;
    }

    @NotNull
    public static final List<String> getIdeJvmArgs(@NotNull JavaForkOptions options, @NotNull List<String> arguments, @Nullable File ideDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        Object object = options.getMaxHeapSize();
        options.setMaxHeapSize((String)(object == null ? "512m" : object));
        object = options.getMinHeapSize();
        options.setMinHeapSize((String)(object == null ? "256m" : object));
        object = ideDirectory;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            File bootJar = new File(ideDirectory, "lib/boot.jar");
            if (bootJar.exists()) {
                return CollectionsKt.plus((Collection)arguments, (Object)("-Xbootclasspath/a:" + bootJar.getAbsolutePath()));
            }
        }
        return arguments;
    }

    @NotNull
    public static final String ideBuildNumber(@NotNull File ideDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)ideDirectory, (String)"ideDirectory");
        File file = new File(ideDirectory, "Resources/build.txt");
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        Object object = OperatingSystem.current().isMacOsX() && it.exists() ? file : null;
        object = FilesKt.readText$default((File)(object == null ? new File(ideDirectory, "build.txt") : object), null, (int)1, null);
        boolean bl4 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    @NotNull
    public static final File ideaDir(@NotNull String path) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file2 = new File(path);
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        File file3 = it;
        boolean bl4 = false;
        boolean bl5 = false;
        File it2 = file3;
        boolean bl6 = false;
        String string = it2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
        File file4 = file = !StringsKt.endsWith$default((String)string, (String)".app", (boolean)false, (int)2, null) ? file3 : null;
        return file == null ? new File(it, "Contents") : file;
    }

    public static final boolean isJar(@NotNull File $this$isJar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isJar, (String)"<this>");
        Path path = $this$isJar.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"toPath()");
        return FileUtilKt.isJar((Path)path);
    }

    public static final boolean isZip(@NotNull File $this$isZip) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isZip, (String)"<this>");
        Path path = $this$isZip.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"toPath()");
        return FileUtilKt.isZip((Path)path);
    }

    @NotNull
    public static final Collection<File> collectJars(@NotNull File directory, @NotNull Predicate<File> filter) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        if (!directory.isDirectory()) {
            collection = CollectionsKt.emptyList();
        } else {
            Collection collection2 = FileUtils.listFiles((File)directory, (IOFileFilter)((IOFileFilter)new AbstractFileFilter(filter){
                final /* synthetic */ Predicate<File> $filter;
                {
                    this.$filter = $filter;
                }

                public boolean accept(@NotNull File file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    return Utils.isJar(file) && this.$filter.test(file);
                }
            }), (IOFileFilter)FalseFileFilter.FALSE);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"filter: Predicate<File>)\u2026}, FalseFileFilter.FALSE)");
            collection = collection2;
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String releaseType(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (StringsKt.endsWith$default((String)version, (String)"-EAP-SNAPSHOT", (boolean)false, (int)2, null)) return "snapshots";
        if (StringsKt.endsWith$default((String)version, (String)"-EAP-CANDIDATE-SNAPSHOT", (boolean)false, (int)2, null)) return "snapshots";
        if (StringsKt.endsWith$default((String)version, (String)"-CUSTOM-SNAPSHOT", (boolean)false, (int)2, null)) return "snapshots";
        CharSequence charSequence = version;
        Pattern pattern = MAJOR_VERSION_PATTERN;
        boolean bl = false;
        pattern = new Regex(pattern);
        bl = false;
        if (pattern.matches(charSequence)) {
            return "snapshots";
        }
        if (!StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) return "releases";
        return "nightly";
    }

    public static final void error(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.ERROR, logCategory, message, e);
    }

    public static /* synthetic */ void error$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.error(string, string2, throwable);
    }

    public static final void warn(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.WARN, logCategory, message, e);
    }

    public static /* synthetic */ void warn$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.warn(string, string2, throwable);
    }

    public static final void info(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.INFO, logCategory, message, e);
    }

    public static /* synthetic */ void info$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.info(string, string2, throwable);
    }

    public static final void debug(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.DEBUG, logCategory, message, e);
    }

    public static /* synthetic */ void debug$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.debug(string, string2, throwable);
    }

    private static final void log(LogLevel level, String logCategory, String message, Throwable e) {
        Object object = logCategory;
        object = "gradle-intellij-plugin " + (String)(object == null ? "" : object);
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String category = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        Logger logger = Logging.getLogger(IntelliJPlugin.class);
        if (e != null && level != LogLevel.ERROR && !logger.isDebugEnabled()) {
            logger.log(level, "[" + category + "] " + message + ". Run with --debug option to get more log output.");
        } else {
            logger.log(level, "[" + category + "] " + message, e);
        }
    }

    @NotNull
    public static final String logCategory(@NotNull Project $this$logCategory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$logCategory, (String)"<this>");
        return $this$logCategory.getPath() + $this$logCategory.getName();
    }

    @NotNull
    public static final String logCategory(@NotNull Task $this$logCategory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$logCategory, (String)"<this>");
        return $this$logCategory.getProject().getPath() + $this$logCategory.getProject().getName() + $this$logCategory.getPath();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IdePlugin createPlugin(@NotNull File artifact, boolean validatePluginXml, @Nullable String context) {
        IdePlugin idePlugin;
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        Path extractDirectory = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)extractDirectory, (String)"extractDirectory");
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager(extractDirectory);
        Path path = artifact.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"artifact.toPath()");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path, validatePluginXml, "plugin.xml");
        path = creationResult;
        if (path instanceof PluginCreationSuccess) {
            idePlugin = (IdePlugin)((PluginCreationSuccess)creationResult).getPlugin();
        } else if (path instanceof PluginCreationFail) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PluginProblem it = (PluginProblem)element$iv$iv;
                boolean bl = false;
                if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String problems = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
            Utils.warn$default(context, "Cannot create plugin from file '" + artifact + "': " + problems, null, 4, null);
            idePlugin = null;
        } else {
            Utils.warn$default(context, "Cannot create plugin from file '" + artifact + "'. " + creationResult, null, 4, null);
            idePlugin = null;
        }
        return idePlugin;
    }

    public static final boolean isKotlinRuntime(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)name, (Object)"kotlin-runtime") || Intrinsics.areEqual((Object)name, (Object)"kotlin-reflect") || StringsKt.startsWith$default((String)name, (String)"kotlin-reflect-", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"kotlin-stdlib") || StringsKt.startsWith$default((String)name, (String)"kotlin-stdlib-", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"kotlin-test") || StringsKt.startsWith$default((String)name, (String)"kotlin-test-", (boolean)false, (int)2, null);
    }

    public static final boolean isDependencyOnPyCharm(@NotNull IdeaDependency dependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        return Intrinsics.areEqual((Object)dependency.getName(), (Object)"pycharmPY") || Intrinsics.areEqual((Object)dependency.getName(), (Object)"pycharmPC");
    }

    public static final boolean isPyCharmType(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"PY") || Intrinsics.areEqual((Object)type, (Object)"PC");
    }

    @Nullable
    public static final <T> T ifNull(@Nullable T $this$ifNull, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        if ($this$ifNull == null) {
            block.invoke();
        }
        return $this$ifNull;
    }

    public static final boolean ifFalse(boolean $this$ifFalse, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        if (!$this$ifFalse) {
            block.invoke();
        }
        return $this$ifFalse;
    }

    static {
        String string = "(RIDER-|GO-)?\\d{4}\\.\\d-(EAP\\d*-)?SNAPSHOT";
        int n = 0;
        boolean bl = false;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
        MAJOR_VERSION_PATTERN = pattern;
    }
}

