/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.utils;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JJ\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e2\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/intellij/utils/ArchiveUtils;", "", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/file/ArchiveOperations;Lorg/gradle/api/file/FileSystemOperations;)V", "extract", "Ljava/nio/file/Path;", "archive", "targetDirectory", "context", "", "isUpToDate", "Ljava/util/function/Predicate;", "markUpToDate", "Ljava/util/function/BiConsumer;", "gradle-intellij-plugin"})
public abstract class ArchiveUtils {
    @NotNull
    private final ArchiveOperations archiveOperations;
    @NotNull
    private final FileSystemOperations fileSystemOperations;

    @Inject
    public ArchiveUtils(@NotNull ArchiveOperations archiveOperations, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkNotNullParameter((Object)archiveOperations, (String)"archiveOperations");
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.archiveOperations = archiveOperations;
        this.fileSystemOperations = fileSystemOperations;
    }

    @NotNull
    public final Path extract(@NotNull Path archive, @NotNull Path targetDirectory, @Nullable String context, @Nullable Predicate<Path> isUpToDate, @Nullable BiConsumer<Path, Path> markUpToDate) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
            Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
            String name = FileUtilKt.getSimpleName((Path)archive);
            Path markerFile = targetDirectory.resolve("markerFile");
            Intrinsics.checkNotNullExpressionValue((Object)markerFile, (String)"markerFile");
            if (FileUtilKt.exists((Path)markerFile) && (isUpToDate == null || isUpToDate.test(markerFile))) {
                return targetDirectory;
            }
            FileUtilKt.deleteQuietly((Path)targetDirectory);
            FileUtilKt.createDir((Path)targetDirectory);
            Utils.debug$default(context, "Extracting: " + name, null, 4, null);
            if (StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".sit", (boolean)false, (int)2, null)) {
                this.fileSystemOperations.copy(new Action(this, archive, targetDirectory){
                    final /* synthetic */ ArchiveUtils this$0;
                    final /* synthetic */ Path $archive;
                    final /* synthetic */ Path $targetDirectory;
                    {
                        this.this$0 = $receiver;
                        this.$archive = $archive;
                        this.$targetDirectory = $targetDirectory;
                    }

                    public final void execute(@NotNull CopySpec $this$copy) {
                        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
                        Object[] objectArray = new Object[]{ArchiveUtils.access$getArchiveOperations$p(this.this$0).zipTree((Object)this.$archive)};
                        $this$copy.from(objectArray);
                        $this$copy.into((Object)this.$targetDirectory);
                    }
                });
            } else if (StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null)) {
                this.fileSystemOperations.copy(new Action(this, archive, targetDirectory){
                    final /* synthetic */ ArchiveUtils this$0;
                    final /* synthetic */ Path $archive;
                    final /* synthetic */ Path $targetDirectory;
                    {
                        this.this$0 = $receiver;
                        this.$archive = $archive;
                        this.$targetDirectory = $targetDirectory;
                    }

                    public final void execute(@NotNull CopySpec $this$copy) {
                        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
                        Object[] objectArray = new Object[]{ArchiveUtils.access$getArchiveOperations$p(this.this$0).tarTree((Object)this.$archive)};
                        $this$copy.from(objectArray);
                        $this$copy.into((Object)this.$targetDirectory);
                    }
                });
            } else {
                throw new IllegalArgumentException("Unknown type archive type: " + name);
            }
            Utils.debug$default(context, "Extracted: " + name, null, 4, null);
            FileUtilKt.create((Path)markerFile);
            BiConsumer<Path, Path> biConsumer = markUpToDate;
            if (biConsumer == null) break block5;
            biConsumer.accept(targetDirectory, markerFile);
        }
        return targetDirectory;
    }

    public static /* synthetic */ Path extract$default(ArchiveUtils archiveUtils, Path path, Path path2, String string, Predicate predicate, BiConsumer biConsumer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extract");
        }
        if ((n & 8) != 0) {
            predicate = null;
        }
        if ((n & 0x10) != 0) {
            biConsumer = null;
        }
        return archiveUtils.extract(path, path2, string, predicate, biConsumer);
    }

    public static final /* synthetic */ ArchiveOperations access$getArchiveOperations$p(ArchiveUtils $this) {
        return $this.archiveOperations;
    }
}

