/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tools.ant.util.TeeOutputStream;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0004J\b\u0010\u0016\u001a\u00020\tH\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/intellij/tasks/ZipSigningToolBase;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "cliPath", "Lorg/gradle/api/provider/Property;", "", "getCliPath", "()Lorg/gradle/api/provider/Property;", "context", "inputArchiveFile", "Lorg/gradle/api/file/RegularFileProperty;", "getInputArchiveFile", "()Lorg/gradle/api/file/RegularFileProperty;", "collectArguments", "", "executeZipSigningTool", "", "command", "resolveCliPath", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nZipSigningToolBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipSigningToolBase.kt\norg/jetbrains/intellij/tasks/ZipSigningToolBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public abstract class ZipSigningToolBase
extends DefaultTask {
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final String context;

    public ZipSigningToolBase(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        this.context = Utils.logCategory((Task)this);
        this.setGroup("intellij");
        this.setDescription("Signs the ZIP archive with the provided key using marketplace-zip-signer library.");
    }

    @InputFile
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getInputArchiveFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCliPath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeZipSigningTool(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String cliPath = this.resolveCliPath();
        List cliArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)command), (Iterable)this.collectArguments());
        Utils.debug$default(this.context, "Marketplace ZIP Signer CLI path: " + cliPath, null, 4, null);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ExecResult execResult;
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            try {
                execResult = this.execOperations.javaexec(new Action(this, cliPath, cliArgs, os){
                    final /* synthetic */ ZipSigningToolBase this$0;
                    final /* synthetic */ String $cliPath;
                    final /* synthetic */ List<String> $cliArgs;
                    final /* synthetic */ ByteArrayOutputStream $os;
                    {
                        this.this$0 = $receiver;
                        this.$cliPath = $cliPath;
                        this.$cliArgs = $cliArgs;
                        this.$os = $os;
                    }

                    public final void execute(@NotNull JavaExecSpec $this$javaexec) {
                        Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$this$javaexec");
                        Object[] objectArray = new Object[]{this.$cliPath};
                        $this$javaexec.setClasspath((FileCollection)ZipSigningToolBase.access$getObjectFactory$p(this.this$0).fileCollection().from(objectArray));
                        $this$javaexec.getMainClass().set((Object)"org.jetbrains.zip.signer.ZipSigningTool");
                        $this$javaexec.setArgs(this.$cliArgs);
                        $this$javaexec.setStandardOutput((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)this.$os));
                        $this$javaexec.setErrorOutput((OutputStream)new TeeOutputStream((OutputStream)System.err, (OutputStream)this.$os));
                    }
                });
            }
            catch (ExecException e) {
                Utils.error$default(this.context, "Error during Marketplace ZIP Signer CLI execution:\n" + os, null, 4, null);
                throw e;
            }
            ExecResult execResult2 = execResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String resolveCliPath() {
        String path = (String)this.getCliPath().getOrNull();
        CharSequence charSequence = path;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Path verifier = Path.of(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"verifier");
            if (FileUtilKt.exists((Path)verifier)) {
                return path;
            }
        }
        throw new InvalidUserDataException("Provided Marketplace ZIP Signer path doesn't exist.");
    }

    @NotNull
    protected List<String> collectArguments() {
        Path path;
        Object[] objectArray;
        block5: {
            block4: {
                Path path2;
                objectArray = (Object[])this.getInputArchiveFile().getOrNull();
                if (objectArray == null) break block4;
                Object[] $this$collectArguments_u24lambda_u242 = objectArray;
                boolean bl = false;
                Path it = path2 = Utils.getAsPath((FileSystemLocation)$this$collectArguments_u24lambda_u242);
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Path path3 = FileUtilKt.exists((Path)it) ? path2 : null;
                if (path3 == null) {
                    throw new InvalidUserDataException("Plugin file does not exist: " + (RegularFile)$this$collectArguments_u24lambda_u242);
                }
                path = path3;
                if (path != null) break block5;
            }
            throw new InvalidUserDataException("Input archive file is not provided.");
        }
        Path file = path;
        Utils.debug$default(this.context, "Distribution file: " + file, null, 4, null);
        objectArray = new String[]{"-in", ((Object)file.toAbsolutePath()).toString()};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public static final /* synthetic */ ObjectFactory access$getObjectFactory$p(ZipSigningToolBase $this) {
        return $this.objectFactory;
    }
}

