/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.tasks.ZipSigningToolBase;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/intellij/tasks/VerifyPluginSignatureTask;", "Lorg/jetbrains/intellij/tasks/ZipSigningToolBase;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "certificateChainFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCertificateChainFile", "()Lorg/gradle/api/file/RegularFileProperty;", "context", "", "collectArguments", "", "verifyPluginSignature", "", "gradle-intellij-plugin"})
public abstract class VerifyPluginSignatureTask
extends ZipSigningToolBase {
    @NotNull
    private final String context;

    @Inject
    public VerifyPluginSignatureTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        super(objectFactory, execOperations);
        this.context = Utils.logCategory((Task)this);
        this.setGroup("intellij");
        this.setDescription("Verifies signed ZIP archive with the provided key using marketplace-zip-signer library.");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getCertificateChainFile();

    @TaskAction
    public final void verifyPluginSignature() {
        this.executeZipSigningTool("verify");
    }

    @Override
    @NotNull
    protected List<String> collectArguments() {
        Unit unit;
        List arguments = new ArrayList();
        RegularFile regularFile = (RegularFile)this.getCertificateChainFile().getOrNull();
        if (regularFile != null) {
            RegularFile it = regularFile;
            boolean bl = false;
            arguments.add("-cert");
            arguments.add(((Object)Utils.getAsPath((FileSystemLocation)it).toAbsolutePath()).toString());
            Utils.debug$default(this.context, "Using certificate chain passed as file", null, 4, null);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new InvalidUserDataException("Certificate chain not found.");
        }
        return CollectionsKt.plus((Collection)arguments, (Iterable)super.collectArguments());
    }
}

