/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.tasks.ZipSigningToolBase;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$H\u0014J\b\u0010%\u001a\u00020&H\u0007R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0014\u0010\u001b\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000bR\u0014\u0010!\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000f\u00a8\u0006'"}, d2={"Lorg/jetbrains/intellij/tasks/SignPluginTask;", "Lorg/jetbrains/intellij/tasks/ZipSigningToolBase;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "certificateChain", "Lorg/gradle/api/provider/Property;", "", "getCertificateChain", "()Lorg/gradle/api/provider/Property;", "certificateChainFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCertificateChainFile", "()Lorg/gradle/api/file/RegularFileProperty;", "context", "keyStore", "getKeyStore", "keyStoreKeyAlias", "getKeyStoreKeyAlias", "keyStorePassword", "getKeyStorePassword", "keyStoreProviderName", "getKeyStoreProviderName", "keyStoreType", "getKeyStoreType", "outputArchiveFile", "getOutputArchiveFile", "password", "getPassword", "privateKey", "getPrivateKey", "privateKeyFile", "getPrivateKeyFile", "collectArguments", "", "signPlugin", "", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nSignPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignPluginTask.kt\norg/jetbrains/intellij/tasks/SignPluginTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public abstract class SignPluginTask
extends ZipSigningToolBase {
    @NotNull
    private final String context;

    @Inject
    public SignPluginTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        super(objectFactory, execOperations);
        this.context = Utils.logCategory((Task)this);
        this.setGroup("intellij");
        this.setDescription("Signs the ZIP archive with the provided key using marketplace-zip-signer library.");
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputArchiveFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStore();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStorePassword();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreKeyAlias();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreType();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreProviderName();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPrivateKey();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getPrivateKeyFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPassword();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCertificateChain();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getCertificateChainFile();

    @TaskAction
    public final void signPlugin() {
        this.executeZipSigningTool("sign");
    }

    @Override
    @NotNull
    protected List<String> collectArguments() {
        List arguments;
        block19: {
            String it;
            Unit unit;
            Unit unit2;
            String p0;
            byte[] p02;
            String it2;
            Object[] objectArray = new String[2];
            objectArray[0] = "-out";
            Object object = this.getOutputArchiveFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputArchiveFile.get()");
            objectArray[1] = ((Object)Utils.getAsPath((FileSystemLocation)object).toAbsolutePath()).toString();
            arguments = CollectionsKt.mutableListOf((Object[])objectArray);
            String string = (String)this.getPrivateKey().getOrNull();
            if (string != null) {
                Object $this$collectArguments_u24lambda_u242_u24lambda_u240;
                it2 = string;
                boolean bl = false;
                arguments.add("-key");
                Object object2 = Base64.getDecoder();
                try {
                    $this$collectArguments_u24lambda_u242_u24lambda_u240 = object2;
                    boolean bl2 = false;
                    p02 = ((Base64.Decoder)$this$collectArguments_u24lambda_u242_u24lambda_u240).decode(((Object)StringsKt.trim((CharSequence)it2)).toString());
                    boolean bl3 = false;
                    $this$collectArguments_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)new String(p02, Charsets.UTF_8));
                }
                catch (Throwable bl2) {
                    $this$collectArguments_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = $this$collectArguments_u24lambda_u242_u24lambda_u240;
                $this$collectArguments_u24lambda_u242_u24lambda_u240 = it2;
                p0 = (String)(Result.isFailure-impl((Object)object2) ? $this$collectArguments_u24lambda_u242_u24lambda_u240 : object2);
                boolean bl4 = false;
                arguments.add(p0);
                Utils.debug$default(this.context, "Using private key passed as content", null, 4, null);
                unit2 = Unit.INSTANCE;
            } else {
                RegularFile regularFile = (RegularFile)this.getPrivateKeyFile().getOrNull();
                if (regularFile != null) {
                    RegularFile it3 = regularFile;
                    boolean bl5 = false;
                    arguments.add("-key-file");
                    arguments.add(((Object)Utils.getAsPath((FileSystemLocation)it3).toAbsolutePath()).toString());
                    Utils.debug$default(this.context, "Using private key passed as file", null, 4, null);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
            }
            if (unit2 == null) {
                throw new InvalidUserDataException("Private key not found. One of the 'privateKey' or 'privateKeyFile' properties has to be provided.");
            }
            String string2 = (String)this.getCertificateChain().getOrNull();
            if (string2 != null) {
                Object $this$collectArguments_u24lambda_u247_u24lambda_u245;
                it2 = string2;
                boolean bl = false;
                arguments.add("-cert");
                Object bl5 = Base64.getDecoder();
                try {
                    $this$collectArguments_u24lambda_u247_u24lambda_u245 = bl5;
                    boolean bl6 = false;
                    p02 = ((Base64.Decoder)$this$collectArguments_u24lambda_u247_u24lambda_u245).decode(((Object)StringsKt.trim((CharSequence)it2)).toString());
                    boolean bl7 = false;
                    $this$collectArguments_u24lambda_u247_u24lambda_u245 = Result.constructor-impl((Object)new String(p02, Charsets.UTF_8));
                }
                catch (Throwable bl6) {
                    $this$collectArguments_u24lambda_u247_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl6));
                }
                bl5 = $this$collectArguments_u24lambda_u247_u24lambda_u245;
                $this$collectArguments_u24lambda_u247_u24lambda_u245 = it2;
                p0 = (String)(Result.isFailure-impl((Object)bl5) ? $this$collectArguments_u24lambda_u247_u24lambda_u245 : bl5);
                boolean bl8 = false;
                arguments.add(p0);
                Utils.debug$default(this.context, "Using certificate chain passed as content", null, 4, null);
                unit = Unit.INSTANCE;
            } else {
                RegularFile regularFile = (RegularFile)this.getCertificateChainFile().getOrNull();
                if (regularFile != null) {
                    RegularFile it4 = regularFile;
                    boolean bl = false;
                    arguments.add("-cert-file");
                    arguments.add(((Object)Utils.getAsPath((FileSystemLocation)it4).toAbsolutePath()).toString());
                    Utils.debug$default(this.context, "Using certificate chain passed as file", null, 4, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (unit == null) {
                throw new InvalidUserDataException("Certificate chain not found. One of the 'certificateChain' or 'certificateChainFile' properties has to be provided.");
            }
            String string3 = (String)this.getPassword().getOrNull();
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                arguments.add("-key-pass");
                arguments.add(it);
                Utils.debug$default(this.context, "Using private key password", null, 4, null);
            }
            String string4 = (String)this.getKeyStore().getOrNull();
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                arguments.add("-ks");
                arguments.add(it);
            }
            String string5 = (String)this.getKeyStorePassword().getOrNull();
            if (string5 != null) {
                it = string5;
                boolean bl = false;
                arguments.add("-ks-pass");
                arguments.add(it);
            }
            String string6 = (String)this.getKeyStoreKeyAlias().getOrNull();
            if (string6 != null) {
                it = string6;
                boolean bl = false;
                arguments.add("-ks-key-alias");
                arguments.add(it);
            }
            String string7 = (String)this.getKeyStoreType().getOrNull();
            if (string7 != null) {
                it = string7;
                boolean bl = false;
                arguments.add("-ks-type");
                arguments.add(it);
            }
            String string8 = (String)this.getKeyStoreProviderName().getOrNull();
            if (string8 == null) break block19;
            it = string8;
            boolean bl = false;
            arguments.add("-ks-provider-name");
            arguments.add(it);
        }
        return CollectionsKt.plus((Collection)arguments, (Iterable)super.collectArguments());
    }
}

