/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.model.PerformanceTestResult;
import org.jetbrains.intellij.model.PerformanceTestScript;
import org.jetbrains.intellij.model.PerformanceTestStatistic;
import org.jetbrains.intellij.performanceTest.ProfilerName;
import org.jetbrains.intellij.performanceTest.TestExecutionFailException;
import org.jetbrains.intellij.performanceTest.parsers.IdeaLogParser;
import org.jetbrains.intellij.performanceTest.parsers.SimpleIJPerformanceParser;
import org.jetbrains.intellij.propertyProviders.PerformanceTestArgumentProvider;
import org.jetbrains.intellij.tasks.RunIdeBase;
import org.jetbrains.intellij.tasks.RunIdePerformanceTestTask;

@Incubating
@UntrackedTask(because="Should always run IDE for performance tests")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0017R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/intellij/tasks/RunIdePerformanceTestTask;", "Lorg/jetbrains/intellij/tasks/RunIdeBase;", "()V", "artifactsDir", "Lorg/gradle/api/provider/Property;", "", "getArtifactsDir", "()Lorg/gradle/api/provider/Property;", "context", "profilerName", "Lorg/jetbrains/intellij/performanceTest/ProfilerName;", "getProfilerName", "testDataDir", "getTestDataDir", "exec", "", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nRunIdePerformanceTestTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunIdePerformanceTestTask.kt\norg/jetbrains/intellij/tasks/RunIdePerformanceTestTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1855#2,2:120\n*S KotlinDebug\n*F\n+ 1 RunIdePerformanceTestTask.kt\norg/jetbrains/intellij/tasks/RunIdePerformanceTestTask\n*L\n111#1:120,2\n*E\n"})
public abstract class RunIdePerformanceTestTask
extends RunIdeBase {
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public RunIdePerformanceTestTask() {
        this.setGroup("intellij");
        this.setDescription("Runs performance tests on the IDE with the developed plugin installed.");
    }

    @Input
    @NotNull
    public abstract Property<String> getTestDataDir();

    @Input
    @NotNull
    public abstract Property<String> getArtifactsDir();

    @Input
    @NotNull
    public abstract Property<ProfilerName> getProfilerName();

    @Override
    @TaskAction
    public void exec() {
        Path path = Paths.get((String)this.getArtifactsDir().get(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(artifactsDir.get())");
        Path dir = FileUtilKt.createDir((Path)path);
        Path testData = Path.of((String)this.getTestDataDir().get(), new String[0]);
        List testExecutionResults = new ArrayList();
        Files.walk(testData, 1, new FileVisitOption[0]).filter(exec.1.INSTANCE).forEach(new Consumer(dir, this, testExecutionResults){
            final /* synthetic */ Path $dir;
            final /* synthetic */ RunIdePerformanceTestTask this$0;
            final /* synthetic */ List<PerformanceTestResult> $testExecutionResults;
            {
                this.$dir = $dir;
                this.this$0 = $receiver;
                this.$testExecutionResults = $testExecutionResults;
            }

            public final void accept(Path scriptPath) {
                Intrinsics.checkNotNullExpressionValue((Object)scriptPath, (String)"scriptPath");
                String testName = FileUtilKt.getNameWithoutExtension((Path)scriptPath);
                PerformanceTestScript testScript = new SimpleIJPerformanceParser(scriptPath).parse();
                Path path = this.$dir.resolve(testName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dir.resolve(testName)");
                Path testArtifactsDirPath = FileUtilKt.createDir((Path)path);
                this.this$0.setArgs(CollectionsKt.listOf((Object)(this.this$0.getTestDataDir().get() + "/" + testScript.getProjectName())));
                List list = this.this$0.getJvmArgumentProviders();
                String string = ((ProfilerName)((Object)this.this$0.getProfilerName().get())).name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                list.add(new PerformanceTestArgumentProvider(scriptPath, testArtifactsDirPath, string));
                RunIdePerformanceTestTask.access$exec$s1804108720(this.this$0);
                PerformanceTestStatistic performanceTestStatistic = new IdeaLogParser(((Object)testArtifactsDirPath.resolve("idea.log").toAbsolutePath()).toString()).getTestStatistic();
                RunIdePerformanceTestTask runIdePerformanceTestTask = this.this$0;
                List<PerformanceTestResult> list2 = this.$testExecutionResults;
                PerformanceTestStatistic testResults = performanceTestStatistic;
                boolean bl = false;
                Utils.info$default(RunIdePerformanceTestTask.access$getContext$p(runIdePerformanceTestTask), "Total time " + testResults.getTotalTime() + "ms, expected time ms " + testScript.getAssertionTimeout() + "ms", null, 4, null);
                if (testScript.getAssertionTimeout() != null) {
                    Long l = testResults.getTotalTime();
                    Intrinsics.checkNotNull((Object)l);
                    if (l > testScript.getAssertionTimeout()) {
                        list2.add(new PerformanceTestResult(testName, testResults, testScript));
                    }
                }
            }
        });
        if (!((Collection)testExecutionResults).isEmpty()) {
            Iterable $this$forEach$iv = testExecutionResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PerformanceTestResult it = (PerformanceTestResult)element$iv;
                boolean bl = false;
                Utils.error$default(this.context, "TEST `" + it.getTestName() + "` FAILED", null, 4, null);
                Utils.error$default(this.context, "Expected time of execution `" + it.getScript().getAssertionTimeout() + "ms`, but was " + it.getStatistic().getTotalTime() + "ms", null, 4, null);
            }
            throw new TestExecutionFailException(testExecutionResults.size() + " test(s) failed");
        }
    }

    public static final /* synthetic */ void access$exec$s1804108720(RunIdePerformanceTestTask $this) {
        super.exec();
    }

    public static final /* synthetic */ String access$getContext$p(RunIdePerformanceTestTask $this) {
        return $this.context;
    }
}

