/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyImpl;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.ArchiveUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ(\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0012\u0010 \u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0002J\u001e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u0010'\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)J\u001a\u0010*\u001a\u0004\u0018\u00010\u00152\u0006\u0010+\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/intellij/dependency/PluginDependencyManager;", "", "gradleHomePath", "", "ideaDependencyProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "pluginsRepositories", "", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "context", "(Ljava/lang/String;Lorg/gradle/api/provider/Provider;Ljava/util/List;Lorg/jetbrains/intellij/utils/ArchiveUtils;Ljava/lang/String;)V", "cacheDirectoryPath", "ivyArtifactRepository", "Lorg/gradle/api/artifacts/repositories/IvyArtifactRepository;", "mavenCacheDirectoryPath", "pluginSources", "", "externalPluginDependency", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "artifact", "Ljava/nio/file/Path;", "channel", "maven", "", "findSingleDirectory", "dir", "generateIvyFile", "", "plugin", "groupId", "register", "project", "Lorg/gradle/api/Project;", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "registerRepositoryIfNeeded", "resolve", "dependency", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "zippedPluginDependency", "pluginFile", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nPluginDependencyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDependencyManager.kt\norg/jetbrains/intellij/dependency/PluginDependencyManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1#2:167\n1855#3,2:168\n661#3,11:170\n*S KotlinDebug\n*F\n+ 1 PluginDependencyManager.kt\norg/jetbrains/intellij/dependency/PluginDependencyManager\n*L\n55#1:168,2\n106#1:170,11\n*E\n"})
public abstract class PluginDependencyManager {
    @NotNull
    private final Provider<IdeaDependency> ideaDependencyProvider;
    @NotNull
    private final List<PluginsRepository> pluginsRepositories;
    @NotNull
    private final ArchiveUtils archiveUtils;
    @Nullable
    private final String context;
    @NotNull
    private final String mavenCacheDirectoryPath;
    @NotNull
    private final String cacheDirectoryPath;
    @NotNull
    private final Set<String> pluginSources;
    @Nullable
    private IvyArtifactRepository ivyArtifactRepository;

    @Inject
    public PluginDependencyManager(@NotNull String gradleHomePath, @NotNull Provider<IdeaDependency> ideaDependencyProvider, @NotNull List<? extends PluginsRepository> pluginsRepositories, @NotNull ArchiveUtils archiveUtils, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)gradleHomePath, (String)"gradleHomePath");
        Intrinsics.checkNotNullParameter(ideaDependencyProvider, (String)"ideaDependencyProvider");
        Intrinsics.checkNotNullParameter(pluginsRepositories, (String)"pluginsRepositories");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        this.ideaDependencyProvider = ideaDependencyProvider;
        this.pluginsRepositories = pluginsRepositories;
        this.archiveUtils = archiveUtils;
        this.context = context;
        String[] stringArray = new String[]{"caches/modules-2/files-2.1"};
        this.mavenCacheDirectoryPath = ((Object)Paths.get(gradleHomePath, stringArray)).toString();
        stringArray = new String[]{"com.jetbrains.intellij.idea"};
        this.cacheDirectoryPath = ((Object)Paths.get(this.mavenCacheDirectoryPath, stringArray)).toString();
        this.pluginSources = new LinkedHashSet();
    }

    @Nullable
    public final PluginDependency resolve(@NotNull Project project, @NotNull PluginDependencyNotation dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Object object = this.ideaDependencyProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaDependencyProvider.get()");
        IdeaDependency ideaDependency = (IdeaDependency)object;
        Object object2 = dependency.getVersion();
        if ((object2 == null || object2.length() == 0) && ((object2 = (CharSequence)dependency.getChannel()) == null || object2.length() == 0)) {
            if (Paths.get(dependency.getId(), new String[0]).isAbsolute()) {
                Path path = Path.of(dependency.getId(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(dependency.id)");
                return PluginDependencyManager.externalPluginDependency$default(this, path, null, false, 6, null);
            }
            Utils.info$default(this.context, "Looking for builtin '" + dependency.getId() + "' in: " + ideaDependency.getClasses().getCanonicalPath(), null, 4, null);
            object2 = ideaDependency.getPluginsRegistry().findPlugin(dependency.getId());
            if (object2 != null) {
                String string;
                Object it = object2;
                boolean bl = false;
                String string2 = string = "-withSources";
                String string3 = ideaDependency.getBuildNumber();
                String string4 = ideaDependency.getName();
                boolean bl2 = false;
                boolean bl3 = ideaDependency.getSources() != null;
                String string5 = bl3 ? string : null;
                if (string5 == null) {
                    string5 = "";
                }
                String builtinPluginVersion = string4 + "-" + string3 + string5;
                String string6 = PathsKt.getName((Path)it);
                String string7 = dependency.getId();
                File file = it.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.toFile()");
                return new PluginDependencyImpl(string6, string7, builtinPluginVersion, file, true, false, 32, null);
            }
            throw new BuildException("Cannot find builtin plugin '" + dependency.getId() + "' for IDE: " + ideaDependency.getClasses().getCanonicalPath(), null);
        }
        Iterable $this$forEach$iv = this.pluginsRepositories;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginDependency pluginDependency2;
            PluginsRepository repository = (PluginsRepository)element$iv;
            boolean bl = false;
            File file = repository.resolve(project, dependency, this.context);
            if (file == null) continue;
            File it = file;
            boolean bl4 = false;
            Path file2 = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            if (FileUtilKt.isZip((Path)file2)) {
                pluginDependency2 = this.zippedPluginDependency(file2, dependency);
            } else if (FileUtilKt.isJar((Path)file2)) {
                pluginDependency2 = this.externalPluginDependency(file2, dependency.getChannel(), true);
            } else {
                throw new BuildException("Invalid type of downloaded plugin: " + FileUtilKt.getSimpleName((Path)file2), null);
            }
            return pluginDependency2;
        }
        Object $i$f$forEach22 = object2 = " from channel '" + dependency.getChannel() + "'";
        String string = dependency.getVersion();
        String string8 = dependency.getId();
        boolean bl = false;
        boolean bl5 = dependency.getChannel() != null;
        Object object3 = bl5 ? object2 : null;
        if (object3 == null) {
            object3 = "";
        }
        Throwable throwable = null;
        String string9 = "Cannot resolve plugin '" + string8 + "' in version '" + string + "'" + (String)object3;
        throw new BuildException(string9, throwable);
    }

    public final void register(@NotNull Project project, @NotNull PluginDependency plugin, @NotNull DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (plugin.getMaven()) {
            Path path = plugin.getArtifact().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"plugin.artifact.toPath()");
            if (FileUtilKt.isJar((Path)path)) {
                dependencies.add((Object)plugin.getNotation().toDependency(project));
                return;
            }
        }
        this.registerRepositoryIfNeeded(project, plugin);
        this.generateIvyFile(plugin);
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        dependencies.add((Object)DependencyHandlerExtensionsKt.create$default((DependencyHandler)dependencyHandler, (String)this.groupId(plugin.getChannel()), (String)plugin.getId(), (String)plugin.getVersion(), (String)"compile", null, null, (int)48, null));
    }

    private final PluginDependency zippedPluginDependency(Path pluginFile, PluginDependencyNotation dependency) {
        Path path = FilesKt.resolve((File)new File(this.cacheDirectoryPath, this.groupId(dependency.getChannel())), (String)(dependency.getId() + "-" + dependency.getVersion())).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"File(cacheDirectoryPath,\u2026dency.version}\").toPath()");
        Path pluginDir = this.findSingleDirectory(ArchiveUtils.extract$default(this.archiveUtils, pluginFile, path, this.context, null, null, 24, null));
        return this.externalPluginDependency(pluginDir, dependency.getChannel(), true);
    }

    private final String groupId(String channel) {
        CharSequence charSequence = channel;
        return charSequence == null || charSequence.length() == 0 ? "unzipped.com.jetbrains.plugins" : "unzipped." + channel + ".com.jetbrains.plugins";
    }

    private final Path findSingleDirectory(Path dir) {
        Object v1;
        block3: {
            Iterable $this$singleOrNull$iv = FileUtilKt.listFiles((Path)dir);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                if (found$iv) {
                    v1 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        Path path = v1;
        if (path == null) {
            throw new BuildException("Single directory expected in: " + dir, null);
        }
        return path;
    }

    private final void registerRepositoryIfNeeded(Project project, PluginDependency plugin) {
        block3: {
            Path artifactParent;
            Object object = this.ideaDependencyProvider.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaDependencyProvider.get()");
            IdeaDependency ideaDependency = (IdeaDependency)object;
            if (this.ivyArtifactRepository == null) {
                this.ivyArtifactRepository = project.getRepositories().ivy(new Action(plugin, this, ideaDependency){
                    final /* synthetic */ PluginDependency $plugin;
                    final /* synthetic */ PluginDependencyManager this$0;
                    final /* synthetic */ IdeaDependency $ideaDependency;
                    {
                        this.$plugin = $plugin;
                        this.this$0 = $receiver;
                        this.$ideaDependency = $ideaDependency;
                    }

                    public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                        Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$this$ivy");
                        String string = this.$plugin.getFqn().substring((this.$plugin.getId() + "-" + this.$plugin.getVersion()).length());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        String ivyFileSuffix = string;
                        $this$ivy.ivyPattern(PluginDependencyManager.access$getCacheDirectoryPath$p(this.this$0) + "/[organisation]/[module]-[revision]" + ivyFileSuffix + ".[ext]");
                        File it = this.$ideaDependency.getClasses();
                        boolean bl = false;
                        $this$ivy.artifactPattern(it + "/plugins/[module]/[artifact](.[ext])");
                        $this$ivy.artifactPattern(it + "/[artifact](.[ext])");
                        $this$ivy.artifactPattern(PluginDependencyManager.access$getCacheDirectoryPath$p(this.this$0) + "(/[classifier])/[module]-[revision]/[artifact](.[ext])");
                        if (this.$ideaDependency.getSources() != null) {
                            $this$ivy.artifactPattern(this.$ideaDependency.getSources().getParent() + "/[artifact]-" + this.$ideaDependency.getVersion() + "(-[classifier]).[ext]");
                        }
                    }
                });
            }
            if (plugin.getBuiltin() || plugin.getMaven() || Intrinsics.areEqual((Object)(artifactParent = plugin.getArtifact().toPath().getParent()).getParent(), (Object)Path.of(this.cacheDirectoryPath, new String[0]))) break block3;
            Intrinsics.checkNotNullExpressionValue((Object)artifactParent, (String)"artifactParent");
            if (this.pluginSources.add(((Object)artifactParent.toAbsolutePath()).toString())) {
                IvyArtifactRepository ivyArtifactRepository = this.ivyArtifactRepository;
                if (ivyArtifactRepository != null) {
                    ivyArtifactRepository.artifactPattern(artifactParent + "/[artifact](.[ext])");
                }
            }
        }
    }

    private final void generateIvyFile(PluginDependency plugin) {
        Path path;
        Object object = this.ideaDependencyProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaDependencyProvider.get()");
        IdeaDependency ideaDependency = (IdeaDependency)object;
        Path baseDir = plugin.getBuiltin() ? plugin.getArtifact().toPath() : plugin.getArtifact().toPath().getParent();
        String pluginFqn = plugin.getFqn();
        String groupId = this.groupId(plugin.getChannel());
        Path it = path = Path.of(this.cacheDirectoryPath, new String[0]).resolve(groupId).resolve(pluginFqn + ".xml");
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Path path2 = !FileUtilKt.exists((Path)it) ? path : null;
        if (path2 == null) {
            return;
        }
        Path ivyFile = path2;
        IntelliJIvyDescriptorFileGenerator.IvyCoordinates identity = new IntelliJIvyDescriptorFileGenerator.IvyCoordinates(groupId, plugin.getId(), plugin.getVersion());
        IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator(identity).addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
        Intrinsics.checkNotNullExpressionValue((Object)baseDir, (String)"baseDir");
        intelliJIvyDescriptorFileGenerator.addCompileArtifacts(plugin, baseDir, groupId).addSourceArtifacts(ideaDependency, plugin, baseDir, groupId).writeTo(ivyFile);
    }

    private final PluginDependency externalPluginDependency(Path artifact, String channel, boolean maven) {
        IdePlugin idePlugin;
        if (!FileUtilKt.isJar((Path)artifact)) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(artifact, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Utils.warn$default(this.context, "Cannot create plugin from file '" + artifact + "' - only directories or jars are supported", null, 4, null);
            }
        }
        if ((idePlugin = Utils.createPlugin(artifact, true, this.context)) != null) {
            PluginDependencyImpl pluginDependencyImpl;
            IdePlugin it = idePlugin;
            boolean bl = false;
            String string = it.getPluginId();
            if (string == null) {
                return null;
            }
            String pluginId = string;
            String string2 = it.getPluginVersion();
            if (string2 == null) {
                return null;
            }
            String pluginVersion = string2;
            File file = artifact.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.toFile()");
            PluginDependencyImpl $this$externalPluginDependency_u24lambda_u248_u24lambda_u247 = pluginDependencyImpl = new PluginDependencyImpl(pluginId, pluginId, pluginVersion, file, false, maven);
            boolean bl2 = false;
            $this$externalPluginDependency_u24lambda_u248_u24lambda_u247.setChannel(channel);
            IdeVersion ideVersion = it.getSinceBuild();
            $this$externalPluginDependency_u24lambda_u248_u24lambda_u247.setSinceBuild(ideVersion != null ? ideVersion.asStringWithoutProductCode() : null);
            IdeVersion ideVersion2 = it.getUntilBuild();
            $this$externalPluginDependency_u24lambda_u248_u24lambda_u247.setUntilBuild(ideVersion2 != null ? ideVersion2.asStringWithoutProductCode() : null);
            return pluginDependencyImpl;
        }
        return null;
    }

    static /* synthetic */ PluginDependency externalPluginDependency$default(PluginDependencyManager pluginDependencyManager, Path path, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: externalPluginDependency");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pluginDependencyManager.externalPluginDependency(path, string, bl);
    }

    public static final /* synthetic */ String access$getCacheDirectoryPath$p(PluginDependencyManager $this) {
        return $this.cacheDirectoryPath;
    }
}

