/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u00103\u001a\u00020\t2\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u001c\u0010!\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010\u0018R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u001c\u0010)\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0012\"\u0004\b+\u0010\u0014R \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001d\"\u0004\b.\u0010\u001fR\u001c\u0010/\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0012\u00a8\u0006;"}, d2={"Lorg/jetbrains/intellij/dependency/PluginDependencyImpl;", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "id", "", "platformPluginId", "version", "artifact", "Ljava/io/File;", "builtin", "", "maven", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;ZZ)V", "getArtifact", "()Ljava/io/File;", "getBuiltin", "()Z", "channel", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "classesDirectory", "getClassesDirectory", "setClassesDirectory", "(Ljava/io/File;)V", "getId", "jarFiles", "", "getJarFiles", "()Ljava/util/Collection;", "setJarFiles", "(Ljava/util/Collection;)V", "getMaven", "metaInfDirectory", "getMetaInfDirectory", "setMetaInfDirectory", "notation", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "getNotation", "()Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "getPlatformPluginId", "sinceBuild", "getSinceBuild", "setSinceBuild", "sourceJarFiles", "getSourceJarFiles", "setSourceJarFiles", "untilBuild", "getUntilBuild", "setUntilBuild", "getVersion", "equals", "other", "", "hashCode", "", "isCompatible", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nPluginDependencyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDependencyImpl.kt\norg/jetbrains/intellij/dependency/PluginDependencyImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1549#2:98\n1620#2,3:99\n1549#2:102\n1620#2,3:103\n1#3:106\n*S KotlinDebug\n*F\n+ 1 PluginDependencyImpl.kt\norg/jetbrains/intellij/dependency/PluginDependencyImpl\n*L\n35#1:98\n35#1:99,3\n36#1:102\n36#1:103,3\n*E\n"})
public final class PluginDependencyImpl
implements PluginDependency {
    @NotNull
    private final String id;
    @Nullable
    private final String platformPluginId;
    @NotNull
    private final String version;
    @NotNull
    private final File artifact;
    private final boolean builtin;
    private final boolean maven;
    @Nullable
    private String channel;
    @NotNull
    private Collection<? extends File> jarFiles;
    @NotNull
    private Collection<? extends File> sourceJarFiles;
    @Nullable
    private File classesDirectory;
    @Nullable
    private File metaInfDirectory;
    @NotNull
    private final PluginDependencyNotation notation;
    @Nullable
    private String sinceBuild;
    @Nullable
    private String untilBuild;

    public PluginDependencyImpl(@NotNull String id, @Nullable String platformPluginId, @NotNull String version2, @NotNull File artifact, boolean builtin, boolean maven) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        this.id = id;
        this.platformPluginId = platformPluginId;
        this.version = version2;
        this.artifact = artifact;
        this.builtin = builtin;
        this.maven = maven;
        this.jarFiles = CollectionsKt.emptyList();
        this.sourceJarFiles = CollectionsKt.emptyList();
        this.notation = new PluginDependencyNotation(this.getId(), this.getVersion(), this.getChannel());
        Path path = this.getArtifact().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"artifact.toPath()");
        if (FileUtilKt.isJar((Path)path)) {
            this.setJarFiles(CollectionsKt.listOf((Object)this.getArtifact()));
        }
        if (this.getArtifact().isDirectory()) {
            File metaInf;
            File classes;
            File lib = new File(this.getArtifact(), "lib");
            if (lib.isDirectory()) {
                Path it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Path path2 = lib.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"lib.toPath()");
                Iterable iterable = Utils.collectJars$default(path2, null, 2, null);
                PluginDependencyImpl pluginDependencyImpl = this;
                boolean $i$f$map = false;
                void var10_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Path path3 = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toFile());
                }
                pluginDependencyImpl.setJarFiles((List)destination$iv$iv);
                Path path4 = lib.toPath().resolve("src");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"lib.toPath().resolve(\"src\")");
                $this$map$iv = Utils.collectJars$default(path4, null, 2, null);
                pluginDependencyImpl = this;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toFile());
                }
                pluginDependencyImpl.setSourceJarFiles((List)destination$iv$iv);
            }
            if ((classes = FilesKt.resolve((File)this.getArtifact(), (String)"classes")).isDirectory()) {
                this.setClassesDirectory(classes);
            }
            if ((metaInf = FilesKt.resolve((File)this.getArtifact(), (String)"META-INF")).isDirectory()) {
                this.setMetaInfDirectory(metaInf);
            }
        }
    }

    public /* synthetic */ PluginDependencyImpl(String string, String string2, String string3, File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(string, string2, string3, file, bl, bl2);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getPlatformPluginId() {
        return this.platformPluginId;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public File getArtifact() {
        return this.artifact;
    }

    @Override
    public boolean getBuiltin() {
        return this.builtin;
    }

    @Override
    public boolean getMaven() {
        return this.maven;
    }

    @Override
    @Nullable
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(@Nullable String string) {
        this.channel = string;
    }

    @Override
    @NotNull
    public Collection<File> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.jarFiles = collection;
    }

    @Override
    @NotNull
    public Collection<File> getSourceJarFiles() {
        return this.sourceJarFiles;
    }

    public void setSourceJarFiles(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.sourceJarFiles = collection;
    }

    @Override
    @Nullable
    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(@Nullable File file) {
        this.classesDirectory = file;
    }

    @Override
    @Nullable
    public File getMetaInfDirectory() {
        return this.metaInfDirectory;
    }

    public void setMetaInfDirectory(@Nullable File file) {
        this.metaInfDirectory = file;
    }

    @Override
    @NotNull
    public PluginDependencyNotation getNotation() {
        return this.notation;
    }

    @Nullable
    public final String getSinceBuild() {
        return this.sinceBuild;
    }

    public final void setSinceBuild(@Nullable String string) {
        this.sinceBuild = string;
    }

    @Nullable
    public final String getUntilBuild() {
        return this.untilBuild;
    }

    public final void setUntilBuild(@Nullable String string) {
        this.untilBuild = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCompatible(@NotNull IdeVersion ideVersion) {
        boolean bl;
        String it;
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        String string = this.sinceBuild;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            if (IdeVersion.createIdeVersion((String)it).compareTo(ideVersion) > 0) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        String string2 = this.untilBuild;
        if (string2 == null) return true;
        it = string2;
        boolean bl3 = false;
        if (ideVersion.compareTo(IdeVersion.createIdeVersion((String)it)) > 0) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.intellij.dependency.PluginDependencyImpl");
        PluginDependencyImpl cfr_ignored_0 = (PluginDependencyImpl)other;
        if (!Intrinsics.areEqual((Object)this.getId(), (Object)((PluginDependencyImpl)other).getId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPlatformPluginId(), (Object)((PluginDependencyImpl)other).getPlatformPluginId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getVersion(), (Object)((PluginDependencyImpl)other).getVersion())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getArtifact(), (Object)((PluginDependencyImpl)other).getArtifact())) {
            return false;
        }
        if (this.getBuiltin() != ((PluginDependencyImpl)other).getBuiltin()) {
            return false;
        }
        if (this.getMaven() != ((PluginDependencyImpl)other).getMaven()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getChannel(), (Object)((PluginDependencyImpl)other).getChannel())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getJarFiles(), ((PluginDependencyImpl)other).getJarFiles())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getSourceJarFiles(), ((PluginDependencyImpl)other).getSourceJarFiles())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getClassesDirectory(), (Object)((PluginDependencyImpl)other).getClassesDirectory())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMetaInfDirectory(), (Object)((PluginDependencyImpl)other).getMetaInfDirectory())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getNotation(), (Object)((PluginDependencyImpl)other).getNotation())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sinceBuild, (Object)((PluginDependencyImpl)other).sinceBuild)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.untilBuild, (Object)((PluginDependencyImpl)other).untilBuild);
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        String string = this.getPlatformPluginId();
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + this.getVersion().hashCode();
        result = 31 * result + this.getArtifact().hashCode();
        result = 31 * result + Boolean.hashCode(this.getBuiltin());
        result = 31 * result + Boolean.hashCode(this.getMaven());
        String string2 = this.getChannel();
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        result = 31 * result + ((Object)this.getJarFiles()).hashCode();
        result = 31 * result + ((Object)this.getSourceJarFiles()).hashCode();
        File file = this.getClassesDirectory();
        result = 31 * result + (file != null ? ((Object)file).hashCode() : 0);
        File file2 = this.getMetaInfDirectory();
        result = 31 * result + (file2 != null ? ((Object)file2).hashCode() : 0);
        result = 31 * result + this.getNotation().hashCode();
        String string3 = this.sinceBuild;
        result = 31 * result + (string3 != null ? string3.hashCode() : 0);
        String string4 = this.untilBuild;
        result = 31 * result + (string4 != null ? string4.hashCode() : 0);
        return result;
    }
}

