/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.MavenRepository;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/dependency/MavenRepositoryPlugin;", "Lorg/jetbrains/intellij/dependency/MavenRepository;", "repositoryUrl", "", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "(Ljava/lang/String;Lorg/jetbrains/intellij/utils/DependenciesDownloader;)V", "resolvedDependency", "", "getResolvedDependency", "()Z", "setResolvedDependency", "(Z)V", "postResolve", "", "project", "Lorg/gradle/api/Project;", "context", "resolve", "Ljava/io/File;", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "gradle-intellij-plugin"})
public final class MavenRepositoryPlugin
implements MavenRepository {
    @NotNull
    private final String repositoryUrl;
    @NotNull
    private final DependenciesDownloader dependenciesDownloader;
    private boolean resolvedDependency;

    public MavenRepositoryPlugin(@NotNull String repositoryUrl, @NotNull DependenciesDownloader dependenciesDownloader) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.repositoryUrl = repositoryUrl;
        this.dependenciesDownloader = dependenciesDownloader;
    }

    @Override
    public boolean getResolvedDependency() {
        return this.resolvedDependency;
    }

    @Override
    public void setResolvedDependency(boolean bl) {
        this.resolvedDependency = bl;
    }

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Dependency dependency = plugin.toDependency(project);
        RepositoryHandler repositoryHandler = project.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryHandler, (String)"project.repositories");
        MavenArtifactRepository mavenRepository2 = DependenciesDownloaderKt.mavenRepository$default(repositoryHandler, this.repositoryUrl, null, 2, null);
        return this.getPluginFile(project, this.dependenciesDownloader, dependency, mavenRepository2, this.repositoryUrl, context);
    }

    @Override
    public void postResolve(@NotNull Project project, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.postResolve(project, (Function0<Unit>)((Function0)new Function0<Unit>(context, this, project){
            final /* synthetic */ String $context;
            final /* synthetic */ MavenRepositoryPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                Utils.debug$default(this.$context, "Adding Maven plugins repository: " + MavenRepositoryPlugin.access$getRepositoryUrl$p(this.this$0), null, 4, null);
                RepositoryHandler repositoryHandler = this.$project.getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoryHandler, (String)"project.repositories");
                DependenciesDownloaderKt.mavenRepository$default(repositoryHandler, MavenRepositoryPlugin.access$getRepositoryUrl$p(this.this$0), null, 2, null);
            }
        }));
    }

    public static final /* synthetic */ String access$getRepositoryUrl$p(MavenRepositoryPlugin $this) {
        return $this.repositoryUrl;
    }
}

