/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.internal.xml.SimpleXmlWriter;
import org.gradle.internal.xml.XmlTransformer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdePluginSourceZipFilesProvider;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.PluginDependency;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0007J\u001e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\tJ(\u0010\u001b\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010$\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0017J\f\u0010(\u001a\u00020!*\u00020)H\u0002J\f\u0010*\u001a\u00020!*\u00020)H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator;", "", "coordinates", "Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$IvyCoordinates;", "(Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$IvyCoordinates;)V", "artifacts", "", "Lorg/gradle/api/publish/ivy/IvyArtifact;", "configurations", "Lorg/gradle/api/publish/ivy/IvyConfiguration;", "ivyDateFormat", "Ljava/text/SimpleDateFormat;", "ivyDatePattern", "", "ivyFileEncoding", "xmlTransformer", "Lorg/gradle/internal/xml/XmlTransformer;", "addArtifact", "ivyArtifact", "addCompileArtifacts", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "baseDir", "Ljava/nio/file/Path;", "groupId", "addConfiguration", "ivyConfiguration", "addSourceArtifacts", "ideaDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "usesClassifier", "", "writeDescriptor", "", "writer", "Ljava/io/Writer;", "writeTo", "file", "Ljava/io/File;", "path", "writeConfigurations", "Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$OptionalAttributeXmlWriter;", "writePublications", "IvyCoordinates", "OptionalAttributeXmlWriter", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nIntelliJIvyDescriptorFileGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJIvyDescriptorFileGenerator.kt\norg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1855#2,2:181\n1855#2,2:183\n1549#2:185\n1620#2,3:186\n1747#2,3:190\n1855#2,2:193\n1855#2,2:195\n1#3:189\n*S KotlinDebug\n*F\n+ 1 IntelliJIvyDescriptorFileGenerator.kt\norg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator\n*L\n46#1:181,2\n63#1:183,2\n69#1:185\n69#1:186,3\n127#1:190,3\n132#1:193,2\n147#1:195,2\n*E\n"})
public final class IntelliJIvyDescriptorFileGenerator {
    @NotNull
    private final IvyCoordinates coordinates;
    @NotNull
    private final String ivyFileEncoding;
    @NotNull
    private final String ivyDatePattern;
    @NotNull
    private final SimpleDateFormat ivyDateFormat;
    @NotNull
    private final XmlTransformer xmlTransformer;
    @NotNull
    private final List<IvyConfiguration> configurations;
    @NotNull
    private final List<IvyArtifact> artifacts;

    public IntelliJIvyDescriptorFileGenerator(@NotNull IvyCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.coordinates = coordinates;
        this.ivyFileEncoding = "UTF-8";
        this.ivyDatePattern = "yyyyMMddHHmmss";
        this.ivyDateFormat = new SimpleDateFormat(this.ivyDatePattern);
        this.xmlTransformer = new XmlTransformer();
        this.configurations = new ArrayList();
        this.artifacts = new ArrayList();
    }

    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addConfiguration(@NotNull IvyConfiguration ivyConfiguration) {
        Intrinsics.checkNotNullParameter((Object)ivyConfiguration, (String)"ivyConfiguration");
        this.configurations.add(ivyConfiguration);
        return this;
    }

    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addArtifact(@NotNull IvyArtifact ivyArtifact) {
        Intrinsics.checkNotNullParameter((Object)ivyArtifact, (String)"ivyArtifact");
        this.artifacts.add(ivyArtifact);
        return this;
    }

    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addCompileArtifacts(@NotNull PluginDependency plugin, @NotNull Path baseDir, @NotNull String groupId) {
        block2: {
            File it;
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            DefaultIvyConfiguration compileConfiguration = new DefaultIvyConfiguration("compile");
            this.addConfiguration((IvyConfiguration)compileConfiguration);
            Iterable $this$forEach$iv = plugin.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl = false;
                Path path = it2.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
                String string = compileConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
                this.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(path, string, baseDir, groupId));
            }
            File file = plugin.getClassesDirectory();
            if (file != null) {
                it = file;
                boolean bl = false;
                Path path = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
                String string = compileConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
                this.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(path, string, baseDir, groupId));
            }
            File file2 = plugin.getMetaInfDirectory();
            if (file2 == null) break block2;
            it = file2;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
            String string = compileConfiguration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
            this.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(path, string, baseDir, groupId));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addSourceArtifacts(@Nullable IdeaDependency ideaDependency, @NotNull PluginDependency plugin, @NotNull Path baseDir, @NotNull String groupId) {
        block8: {
            Object object;
            Object object2;
            Object it;
            Object object3;
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            DefaultIvyConfiguration sourcesConfiguration = new DefaultIvyConfiguration("sources");
            this.addConfiguration((IvyConfiguration)sourcesConfiguration);
            if (!plugin.getSourceJarFiles().isEmpty()) {
                Iterable $this$forEach$iv = plugin.getSourceJarFiles();
                boolean $i$f$forEach = false;
                object3 = $this$forEach$iv.iterator();
                while (object3.hasNext()) {
                    Object element$iv = object3.next();
                    it = (File)element$iv;
                    boolean bl = false;
                    Path path = ((File)it).toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
                    String string = sourcesConfiguration.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcesConfiguration.name");
                    this.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(path, string, baseDir, groupId));
                }
            } else if (ideaDependency != null && (object2 = ideaDependency.getSourceZipFiles()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                object3 = (Iterable)object2;
                boolean $i$f$map2 = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.toPath());
                }
                it = (List)destination$iv$iv;
                boolean bl = false;
                object3 = IdePluginSourceZipFilesProvider.INSTANCE.getSourceZips((Collection)it, plugin.getPlatformPluginId());
                if (object3 != null) {
                    Object it3 = object3;
                    boolean bl2 = false;
                    String string = sourcesConfiguration.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcesConfiguration.name");
                    Path path = ideaDependency.getClasses().toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ideaDependency.classes.toPath()");
                    IvyArtifact $i$f$map2 = IntellijIvyArtifact.Companion.createZipDependency$default(IntellijIvyArtifact.Companion, (Path)it3, string, path, null, 8, null);
                    if ($i$f$map2 != null) {
                        IvyArtifact p0 = $i$f$map2;
                        boolean bl3 = false;
                        this.addArtifact(p0);
                    }
                }
            }
            if (ideaDependency == null || (object2 = ideaDependency.getSources()) == null) break block8;
            Object it4 = object3 = object2;
            boolean bl = false;
            Object object4 = object = plugin.getBuiltin() ? object3 : null;
            if (object != null) {
                it4 = object;
                boolean bl4 = false;
                String name = Utils.isDependencyOnPyCharm(ideaDependency) ? "pycharmPC" : "ideaIC";
                Path path = ((File)it4).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
                IntellijIvyArtifact artifact = new IntellijIvyArtifact(path, name, "jar", "sources", "sources");
                artifact.setConf(sourcesConfiguration.getName());
                this.addArtifact(artifact);
            }
        }
        return this;
    }

    @Deprecated(message="Use writeTo(path: Path) instead")
    public final void writeTo(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.xmlTransformer.transform(file, this.ivyFileEncoding, new Action(this){
            final /* synthetic */ IntelliJIvyDescriptorFileGenerator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull Writer $this$transform) {
                Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$this$transform");
                try {
                    IntelliJIvyDescriptorFileGenerator.access$writeDescriptor(this.this$0, $this$transform);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    public final void writeTo(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.xmlTransformer.transform(path.toFile(), this.ivyFileEncoding, new Action(this){
            final /* synthetic */ IntelliJIvyDescriptorFileGenerator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull Writer $this$transform) {
                Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$this$transform");
                try {
                    IntelliJIvyDescriptorFileGenerator.access$writeDescriptor(this.this$0, $this$transform);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    private final void writeDescriptor(Writer writer) throws IOException {
        OptionalAttributeXmlWriter $this$writeDescriptor_u24lambda_u249 = new OptionalAttributeXmlWriter(writer, "  ", this.ivyFileEncoding);
        boolean bl = false;
        $this$writeDescriptor_u24lambda_u249.startElement("ivy-module").attribute("version", "2.0");
        if (this.usesClassifier()) {
            $this$writeDescriptor_u24lambda_u249.attribute("xmlns:m", "https://ant.apache.org/ivy/maven");
        }
        $this$writeDescriptor_u24lambda_u249.startElement("info").attribute("organisation", this.coordinates.getOrganisation()).attribute("module", this.coordinates.getModule()).attribute("revision", this.coordinates.getRevision()).attribute("publication", this.ivyDateFormat.format(new Date()));
        $this$writeDescriptor_u24lambda_u249.endElement();
        this.writeConfigurations($this$writeDescriptor_u24lambda_u249);
        this.writePublications($this$writeDescriptor_u24lambda_u249);
        $this$writeDescriptor_u24lambda_u249.endElement();
    }

    private final boolean usesClassifier() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.artifacts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IvyArtifact it = (IvyArtifact)element$iv;
                    boolean bl2 = false;
                    if (!(it.getClassifier() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void writeConfigurations(OptionalAttributeXmlWriter $this$writeConfigurations) throws IOException {
        $this$writeConfigurations.startElement("configurations");
        Iterable $this$forEach$iv = this.configurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IvyConfiguration it = (IvyConfiguration)element$iv;
            boolean bl = false;
            $this$writeConfigurations.startElement("conf").attribute("name", it.getName()).attribute("visibility", "public");
            if (it.getExtends().size() > 0) {
                Set set = it.getExtends();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.extends");
                $this$writeConfigurations.attribute("extends", CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            $this$writeConfigurations.endElement();
        }
        $this$writeConfigurations.endElement();
    }

    private final void writePublications(OptionalAttributeXmlWriter $this$writePublications) throws IOException {
        $this$writePublications.startElement("publications");
        Iterable $this$forEach$iv = this.artifacts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IvyArtifact it = (IvyArtifact)element$iv;
            boolean bl = false;
            $this$writePublications.startElement("artifact").attribute("name", it.getName()).attribute("type", it.getType()).attribute("ext", it.getExtension()).attribute("conf", it.getConf()).attribute("m:classifier", it.getClassifier()).endElement();
        }
        $this$writePublications.endElement();
    }

    public static final /* synthetic */ void access$writeDescriptor(IntelliJIvyDescriptorFileGenerator $this, Writer writer) {
        $this.writeDescriptor(writer);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$IvyCoordinates;", "", "organisation", "", "module", "revision", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getModule", "()Ljava/lang/String;", "getOrganisation", "getRevision", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-intellij-plugin"})
    public static final class IvyCoordinates {
        @NotNull
        private final String organisation;
        @NotNull
        private final String module;
        @NotNull
        private final String revision;

        public IvyCoordinates(@NotNull String organisation, @NotNull String module, @NotNull String revision) {
            Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
            this.organisation = organisation;
            this.module = module;
            this.revision = revision;
        }

        @NotNull
        public final String getOrganisation() {
            return this.organisation;
        }

        @NotNull
        public final String getModule() {
            return this.module;
        }

        @NotNull
        public final String getRevision() {
            return this.revision;
        }

        @NotNull
        public final String component1() {
            return this.organisation;
        }

        @NotNull
        public final String component2() {
            return this.module;
        }

        @NotNull
        public final String component3() {
            return this.revision;
        }

        @NotNull
        public final IvyCoordinates copy(@NotNull String organisation, @NotNull String module, @NotNull String revision) {
            Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
            return new IvyCoordinates(organisation, module, revision);
        }

        public static /* synthetic */ IvyCoordinates copy$default(IvyCoordinates ivyCoordinates, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = ivyCoordinates.organisation;
            }
            if ((n & 2) != 0) {
                string2 = ivyCoordinates.module;
            }
            if ((n & 4) != 0) {
                string3 = ivyCoordinates.revision;
            }
            return ivyCoordinates.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "IvyCoordinates(organisation=" + this.organisation + ", module=" + this.module + ", revision=" + this.revision + ")";
        }

        public int hashCode() {
            int result = this.organisation.hashCode();
            result = result * 31 + this.module.hashCode();
            result = result * 31 + this.revision.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IvyCoordinates)) {
                return false;
            }
            IvyCoordinates ivyCoordinates = (IvyCoordinates)other;
            if (!Intrinsics.areEqual((Object)this.organisation, (Object)ivyCoordinates.organisation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.module, (Object)ivyCoordinates.module)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.revision, (Object)ivyCoordinates.revision);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u000b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$OptionalAttributeXmlWriter;", "Lorg/gradle/internal/xml/SimpleXmlWriter;", "writer", "Ljava/io/Writer;", "indent", "", "encoding", "(Ljava/io/Writer;Ljava/lang/String;Ljava/lang/String;)V", "attribute", "name", "value", "startElement", "gradle-intellij-plugin"})
    public static final class OptionalAttributeXmlWriter
    extends SimpleXmlWriter {
        public OptionalAttributeXmlWriter(@NotNull Writer writer, @NotNull String indent, @NotNull String encoding) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            super(writer, indent, encoding);
        }

        @NotNull
        public OptionalAttributeXmlWriter startElement(@Nullable String name) {
            super.startElement(name);
            return this;
        }

        @NotNull
        public OptionalAttributeXmlWriter attribute(@Nullable String name, @Nullable String value) {
            if (value != null) {
                super.attribute(name, value);
            }
            return this;
        }
    }
}

