/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.tools.ant.util.TeeOutputStream;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.tasks.RunPluginVerifierTask;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;
import org.jetbrains.intellij.utils.LatestVersionResolver;

@UntrackedTask(because="Should always run Plugin Verifier")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u0000 ^2\u00020\u0001:\u0002^_B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\n0@H\u0002J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020\n0@H\u0002J\u001b\u0010B\u001a\u0010\u0012\f\u0012\n D*\u0004\u0018\u00010\u00140\u00140CH\u0000\u00a2\u0006\u0002\bEJ\b\u0010F\u001a\u00020-H\u0002Jo\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\n2K\u0010I\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(M\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(N\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(O\u0012\u0004\u0012\u00020\u00140JH\u0002J*\u0010P\u001a\u00020\n2\u0006\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0015\u0010Q\u001a\u00020\u00142\u0006\u0010R\u001a\u00020SH\u0000\u00a2\u0006\u0002\bTJ\b\u0010U\u001a\u00020\u0014H\u0002J\u0017\u0010V\u001a\u00020\n2\b\u0010N\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\bWJ\b\u0010X\u001a\u00020YH\u0007J\u0010\u0010Z\u001a\u00020-2\u0006\u0010[\u001a\u00020\u001eH\u0002J\u0016\u0010\\\u001a\u0010\u0012\f\u0012\n D*\u0004\u0018\u00010\u00140\u00140CH\u0002J\u0010\u0010]\u001a\u00020\n2\u0006\u0010N\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0012R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0012R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0012R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0012R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0012R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0012R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020-0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0012R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0012R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0012R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0012\u00a8\u0006`"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;Lorg/gradle/api/provider/ProviderFactory;)V", "context", "", "distributionFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDistributionFile", "()Lorg/gradle/api/file/RegularFileProperty;", "downloadDir", "Lorg/gradle/api/provider/Property;", "getDownloadDir", "()Lorg/gradle/api/provider/Property;", "downloadPath", "Ljava/nio/file/Path;", "getDownloadPath", "externalPrefixes", "Lorg/gradle/api/provider/ListProperty;", "getExternalPrefixes", "()Lorg/gradle/api/provider/ListProperty;", "failureLevel", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "getFailureLevel", "ideDir", "Ljava/io/File;", "getIdeDir", "ideVersions", "getIdeVersions", "jbrArch", "getJbrArch", "jbrVariant", "getJbrVariant", "jbrVersion", "getJbrVersion", "jreRepository", "getJreRepository", "localPaths", "getLocalPaths", "offline", "", "getOffline", "productsReleasesFile", "getProductsReleasesFile", "resolvedRuntimeDir", "getResolvedRuntimeDir", "runtimeDir", "getRuntimeDir", "subsystemsToCheck", "getSubsystemsToCheck", "teamCityOutputFormat", "getTeamCityOutputFormat", "verificationReportsDir", "getVerificationReportsDir", "verifierPath", "getVerifierPath", "verifierVersion", "getVerifierVersion", "getOptions", "", "getPaths", "ideDownloadDir", "Lorg/gradle/api/provider/Provider;", "kotlin.jvm.PlatformType", "ideDownloadDir$gradle_intellij_plugin", "requiresJava11", "resolveIdePath", "ideVersion", "block", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "type", "version", "buildType", "resolveIdeUrl", "resolveRuntimeDir", "jbrResolver", "Lorg/jetbrains/intellij/jbr/JbrResolver;", "resolveRuntimeDir$gradle_intellij_plugin", "resolveVerifierPath", "resolveVerifierVersion", "resolveVerifierVersion$gradle_intellij_plugin", "runPluginVerifier", "", "validateRuntimeDir", "runtimeDirPath", "verifierHomeDir", "versionParameterName", "Companion", "FailureLevel", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nRunPluginVerifierTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunPluginVerifierTask.kt\norg/jetbrains/intellij/tasks/RunPluginVerifierTask\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,684:1\n13579#2,2:685\n50#3:687\n50#3:688\n1549#4:689\n1620#4,3:690\n1549#4:693\n1620#4,3:694\n1855#4,2:698\n1#5:697\n*S KotlinDebug\n*F\n+ 1 RunPluginVerifierTask.kt\norg/jetbrains/intellij/tasks/RunPluginVerifierTask\n*L\n303#1:685,2\n316#1:687\n317#1:688\n373#1:689\n373#1:690,3\n375#1:693\n375#1:694,3\n532#1:698,2\n*E\n"})
public abstract class RunPluginVerifierTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final ProviderFactory providers;
    @NotNull
    private final String context;
    @NotNull
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/packages.jetbrains.team/maven/p/intellij-plugin-verifier/intellij-plugin-verifier/org/jetbrains/intellij/plugins/verifier-cli/maven-metadata.xml";
    @NotNull
    private static final String IDEA_DOWNLOAD_URL = "https://data.services.jetbrains.com/products/download";
    @NotNull
    private static final String ANDROID_STUDIO_DOWNLOAD_URL = "https://redirector.gvt1.com/edgedl/android/studio/ide-zips";

    @Inject
    public RunPluginVerifierTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations, @NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        this.providers = providers;
        this.context = Utils.logCategory((Task)this);
        this.setGroup("intellij");
        this.setDescription("Runs the IntelliJ Plugin Verifier tool to check the binary compatibility with specified IDE builds.");
    }

    @Input
    @NotNull
    public abstract ListProperty<FailureLevel> getFailureLevel();

    @Input
    @Optional
    @NotNull
    public abstract Property<File> getProductsReleasesFile();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getIdeVersions();

    @Input
    @NotNull
    public abstract ListProperty<File> getLocalPaths();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVerifierVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVerifierPath();

    @InputFile
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getDistributionFile();

    @OutputDirectory
    @Optional
    @NotNull
    public abstract Property<String> getVerificationReportsDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getDownloadDir();

    @Internal
    @NotNull
    public abstract Property<Path> getDownloadPath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrVariant();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrArch();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJreRepository();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getRuntimeDir();

    @Internal
    @NotNull
    public abstract Property<File> getResolvedRuntimeDir();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getExternalPrefixes();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getTeamCityOutputFormat();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSubsystemsToCheck();

    @Internal
    @NotNull
    public abstract Property<File> getIdeDir();

    @Internal
    @NotNull
    public abstract Property<Boolean> getOffline();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void runPluginVerifier() {
        Path file;
        Object object = this.getResolvedRuntimeDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resolvedRuntimeDir.get()");
        this.validateRuntimeDir((File)object);
        RegularFile regularFile = (RegularFile)this.getDistributionFile().getOrNull();
        Path path = file = regularFile != null ? Utils.getAsPath((FileSystemLocation)regularFile) : null;
        if (file == null || !FileUtilKt.exists((Path)file)) {
            throw new IllegalStateException("Plugin file does not exist: " + file);
        }
        List<String> paths2 = this.getPaths();
        if (paths2.isEmpty()) {
            throw new GradleException("'ideVersions' and 'localPaths' properties should not be empty");
        }
        Path verifierPath = this.resolveVerifierPath();
        List verifierArgs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"check-plugin"), (Iterable)this.getOptions()), (Object)((Object)file).toString()), (Iterable)paths2);
        Utils.debug$default(this.context, "Distribution file: " + file, null, 4, null);
        Utils.debug$default(this.context, "Verifier path: " + verifierPath, null, 4, null);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            try {
                this.execOperations.javaexec(new Action(this, verifierPath, verifierArgs, os){
                    final /* synthetic */ RunPluginVerifierTask this$0;
                    final /* synthetic */ Path $verifierPath;
                    final /* synthetic */ List<String> $verifierArgs;
                    final /* synthetic */ ByteArrayOutputStream $os;
                    {
                        this.this$0 = $receiver;
                        this.$verifierPath = $verifierPath;
                        this.$verifierArgs = $verifierArgs;
                        this.$os = $os;
                    }

                    public final void execute(@NotNull JavaExecSpec $this$javaexec) {
                        Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$this$javaexec");
                        Object[] objectArray = new Object[]{this.$verifierPath};
                        $this$javaexec.setClasspath((FileCollection)RunPluginVerifierTask.access$getObjectFactory$p(this.this$0).fileCollection().from(objectArray));
                        $this$javaexec.getMainClass().set((Object)"com.jetbrains.pluginverifier.PluginVerifierMain");
                        $this$javaexec.setArgs(this.$verifierArgs);
                        $this$javaexec.setStandardOutput((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)this.$os));
                    }
                });
            }
            catch (ExecException e) {
                Utils.error$default(this.context, "Error during Plugin Verifier CLI execution:\n" + os, null, 4, null);
                throw e;
            }
            Utils.debug$default(this.context, "Current failure levels: " + ArraysKt.joinToString$default((Object[])FailureLevel.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
            FailureLevel[] $this$forEach$iv = FailureLevel.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                FailureLevel element$iv;
                FailureLevel level = element$iv = $this$forEach$iv[j];
                boolean bl2 = false;
                if (!((List)this.getFailureLevel().get()).contains((Object)level)) continue;
                String string = os.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"os.toString()");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)level.getSectionHeading(), (boolean)false, (int)2, null)) continue;
                Utils.debug$default(this.context, "Failing task on '" + this.getFailureLevel() + "' failure level", null, 4, null);
                throw new GradleException(level + ": " + level.getMessage() + " Check Plugin Verifier report for more details.\nIncompatible API Changes: https://jb.gg/intellij-api-changes");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPaths() {
        Path it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$newInstance$iv;
        ObjectFactory parameters$iv;
        void $this$newInstance$iv2;
        ObjectFactory objectFactory = this.objectFactory;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.getOffline().get(), (String)"offline.get()");
        boolean $i$f$newInstance = false;
        DependenciesDownloader dependenciesDownloader = (DependenciesDownloader)$this$newInstance$iv2.newInstance(DependenciesDownloader.class, (Object[])Arrays.copyOf(parameters$iv, ((void)parameters$iv).length));
        parameters$iv = this.objectFactory;
        Object[] parameters$iv2 = new Object[]{};
        boolean $i$f$newInstance2 = false;
        ArchiveUtils archiveUtils = (ArchiveUtils)$this$newInstance$iv.newInstance(ArchiveUtils.class, Arrays.copyOf(parameters$iv2, parameters$iv2.length));
        Object object = this.getIdeVersions().map(new Transformer(this, dependenciesDownloader, archiveUtils){
            final /* synthetic */ RunPluginVerifierTask this$0;
            final /* synthetic */ DependenciesDownloader $dependenciesDownloader;
            final /* synthetic */ ArchiveUtils $archiveUtils;
            {
                this.this$0 = $receiver;
                this.$dependenciesDownloader = $dependenciesDownloader;
                this.$archiveUtils = $archiveUtils;
            }

            /*
             * WARNING - void declaration
             */
            public final List<Path> transform(@NotNull List<String> ideVersions) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list;
                List<E> list2;
                Object object;
                Intrinsics.checkNotNullParameter(ideVersions, (String)"ideVersions");
                Iterable<E> iterable = ideVersions;
                RunPluginVerifierTask runPluginVerifierTask = this.this$0;
                if (iterable.isEmpty()) {
                    boolean bl = false;
                    if (((List)runPluginVerifierTask.getLocalPaths().get()).isEmpty()) {
                        Object object2 = runPluginVerifierTask.getProductsReleasesFile().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"productsReleasesFile.get()");
                        object = object2;
                        File p0 = (File)object;
                        boolean bl2 = false;
                        File file = (File)(p0.exists() ? object : null);
                        list2 = file != null ? FilesKt.readLines$default((File)file, null, (int)1, null) : null;
                    } else {
                        list2 = null;
                    }
                } else {
                    list2 = iterable;
                }
                if ((list = (List)list2) == null) {
                    list = CollectionsKt.emptyList();
                }
                iterable = list;
                runPluginVerifierTask = this.this$0;
                DependenciesDownloader dependenciesDownloader = this.$dependenciesDownloader;
                object = this.$archiveUtils;
                boolean $i$f$map = false;
                void bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void ideVersion;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)ideVersion, (String)"ideVersion");
                    Object object3 = runPluginVerifierTask.getDownloadPath().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"downloadPath.get()");
                    collection.add(RunPluginVerifierTask.access$resolveIdePath(runPluginVerifierTask, (String)ideVersion, (Path)object3, RunPluginVerifierTask.access$getContext$p(runPluginVerifierTask), (Function3)new Function3<String, String, String, Path>(runPluginVerifierTask, dependenciesDownloader, (ArchiveUtils)object){
                        final /* synthetic */ RunPluginVerifierTask this$0;
                        final /* synthetic */ DependenciesDownloader $dependenciesDownloader;
                        final /* synthetic */ ArchiveUtils $archiveUtils;
                        {
                            this.this$0 = $receiver;
                            this.$dependenciesDownloader = $dependenciesDownloader;
                            this.$archiveUtils = $archiveUtils;
                            super(3);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final Path invoke(@NotNull String type, @NotNull String version2, @NotNull String buildType) {
                            Object p0;
                            void $this$filterNotTo$iv$iv;
                            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                            Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
                            String name = type + "-" + version2;
                            Path ideDir = ((Path)this.this$0.getDownloadPath().get()).resolve(name);
                            Utils.info$default(RunPluginVerifierTask.access$getContext$p(this.this$0), "Downloading IDE '" + name + "' to: " + ideDir, null, 4, null);
                            String url = RunPluginVerifierTask.access$resolveIdeUrl(this.this$0, type, version2, buildType, RunPluginVerifierTask.access$getContext$p(this.this$0));
                            Object[] objectArray = new String[]{type, version2, buildType};
                            Iterable $this$filterNot$iv = CollectionsKt.listOf((Object[])objectArray);
                            boolean $i$f$filterNot = false;
                            Iterable iterable = $this$filterNot$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterNotTo = false;
                            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                p0 = (String)element$iv$iv;
                                boolean bl = false;
                                CharSequence charSequence = (CharSequence)p0;
                                if (charSequence == null || charSequence.length() == 0) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            String dependencyVersion = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
                            String group = Intrinsics.areEqual((Object)type, (Object)"AI") ? "com.android" : "com.jetbrains";
                            Utils.debug$default(RunPluginVerifierTask.access$getContext$p(this.this$0), "Downloading IDE from " + url, null, 4, null);
                            try {
                                void $this$forEach$iv;
                                void $this$filterTo$iv$iv;
                                File ideArchive2 = (File)CollectionsKt.first((List)DependenciesDownloader.downloadFromRepository$default(this.$dependenciesDownloader, RunPluginVerifierTask.access$getContext$p(this.this$0), (Function1)new Function1<DependencyHandler, Dependency>(group, dependencyVersion){
                                    final /* synthetic */ String $group;
                                    final /* synthetic */ String $dependencyVersion;
                                    {
                                        this.$group = $group;
                                        this.$dependencyVersion = $dependencyVersion;
                                        super(1);
                                    }

                                    @NotNull
                                    public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                                        Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                                        return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)this.$group, (String)"ides", (String)this.$dependencyVersion, null, null, (String)"tar.gz", (int)24, null);
                                    }
                                }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
                                    final /* synthetic */ String $url;
                                    {
                                        this.$url = $url;
                                        super(1);
                                    }

                                    @NotNull
                                    public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                                        Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                                        return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, this.$url, null, null, 6, null);
                                    }
                                }, false, 8, null));
                                Utils.debug$default(RunPluginVerifierTask.access$getContext$p(this.this$0), "IDE downloaded, extracting...", null, 4, null);
                                Path path = ideArchive2.toPath();
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ideArchive.toPath()");
                                Intrinsics.checkNotNullExpressionValue((Object)ideDir, (String)"ideDir");
                                ArchiveUtils.extract$default(this.$archiveUtils, path, ideDir, RunPluginVerifierTask.access$getContext$p(this.this$0), null, null, 24, null);
                                List files2 = FileUtilKt.listFiles((Path)ideDir);
                                boolean bl = false;
                                Iterable $this$filter$iv = files2;
                                boolean $i$f$filter = false;
                                p0 = $this$filter$iv;
                                Collection destination$iv$iv2 = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    Path it = (Path)element$iv$iv;
                                    boolean bl2 = false;
                                    if (!FileUtilKt.isDirectory((Path)it)) continue;
                                    destination$iv$iv2.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv2;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    Path container = (Path)element$iv;
                                    boolean bl3 = false;
                                    Iterable $this$forEach$iv2 = FileUtilKt.listFiles((Path)container);
                                    boolean $i$f$forEach2 = false;
                                    for (T element$iv2 : $this$forEach$iv2) {
                                        Path file = (Path)element$iv2;
                                        boolean bl4 = false;
                                        Files.move(file, ideDir.resolve(FileUtilKt.getSimpleName((Path)file)), new CopyOption[0]);
                                    }
                                    FileUtilKt.forceRemoveDirectory((Path)container);
                                }
                            }
                            catch (Exception e) {
                                Utils.warn(RunPluginVerifierTask.access$getContext$p(this.this$0), "Cannot download '" + type + "-" + version2 + "' from '" + buildType + "' channel: " + url, e);
                            }
                            Utils.debug$default(RunPluginVerifierTask.access$getContext$p(this.this$0), "IDE extracted to: " + ideDir, null, 4, null);
                            Intrinsics.checkNotNullExpressionValue((Object)ideDir, (String)"ideDir");
                            return ideDir;
                        }
                    }));
                }
                return (List)destination$iv$iv;
            }
        }).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"private fun getPaths(): \u2026oString()\n        }\n    }");
        List idePaths2 = (List)object;
        Object object2 = this.getLocalPaths().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"localPaths.get()");
        Iterable $this$map$iv = (Iterable)object2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((File)((Object)it)).toPath());
        }
        List userPaths = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus((Collection)idePaths2, (Iterable)userPaths);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)it.toAbsolutePath()).toString());
        }
        return (List)destination$iv$iv;
    }

    private final Path resolveVerifierPath() {
        Path path;
        block3: {
            block2: {
                Path path2;
                String string = (String)this.getVerifierPath().getOrNull();
                if (string == null) break block2;
                String p0 = string;
                boolean bl = false;
                Path path3 = Path.of(p0, new String[0]);
                if (path3 == null) break block2;
                Path p02 = path2 = path3;
                boolean bl2 = false;
                Path path4 = path = FileUtilKt.exists((Path)p02) ? path2 : null;
                if (path != null) break block3;
            }
            throw new InvalidUserDataException("Provided Plugin Verifier path doesn't exist: '" + this.getPath() + "'. Downloading Plugin Verifier: " + this.getVerifierVersion());
        }
        return path;
    }

    @NotNull
    public final Path resolveRuntimeDir$gradle_intellij_plugin(@NotNull JbrResolver jbrResolver) {
        Intrinsics.checkNotNullParameter((Object)jbrResolver, (String)"jbrResolver");
        Path path = JbrResolver.resolveRuntimeDir$default(jbrResolver, (String)this.getRuntimeDir().getOrNull(), (String)this.getJbrVersion().getOrNull(), (String)this.getJbrVariant().getOrNull(), (String)this.getJbrArch().getOrNull(), (File)this.getIdeDir().getOrNull(), null, 32, null);
        if (path == null) {
            throw new InvalidUserDataException(this.requiresJava11() ? "Java Runtime directory couldn't be resolved. Note: Plugin Verifier 1.260+ requires Java 11" : "Java Runtime directory couldn't be resolved");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validateRuntimeDir(File runtimeDirPath) {
        boolean bl;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            Utils.debug$default(this.context, "Plugin Verifier JRE verification: " + runtimeDirPath, null, 4, null);
            if (!this.requiresJava11()) {
                boolean bl3 = true;
                return bl3;
            }
            this.execOperations.exec(new Action(runtimeDirPath, os){
                final /* synthetic */ File $runtimeDirPath;
                final /* synthetic */ ByteArrayOutputStream $os;
                {
                    this.$runtimeDirPath = $runtimeDirPath;
                    this.$os = $os;
                }

                public final void execute(@NotNull ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable(FilesKt.resolve((File)this.$runtimeDirPath, (String)"bin/java").getAbsolutePath());
                    $this$exec.setArgs(CollectionsKt.listOf((Object)"-version"));
                    $this$exec.setErrorOutput((OutputStream)this.$os);
                }
            });
            String string = os.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"os.toString()");
            Version version2 = Version.Companion.parse(string);
            boolean result2 = version2.compareTo(new Version(11, 0, 0, null, 14, null)) >= 0;
            bl = Utils.ifFalse(result2, (Function0<Unit>)((Function0)new Function0<Unit>(version2, runtimeDirPath){
                final /* synthetic */ Version $version;
                final /* synthetic */ File $runtimeDirPath;
                {
                    this.$version = $version;
                    this.$runtimeDirPath = $runtimeDirPath;
                    super(0);
                }

                public final void invoke() {
                    throw new GradleException("Plugin Verifier 1.260+ requires Java 11, but '" + this.$version + "' was provided with 'runtimeDir': " + this.$runtimeDirPath);
                }
            }));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    private final boolean requiresJava11() {
        String string = this.resolveVerifierVersion$gradle_intellij_plugin((String)this.getVerifierVersion().getOrNull());
        Version.Companion companion = Version.Companion;
        String p0 = string;
        boolean bl = false;
        return companion.parse(p0).compareTo(new Version(1, 260, 0, null, 12, null)) >= 0;
    }

    private final List<String> getOptions() {
        Object[] objectArray = new String[]{"-verification-reports-dir", this.getVerificationReportsDir().get(), "-runtime-dir", ((File)this.getResolvedRuntimeDir().get()).getAbsolutePath()};
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        Object object = this.getExternalPrefixes().get();
        List it = (List)object;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        List list = (List)(!((Collection)it).isEmpty() ? object : null);
        if (list != null) {
            it = list;
            boolean bl2 = false;
            args.add("-external-prefixes");
            args.add(CollectionsKt.joinToString$default((Iterable)it, (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
        }
        Object object2 = this.getTeamCityOutputFormat().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"teamCityOutputFormat.get()");
        if (((Boolean)object2).booleanValue()) {
            args.add("-team-city");
        }
        if (this.getSubsystemsToCheck().getOrNull() != null) {
            args.add("-subsystems-to-check");
            args.add(this.getSubsystemsToCheck().get());
        }
        Object object3 = this.getOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"offline.get()");
        if (((Boolean)object3).booleanValue()) {
            args.add("-offline");
        }
        return args;
    }

    private final Provider<Path> verifierHomeDir() {
        Provider provider = this.providers.systemProperty("plugin.verifier.home.dir").forUseAtConfigurationTime().map((Transformer)verifierHomeDir.1.INSTANCE).orElse(this.providers.environmentVariable("XDG_CACHE_HOME").forUseAtConfigurationTime().map((Transformer)verifierHomeDir.2.INSTANCE)).orElse(this.providers.systemProperty("user.home").forUseAtConfigurationTime().map((Transformer)verifierHomeDir.3.INSTANCE)).orElse((Object)this.getTemporaryDir().toPath().resolve("pluginVerifier"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.systemProperty\u2026esolve(\"pluginVerifier\"))");
        return provider;
    }

    @NotNull
    public final String resolveVerifierVersion$gradle_intellij_plugin(@Nullable String version2) {
        String string;
        block3: {
            block2: {
                String string2;
                string = version2;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"latest") ? string2 : null;
                if (string != null) break block3;
            }
            string = Companion.resolveLatestVersion();
        }
        return string;
    }

    private final Path resolveIdePath(String ideVersion, Path downloadPath, String context, Function3<? super String, ? super String, ? super String, ? extends Path> block) {
        List list;
        Utils.debug$default(context, "Resolving IDE path for: " + ideVersion, null, 4, null);
        char[] cArray = new char[]{'-'};
        List list2 = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)ideVersion)).toString(), (char[])cArray, (boolean)false, (int)2, (int)2, null), null);
        String type = null;
        type = (String)list2.get(0);
        String version2 = null;
        version2 = (String)list2.get(1);
        if (version2 == null) {
            Utils.debug$default(context, "IDE type not specified, setting type to IC", null, 4, null);
            version2 = type;
            type = "IC";
        }
        String name = type + "-" + version2;
        Path ideDirPath2 = downloadPath.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)ideDirPath2, (String)"ideDirPath");
        if (FileUtilKt.exists((Path)ideDirPath2)) {
            Utils.debug$default(context, "IDE already available in: " + ideDirPath2, null, 4, null);
            return ideDirPath2;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"AI")) {
            list = CollectionsKt.listOf((Object)"");
        } else {
            Object[] objectArray = new String[]{"release", "rc", "eap", "beta"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List buildTypes = list;
        Iterable $this$forEach$iv = buildTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String buildType = (String)element$iv;
            boolean bl = false;
            Utils.debug$default(context, "Downloading IDE '" + type + "-" + version2 + "' from '" + buildType + "' channel to: " + downloadPath, null, 4, null);
            try {
                String string = type;
                Intrinsics.checkNotNull((Object)string);
                String string2 = version2;
                Intrinsics.checkNotNull((Object)string2);
                Object object = block.invoke((Object)string, (Object)string2, (Object)buildType);
                Path it = (Path)object;
                boolean bl2 = false;
                Utils.debug$default(context, "Resolved IDE '" + type + "-" + version2 + "' path: " + it, null, 4, null);
                return (Path)object;
            }
            catch (IOException e) {
                Utils.debug(context, "Cannot download IDE '" + type + "-" + version2 + "' from '" + buildType + "' channel. Trying another channel...", e);
            }
        }
        throw new GradleException("IDE '" + ideVersion + "' cannot be downloaded. Please verify the specified IDE version against the products available for testing: https://jb.gg/intellij-platform-builds-list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String resolveIdeUrl(String type, String version2, String buildType, String context) {
        boolean isAndroidStudio = Intrinsics.areEqual((Object)type, (Object)"AI");
        String url = isAndroidStudio ? "https://redirector.gvt1.com/edgedl/android/studio/ide-zips/" + version2 + "/android-studio-" + version2 + "-linux.tar.gz" : "https://data.services.jetbrains.com/products/download?code=" + type + "&platform=linux&type=" + buildType + "&" + this.versionParameterName(version2) + "=" + version2;
        Utils.debug$default(context, "Resolving direct IDE download URL for: " + url, null, 4, null);
        HttpURLConnection connection = null;
        try {
            Throwable throwable;
            Closeable closeable;
            block11: {
                URLConnection uRLConnection = new URL(url).openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection $this$resolveIdeUrl_u24lambda_u2412 = (HttpURLConnection)uRLConnection;
                boolean bl = false;
                connection = $this$resolveIdeUrl_u24lambda_u2412;
                $this$resolveIdeUrl_u24lambda_u2412.setInstanceFollowRedirects(false);
                closeable = $this$resolveIdeUrl_u24lambda_u2412.getInputStream();
                throwable = null;
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                if ($this$resolveIdeUrl_u24lambda_u2412.getResponseCode() != 301 && $this$resolveIdeUrl_u24lambda_u2412.getResponseCode() != 302 || isAndroidStudio) break block11;
                URL redirectUrl = new URL($this$resolveIdeUrl_u24lambda_u2412.getHeaderField("Location"));
                $this$resolveIdeUrl_u24lambda_u2412.disconnect();
                Utils.debug$default(context, "Resolved IDE download URL: " + url, null, 4, null);
                String string = "https://cache-redirector.jetbrains.com/" + redirectUrl.getHost() + redirectUrl.getFile();
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                String string2 = string;
                connection.disconnect();
                return string2;
            }
            try {
                Utils.debug$default(context, "IDE download URL has no redirection provided. Skipping", null, 4, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            connection.disconnect();
            return url;
        }
        catch (Exception e) {
            try {
                Utils.info$default(context, "Cannot resolve direct download URL for: " + url, null, 4, null);
                Utils.debug(context, "Download exception stacktrace:", e);
                throw e;
            }
            catch (Throwable throwable) {
                HttpURLConnection httpURLConnection = connection;
                if (httpURLConnection == null) throw throwable;
                httpURLConnection.disconnect();
                throw throwable;
            }
        }
    }

    private final String versionParameterName(String version2) {
        CharSequence charSequence = version2;
        return new Regex("\\d{3}(\\.\\d+)+").matches(charSequence) ? "build" : "version";
    }

    @NotNull
    public final Provider<Path> ideDownloadDir$gradle_intellij_plugin() {
        Provider provider = this.verifierHomeDir().map((Transformer)ideDownloadDir.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"verifierHomeDir().map { \u2026lve(\"ides\").createDir() }");
        return provider;
    }

    public static final /* synthetic */ Path access$resolveIdePath(RunPluginVerifierTask $this, String ideVersion, Path downloadPath, String context, Function3 block) {
        return $this.resolveIdePath(ideVersion, downloadPath, context, (Function3<? super String, ? super String, ? super String, ? extends Path>)block);
    }

    public static final /* synthetic */ String access$getContext$p(RunPluginVerifierTask $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$resolveIdeUrl(RunPluginVerifierTask $this, String type, String version2, String buildType, String context) {
        return $this.resolveIdeUrl(type, version2, buildType, context);
    }

    public static final /* synthetic */ ObjectFactory access$getObjectFactory$p(RunPluginVerifierTask $this) {
        return $this.objectFactory;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$Companion;", "", "()V", "ANDROID_STUDIO_DOWNLOAD_URL", "", "IDEA_DOWNLOAD_URL", "METADATA_URL", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLatestVersion() {
            return LatestVersionResolver.Companion.fromMaven("Plugin Verifier", RunPluginVerifierTask.METADATA_URL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0001\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "", "sectionHeading", "", "message", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getSectionHeading", "COMPATIBILITY_WARNINGS", "COMPATIBILITY_PROBLEMS", "DEPRECATED_API_USAGES", "SCHEDULED_FOR_REMOVAL_API_USAGES", "EXPERIMENTAL_API_USAGES", "INTERNAL_API_USAGES", "OVERRIDE_ONLY_API_USAGES", "NON_EXTENDABLE_API_USAGES", "PLUGIN_STRUCTURE_WARNINGS", "MISSING_DEPENDENCIES", "INVALID_PLUGIN", "NOT_DYNAMIC", "Companion", "gradle-intellij-plugin"})
    public static final class FailureLevel
    extends Enum<FailureLevel> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String sectionHeading;
        @NotNull
        private final String message;
        @JvmField
        @NotNull
        public static final EnumSet<FailureLevel> ALL;
        @JvmField
        @NotNull
        public static final EnumSet<FailureLevel> NONE;
        public static final /* enum */ FailureLevel COMPATIBILITY_WARNINGS;
        public static final /* enum */ FailureLevel COMPATIBILITY_PROBLEMS;
        public static final /* enum */ FailureLevel DEPRECATED_API_USAGES;
        public static final /* enum */ FailureLevel SCHEDULED_FOR_REMOVAL_API_USAGES;
        public static final /* enum */ FailureLevel EXPERIMENTAL_API_USAGES;
        public static final /* enum */ FailureLevel INTERNAL_API_USAGES;
        public static final /* enum */ FailureLevel OVERRIDE_ONLY_API_USAGES;
        public static final /* enum */ FailureLevel NON_EXTENDABLE_API_USAGES;
        public static final /* enum */ FailureLevel PLUGIN_STRUCTURE_WARNINGS;
        public static final /* enum */ FailureLevel MISSING_DEPENDENCIES;
        public static final /* enum */ FailureLevel INVALID_PLUGIN;
        public static final /* enum */ FailureLevel NOT_DYNAMIC;
        private static final /* synthetic */ FailureLevel[] $VALUES;

        private FailureLevel(String sectionHeading, String message) {
            this.sectionHeading = sectionHeading;
            this.message = message;
        }

        @NotNull
        public final String getSectionHeading() {
            return this.sectionHeading;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static FailureLevel[] values() {
            return (FailureLevel[])$VALUES.clone();
        }

        public static FailureLevel valueOf(String value) {
            return Enum.valueOf(FailureLevel.class, value);
        }

        static {
            COMPATIBILITY_WARNINGS = new FailureLevel("Compatibility warnings", "Compatibility warnings detected against the specified IDE version.");
            COMPATIBILITY_PROBLEMS = new FailureLevel("Compatibility problems", "Compatibility problems detected against the specified IDE version.");
            DEPRECATED_API_USAGES = new FailureLevel("Deprecated API usages", "Plugin uses API marked as deprecated (@Deprecated).");
            SCHEDULED_FOR_REMOVAL_API_USAGES = new FailureLevel("scheduled for removal API", "Plugin uses API marked as scheduled for removal (ApiStatus.@ScheduledForRemoval).");
            EXPERIMENTAL_API_USAGES = new FailureLevel("Experimental API usages", "Plugin uses API marked as experimental (ApiStatus.@Experimental).");
            INTERNAL_API_USAGES = new FailureLevel("Internal API usages", "Plugin uses API marked as internal (ApiStatus.@get:Internal).");
            OVERRIDE_ONLY_API_USAGES = new FailureLevel("Override-only API usages", "Override-only API is used incorrectly (ApiStatus.@OverrideOnly).");
            NON_EXTENDABLE_API_USAGES = new FailureLevel("Non-extendable API usages", "Non-extendable API is used incorrectly (ApiStatus.@NonExtendable).");
            PLUGIN_STRUCTURE_WARNINGS = new FailureLevel("Plugin structure warnings", "The structure of the plugin is not valid.");
            MISSING_DEPENDENCIES = new FailureLevel("Missing dependencies", "Plugin has some dependencies missing.");
            INVALID_PLUGIN = new FailureLevel("The following files specified for the verification are not valid plugins", "Provided plugin artifact is not valid.");
            NOT_DYNAMIC = new FailureLevel("Plugin cannot be loaded/unloaded without IDE restart", "Plugin cannot be loaded/unloaded without IDE restart.");
            $VALUES = failureLevelArray = new FailureLevel[]{FailureLevel.COMPATIBILITY_WARNINGS, FailureLevel.COMPATIBILITY_PROBLEMS, FailureLevel.DEPRECATED_API_USAGES, FailureLevel.SCHEDULED_FOR_REMOVAL_API_USAGES, FailureLevel.EXPERIMENTAL_API_USAGES, FailureLevel.INTERNAL_API_USAGES, FailureLevel.OVERRIDE_ONLY_API_USAGES, FailureLevel.NON_EXTENDABLE_API_USAGES, FailureLevel.PLUGIN_STRUCTURE_WARNINGS, FailureLevel.MISSING_DEPENDENCIES, FailureLevel.INVALID_PLUGIN, FailureLevel.NOT_DYNAMIC};
            Companion = new Companion(null);
            EnumSet<FailureLevel> enumSet = EnumSet.allOf(FailureLevel.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"allOf(FailureLevel::class.java)");
            ALL = enumSet;
            EnumSet<FailureLevel> enumSet2 = EnumSet.noneOf(FailureLevel.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(FailureLevel::class.java)");
            NONE = enumSet2;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel$Companion;", "", "()V", "ALL", "Ljava/util/EnumSet;", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "NONE", "gradle-intellij-plugin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

