/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.tasks.InitializeIntelliJPluginTask;
import org.jetbrains.intellij.utils.LatestVersionResolver;

@UntrackedTask(because="Should always be run to initialize the plugin")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/intellij/tasks/InitializeIntelliJPluginTask;", "Lorg/gradle/api/DefaultTask;", "()V", "context", "", "lockFile", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getLockFile", "()Lorg/gradle/api/provider/Property;", "offline", "", "getOffline", "selfUpdateCheck", "getSelfUpdateCheck", "checkPluginVersion", "", "initialize", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nInitializeIntelliJPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitializeIntelliJPluginTask.kt\norg/jetbrains/intellij/tasks/InitializeIntelliJPluginTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public abstract class InitializeIntelliJPluginTask
extends DefaultTask {
    @NotNull
    private final String context;

    public InitializeIntelliJPluginTask() {
        this.setGroup("intellij");
        this.setDescription("Initializes the Gradle IntelliJ Plugin");
        this.context = Utils.logCategory((Task)this);
    }

    @Internal
    @NotNull
    public abstract Property<Boolean> getOffline();

    @Internal
    @NotNull
    public abstract Property<Boolean> getSelfUpdateCheck();

    @Internal
    @NotNull
    public abstract Property<File> getLockFile();

    @TaskAction
    public final void initialize() {
        this.checkPluginVersion();
    }

    private final void checkPluginVersion() {
        block10: {
            block9: {
                if (!((Boolean)this.getSelfUpdateCheck().get()).booleanValue()) break block9;
                Object object = this.getOffline().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"offline.get()");
                if (!((Boolean)object).booleanValue()) break block10;
            }
            return;
        }
        try {
            Version version2;
            String string = Utils.getCurrentPluginVersion();
            if (string != null) {
                String string2 = string;
                Version.Companion companion = Version.Companion;
                String p0 = string2;
                boolean bl = false;
                version2 = companion.parse(p0);
            } else {
                version2 = null;
            }
            Version version3 = Utils.or(version2, checkPluginVersion.version.2.INSTANCE);
            String latestVersion = LatestVersionResolver.Companion.fromGitHub("Gradle IntelliJ Plugin", "https://github.com/jetbrains/gradle-intellij-plugin");
            if (version3.compareTo(Version.Companion.parse(latestVersion)) < 0) {
                Utils.warn$default(this.context, "Gradle IntelliJ Plugin is outdated: " + version3 + ". Update `org.jetbrains.intellij` to: " + latestVersion, null, 4, null);
            }
            Path path = ((File)this.getLockFile().get()).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"lockFile.get().toPath()");
            FileUtilKt.create((Path)path);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            Utils.error(this.context, string, e);
        }
    }
}

