/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.tasks.RunIdeBase;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000fH\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/tasks/BuildSearchableOptionsTask;", "Lorg/jetbrains/intellij/tasks/RunIdeBase;", "()V", "context", "", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "showPaidPluginWarning", "Lorg/gradle/api/provider/Property;", "", "getShowPaidPluginWarning", "()Lorg/gradle/api/provider/Property;", "traverseUIArgs", "", "exec", "", "setArgs", "Lorg/gradle/api/tasks/JavaExec;", "applicationArgs", "", "gradle-intellij-plugin"})
public abstract class BuildSearchableOptionsTask
extends RunIdeBase {
    @NotNull
    private final List<String> traverseUIArgs = CollectionsKt.listOf((Object)"traverseUI");
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public BuildSearchableOptionsTask() {
        this.setGroup("intellij");
        this.setDescription("Builds an index of UI components (searchable options) for the plugin.");
        this.setArgs(this.traverseUIArgs);
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Internal
    @NotNull
    public abstract Property<Boolean> getShowPaidPluginWarning();

    @Override
    public void exec() {
        Object object = this.getShowPaidPluginWarning().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"showPaidPluginWarning.get()");
        if (((Boolean)object).booleanValue()) {
            Utils.warn$default(this.context, "Due to IDE limitations, it is impossible to run the IDE in headless mode to collect searchable options for a paid plugin. As paid plugins require providing a valid license and presenting a UI dialog, it is impossible to handle such a case, and the task will fail. Please consider disabling the task in the Gradle configuration. See: https://plugins.jetbrains.com/docs/intellij/tools-gradle-intellij-plugin-faq.html#how-to-disable-building-searchable-option", null, 4, null);
        }
        List list = this.getArgs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"args");
        Object[] objectArray = new String[]{((Directory)this.getOutputDir().get()).getAsFile().getCanonicalPath(), "true"};
        this.setArgs((List<String>)CollectionsKt.plus((Collection)list, (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        super.exec();
    }

    @NotNull
    public JavaExec setArgs(@Nullable List<String> applicationArgs) {
        Iterable iterable = this.traverseUIArgs;
        List<String> list = applicationArgs;
        List list2 = list != null ? CollectionsKt.toList((Iterable)list) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        JavaExec javaExec = super.setArgs((Iterable)CollectionsKt.union((Iterable)iterable, (Iterable)list2));
        Intrinsics.checkNotNullExpressionValue((Object)javaExec, (String)"super.setArgs(traverseUI\u2026rgs?.toList().orEmpty()))");
        return javaExec;
    }

    @NotNull
    public JavaExec setArgs(@Nullable Iterable<?> applicationArgs) {
        Iterable iterable = this.traverseUIArgs;
        Iterable<?> iterable2 = applicationArgs;
        List list = iterable2 != null ? CollectionsKt.toList(iterable2) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        JavaExec javaExec = super.setArgs((Iterable)CollectionsKt.union((Iterable)iterable, (Iterable)list));
        Intrinsics.checkNotNullExpressionValue((Object)javaExec, (String)"super.setArgs(traverseUI\u2026rgs?.toList().orEmpty()))");
        return javaExec;
    }
}

