/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.propertyProviders;

import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/intellij/propertyProviders/PerformanceTestArgumentProvider;", "Lorg/gradle/process/CommandLineArgumentProvider;", "scriptPath", "Ljava/nio/file/Path;", "testArtifactsDirPath", "profilerName", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;)V", "getScriptPath", "()Ljava/nio/file/Path;", "getTestArtifactsDirPath", "asArguments", "", "gradle-intellij-plugin"})
public final class PerformanceTestArgumentProvider
implements CommandLineArgumentProvider {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final Path scriptPath;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final Path testArtifactsDirPath;
    @NotNull
    private final String profilerName;

    public PerformanceTestArgumentProvider(@NotNull Path scriptPath, @NotNull Path testArtifactsDirPath, @NotNull String profilerName) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Intrinsics.checkNotNullParameter((Object)testArtifactsDirPath, (String)"testArtifactsDirPath");
        Intrinsics.checkNotNullParameter((Object)profilerName, (String)"profilerName");
        this.scriptPath = scriptPath;
        this.testArtifactsDirPath = testArtifactsDirPath;
        this.profilerName = profilerName;
    }

    @NotNull
    public final Path getScriptPath() {
        return this.scriptPath;
    }

    @NotNull
    public final Path getTestArtifactsDirPath() {
        return this.testArtifactsDirPath;
    }

    @NotNull
    public List<String> asArguments() {
        Object[] objectArray = new String[]{"-Djdk.attach.allowAttachSelf=true", "-Didea.is.integration.test=true", "-Djb.privacy.policy.text=<!--999.999-->", "-Djb.consents.confirmation.enabled=false", "-Didea.local.statistics.without.report=true", "-Dlinux.native.menu.force.disable=true", "-Didea.fatal.error.notification=true", "-Dtestscript.filename=" + ((Object)this.scriptPath.toAbsolutePath()).toString(), "-DintegrationTests.profiler=" + this.profilerName, "-Dide.performance.screenshot.before.kill=" + ((Object)this.testArtifactsDirPath.toAbsolutePath()).toString(), "-Didea.log.path=" + ((Object)this.testArtifactsDirPath.toAbsolutePath()).toString(), "-Dsnapshots.path=" + ((Object)this.testArtifactsDirPath.toAbsolutePath()).toString(), "-Dmemory.snapshots.path=" + ((Object)this.testArtifactsDirPath.toAbsolutePath()).toString()};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

