/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.propertyProviders;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.model.Launch;
import org.jetbrains.intellij.model.ProductInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/propertyProviders/LaunchSystemArgumentProvider;", "Lorg/gradle/process/CommandLineArgumentProvider;", "ideDirectory", "Ljava/nio/file/Path;", "configDirectory", "Ljava/io/File;", "systemDirectory", "pluginsDirectory", "requirePluginIds", "", "", "(Ljava/nio/file/Path;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/util/List;)V", "getConfigDirectory", "()Ljava/io/File;", "currentLaunchProperties", "getCurrentLaunchProperties", "()Ljava/util/List;", "getIdeDirectory", "()Ljava/nio/file/Path;", "getPluginsDirectory", "getSystemDirectory", "asArguments", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nLaunchSystemArgumentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchSystemArgumentProvider.kt\norg/jetbrains/intellij/propertyProviders/LaunchSystemArgumentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n766#2:39\n857#2,2:40\n1549#2:42\n1620#2,3:43\n*S KotlinDebug\n*F\n+ 1 LaunchSystemArgumentProvider.kt\norg/jetbrains/intellij/propertyProviders/LaunchSystemArgumentProvider\n*L\n26#1:39\n26#1:40,2\n27#1:42\n27#1:43,3\n*E\n"})
public final class LaunchSystemArgumentProvider
implements CommandLineArgumentProvider {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final Path ideDirectory;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final File configDirectory;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final File systemDirectory;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final File pluginsDirectory;
    @NotNull
    private final List<String> requirePluginIds;

    public LaunchSystemArgumentProvider(@NotNull Path ideDirectory, @NotNull File configDirectory, @NotNull File systemDirectory, @NotNull File pluginsDirectory, @NotNull List<String> requirePluginIds) {
        Intrinsics.checkNotNullParameter((Object)ideDirectory, (String)"ideDirectory");
        Intrinsics.checkNotNullParameter((Object)configDirectory, (String)"configDirectory");
        Intrinsics.checkNotNullParameter((Object)systemDirectory, (String)"systemDirectory");
        Intrinsics.checkNotNullParameter((Object)pluginsDirectory, (String)"pluginsDirectory");
        Intrinsics.checkNotNullParameter(requirePluginIds, (String)"requirePluginIds");
        this.ideDirectory = ideDirectory;
        this.configDirectory = configDirectory;
        this.systemDirectory = systemDirectory;
        this.pluginsDirectory = pluginsDirectory;
        this.requirePluginIds = requirePluginIds;
    }

    @NotNull
    public final Path getIdeDirectory() {
        return this.ideDirectory;
    }

    @NotNull
    public final File getConfigDirectory() {
        return this.configDirectory;
    }

    @NotNull
    public final File getSystemDirectory() {
        return this.systemDirectory;
    }

    @NotNull
    public final File getPluginsDirectory() {
        return this.pluginsDirectory;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getCurrentLaunchProperties() {
        List list;
        List list2;
        List<String> list3;
        Launch launch;
        ProductInfo productInfo = Utils.ideProductInfo(this.ideDirectory);
        if (productInfo != null && (launch = productInfo.getCurrentLaunch()) != null && (list3 = launch.getAdditionalJvmArguments()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = list3;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-D", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Utils.resolveIdeHomeVariable(it, this.ideDirectory));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public List<String> asArguments() {
        Object[] objectArray = new String[]{"-Didea.config.path=" + this.configDirectory.getAbsolutePath(), "-Didea.system.path=" + this.systemDirectory.getAbsolutePath(), "-Didea.log.path=" + FilesKt.resolve((File)this.systemDirectory, (String)"log").getAbsolutePath(), "-Didea.plugins.path=" + this.pluginsDirectory.getAbsolutePath(), "-Didea.required.plugins.id=" + CollectionsKt.joinToString$default((Iterable)this.requirePluginIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)};
        return CollectionsKt.plus((Collection)this.getCurrentLaunchProperties(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

