/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.propertyProviders;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.model.Launch;
import org.jetbrains.intellij.model.ProductInfo;
import org.jetbrains.intellij.utils.OpenedPackagesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/intellij/propertyProviders/IntelliJPlatformArgumentProvider;", "Lorg/gradle/process/CommandLineArgumentProvider;", "ideDirectory", "Ljava/nio/file/Path;", "options", "Lorg/gradle/process/JavaForkOptions;", "(Ljava/nio/file/Path;Lorg/gradle/process/JavaForkOptions;)V", "additionalJvmArguments", "", "", "getAdditionalJvmArguments", "()Ljava/util/List;", "bootclasspath", "getBootclasspath", "defaultHeapSpace", "heapSpace", "getHeapSpace", "getIdeDirectory", "()Ljava/nio/file/Path;", "productInfo", "Lorg/jetbrains/intellij/model/ProductInfo;", "getProductInfo", "()Lorg/jetbrains/intellij/model/ProductInfo;", "vmOptions", "getVmOptions", "asArguments", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nIntelliJPlatformArgumentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJPlatformArgumentProvider.kt\norg/jetbrains/intellij/propertyProviders/IntelliJPlatformArgumentProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1#2:61\n819#3:62\n847#3,2:63\n1549#3:65\n1620#3,3:66\n766#3:69\n857#3,2:70\n*S KotlinDebug\n*F\n+ 1 IntelliJPlatformArgumentProvider.kt\norg/jetbrains/intellij/propertyProviders/IntelliJPlatformArgumentProvider\n*L\n44#1:62\n44#1:63,2\n46#1:65\n46#1:66,3\n58#1:69\n58#1:70,2\n*E\n"})
public final class IntelliJPlatformArgumentProvider
implements CommandLineArgumentProvider {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final Path ideDirectory;
    @NotNull
    private final JavaForkOptions options;
    @NotNull
    private final List<String> defaultHeapSpace;

    public IntelliJPlatformArgumentProvider(@NotNull Path ideDirectory, @NotNull JavaForkOptions options) {
        Intrinsics.checkNotNullParameter((Object)ideDirectory, (String)"ideDirectory");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.ideDirectory = ideDirectory;
        this.options = options;
        Object[] objectArray = new String[]{"-Xmx512m", "-Xms256m"};
        this.defaultHeapSpace = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Path getIdeDirectory() {
        return this.ideDirectory;
    }

    private final ProductInfo getProductInfo() {
        return Utils.ideProductInfo(this.ideDirectory);
    }

    private final List<String> getBootclasspath() {
        List list;
        List list2;
        Path path;
        Path path2;
        Path it = path2 = this.ideDirectory.resolve("lib/boot.jar");
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Path path3 = path = FileUtilKt.exists((Path)it) ? path2 : null;
        if (path != null) {
            it = path;
            boolean bl2 = false;
            list2 = CollectionsKt.listOf((Object)("-Xbootclasspath/a:" + it));
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<String> getVmOptions() {
        List list;
        List list2;
        String string;
        String string2;
        Launch launch;
        ProductInfo productInfo = this.getProductInfo();
        if (productInfo != null && (launch = productInfo.getCurrentLaunch()) != null && (string2 = launch.getVmOptionsFilePath()) != null && (string = StringsKt.removePrefix((String)string2, (CharSequence)"../")) != null) {
            String it = string;
            boolean bl = false;
            Path path = this.ideDirectory.resolve(it);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ideDirectory.resolve(it)");
            list2 = FileUtilKt.readLines$default((Path)path, null, (int)1, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<String> getAdditionalJvmArguments() {
        List list;
        List<String> list2;
        Launch launch;
        ProductInfo productInfo = this.getProductInfo();
        if (productInfo != null && (launch = productInfo.getCurrentLaunch()) != null && (list2 = launch.getAdditionalJvmArguments()) != null) {
            List list3;
            void $this$filterNot$iv;
            Iterable iterable = list2;
            boolean $i$f$filterNot = false;
            void var6_7 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo2 = false;
            for (Object element$iv$iv : var6_7) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"-D", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list4 = list3 = (List)destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = iterable = !((Collection)list4).isEmpty() ? list3 : null;
            if (iterable != null) {
                void $this$mapTo$iv$iv;
                Iterable iterable3 = iterable;
                boolean $i$f$map = false;
                Iterable $i$f$filterNotTo2 = iterable3;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (true) {
                    void it;
                    if (!iterator.hasNext()) {
                        list = (List)destination$iv$iv2;
                        return list;
                    }
                    Object item$iv$iv = iterator.next();
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(Utils.resolveIdeHomeVariable((String)it, this.ideDirectory));
                }
            }
        }
        list = OpenedPackagesKt.getOpenedPackages();
        return list;
    }

    private final List<String> getHeapSpace() {
        String string;
        String string2;
        String string3;
        String it;
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        Object[] objectArray3 = objectArray2 = new String[2];
        int n2 = 0;
        String string4 = this.options.getMaxHeapSize();
        if (string4 != null) {
            String string5 = string4;
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            string3 = "-Xmx" + it;
            objectArray3 = objectArray;
            n2 = n;
            string2 = string3;
        } else {
            string2 = null;
        }
        objectArray3[n2] = string2;
        Object[] objectArray4 = objectArray2;
        int n3 = 1;
        String string6 = this.options.getMinHeapSize();
        if (string6 != null) {
            it = string6;
            n = n3;
            objectArray = objectArray4;
            boolean bl = false;
            string3 = "-Xms" + it;
            objectArray4 = objectArray;
            n3 = n;
            string = string3;
        } else {
            string = null;
        }
        objectArray4[n3] = string;
        return CollectionsKt.listOfNotNull((Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> asArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.defaultHeapSpace, (Iterable)this.getBootclasspath()), (Iterable)this.getVmOptions()), (Iterable)this.getAdditionalJvmArguments()), (Iterable)this.getHeapSpace());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

