/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.jbr;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.Properties;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.provider.Provider;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.Jbr;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001-B/\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J&\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004Js\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010%\u001a\u00020&2#\b\u0002\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020&0(Ji\u0010,\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00172#\b\u0002\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020&0(R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver;", "", "jreRepository", "Lorg/gradle/api/provider/Provider;", "", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Lorg/gradle/api/provider/Provider;Lorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "kotlin.jvm.PlatformType", "findJavaExecutable", "Ljava/nio/file/Path;", "javaHome", "fromDir", "Lorg/jetbrains/intellij/jbr/Jbr;", "javaDir", "version", "getBuiltinJbrVersion", "ideDirectory", "Ljava/io/File;", "getJavaArchive", "jbrArtifact", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "getJbrRoot", "resolve", "variant", "arch", "resolveRuntime", "runtimeDir", "jbrVersion", "jbrVariant", "jbrArch", "ideDir", "resolveExecutable", "", "validate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "executable", "resolveRuntimeDir", "JbrArtifact", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nJbrResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbrResolver.kt\norg/jetbrains/intellij/jbr/JbrResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n1#2:305\n288#3,2:306\n*S KotlinDebug\n*F\n+ 1 JbrResolver.kt\norg/jetbrains/intellij/jbr/JbrResolver\n*L\n184#1:306,2\n*E\n"})
public abstract class JbrResolver {
    @NotNull
    private final Provider<String> jreRepository;
    @NotNull
    private final ArchiveUtils archiveUtils;
    @NotNull
    private final DependenciesDownloader dependenciesDownloader;
    @Nullable
    private final String context;
    private final OperatingSystem operatingSystem;

    @Inject
    public JbrResolver(@NotNull Provider<String> jreRepository, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkNotNullParameter(jreRepository, (String)"jreRepository");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.jreRepository = jreRepository;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        this.operatingSystem = OperatingSystem.current();
    }

    @Nullable
    public final Path resolveRuntimeDir(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable String jbrVariant, @Nullable String jbrArch, @Nullable File ideDir, @NotNull Function1<? super Path, Boolean> validate) {
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        return this.resolveRuntime(runtimeDir, jbrVersion, jbrVariant, jbrArch, ideDir, false, validate);
    }

    public static /* synthetic */ Path resolveRuntimeDir$default(JbrResolver jbrResolver, String string, String string2, String string3, String string4, File file, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntimeDir");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            file = null;
        }
        if ((n & 0x20) != 0) {
            function1 = resolveRuntimeDir.1.INSTANCE;
        }
        return jbrResolver.resolveRuntimeDir(string, string2, string3, string4, file, (Function1<? super Path, Boolean>)function1);
    }

    @Nullable
    public final Path resolveRuntime(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable String jbrVariant, @Nullable String jbrArch, @Nullable File ideDir, boolean resolveExecutable, @NotNull Function1<? super Path, Boolean> validate) {
        Object object;
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        Utils.debug$default(this.context, "Resolving runtime directory.", null, 4, null);
        Object object2 = new Function0[]{new Function0<Path>(runtimeDir, this, resolveExecutable){
            final /* synthetic */ String $runtimeDir;
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ boolean $resolveExecutable;
            {
                this.$runtimeDir = $runtimeDir;
                this.this$0 = $receiver;
                this.$resolveExecutable = $resolveExecutable;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path;
                String string = this.$runtimeDir;
                if (string != null) {
                    Path path2;
                    String string2 = string;
                    JbrResolver jbrResolver = this.this$0;
                    boolean bl = this.$resolveExecutable;
                    String path3 = string2;
                    boolean bl2 = false;
                    Path p0 = Path.of(path3, new String[0]);
                    boolean bl3 = false;
                    Path $this$invoke_u24lambda_u243_u24lambda_u240 = JbrResolver.access$getJbrRoot(jbrResolver, p0);
                    boolean bl4 = false;
                    p0 = path2 = bl ? $this$invoke_u24lambda_u243_u24lambda_u240.resolve("bin/java") : $this$invoke_u24lambda_u243_u24lambda_u240;
                    boolean bl5 = false;
                    Path it = path2 = FileUtilKt.exists((Path)p0) ? path2 : null;
                    boolean bl6 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with runtimeDir='" + path3 + "' resolved as: " + it, null, 4, null);
                    path = Utils.ifNull(path2, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, path3){
                        final /* synthetic */ JbrResolver this$0;
                        final /* synthetic */ String $path;
                        {
                            this.this$0 = $receiver;
                            this.$path = $path;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with runtimeDir='" + this.$path + "'", null, 4, null);
                        }
                    }));
                } else {
                    path = null;
                }
                return path;
            }
        }, new Function0<Path>(jbrVersion, this, jbrVariant, jbrArch, resolveExecutable){
            final /* synthetic */ String $jbrVersion;
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $jbrVariant;
            final /* synthetic */ String $jbrArch;
            final /* synthetic */ boolean $resolveExecutable;
            {
                this.$jbrVersion = $jbrVersion;
                this.this$0 = $receiver;
                this.$jbrVariant = $jbrVariant;
                this.$jbrArch = $jbrArch;
                this.$resolveExecutable = $resolveExecutable;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path;
                String string = this.$jbrVersion;
                if (string != null) {
                    Path path2;
                    Path path3;
                    String string2 = string;
                    JbrResolver jbrResolver = this.this$0;
                    String string3 = this.$jbrVariant;
                    String string4 = this.$jbrArch;
                    boolean bl = this.$resolveExecutable;
                    String version2 = string2;
                    boolean bl2 = false;
                    Jbr jbr = jbrResolver.resolve(version2, string3, string4);
                    if (jbr != null) {
                        Jbr $this$invoke_u24lambda_u243_u24lambda_u241 = jbr;
                        boolean bl3 = false;
                        if (bl) {
                            String string5 = $this$invoke_u24lambda_u243_u24lambda_u241.getJavaExecutable();
                            if (string5 != null) {
                                String it = string5;
                                boolean bl4 = false;
                                path3 = Path.of(it, new String[0]);
                            } else {
                                path3 = null;
                            }
                        } else {
                            Path p0 = $this$invoke_u24lambda_u243_u24lambda_u241.getJavaHome();
                            boolean bl5 = false;
                            path3 = JbrResolver.access$getJbrRoot(jbrResolver, p0);
                        }
                    } else {
                        path3 = null;
                    }
                    Path it = path2 = path3;
                    boolean bl6 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with jbrVersion='" + version2 + "', jbrVariant='" + string3 + "', jbrArch='" + string4 + "' resolved as: " + it, null, 4, null);
                    path = Utils.ifNull(path2, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, version2, string3, string4){
                        final /* synthetic */ JbrResolver this$0;
                        final /* synthetic */ String $version;
                        final /* synthetic */ String $jbrVariant;
                        final /* synthetic */ String $jbrArch;
                        {
                            this.this$0 = $receiver;
                            this.$version = $version;
                            this.$jbrVariant = $jbrVariant;
                            this.$jbrArch = $jbrArch;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with jbrVersion='" + this.$version + "', jbrVariant='" + this.$jbrVariant + "', jbrArch='" + this.$jbrArch + "'", null, 4, null);
                        }
                    }));
                } else {
                    path = null;
                }
                return path;
            }
        }, new Function0<Path>(ideDir, this, resolveExecutable){
            final /* synthetic */ File $ideDir;
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ boolean $resolveExecutable;
            {
                this.$ideDir = $ideDir;
                this.this$0 = $receiver;
                this.$resolveExecutable = $resolveExecutable;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path;
                File file = this.$ideDir;
                if (file != null) {
                    Path path2;
                    Path path3;
                    Path path4;
                    File file2 = file;
                    JbrResolver jbrResolver = this.this$0;
                    boolean bl = this.$resolveExecutable;
                    File file3 = file2;
                    boolean bl2 = false;
                    Path p0 = file3.toPath();
                    boolean bl3 = false;
                    Path $this$invoke_u24lambda_u245_u24lambda_u243 = JbrResolver.access$getJbrRoot(jbrResolver, p0);
                    boolean bl4 = false;
                    Path p02 = path4 = $this$invoke_u24lambda_u245_u24lambda_u243.resolve("bin/java");
                    boolean bl5 = false;
                    Path path5 = FileUtilKt.exists((Path)p02) ? path4 : null;
                    if (path5 != null) {
                        Path executable = path5;
                        boolean bl6 = false;
                        if (bl) {
                            path3 = executable;
                        } else {
                            Path path6;
                            Path it = path6 = $this$invoke_u24lambda_u245_u24lambda_u243;
                            boolean bl7 = false;
                            path3 = FileUtilKt.exists((Path)executable) ? path6 : null;
                        }
                    } else {
                        path3 = null;
                    }
                    Path it = path2 = path3;
                    boolean bl8 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with ideDir='" + file3 + "' resolved as: " + it, null, 4, null);
                    path = Utils.ifNull(path2, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, file3){
                        final /* synthetic */ JbrResolver this$0;
                        final /* synthetic */ File $file;
                        {
                            this.this$0 = $receiver;
                            this.$file = $file;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with ideDir='" + this.$file + "'", null, 4, null);
                        }
                    }));
                } else {
                    path = null;
                }
                return path;
            }
        }, new Function0<Path>(ideDir, this, jbrVariant, jbrArch, resolveExecutable){
            final /* synthetic */ File $ideDir;
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $jbrVariant;
            final /* synthetic */ String $jbrArch;
            final /* synthetic */ boolean $resolveExecutable;
            {
                this.$ideDir = $ideDir;
                this.this$0 = $receiver;
                this.$jbrVariant = $jbrVariant;
                this.$jbrArch = $jbrArch;
                this.$resolveExecutable = $resolveExecutable;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path;
                File file = this.$ideDir;
                if (file != null) {
                    Path path2;
                    File file2 = file;
                    JbrResolver jbrResolver = this.this$0;
                    String string = this.$jbrVariant;
                    String string2 = this.$jbrArch;
                    boolean bl = this.$resolveExecutable;
                    File file3 = file2;
                    boolean bl2 = false;
                    String string3 = JbrResolver.access$getBuiltinJbrVersion(jbrResolver, file3);
                    if (string3 != null) {
                        Path path3;
                        Path path4;
                        String version2 = string3;
                        boolean bl3 = false;
                        Jbr jbr = jbrResolver.resolve(version2, string, string2);
                        if (jbr != null) {
                            Jbr $this$invoke_u24lambda_u244_u24lambda_u243_u24lambda_u241 = jbr;
                            boolean bl4 = false;
                            if (bl) {
                                String string4 = $this$invoke_u24lambda_u244_u24lambda_u243_u24lambda_u241.getJavaExecutable();
                                if (string4 != null) {
                                    String it = string4;
                                    boolean bl5 = false;
                                    path4 = Path.of(it, new String[0]);
                                } else {
                                    path4 = null;
                                }
                            } else {
                                Path p0 = $this$invoke_u24lambda_u244_u24lambda_u243_u24lambda_u241.getJavaHome();
                                boolean bl6 = false;
                                path4 = JbrResolver.access$getJbrRoot(jbrResolver, p0);
                            }
                        } else {
                            path4 = null;
                        }
                        Path it = path3 = path4;
                        boolean bl7 = false;
                        Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with ideDir='" + file3 + "', version='" + version2 + "' resolved as: " + it, null, 4, null);
                        path2 = Utils.ifNull(path3, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, file3, version2){
                            final /* synthetic */ JbrResolver this$0;
                            final /* synthetic */ File $file;
                            final /* synthetic */ String $version;
                            {
                                this.this$0 = $receiver;
                                this.$file = $file;
                                this.$version = $version;
                                super(0);
                            }

                            public final void invoke() {
                                Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with ideDir='" + this.$file + "', version='" + this.$version + "'", null, 4, null);
                            }
                        }));
                    } else {
                        path2 = null;
                    }
                    path = Utils.ifNull(path2, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, file3){
                        final /* synthetic */ JbrResolver this$0;
                        final /* synthetic */ File $file;
                        {
                            this.this$0 = $receiver;
                            this.$file = $file;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with ideDir='" + this.$file + "'", null, 4, null);
                        }
                    }));
                } else {
                    path = null;
                }
                return path;
            }
        }, new Function0<Path>(resolveExecutable, this){
            final /* synthetic */ boolean $resolveExecutable;
            final /* synthetic */ JbrResolver this$0;
            {
                this.$resolveExecutable = $resolveExecutable;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path;
                Object object = Jvm.current();
                boolean bl = this.$resolveExecutable;
                JbrResolver jbrResolver = this.this$0;
                Jvm $this$invoke_u24lambda_u240 = object;
                boolean bl2 = false;
                boolean bl3 = bl;
                if (bl3) {
                    path = $this$invoke_u24lambda_u240.getJavaExecutable().toPath();
                } else if (!bl3) {
                    Path p0 = $this$invoke_u24lambda_u240.getJavaHome().toPath();
                    boolean bl4 = false;
                    path = JbrResolver.access$getJbrRoot(jbrResolver, p0);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object = path;
                JbrResolver jbrResolver2 = this.this$0;
                Object it = object;
                boolean bl5 = false;
                Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver2), "Using current JVM: " + (Path)it, null, 4, null);
                return (Path)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ JbrResolver this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve current JVM", null, 4, null);
                    }
                }));
            }
        }};
        Path path = (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])object2)), (Function1)((Function1)new Function1<Function0<? extends Path>, Path>(validate){
            final /* synthetic */ Function1<Path, Boolean> $validate;
            {
                this.$validate = $validate;
                super(1);
            }

            @Nullable
            public final Path invoke(@NotNull Function0<? extends Path> it) {
                Path path;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Path path2 = (Path)it.invoke();
                return path2 != null ? (((Boolean)this.$validate.invoke((Object)(path = path2))).booleanValue() ? path : null) : null;
            }
        })));
        if (path != null) {
            Object it = object2 = path;
            boolean bl = false;
            Utils.info$default(this.context, "Resolved JVM Runtime directory: " + (Path)it, null, 4, null);
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    public static /* synthetic */ Path resolveRuntime$default(JbrResolver jbrResolver, String string, String string2, String string3, String string4, File file, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntime");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            file = null;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x40) != 0) {
            function1 = resolveRuntime.1.INSTANCE;
        }
        return jbrResolver.resolveRuntime(string, string2, string3, string4, file, bl, (Function1<? super Path, Boolean>)function1);
    }

    @Nullable
    public final Jbr resolve(@Nullable String version2, @Nullable String variant, @Nullable String arch) {
        Jbr jbr;
        CharSequence charSequence = version2;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        JbrArtifact jbrArtifact = JbrArtifact.Companion.from(version2, variant, arch, operatingSystem);
        Path path = this.getJavaArchive(jbrArtifact);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Path javaDir = Path.of(StringsKt.replaceAfter$default((String)((Object)it).toString(), (String)jbrArtifact.getName(), (String)"", null, (int)4, null), new String[0]).resolve("extracted");
            Intrinsics.checkNotNullExpressionValue((Object)javaDir, (String)"javaDir");
            ArchiveUtils.extract$default(this.archiveUtils, it, javaDir, this.context, null, null, 24, null);
            jbr = this.fromDir(javaDir, version2);
        } else {
            jbr = null;
        }
        return jbr;
    }

    private final Jbr fromDir(Path javaDir, String version2) {
        Jbr jbr;
        Path path = this.findJavaExecutable(javaDir);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            jbr = new Jbr(version2, javaDir, it.toFile().getCanonicalPath());
        } else {
            jbr = null;
        }
        return Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(this, javaDir){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ Path $javaDir;
            {
                this.this$0 = $receiver;
                this.$javaDir = $javaDir;
                super(0);
            }

            public final void invoke() {
                Utils.warn$default(JbrResolver.access$getContext$p(this.this$0), "Cannot find java executable in: " + this.$javaDir, null, 4, null);
            }
        }));
    }

    private final Path getJavaArchive(JbrArtifact jbrArtifact) {
        Path path;
        Object object = this.jreRepository.getOrNull();
        String it = (String)object;
        boolean bl = false;
        CharSequence charSequence = it;
        String string = Utils.or(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? object : null, jbrArtifact.getRepositoryUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jreRepository\n          \u2026brArtifact.repositoryUrl)");
        String url = string;
        try {
            path = ((File)CollectionsKt.first(this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(jbrArtifact){
                final /* synthetic */ JbrArtifact $jbrArtifact;
                {
                    this.$jbrArtifact = $jbrArtifact;
                    super(1);
                }

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains", (String)"jbre", (String)this.$jbrArtifact.getName(), null, null, (String)"tar.gz", (int)24, null);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
                final /* synthetic */ String $url;
                {
                    this.$url = $url;
                    super(1);
                }

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, this.$url, "[revision].tar.gz", null, 4, null);
                }
            }), true))).toPath();
        }
        catch (Exception e) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + "'", null, 4, null);
            path = null;
        }
        return path;
    }

    private final Path findJavaExecutable(Path javaHome) {
        Object object;
        Path root = this.getJbrRoot(javaHome);
        Path jre = root.resolve("jre");
        Object it = object = jre;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Object object2 = FileUtilKt.exists((Path)it) ? object : null;
        it = object = ".exe";
        Path path = Utils.or(object2, root);
        boolean bl2 = false;
        boolean bl3 = this.operatingSystem.isWindows();
        Object object3 = bl3 ? object : null;
        if (object3 == null) {
            object3 = "";
        }
        Path java = path.resolve("bin/java" + (String)object3);
        it = object = java;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)java, (String)"java");
        return FileUtilKt.exists((Path)java) ? object : null;
    }

    private final Path getJbrRoot(Path javaHome) {
        Path path;
        Path path2;
        Object v0;
        block8: {
            Iterable $this$firstOrNull$iv = FileUtilKt.listFiles((Path)javaHome);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)FileUtilKt.getSimpleName((Path)it), (String)"jbr", (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        Path path3 = v0;
        if (path3 != null) {
            Path path4;
            Path p0 = path4 = path3;
            boolean bl = false;
            path2 = FileUtilKt.exists((Path)p0) ? path4 : null;
        } else {
            path2 = null;
        }
        Path jbr = path2;
        if (this.operatingSystem.isMacOsX()) {
            Path path5;
            if (javaHome.endsWith("Contents/Home")) {
                path5 = javaHome;
            } else {
                Path path6 = jbr;
                path5 = path6 != null ? path6.resolve("Contents/Home") : javaHome.resolve("jdk/Contents/Home");
            }
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"when {\n                j\u2026ents/Home\")\n            }");
        } else {
            path = jbr;
            if (path == null) {
                path = javaHome;
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getBuiltinJbrVersion(File ideDirectory) {
        File dependenciesFile = new File(ideDirectory, "dependencies.txt");
        if (dependenciesFile.exists()) {
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(dependenciesFile);){
                properties.load(reader);
                String string = properties.getProperty("runtimeBuild");
                if (string == null) {
                    string = properties.getProperty("jdkBuild");
                }
                String string2 = string;
                return string2;
            }
        }
        return null;
    }

    public static final /* synthetic */ Path access$getJbrRoot(JbrResolver $this, Path javaHome) {
        return $this.getJbrRoot(javaHome);
    }

    public static final /* synthetic */ String access$getContext$p(JbrResolver $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getBuiltinJbrVersion(JbrResolver $this, File ideDirectory) {
        return $this.getBuiltinJbrVersion(ideDirectory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "", "name", "", "repositoryUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRepositoryUrl", "Companion", "gradle-intellij-plugin"})
    public static final class JbrArtifact {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String repositoryUrl;

        public JbrArtifact(@NotNull String name, @NotNull String repositoryUrl) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
            this.name = name;
            this.repositoryUrl = repositoryUrl;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002J\u0015\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact$Companion;", "", "()V", "arch", "", "newFormat", "", "arch$gradle_intellij_plugin", "from", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "jbrVersion", "jbrVariant", "jbrArch", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "getPrefix", "version", "variant", "platform", "platform$gradle_intellij_plugin", "gradle-intellij-plugin"})
        @SourceDebugExtension(value={"SMAP\nJbrResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbrResolver.kt\norg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n1#2:305\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final JbrArtifact from(@NotNull String jbrVersion, @Nullable String jbrVariant, @Nullable String jbrArch, @NotNull OperatingSystem operatingSystem) {
                String arch;
                boolean oldFormat;
                String string;
                String string2;
                boolean bl;
                String string3;
                Intrinsics.checkNotNullParameter((Object)jbrVersion, (String)"jbrVersion");
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                String it = string3 = "8";
                boolean bl2 = false;
                String string4 = StringsKt.startsWith$default((CharSequence)jbrVersion, (char)'u', (boolean)false, (int)2, null) ? string3 : null;
                if (string4 == null) {
                    string4 = "";
                }
                String version2 = string4 + jbrVersion;
                String prefix2 = this.getPrefix(version2, jbrVariant);
                int lastIndexOfB = StringsKt.lastIndexOf$default((CharSequence)version2, (char)'b', (int)0, (boolean)false, (int)6, null);
                int lastIndexOfDash = StringsKt.lastIndexOf$default((CharSequence)version2, (char)'-', (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl3 = bl = lastIndexOfB > -1;
                if (bl) {
                    String string5 = version2.substring(lastIndexOfDash, lastIndexOfB);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else if (!bl) {
                    String string6 = version2.substring(lastIndexOfDash);
                    string2 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String majorVersion = string2;
                boolean bl4 = lastIndexOfB > -1;
                if (bl4 == (lastIndexOfDash == lastIndexOfB)) {
                    String string7 = version2.substring(0, lastIndexOfDash - 1);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else if (bl4) {
                    String string8 = version2.substring(lastIndexOfB + 1);
                    string = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String buildNumberString = string;
                Version buildNumber2 = Version.Companion.parse(buildNumberString);
                boolean isJava8 = StringsKt.startsWith$default((String)majorVersion, (String)"8", (boolean)false, (int)2, null);
                boolean isJava17 = StringsKt.startsWith$default((String)majorVersion, (String)"17", (boolean)false, (int)2, null);
                boolean bl5 = oldFormat = Intrinsics.areEqual((Object)prefix2, (Object)"jbrex") || isJava8 && buildNumber2.compareTo(Version.Companion.parse("1483.24")) < 0;
                if (oldFormat) {
                    return new JbrArtifact("jbrex" + majorVersion + "b" + buildNumberString + "_" + this.platform$gradle_intellij_plugin(operatingSystem) + "_" + this.arch$gradle_intellij_plugin(false), "https://cache-redirector.jetbrains.com/intellij-jbr");
                }
                String string9 = jbrArch;
                if (string9 == null) {
                    string9 = arch = this.arch$gradle_intellij_plugin(isJava8);
                }
                if (((CharSequence)prefix2).length() == 0) {
                    prefix2 = isJava17 ? "jbr_jcef-" : (isJava8 ? "jbrx-" : (operatingSystem.isMacOsX() && Intrinsics.areEqual((Object)arch, (Object)"aarch64") ? "jbr_jcef-" : (buildNumber2.compareTo(Version.Companion.parse("1319.6")) < 0 ? "jbr-" : "jbr_jcef-")));
                }
                return new JbrArtifact(prefix2 + majorVersion + "-" + this.platform$gradle_intellij_plugin(operatingSystem) + "-" + arch + "-b" + buildNumberString, "https://cache-redirector.jetbrains.com/intellij-jbr");
            }

            private final String getPrefix(String version2, String variant) {
                CharSequence charSequence = variant;
                return !(charSequence == null || charSequence.length() == 0) ? (Intrinsics.areEqual((Object)variant, (Object)"sdk") ? "jbrsdk-" : "jbr_" + variant + "-") : (StringsKt.startsWith$default((String)version2, (String)"jbrsdk-", (boolean)false, (int)2, null) ? "jbrsdk-" : (StringsKt.startsWith$default((String)version2, (String)"jbr_jcef-", (boolean)false, (int)2, null) ? "jbr_jcef-" : (StringsKt.startsWith$default((String)version2, (String)"jbr_dcevm-", (boolean)false, (int)2, null) ? "jbr_dcevm-" : (StringsKt.startsWith$default((String)version2, (String)"jbr_fd-", (boolean)false, (int)2, null) ? "jbr_fd-" : (StringsKt.startsWith$default((String)version2, (String)"jbr_nomod-", (boolean)false, (int)2, null) ? "jbr_nomod-" : (StringsKt.startsWith$default((String)version2, (String)"jbr-", (boolean)false, (int)2, null) ? "jbr-" : (StringsKt.startsWith$default((String)version2, (String)"jbrx-", (boolean)false, (int)2, null) ? "jbrx-" : (StringsKt.startsWith$default((String)version2, (String)"jbrex8", (boolean)false, (int)2, null) ? "jbrex" : ""))))))));
            }

            @NotNull
            public final String platform$gradle_intellij_plugin(@NotNull OperatingSystem operatingSystem) {
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                return operatingSystem.isWindows() ? "windows" : (operatingSystem.isMacOsX() ? "osx" : "linux");
            }

            @NotNull
            public final String arch$gradle_intellij_plugin(boolean newFormat) {
                String string;
                String arch = System.getProperty("os.arch");
                if (Intrinsics.areEqual((Object)"aarch64", (Object)arch) || Intrinsics.areEqual((Object)"arm64", (Object)arch)) {
                    return "aarch64";
                }
                if (Intrinsics.areEqual((Object)"x86_64", (Object)arch) || Intrinsics.areEqual((Object)"amd64", (Object)arch)) {
                    return "x64";
                }
                String name = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (StringsKt.contains$default((CharSequence)name, (CharSequence)"Windows", (boolean)false, (int)2, null) && System.getenv("ProgramFiles(x86)") != null) {
                    return "x64";
                }
                boolean bl = newFormat;
                if (bl) {
                    string = "i586";
                } else if (!bl) {
                    string = "x86";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

