/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.model.PerformanceTestResult;
import org.jetbrains.intellij.model.PerformanceTestScript;
import org.jetbrains.intellij.model.PerformanceTestStatistic;
import org.jetbrains.intellij.performanceTest.ProfilerName;
import org.jetbrains.intellij.performanceTest.TestExecutionFailException;
import org.jetbrains.intellij.performanceTest.parsers.IdeaLogParser;
import org.jetbrains.intellij.performanceTest.parsers.SimpleIJPerformanceParser;
import org.jetbrains.intellij.tasks.RunIdeBase;
import org.jetbrains.intellij.tasks.RunIdePerformanceTestTask;

@Incubating
@UntrackedTask(because="Should always run IDE for performance tests")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0017R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/intellij/tasks/RunIdePerformanceTestTask;", "Lorg/jetbrains/intellij/tasks/RunIdeBase;", "()V", "artifactsDir", "Lorg/gradle/api/provider/Property;", "", "getArtifactsDir", "()Lorg/gradle/api/provider/Property;", "context", "profilerName", "Lorg/jetbrains/intellij/performanceTest/ProfilerName;", "getProfilerName", "scriptPath", "testArtifactsDirPath", "Ljava/nio/file/Path;", "testDataDir", "getTestDataDir", "collectJvmArgs", "", "exec", "", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nRunIdePerformanceTestTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunIdePerformanceTestTask.kt\norg/jetbrains/intellij/tasks/RunIdePerformanceTestTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1855#2,2:137\n*S KotlinDebug\n*F\n+ 1 RunIdePerformanceTestTask.kt\norg/jetbrains/intellij/tasks/RunIdePerformanceTestTask\n*L\n109#1:137,2\n*E\n"})
public abstract class RunIdePerformanceTestTask
extends RunIdeBase {
    private String scriptPath;
    private Path testArtifactsDirPath;
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public RunIdePerformanceTestTask() {
        this.setGroup("intellij");
        this.setDescription("Runs performance tests on the IDE with the developed plugin installed.");
    }

    @Input
    @NotNull
    public abstract Property<String> getTestDataDir();

    @Input
    @NotNull
    public abstract Property<String> getArtifactsDir();

    @Input
    @NotNull
    public abstract Property<ProfilerName> getProfilerName();

    @Override
    @TaskAction
    public void exec() {
        Path path = Paths.get((String)this.getArtifactsDir().get(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(artifactsDir.get())");
        Path dir = FileUtilKt.createDir((Path)path);
        Path testData = Path.of((String)this.getTestDataDir().get(), new String[0]);
        List testExecutionResults = new ArrayList();
        Files.walk(testData, 1, new FileVisitOption[0]).filter(exec.1.INSTANCE).forEach(new Consumer(this, dir, testExecutionResults){
            final /* synthetic */ RunIdePerformanceTestTask this$0;
            final /* synthetic */ Path $dir;
            final /* synthetic */ List<PerformanceTestResult> $testExecutionResults;
            {
                this.this$0 = $receiver;
                this.$dir = $dir;
                this.$testExecutionResults = $testExecutionResults;
            }

            public final void accept(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String testName = FileUtilKt.getNameWithoutExtension((Path)it);
                PerformanceTestScript testScript = new SimpleIJPerformanceParser(it).parse();
                RunIdePerformanceTestTask.access$setScriptPath$p(this.this$0, ((Object)it.toAbsolutePath()).toString());
                Path path = this.$dir.resolve(testName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dir.resolve(testName)");
                Path path2 = FileUtilKt.createDir((Path)path).toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir.resolve(testName).createDir().toAbsolutePath()");
                RunIdePerformanceTestTask.access$setTestArtifactsDirPath$p(this.this$0, path2);
                this.this$0.setArgs(CollectionsKt.listOf((Object)(this.this$0.getTestDataDir().get() + "/" + testScript.getProjectName())));
                RunIdePerformanceTestTask.access$exec$s1804108720(this.this$0);
                Path path3 = RunIdePerformanceTestTask.access$getTestArtifactsDirPath$p(this.this$0);
                if (path3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
                    path3 = null;
                }
                PerformanceTestStatistic performanceTestStatistic = new IdeaLogParser(((Object)path3.resolve("idea.log")).toString()).getTestStatistic();
                RunIdePerformanceTestTask runIdePerformanceTestTask = this.this$0;
                List<PerformanceTestResult> list = this.$testExecutionResults;
                PerformanceTestStatistic testResults = performanceTestStatistic;
                boolean bl = false;
                Utils.info$default(RunIdePerformanceTestTask.access$getContext$p(runIdePerformanceTestTask), "Total time " + testResults.getTotalTime() + "ms, expected time ms " + testScript.getAssertionTimeout() + "ms", null, 4, null);
                if (testScript.getAssertionTimeout() != null) {
                    Long l = testResults.getTotalTime();
                    Intrinsics.checkNotNull((Object)l);
                    if (l > testScript.getAssertionTimeout()) {
                        list.add(new PerformanceTestResult(testName, testResults, testScript));
                    }
                }
            }
        });
        if (!((Collection)testExecutionResults).isEmpty()) {
            Iterable $this$forEach$iv = testExecutionResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PerformanceTestResult it = (PerformanceTestResult)element$iv;
                boolean bl = false;
                Utils.error$default(this.context, "TEST `" + it.getTestName() + "` FAILED", null, 4, null);
                Utils.error$default(this.context, "Expected time of execution `" + it.getScript().getAssertionTimeout() + "ms`, but was " + it.getStatistic().getTotalTime() + "ms", null, 4, null);
            }
            throw new TestExecutionFailException(testExecutionResults.size() + " test(s) failed");
        }
    }

    @Override
    @NotNull
    protected List<String> collectJvmArgs() {
        Collection collection = super.collectJvmArgs();
        Object[] objectArray = new String[13];
        objectArray[0] = "-Djdk.attach.allowAttachSelf=true";
        objectArray[1] = "-Didea.is.integration.test=true";
        objectArray[2] = "-Djb.privacy.policy.text=<!--999.999-->";
        objectArray[3] = "-Djb.consents.confirmation.enabled=false";
        objectArray[4] = "-Didea.local.statistics.without.report=true";
        objectArray[5] = "-Dlinux.native.menu.force.disable=true";
        objectArray[6] = "-Didea.fatal.error.notification=true";
        String string = this.scriptPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scriptPath");
            string = null;
        }
        objectArray[7] = "-Dtestscript.filename=" + string;
        String string2 = ((ProfilerName)((Object)this.getProfilerName().get())).name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        objectArray[8] = "-DintegrationTests.profiler=" + string2;
        Path path = this.testArtifactsDirPath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
            path = null;
        }
        objectArray[9] = "-Dide.performance.screenshot.before.kill=" + path;
        Path path2 = this.testArtifactsDirPath;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
            path2 = null;
        }
        objectArray[10] = "-Didea.log.path=" + path2;
        Path path3 = this.testArtifactsDirPath;
        if (path3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
            path3 = null;
        }
        objectArray[11] = "-Dsnapshots.path=" + path3;
        Path path4 = this.testArtifactsDirPath;
        if (path4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
            path4 = null;
        }
        objectArray[12] = "-Dmemory.snapshots.path=" + path4;
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.mutableListOf((Object[])objectArray));
    }

    public static final /* synthetic */ void access$setScriptPath$p(RunIdePerformanceTestTask $this, String string) {
        $this.scriptPath = string;
    }

    public static final /* synthetic */ void access$setTestArtifactsDirPath$p(RunIdePerformanceTestTask $this, Path path) {
        $this.testArtifactsDirPath = path;
    }

    public static final /* synthetic */ void access$exec$s1804108720(RunIdePerformanceTestTask $this) {
        super.exec();
    }

    public static final /* synthetic */ Path access$getTestArtifactsDirPath$p(RunIdePerformanceTestTask $this) {
        return $this.testArtifactsDirPath;
    }

    public static final /* synthetic */ String access$getContext$p(RunIdePerformanceTestTask $this) {
        return $this.context;
    }
}

