/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;

@Incubating
@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/intellij/tasks/ListBundledPluginsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "context", "", "ideDir", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getIdeDir", "()Lorg/gradle/api/provider/Property;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "listBundledPlugins", "", "gradle-intellij-plugin"})
public abstract class ListBundledPluginsTask
extends DefaultTask {
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public ListBundledPluginsTask() {
        this.setGroup("intellij");
        this.setDescription("List bundled plugins within the currently targeted IntelliJ-based IDE release.");
    }

    @Input
    @NotNull
    public abstract Property<File> getIdeDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void listBundledPlugins() {
        Object object = this.getOutputFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFile.get()");
        Path path = Utils.getAsPath((FileSystemLocation)object);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputFile.get().asPath");
        Closeable closeable = FileUtilKt.outputStream((Path)path);
        Throwable throwable = null;
        try {
            String string;
            OutputStream os = (OutputStream)closeable;
            boolean bl = false;
            Path path2 = ((File)this.getIdeDir().get()).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"ideDir.get().toPath()");
            String $this$listBundledPlugins_u24lambda_u241_u24lambda_u240 = string = CollectionsKt.joinToString$default((Iterable)BuiltinPluginsRegistry.Companion.resolveBundledPlugins(path2, this.context), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean bl2 = false;
            byte[] byArray = $this$listBundledPlugins_u24lambda_u241_u24lambda_u240.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            os.write(byArray);
            String string2 = string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

