/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/tasks/VerifyPluginTask;", "Lorg/gradle/api/DefaultTask;", "()V", "context", "", "ignoreFailures", "Lorg/gradle/api/provider/Property;", "", "getIgnoreFailures", "()Lorg/gradle/api/provider/Property;", "ignoreUnacceptableWarnings", "getIgnoreUnacceptableWarnings", "ignoreWarnings", "getIgnoreWarnings", "pluginDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPluginDir", "()Lorg/gradle/api/file/DirectoryProperty;", "verifyPlugin", "", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nVerifyPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifyPluginTask.kt\norg/jetbrains/intellij/tasks/VerifyPluginTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1#2:92\n1855#3,2:93\n1855#3,2:95\n1855#3,2:97\n*S KotlinDebug\n*F\n+ 1 VerifyPluginTask.kt\norg/jetbrains/intellij/tasks/VerifyPluginTask\n*L\n65#1:93,2\n68#1:95,2\n73#1:97,2\n*E\n"})
public abstract class VerifyPluginTask
extends DefaultTask {
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public VerifyPluginTask() {
        this.setGroup("intellij");
        this.setDescription("Validates completeness and contents of `plugin.xml` descriptors as well as plugin archive structure.");
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreFailures();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreUnacceptableWarnings();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreWarnings();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getPluginDir();

    @TaskAction
    public final void verifyPlugin() {
        boolean failBuild;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        PluginCreationResult creationResult;
        Directory it = (Directory)this.getPluginDir().get();
        boolean bl = false;
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Path path = Utils.getAsPath((FileSystemLocation)it);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.asPath");
        PluginCreationResult pluginCreationResult = creationResult = idePluginManager.createPlugin(path);
        if (pluginCreationResult instanceof PluginCreationSuccess) {
            PluginProblem it2;
            $this$forEach$iv = ((PluginCreationSuccess)creationResult).getWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (PluginProblem)element$iv;
                boolean bl2 = false;
                Utils.warn$default(this.context, it2.getMessage(), null, 4, null);
            }
            $this$forEach$iv = ((PluginCreationSuccess)creationResult).getUnacceptableWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (PluginProblem)element$iv;
                boolean bl3 = false;
                Utils.error$default(this.context, it2.getMessage(), null, 4, null);
            }
        } else if (pluginCreationResult instanceof PluginCreationFail) {
            $this$forEach$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginProblem it3 = (PluginProblem)element$iv;
                boolean bl4 = false;
                if (it3.getLevel() == PluginProblem.Level.ERROR) {
                    Utils.error$default(this.context, it3.getMessage(), null, 4, null);
                    continue;
                }
                Utils.warn$default(this.context, it3.getMessage(), null, 4, null);
            }
        } else {
            Utils.error$default(this.context, creationResult.toString(), null, 4, null);
        }
        boolean bl5 = !(creationResult instanceof PluginCreationSuccess) || (Boolean)this.getIgnoreUnacceptableWarnings().get() == false && !((Collection)((PluginCreationSuccess)creationResult).getUnacceptableWarnings()).isEmpty() || (Boolean)this.getIgnoreWarnings().get() == false && !((Collection)((PluginCreationSuccess)creationResult).getWarnings()).isEmpty() ? true : (failBuild = false);
        if (failBuild && !((Boolean)this.getIgnoreFailures().get()).booleanValue()) {
            throw new GradleException("Plugin verification failed.");
        }
    }
}

