/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.tools.ant.util.TeeOutputStream;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(H\u0002J\b\u0010)\u001a\u00020\tH\u0002J\b\u0010*\u001a\u00020+H\u0007R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000bR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000bR\u0014\u0010%\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000f\u00a8\u0006,"}, d2={"Lorg/jetbrains/intellij/tasks/SignPluginTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "certificateChain", "Lorg/gradle/api/provider/Property;", "", "getCertificateChain", "()Lorg/gradle/api/provider/Property;", "certificateChainFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCertificateChainFile", "()Lorg/gradle/api/file/RegularFileProperty;", "cliPath", "getCliPath", "context", "inputArchiveFile", "getInputArchiveFile", "keyStore", "getKeyStore", "keyStoreKeyAlias", "getKeyStoreKeyAlias", "keyStorePassword", "getKeyStorePassword", "keyStoreProviderName", "getKeyStoreProviderName", "keyStoreType", "getKeyStoreType", "outputArchiveFile", "getOutputArchiveFile", "password", "getPassword", "privateKey", "getPrivateKey", "privateKeyFile", "getPrivateKeyFile", "getOptions", "", "resolveCliPath", "signPlugin", "", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nSignPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignPluginTask.kt\norg/jetbrains/intellij/tasks/SignPluginTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public abstract class SignPluginTask
extends DefaultTask {
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final String context;

    @Inject
    public SignPluginTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        this.context = Utils.logCategory((Task)this);
        this.setGroup("intellij");
        this.setDescription("Signs the ZIP archive with the provided key using marketplace-zip-signer library.");
    }

    @InputFile
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getInputArchiveFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputArchiveFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCliPath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStore();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStorePassword();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreKeyAlias();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreType();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreProviderName();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPrivateKey();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getPrivateKeyFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPassword();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCertificateChain();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getCertificateChainFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void signPlugin() {
        Path file;
        RegularFile regularFile = (RegularFile)this.getInputArchiveFile().getOrNull();
        Path path = file = regularFile != null ? Utils.getAsPath((FileSystemLocation)regularFile) : null;
        if (file == null || !FileUtilKt.exists((Path)file)) {
            throw new IllegalStateException("Plugin file does not exist: " + file);
        }
        if (this.getPrivateKey().getOrNull() == null && this.getPrivateKeyFile().getOrNull() == null) {
            throw new InvalidUserDataException("Private key not found. One of the 'signPlugin.privateKey' or 'signPlugin.privateKeyFile' properties has to be provided.");
        }
        if (this.getCertificateChain().getOrNull() == null && this.getCertificateChainFile().getOrNull() == null) {
            throw new InvalidUserDataException("Certificate chain not found. One of the 'signPlugin.certificateChain' or 'signPlugin.certificateChainFile' properties has to be provided.");
        }
        String cliPath = this.resolveCliPath();
        List cliArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"sign"), (Iterable)this.getOptions());
        Utils.debug$default(this.context, "Distribution file: " + file, null, 4, null);
        Utils.debug$default(this.context, "Marketplace ZIP Signer CLI path: " + cliPath, null, 4, null);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ExecResult execResult;
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            try {
                execResult = this.execOperations.javaexec(new Action(this, cliPath, cliArgs, os){
                    final /* synthetic */ SignPluginTask this$0;
                    final /* synthetic */ String $cliPath;
                    final /* synthetic */ List<String> $cliArgs;
                    final /* synthetic */ ByteArrayOutputStream $os;
                    {
                        this.this$0 = $receiver;
                        this.$cliPath = $cliPath;
                        this.$cliArgs = $cliArgs;
                        this.$os = $os;
                    }

                    public final void execute(@NotNull JavaExecSpec $this$javaexec) {
                        Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$this$javaexec");
                        Object[] objectArray = new Object[]{this.$cliPath};
                        $this$javaexec.setClasspath((FileCollection)SignPluginTask.access$getObjectFactory$p(this.this$0).fileCollection().from(objectArray));
                        $this$javaexec.getMainClass().set((Object)"org.jetbrains.zip.signer.ZipSigningTool");
                        $this$javaexec.setArgs(this.$cliArgs);
                        $this$javaexec.setStandardOutput((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)this.$os));
                        $this$javaexec.setErrorOutput((OutputStream)new TeeOutputStream((OutputStream)System.err, (OutputStream)this.$os));
                    }
                });
            }
            catch (ExecException e) {
                Utils.error$default(this.context, "Error during Marketplace ZIP Signer CLI execution:\n" + os, null, 4, null);
                throw e;
            }
            ExecResult execResult2 = execResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String resolveCliPath() {
        String path = (String)this.getCliPath().getOrNull();
        CharSequence charSequence = path;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Path verifier = Path.of(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"verifier");
            if (FileUtilKt.exists((Path)verifier)) {
                return path;
            }
        }
        throw new InvalidUserDataException("Provided Marketplace ZIP Signer path doesn't exist.");
    }

    private final List<String> getOptions() {
        List args;
        block15: {
            String it;
            Unit unit;
            Unit unit2;
            String p0;
            byte[] p02;
            Object object;
            Object[] objectArray = new String[4];
            objectArray[0] = "-in";
            Object object2 = this.getInputArchiveFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inputArchiveFile.get()");
            objectArray[1] = ((Object)Utils.getAsPath((FileSystemLocation)object2).toAbsolutePath()).toString();
            objectArray[2] = "-out";
            Object object3 = this.getOutputArchiveFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"outputArchiveFile.get()");
            objectArray[3] = ((Object)Utils.getAsPath((FileSystemLocation)object3).toAbsolutePath()).toString();
            args = CollectionsKt.mutableListOf((Object[])objectArray);
            String string = (String)this.getPrivateKey().getOrNull();
            if (string != null) {
                Object $this$getOptions_u24lambda_u243_u24lambda_u241;
                String it2 = string;
                boolean bl = false;
                args.add("-key");
                object = Base64.getDecoder();
                try {
                    $this$getOptions_u24lambda_u243_u24lambda_u241 = object;
                    boolean bl2 = false;
                    p02 = ((Base64.Decoder)$this$getOptions_u24lambda_u243_u24lambda_u241).decode(((Object)StringsKt.trim((CharSequence)it2)).toString());
                    boolean bl3 = false;
                    $this$getOptions_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)new String(p02, Charsets.UTF_8));
                }
                catch (Throwable bl2) {
                    $this$getOptions_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object = $this$getOptions_u24lambda_u243_u24lambda_u241;
                $this$getOptions_u24lambda_u243_u24lambda_u241 = it2;
                p0 = (String)(Result.isFailure-impl((Object)object) ? $this$getOptions_u24lambda_u243_u24lambda_u241 : object);
                boolean bl4 = false;
                args.add(p0);
                Utils.debug$default(this.context, "Using private key passed as content", null, 4, null);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 == null) {
                SignPluginTask $this$getOptions_u24lambda_u244 = this;
                boolean bl = false;
                args.add("-key-file");
                Object object4 = $this$getOptions_u24lambda_u244.getPrivateKeyFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"privateKeyFile.get()");
                args.add(((Object)Utils.getAsPath((FileSystemLocation)object4).toAbsolutePath()).toString());
                Utils.debug$default($this$getOptions_u24lambda_u244.context, "Using private key passed as file", null, 4, null);
            }
            String string2 = (String)this.getCertificateChain().getOrNull();
            if (string2 != null) {
                Object $this$getOptions_u24lambda_u248_u24lambda_u246;
                String it3 = string2;
                boolean bl = false;
                args.add("-cert");
                object = Base64.getDecoder();
                try {
                    $this$getOptions_u24lambda_u248_u24lambda_u246 = object;
                    boolean bl5 = false;
                    p02 = ((Base64.Decoder)$this$getOptions_u24lambda_u248_u24lambda_u246).decode(((Object)StringsKt.trim((CharSequence)it3)).toString());
                    boolean bl6 = false;
                    $this$getOptions_u24lambda_u248_u24lambda_u246 = Result.constructor-impl((Object)new String(p02, Charsets.UTF_8));
                }
                catch (Throwable bl5) {
                    $this$getOptions_u24lambda_u248_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                }
                object = $this$getOptions_u24lambda_u248_u24lambda_u246;
                $this$getOptions_u24lambda_u248_u24lambda_u246 = it3;
                p0 = (String)(Result.isFailure-impl((Object)object) ? $this$getOptions_u24lambda_u248_u24lambda_u246 : object);
                boolean bl7 = false;
                args.add(p0);
                Utils.debug$default(this.context, "Using certificate chain passed as content", null, 4, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                SignPluginTask $this$getOptions_u24lambda_u249 = this;
                boolean bl = false;
                args.add("-cert-file");
                Object object5 = $this$getOptions_u24lambda_u249.getCertificateChainFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"certificateChainFile.get()");
                args.add(((Object)Utils.getAsPath((FileSystemLocation)object5).toAbsolutePath()).toString());
                Utils.debug$default($this$getOptions_u24lambda_u249.context, "Using certificate chain passed as file", null, 4, null);
            }
            String string3 = (String)this.getPassword().getOrNull();
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                args.add("-key-pass");
                args.add(it);
                Utils.debug$default(this.context, "Using private key password", null, 4, null);
            }
            String string4 = (String)this.getKeyStore().getOrNull();
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                args.add("-ks");
                args.add(it);
            }
            String string5 = (String)this.getKeyStorePassword().getOrNull();
            if (string5 != null) {
                it = string5;
                boolean bl = false;
                args.add("-ks-pass");
                args.add(it);
            }
            String string6 = (String)this.getKeyStoreKeyAlias().getOrNull();
            if (string6 != null) {
                it = string6;
                boolean bl = false;
                args.add("-ks-key-alias");
                args.add(it);
            }
            String string7 = (String)this.getKeyStoreType().getOrNull();
            if (string7 != null) {
                it = string7;
                boolean bl = false;
                args.add("-ks-type");
                args.add(it);
            }
            String string8 = (String)this.getKeyStoreProviderName().getOrNull();
            if (string8 == null) break block15;
            it = string8;
            boolean bl = false;
            args.add("-ks-provider-name");
            args.add(it);
        }
        return args;
    }

    public static final /* synthetic */ ObjectFactory access$getObjectFactory$p(SignPluginTask $this) {
        return $this.objectFactory;
    }
}

