/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/tasks/JarSearchableOptionsTask;", "Lorg/gradle/jvm/tasks/Jar;", "()V", "context", "", "noSearchableOptionsWarning", "Lorg/gradle/api/provider/Property;", "", "getNoSearchableOptionsWarning", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginName", "getPluginName", "sandboxDir", "getSandboxDir", "copy", "", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nJarSearchableOptionsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarSearchableOptionsTask.kt\norg/jetbrains/intellij/tasks/JarSearchableOptionsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n2624#2,3:109\n*S KotlinDebug\n*F\n+ 1 JarSearchableOptionsTask.kt\norg/jetbrains/intellij/tasks/JarSearchableOptionsTask\n*L\n94#1:109,3\n*E\n"})
public abstract class JarSearchableOptionsTask
extends Jar {
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public JarSearchableOptionsTask() {
        this.setGroup("intellij");
        this.setDescription("Creates a JAR file with searchable options to be distributed with the plugin.");
        final Set pluginJarFiles = new LinkedHashSet();
        Object[] objectArray = new Object[]{new Function0<Path>(){

            public final Path invoke() {
                this.include(new Spec(){

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean isSatisfiedBy(FileTreeElement it) {
                        boolean bl;
                        if (it.isDirectory()) {
                            bl = true;
                        } else {
                            Object p0;
                            Set<String> set;
                            Object object;
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            if (StringsKt.endsWith$default((String)string, (String)".searchableOptions.xml", (boolean)false, (int)2, null) && pluginJarFiles.isEmpty()) {
                                void $this$mapTo$iv$iv;
                                Path path = Path.of((String)this.getSandboxDir().get(), new String[0]).resolve((String)this.getPluginName().get()).resolve("lib");
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(sandboxDir.get())\n   \u2026          .resolve(\"lib\")");
                                Iterable $this$map$iv = FileUtilKt.listFiles((Path)path);
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void p02;
                                    Path path2 = (Path)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    collection.add(FileUtilKt.getSimpleName((Path)p02));
                                }
                                object = (List)destination$iv$iv;
                                set = pluginJarFiles;
                                p0 = (Collection)object;
                                boolean bl3 = false;
                                set.addAll((Collection<String>)p0);
                            }
                            String string2 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                            object = StringsKt.replace$default((String)string2, (String)".searchableOptions.xml", (String)"", (boolean)false, (int)4, null);
                            set = pluginJarFiles;
                            p0 = object;
                            boolean bl4 = false;
                            bl = set.contains(p0);
                        }
                        return bl;
                    }
                });
                Object object = this.getOutputDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
                return Utils.getAsPath((FileSystemLocation)object);
            }
        }};
        this.from(objectArray);
        this.eachFile(2.INSTANCE);
        this.setIncludeEmptyDirs(false);
    }

    @OutputDirectory
    @Optional
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPluginName();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSandboxDir();

    @Internal
    @NotNull
    public abstract Property<Boolean> getNoSearchableOptionsWarning();

    @TaskAction
    protected void copy() {
        super.copy();
        Object object = this.getNoSearchableOptionsWarning().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"noSearchableOptionsWarning.get()");
        if (((Boolean)object).booleanValue()) {
            boolean noSearchableOptions;
            block5: {
                boolean bl;
                FileCollection fileCollection = this.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"source");
                Iterable $this$none$iv = (Iterable)fileCollection;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        File it = (File)element$iv;
                        boolean bl2 = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        if (!StringsKt.endsWith$default((String)string, (String)".searchableOptions.xml", (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = noSearchableOptions = true;
                }
            }
            if (noSearchableOptions) {
                Utils.warn$default(this.context, "No searchable options found. If plugin is not supposed to provide custom settings exposed in UI, disable building searchable options to decrease the build time. See: https://plugins.jetbrains.com/docs/intellij/tools-gradle-intellij-plugin-faq.html#how-to-disable-building-searchable-options", null, 4, null);
            }
        }
    }
}

