/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.BuildException;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.IntelliJPluginConstants;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IdeaDependencyManager;
import org.jetbrains.intellij.dependency.IdeaExtraDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.JpsIdeaDependency;
import org.jetbrains.intellij.dependency.LocalIdeaDependency;
import org.jetbrains.intellij.model.AndroidStudioReleases;
import org.jetbrains.intellij.model.Download;
import org.jetbrains.intellij.model.Item;
import org.jetbrains.intellij.model.XmlExtractor;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\b&\u0018\u00002\u00020\u0001:\u0001=B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJR\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J \u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\"\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020!H\u0002J\u001e\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0018\u0010+\u001a\n ,*\u0004\u0018\u00010\u001c0\u001c2\u0006\u0010-\u001a\u00020\u001cH\u0002J,\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\"\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u00100\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00032\b\u00102\u001a\u0004\u0018\u00010\u0003J4\u00103\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u00104\u001a\u00020!2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u001a\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\"\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0002J(\u0010;\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010<\u001a\u00020!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>\u00b2\u0006\n\u0010?\u001a\u00020!X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependencyManager;", "", "repositoryUrl", "", "ideaDependencyCachePath", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "mainDependencies", "", "createDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "name", "type", "version", "buildNumber", "classesDirectory", "Ljava/io/File;", "sourcesDirectory", "project", "Lorg/gradle/api/Project;", "extraDependencies", "", "Lorg/jetbrains/intellij/dependency/IdeaExtraDependency;", "getOrCreateIvyXml", "Ljava/nio/file/Path;", "dependency", "getZipCacheDirectory", "zipFile", "hasKotlinDependency", "", "isCacheUpToDate", "markerFile", "checkVersion", "register", "", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "resetExecutablePermissions", "cacheDirectory", "resolveAndroidStudioPath", "kotlin.jvm.PlatformType", "parentPath", "resolveExtraDependencies", "resolveExtraDependency", "resolveLocal", "localPath", "localPathSources", "resolveRemote", "sources", "resolveSources", "setExecutable", "parent", "child", "storeCache", "directoryToCache", "unzipDependencyFile", "checkVersionChange", "RemoteIdeaDependency", "gradle-intellij-plugin", "hasAppleM1Link"})
@SourceDebugExtension(value={"SMAP\nIdeaDependencyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaDependencyManager.kt\norg/jetbrains/intellij/dependency/IdeaDependencyManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,513:1\n1#2:514\n1855#3,2:515\n1747#3,3:517\n766#3:520\n857#3:521\n1747#3,3:522\n858#3:525\n1855#3,2:526\n*S KotlinDebug\n*F\n+ 1 IdeaDependencyManager.kt\norg/jetbrains/intellij/dependency/IdeaDependencyManager\n*L\n234#1:515,2\n259#1:517,3\n434#1:520\n434#1:521\n434#1:522,3\n434#1:525\n439#1:526,2\n*E\n"})
public abstract class IdeaDependencyManager {
    @NotNull
    private final String repositoryUrl;
    @NotNull
    private final String ideaDependencyCachePath;
    @NotNull
    private final ArchiveUtils archiveUtils;
    @NotNull
    private final DependenciesDownloader dependenciesDownloader;
    @Nullable
    private final String context;
    @NotNull
    private final List<String> mainDependencies;

    @Inject
    public IdeaDependencyManager(@NotNull String repositoryUrl, @NotNull String ideaDependencyCachePath, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)ideaDependencyCachePath, (String)"ideaDependencyCachePath");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.repositoryUrl = repositoryUrl;
        this.ideaDependencyCachePath = ideaDependencyCachePath;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        Object[] objectArray = new String[]{"ideaIC", "ideaIU", "riderRD", "riderRS"};
        this.mainDependencies = CollectionsKt.listOf((Object[])objectArray);
    }

    public final void register(@NotNull Project project, @NotNull IdeaDependency dependency, @NotNull DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Path ivyFile = this.getOrCreateIvyXml(dependency);
        String string = FileUtilKt.getSimpleName((Path)ivyFile).substring((dependency.getName() + "-" + dependency.getVersion()).length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String ivyFileSuffix = StringsKt.removeSuffix((String)string, (CharSequence)".xml");
        project.getRepositories().ivy(new Action(dependency, ivyFile, ivyFileSuffix){
            final /* synthetic */ IdeaDependency $dependency;
            final /* synthetic */ Path $ivyFile;
            final /* synthetic */ String $ivyFileSuffix;
            {
                this.$dependency = $dependency;
                this.$ivyFile = $ivyFile;
                this.$ivyFileSuffix = $ivyFileSuffix;
            }

            public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$this$ivy");
                $this$ivy.setUrl(this.$dependency.getClasses().toURI());
                $this$ivy.ivyPattern(this.$ivyFile.getParent() + "/[module]-[revision]" + this.$ivyFileSuffix + ".[ext]");
                $this$ivy.artifactPattern(this.$dependency.getClasses().getPath() + "/[artifact].[ext]");
                if (this.$dependency.getSources() != null) {
                    $this$ivy.artifactPattern(this.$dependency.getSources().getParent() + "/[artifact]-[revision]-[classifier].[ext]");
                }
            }
        });
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        dependencies.add((Object)DependencyHandlerExtensionsKt.create$default((DependencyHandler)dependencyHandler, (String)"com.jetbrains", (String)dependency.getName(), (String)dependency.getVersion(), (String)"compile", null, null, (int)48, null));
    }

    private final IdeaDependency createDependency(String name, String type, String version2, String buildNumber2, File classesDirectory2, File sourcesDirectory, Project project, Collection<IdeaExtraDependency> extraDependencies) {
        IdeaDependency ideaDependency;
        if (Intrinsics.areEqual((Object)type, (Object)"JPS")) {
            ideaDependency = new JpsIdeaDependency(version2, buildNumber2, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), this.context);
        } else {
            Path path = FilesKt.resolve((File)classesDirectory2, (String)"plugins").toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"classesDirectory.resolve(\"plugins\").toPath()");
            BuiltinPluginsRegistry pluginsRegistry = BuiltinPluginsRegistry.Companion.fromDirectory(path, this.context);
            ideaDependency = type == null ? (IdeaDependency)new LocalIdeaDependency(name, version2, buildNumber2, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies) : new IdeaDependency(name, version2, buildNumber2, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies);
        }
        return ideaDependency;
    }

    private final File resolveSources(String version2, String type) {
        Utils.info$default(this.context, "Adding IDE sources repository", null, 4, null);
        try {
            String releaseType = Utils.releaseType(version2);
            boolean forPyCharm = Utils.isPyCharmType(type);
            List sourcesFiles2 = DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, this.context, (Function1)new Function1<DependencyHandler, Dependency>(forPyCharm, version2){
                final /* synthetic */ boolean $forPyCharm;
                final /* synthetic */ String $version;
                {
                    this.$forPyCharm = $forPyCharm;
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)(this.$forPyCharm ? "com.jetbrains.intellij.pycharm" : "com.jetbrains.intellij.idea"), (String)(this.$forPyCharm ? "pycharmPC" : "ideaIC"), (String)this.$version, null, (String)"sources", (String)"jar", (int)8, null);
                }
            }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;
                {
                    this.this$0 = $receiver;
                    this.$releaseType = $releaseType;
                    super(1);
                }

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return (ArtifactRepository)DependenciesDownloaderKt.mavenRepository$default($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + "/" + this.$releaseType, null, 2, null);
                }
            }, false, 8, null);
            if (sourcesFiles2.size() == 1) {
                File sourcesDirectory = (File)CollectionsKt.first((List)sourcesFiles2);
                Utils.debug$default(this.context, "IDE sources jar: " + sourcesDirectory.getPath(), null, 4, null);
                return sourcesDirectory;
            }
            Utils.warn$default(this.context, "Cannot attach IDE sources. Found files: " + sourcesFiles2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE sources dependency", e);
        }
        return null;
    }

    private final Path unzipDependencyFile(File cacheDirectory, File zipFile, String type, boolean checkVersionChange) {
        Path path = zipFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"zipFile.toPath()");
        String string = zipFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zipFile\n                .name");
        Path path2 = FilesKt.resolve((File)cacheDirectory, (String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)".zip"), (CharSequence)".tar.gz")).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"cacheDirectory.resolve(\n\u2026r.gz\")\n        ).toPath()");
        return this.archiveUtils.extract(path, path2, this.context, new Predicate(this, zipFile, checkVersionChange){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ File $zipFile;
            final /* synthetic */ boolean $checkVersionChange;
            {
                this.this$0 = $receiver;
                this.$zipFile = $zipFile;
                this.$checkVersionChange = $checkVersionChange;
            }

            public final boolean test(@NotNull Path markerFile) {
                Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
                File file = markerFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"markerFile.toFile()");
                return IdeaDependencyManager.access$isCacheUpToDate(this.this$0, this.$zipFile, file, this.$checkVersionChange);
            }
        }, new BiConsumer(this, type){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ String $type;
            {
                this.this$0 = $receiver;
                this.$type = $type;
            }

            public final void accept(@NotNull Path unzippedDirectory, @NotNull Path markerFile) {
                Intrinsics.checkNotNullParameter((Object)unzippedDirectory, (String)"unzippedDirectory");
                Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
                File file = unzippedDirectory.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"unzippedDirectory.toFile()");
                IdeaDependencyManager.access$resetExecutablePermissions(this.this$0, file, this.$type);
                File file2 = unzippedDirectory.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"unzippedDirectory.toFile()");
                File file3 = markerFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"markerFile.toFile()");
                IdeaDependencyManager.access$storeCache(this.this$0, file2, file3);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isCacheUpToDate(File zipFile, File markerFile, boolean checkVersion) {
        if (!checkVersion) {
            return markerFile.exists();
        }
        if (!markerFile.exists()) {
            return false;
        }
        Closeable closeable = new ZipFile(zipFile);
        Throwable throwable = null;
        try {
            String string;
            ZipEntry zipEntry;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            ZipEntry zipEntry2 = zip.getEntry("build.txt");
            if (zipEntry2 == null) {
                boolean bl2 = false;
                return bl2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"zip.getEntry(\"build.txt\") ?: return false");
            ZipEntry entry = zipEntry2;
            Closeable closeable2 = zip.getInputStream(entry);
            Throwable throwable2 = null;
            try {
                InputStream it = (InputStream)closeable2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader(inputStream, charset);
                int n = 8192;
                string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String entryContent = string;
            if (!Intrinsics.areEqual((Object)entryContent, (Object)FilesKt.readText$default((File)markerFile, null, (int)1, null))) {
                boolean bl4 = false;
                return bl4;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    private final void storeCache(File directoryToCache, File markerFile) {
        block0: {
            File file;
            File file2;
            File p0 = file2 = new File(directoryToCache, "build.txt");
            boolean bl = false;
            File file3 = file = p0.exists() ? file2 : null;
            if (file == null) break block0;
            File it = file;
            boolean bl2 = false;
            FilesKt.writeText$default((File)markerFile, (String)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)it, null, (int)1, null))).toString(), null, (int)2, null);
        }
    }

    private final void resetExecutablePermissions(File cacheDirectory, String type) {
        if (Intrinsics.areEqual((Object)type, (Object)"RD") && !OperatingSystem.current().isWindows()) {
            for (File file : FilesKt.walkTopDown((File)cacheDirectory)) {
                if (!file.isFile() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"dylib") && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"py") && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"sh") && !StringsKt.startsWith$default((String)FilesKt.getExtension((File)file), (String)"so", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)file.getName(), (Object)"dotnet") && !Intrinsics.areEqual((Object)file.getName(), (Object)"env-wrapper") && !Intrinsics.areEqual((Object)file.getName(), (Object)"mono-sgen") && !Intrinsics.areEqual((Object)file.getName(), (Object)"BridgeService") && !Intrinsics.areEqual((Object)file.getName(), (Object)"JetBrains.Profiler.PdbServer") && !Intrinsics.areEqual((Object)file.getName(), (Object)"JBDeviceService") && !Intrinsics.areEqual((Object)file.getName(), (Object)"Rider.Backend")) continue;
                String string = FilesKt.relativeTo((File)file, (File)cacheDirectory).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.relativeTo(cacheDirectory).toString()");
                this.setExecutable(cacheDirectory, string, this.context);
            }
        }
    }

    private final void setExecutable(File parent, String child, String context) {
        File file;
        File $this$setExecutable_u24lambda_u243 = file = new File(parent, child);
        boolean bl = false;
        Utils.debug$default(context, "Resetting executable permissions for: " + $this$setExecutable_u24lambda_u243.getPath(), null, 4, null);
        $this$setExecutable_u24lambda_u243.setExecutable(true, true);
    }

    private final Path getOrCreateIvyXml(IdeaDependency dependency) {
        Path ivyFile;
        block6: {
            IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator;
            block5: {
                File file = dependency.getIvyRepositoryDirectory();
                Path directory = file != null ? file.toPath() : null;
                Path path = directory;
                Path path2 = ivyFile = path != null ? path.resolve(dependency.getFqn() + ".xml") : Files.createTempFile(dependency.getFqn(), ".xml", new FileAttribute[0]);
                if (directory == null) break block5;
                Intrinsics.checkNotNullExpressionValue((Object)ivyFile, (String)"ivyFile");
                if (FileUtilKt.exists((Path)ivyFile)) break block6;
            }
            DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity("com.jetbrains", dependency.getName(), dependency.getVersion());
            IntelliJIvyDescriptorFileGenerator $this$getOrCreateIvyXml_u24lambda_u246 = intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity);
            boolean bl = false;
            $this$getOrCreateIvyXml_u24lambda_u246.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
            $this$getOrCreateIvyXml_u24lambda_u246.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("compile"));
            $this$getOrCreateIvyXml_u24lambda_u246.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("sources"));
            Iterable $this$forEach$iv = dependency.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                $this$getOrCreateIvyXml_u24lambda_u246.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, "compile", dependency.getClasses(), null));
            }
            if (dependency.getSources() != null) {
                IntellijIvyArtifact intellijIvyArtifact;
                String name = Utils.isDependencyOnPyCharm(dependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact $this$getOrCreateIvyXml_u24lambda_u246_u24lambda_u245 = intellijIvyArtifact = new IntellijIvyArtifact(dependency.getSources(), name, "jar", "sources", "sources");
                boolean bl3 = false;
                $this$getOrCreateIvyXml_u24lambda_u246_u24lambda_u245.setConf("sources");
                $this$getOrCreateIvyXml_u24lambda_u246.addArtifact($this$getOrCreateIvyXml_u24lambda_u246_u24lambda_u245);
            }
            Intrinsics.checkNotNullExpressionValue((Object)ivyFile, (String)"ivyFile");
            $this$getOrCreateIvyXml_u24lambda_u246.writeTo(ivyFile);
        }
        return ivyFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasKotlinDependency(Project project) {
        boolean bl;
        DependencySet dependencySet = project.getConfigurations().getByName("runtimeClasspath").getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"project.configurations.g\u2026         .allDependencies");
        Iterable $this$any$iv = (Iterable)dependencySet;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Dependency it = (Dependency)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)"org.jetbrains.kotlin", (Object)it.getGroup())) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (Utils.isKotlinRuntime(string)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public final IdeaDependency resolveRemote(@NotNull Project project, @NotNull String version2, @NotNull String type, boolean sources, @NotNull List<String> extraDependencies) {
        RemoteIdeaDependency remoteIdeaDependency2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(extraDependencies, (String)"extraDependencies");
        String releaseType = Utils.releaseType(version2);
        Utils.debug$default(this.context, "Adding IDE repository: " + this.repositoryUrl + "/" + releaseType, null, 4, null);
        Utils.debug$default(this.context, "Adding IDE dependency", null, 4, null);
        if (Intrinsics.areEqual((Object)type, (Object)"IU")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.idea", "ideaIU", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"IC")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.idea", "ideaIC", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"CL")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.clion", "clion", null, null, null, 28, null);
        } else if (Utils.isPyCharmType(type)) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.pycharm", "pycharm" + type, null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"GO")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.goland", "goland", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"PS")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.phpstorm", "phpstorm", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.rider", "riderRD", Utils.ifFalse(sources && !Intrinsics.areEqual((Object)releaseType, (Object)"snapshots"), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ IdeaDependencyManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Utils.warn$default(IdeaDependencyManager.access$getContext$p(this.this$0), "IDE sources are not available for Rider SNAPSHOTS", null, 4, null);
                }
            })), null, null, 24, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"GW")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.gateway", "JetBrainsGateway", false, null, null, 24, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"AI")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.google.android.studio", "android-studio", false, OperatingSystem.current().isLinux() ? "tar.gz" : "zip", (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(this){
                final /* synthetic */ IdeaDependencyManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IdeaDependencyManager ideaDependencyManager = this.this$0;
                    Path $this$invoke_u24lambda_u240 = it;
                    boolean bl = false;
                    Files.list(IdeaDependencyManager.access$resolveAndroidStudioPath(ideaDependencyManager, $this$invoke_u24lambda_u240)).forEach(new Consumer($this$invoke_u24lambda_u240){
                        final /* synthetic */ Path $this_with;
                        {
                            this.$this_with = $receiver;
                        }

                        public final void accept(Path entry) {
                            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Files.move(entry, this.$this_with.resolve(entry.getFileName()), copyOptionArray);
                        }
                    });
                }
            }));
        } else {
            throw new BuildException("Specified type '" + type + "' is unknown. Supported values: " + CollectionsKt.joinToString$default((Iterable)IntelliJPluginConstants.INSTANCE.getPLATFORM_TYPES(), null, null, null, (int)0, null, null, (int)63, null), null);
        }
        RemoteIdeaDependency remoteIdeaDependency3 = remoteIdeaDependency2;
        File it = (File)CollectionsKt.first((List)DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, this.context, (Function1)new Function1<DependencyHandler, Dependency>(remoteIdeaDependency3, version2){
            final /* synthetic */ RemoteIdeaDependency $remoteIdeaDependency;
            final /* synthetic */ String $version;
            {
                this.$remoteIdeaDependency = $remoteIdeaDependency;
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)this.$remoteIdeaDependency.getGroup(), (String)this.$remoteIdeaDependency.getName(), (String)this.$version, null, null, (String)this.$remoteIdeaDependency.getArtifactExtension(), (int)24, null);
            }
        }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(type, this, version2, releaseType){
            final /* synthetic */ String $type;
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ String $version;
            final /* synthetic */ String $releaseType;
            {
                this.$type = $type;
                this.this$0 = $receiver;
                this.$version = $version;
                this.$releaseType = $releaseType;
                super(1);
            }

            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                ArtifactRepository artifactRepository;
                block12: {
                    block9: {
                        String string;
                        Object v4;
                        block8: {
                            Object v2;
                            block7: {
                                Path it;
                                Object object;
                                Iterable<Path> iterable;
                                Object object2;
                                block11: {
                                    block10: {
                                        Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                                        if (!Intrinsics.areEqual((Object)this.$type, (Object)"AI")) break block9;
                                        object2 = DependenciesDownloaderKt.getAndroidStudioReleases(IdeaDependencyManager.access$getDependenciesDownloader$p(this.this$0), IdeaDependencyManager.access$getContext$p(this.this$0));
                                        if (object2 == null) break block10;
                                        iterable = object2;
                                        object = this.this$0;
                                        it = iterable;
                                        boolean bl = false;
                                        AndroidStudioReleases androidStudioReleases = (AndroidStudioReleases)new XmlExtractor<T>(IdeaDependencyManager.access$getContext$p((IdeaDependencyManager)object)).fetch(it);
                                        object2 = androidStudioReleases;
                                        if (androidStudioReleases != null) break block11;
                                    }
                                    throw new GradleException("Cannot resolve Android Studio Releases list");
                                }
                                Object androidStudioReleases = object2;
                                iterable = ((AndroidStudioReleases)androidStudioReleases).getItems();
                                object = this.$version;
                                it = iterable;
                                for (T t : it) {
                                    Item it2 = (Item)t;
                                    boolean bl = false;
                                    if (!(Intrinsics.areEqual((Object)it2.getVersion(), (Object)object) || Intrinsics.areEqual((Object)it2.getBuild(), (Object)("AI-" + (String)object)))) continue;
                                    v2 = t;
                                    break block7;
                                }
                                v2 = null;
                            }
                            Item item = v2;
                            if (item == null) {
                                throw new GradleException("Cannot resolve Android Studio with provided version: " + this.$version);
                            }
                            Item release = item;
                            String arch = System.getProperty("os.arch");
                            Lazy hasAppleM1Link$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(release){
                                final /* synthetic */ Item $release;
                                {
                                    this.$release = $release;
                                    super(0);
                                }

                                @NotNull
                                public final Boolean invoke() {
                                    boolean bl;
                                    block3: {
                                        Iterable $this$any$iv = this.$release.getDownloads();
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl = false;
                                        } else {
                                            for (T element$iv : $this$any$iv) {
                                                Download it = (Download)element$iv;
                                                boolean bl2 = false;
                                                if (!StringsKt.contains$default((CharSequence)it.getLink(), (CharSequence)"-mac_arm.zip", (boolean)false, (int)2, null)) continue;
                                                bl = true;
                                                break block3;
                                            }
                                            bl = false;
                                        }
                                    }
                                    return bl;
                                }
                            }));
                            OperatingSystem $this$invoke_u24lambda_u243 = OperatingSystem.current();
                            boolean bl = false;
                            String suffix = $this$invoke_u24lambda_u243.isMacOsX() ? (Intrinsics.areEqual((Object)arch, (Object)"aarch64") && resolveRemote.classesDirectory.2.invoke$lambda$2((Lazy<Boolean>)hasAppleM1Link$delegate) ? "-mac_arm.zip" : "-mac.zip") : ($this$invoke_u24lambda_u243.isLinux() ? "-linux.tar.gz" : "-windows.zip");
                            Iterable iterable = release.getDownloads();
                            for (T t : iterable) {
                                Download it = (Download)t;
                                boolean bl2 = false;
                                if (!StringsKt.endsWith$default((String)it.getLink(), (String)suffix, (boolean)false, (int)2, null)) continue;
                                v4 = t;
                                break block8;
                            }
                            v4 = null;
                        }
                        Download download = v4;
                        if (download == null || (string = download.getLink()) == null) {
                            throw new GradleException("Cannot resolve Android Studio with provided version: " + this.$version);
                        }
                        String url = string;
                        artifactRepository = (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, url, null, null, 6, null);
                        break block12;
                    }
                    artifactRepository = (ArtifactRepository)DependenciesDownloaderKt.mavenRepository$default($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + "/" + this.$releaseType, null, 2, null);
                }
                return artifactRepository;
            }

            private static final boolean invoke$lambda$2(Lazy<Boolean> $hasAppleM1Link$delegate) {
                Lazy<Boolean> lazy = $hasAppleM1Link$delegate;
                return (Boolean)lazy.getValue();
            }
        }, false, 8, null));
        boolean bl = false;
        Utils.debug$default(this.context, "IDE zip: " + it.getPath(), null, 4, null);
        Path path = this.unzipDependencyFile(this.getZipCacheDirectory(it, project, type), it, type, StringsKt.endsWith$default((String)version2, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
        remoteIdeaDependency3.getPostProcess().invoke((Object)path);
        Path classesDirectory2 = path;
        Utils.info$default(this.context, "IDE dependency cache directory: " + classesDirectory2, null, 4, null);
        String buildNumber2 = Utils.ideBuildNumber(classesDirectory2);
        Boolean bl2 = remoteIdeaDependency3.getHasSources();
        File sourcesDirectory = (bl2 != null ? bl2 : sources) ? this.resolveSources(version2, type) : null;
        Collection<IdeaExtraDependency> resolvedExtraDependencies = this.resolveExtraDependencies(project, version2, extraDependencies);
        String string = remoteIdeaDependency3.getName();
        File file = classesDirectory2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"classesDirectory.toFile()");
        return this.createDependency(string, type, version2, buildNumber2, file, sourcesDirectory, project, resolvedExtraDependencies);
    }

    @NotNull
    public final IdeaDependency resolveLocal(@NotNull Project project, @NotNull String localPath, @Nullable String localPathSources) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Utils.debug$default(this.context, "Adding local IDE dependency", null, 4, null);
        Path it = Path.of(localPath, new String[0]);
        boolean bl = false;
        Path it2 = path = it;
        boolean bl2 = false;
        Path path2 = !it2.endsWith(".app") ? path : null;
        if (path2 == null) {
            path2 = it.resolve("Contents");
        }
        Path ideaDir = path2;
        Intrinsics.checkNotNullExpressionValue((Object)ideaDir, (String)"ideaDir");
        if (!FileUtilKt.exists((Path)ideaDir) || !FileUtilKt.isDirectory((Path)ideaDir)) {
            throw new BuildException("Specified localPath '" + localPath + "' doesn't exist or is not a directory", null);
        }
        String buildNumber2 = Utils.ideBuildNumber(ideaDir);
        CharSequence charSequence = localPathSources;
        File sources = !(charSequence == null || charSequence.length() == 0) ? new File(localPathSources) : null;
        File file = ideaDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"ideaDir.toFile()");
        return this.createDependency("ideaLocal", null, buildNumber2, buildNumber2, file, sources, project, CollectionsKt.emptyList());
    }

    private final File getZipCacheDirectory(File zipFile, Project project, String type) {
        if (((CharSequence)this.ideaDependencyCachePath).length() > 0) {
            File file;
            File $this$getZipCacheDirectory_u24lambda_u2411 = file = new File(this.ideaDependencyCachePath);
            boolean bl = false;
            $this$getZipCacheDirectory_u24lambda_u2411.mkdirs();
            return file;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"RD") && OperatingSystem.current().isWindows()) {
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            return file;
        }
        File file = zipFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"zipFile.parentFile");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<IdeaExtraDependency> resolveExtraDependencies(Project project, String version2, List<String> extraDependencies) {
        List list;
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        if (extraDependencies.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Utils.info$default(this.context, "Configuring IDE extra dependencies: " + extraDependencies, null, 4, null);
        Iterable iterable = extraDependencies;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                String dep = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = this.mainDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)dep)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        List list2 = list = !((Collection)it).isEmpty() ? $this$filter$iv : null;
        if (list != null) {
            it = list;
            boolean bl4 = false;
            throw new GradleException("The items '" + it + "' cannot be used as extra dependencies");
        }
        List resolvedExtraDependencies = new ArrayList();
        Iterable $this$forEach$iv = extraDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl5 = false;
            if (this.resolveExtraDependency(project, version2, it2) != null) {
                File dependencyFile;
                boolean bl6 = false;
                IdeaExtraDependency extraDependency = new IdeaExtraDependency(it2, dependencyFile);
                Utils.debug$default(this.context, "IDE extra dependency '" + it2 + "' in '" + dependencyFile + "' files: " + extraDependency.getJarFiles(), null, 4, null);
                resolvedExtraDependencies.add(extraDependency);
                continue;
            }
            Utils.debug$default(this.context, "IDE extra dependency for '" + it2 + "' was resolved as null", null, 4, null);
        }
        return resolvedExtraDependencies;
    }

    private final File resolveExtraDependency(Project project, String version2, String name) {
        try {
            String releaseType = Utils.releaseType(version2);
            List files2 = DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, this.context, (Function1)new Function1<DependencyHandler, Dependency>(name, version2){
                final /* synthetic */ String $name;
                final /* synthetic */ String $version;
                {
                    this.$name = $name;
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains.intellij.idea", (String)this.$name, (String)this.$version, null, null, null, (int)56, null);
                }
            }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;
                {
                    this.this$0 = $receiver;
                    this.$releaseType = $releaseType;
                    super(1);
                }

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return (ArtifactRepository)DependenciesDownloaderKt.mavenRepository$default($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + "/" + this.$releaseType, null, 2, null);
                }
            }, false, 8, null);
            if (files2.size() == 1) {
                File file;
                File dependencyFile = (File)CollectionsKt.first((List)files2);
                Path dependency = dependencyFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dependency");
                if (FileUtilKt.isZip((Path)dependency)) {
                    File cacheDirectory = this.getZipCacheDirectory(dependencyFile, project, "IC");
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + cacheDirectory.getPath(), null, 4, null);
                    file = this.unzipDependencyFile(cacheDirectory, dependencyFile, "IC", StringsKt.endsWith$default((String)version2, (String)"-SNAPSHOT", (boolean)false, (int)2, null)).toFile();
                } else {
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + dependencyFile.getPath(), null, 4, null);
                    file = dependencyFile;
                }
                return file;
            }
            Utils.warn$default(this.context, "Cannot attach IDE extra dependency '" + name + "'. Found files: " + files2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE extra dependency '" + name + "'", e);
        }
        return null;
    }

    private final Path resolveAndroidStudioPath(Path parentPath) {
        Path path;
        Path it = path = OperatingSystem.current().isMacOsX() ? Files.list(parentPath).filter(resolveAndroidStudioPath.1.INSTANCE).findFirst().get().resolve("Contents") : parentPath.resolve("android-studio");
        boolean bl = false;
        Utils.info$default(this.context, "Android Studio path for " + OperatingSystem.current().getName() + " resolved as: " + it, null, 4, null);
        return path;
    }

    public static final /* synthetic */ String access$getRepositoryUrl$p(IdeaDependencyManager $this) {
        return $this.repositoryUrl;
    }

    public static final /* synthetic */ boolean access$isCacheUpToDate(IdeaDependencyManager $this, File zipFile, File markerFile, boolean checkVersion) {
        return $this.isCacheUpToDate(zipFile, markerFile, checkVersion);
    }

    public static final /* synthetic */ void access$resetExecutablePermissions(IdeaDependencyManager $this, File cacheDirectory, String type) {
        $this.resetExecutablePermissions(cacheDirectory, type);
    }

    public static final /* synthetic */ void access$storeCache(IdeaDependencyManager $this, File directoryToCache, File markerFile) {
        $this.storeCache(directoryToCache, markerFile);
    }

    public static final /* synthetic */ String access$getContext$p(IdeaDependencyManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ Path access$resolveAndroidStudioPath(IdeaDependencyManager $this, Path parentPath) {
        return $this.resolveAndroidStudioPath(parentPath);
    }

    public static final /* synthetic */ DependenciesDownloader access$getDependenciesDownloader$p(IdeaDependencyManager $this) {
        return $this.dependenciesDownloader;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0003JN\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependencyManager$RemoteIdeaDependency;", "", "group", "", "name", "hasSources", "", "artifactExtension", "postProcess", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getArtifactExtension", "()Ljava/lang/String;", "getGroup", "getHasSources", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getName", "getPostProcess", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/intellij/dependency/IdeaDependencyManager$RemoteIdeaDependency;", "equals", "other", "hashCode", "", "toString", "gradle-intellij-plugin"})
    private static final class RemoteIdeaDependency {
        @NotNull
        private final String group;
        @NotNull
        private final String name;
        @Nullable
        private final Boolean hasSources;
        @NotNull
        private final String artifactExtension;
        @NotNull
        private final Function1<Path, Unit> postProcess;

        public RemoteIdeaDependency(@NotNull String group, @NotNull String name, @Nullable Boolean hasSources, @NotNull String artifactExtension, @NotNull Function1<? super Path, Unit> postProcess) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)artifactExtension, (String)"artifactExtension");
            Intrinsics.checkNotNullParameter(postProcess, (String)"postProcess");
            this.group = group;
            this.name = name;
            this.hasSources = hasSources;
            this.artifactExtension = artifactExtension;
            this.postProcess = postProcess;
        }

        public /* synthetic */ RemoteIdeaDependency(String string, String string2, Boolean bl, String string3, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = null;
            }
            if ((n & 8) != 0) {
                string3 = "zip";
            }
            if ((n & 0x10) != 0) {
                function1 = 1.INSTANCE;
            }
            this(string, string2, bl, string3, (Function1<? super Path, Unit>)function1);
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Boolean getHasSources() {
            return this.hasSources;
        }

        @NotNull
        public final String getArtifactExtension() {
            return this.artifactExtension;
        }

        @NotNull
        public final Function1<Path, Unit> getPostProcess() {
            return this.postProcess;
        }

        @NotNull
        public final String component1() {
            return this.group;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final Boolean component3() {
            return this.hasSources;
        }

        @NotNull
        public final String component4() {
            return this.artifactExtension;
        }

        @NotNull
        public final Function1<Path, Unit> component5() {
            return this.postProcess;
        }

        @NotNull
        public final RemoteIdeaDependency copy(@NotNull String group, @NotNull String name, @Nullable Boolean hasSources, @NotNull String artifactExtension, @NotNull Function1<? super Path, Unit> postProcess) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)artifactExtension, (String)"artifactExtension");
            Intrinsics.checkNotNullParameter(postProcess, (String)"postProcess");
            return new RemoteIdeaDependency(group, name, hasSources, artifactExtension, postProcess);
        }

        public static /* synthetic */ RemoteIdeaDependency copy$default(RemoteIdeaDependency remoteIdeaDependency2, String string, String string2, Boolean bl, String string3, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = remoteIdeaDependency2.group;
            }
            if ((n & 2) != 0) {
                string2 = remoteIdeaDependency2.name;
            }
            if ((n & 4) != 0) {
                bl = remoteIdeaDependency2.hasSources;
            }
            if ((n & 8) != 0) {
                string3 = remoteIdeaDependency2.artifactExtension;
            }
            if ((n & 0x10) != 0) {
                function1 = remoteIdeaDependency2.postProcess;
            }
            return remoteIdeaDependency2.copy(string, string2, bl, string3, function1);
        }

        @NotNull
        public String toString() {
            return "RemoteIdeaDependency(group=" + this.group + ", name=" + this.name + ", hasSources=" + this.hasSources + ", artifactExtension=" + this.artifactExtension + ", postProcess=" + this.postProcess + ")";
        }

        public int hashCode() {
            int result2 = this.group.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + (this.hasSources == null ? 0 : ((Object)this.hasSources).hashCode());
            result2 = result2 * 31 + this.artifactExtension.hashCode();
            result2 = result2 * 31 + this.postProcess.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoteIdeaDependency)) {
                return false;
            }
            RemoteIdeaDependency remoteIdeaDependency2 = (RemoteIdeaDependency)other;
            if (!Intrinsics.areEqual((Object)this.group, (Object)remoteIdeaDependency2.group)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)remoteIdeaDependency2.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hasSources, (Object)remoteIdeaDependency2.hasSources)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.artifactExtension, (Object)remoteIdeaDependency2.artifactExtension)) {
                return false;
            }
            return Intrinsics.areEqual(this.postProcess, remoteIdeaDependency2.postProcess);
        }
    }
}

