/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.model.PluginsCache;
import org.jetbrains.intellij.model.PluginsCachePlugin;
import org.jetbrains.intellij.model.ProductInfo;
import org.jetbrains.intellij.model.XmlExtractor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0010\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020!H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "Ljava/io/Serializable;", "pluginsDirectory", "Ljava/io/File;", "context", "", "(Ljava/io/File;Ljava/lang/String;)V", "directoryNameMapping", "", "plugins", "Lorg/jetbrains/intellij/model/PluginsCachePlugin;", "add", "", "artifact", "cacheFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "collectBuiltinDependencies", "", "pluginIds", "dumpToCache", "extractor", "Lorg/jetbrains/intellij/model/XmlExtractor;", "Lorg/jetbrains/intellij/model/PluginsCache;", "equals", "", "other", "", "fillFromCache", "fillFromDirectory", "findPlugin", "name", "hashCode", "", "Companion", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nBuiltinPluginsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinPluginsRegistry.kt\norg/jetbrains/intellij/dependency/BuiltinPluginsRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,141:1\n1#2:142\n1855#3,2:143\n766#3:147\n857#3,2:148\n1549#3:150\n1620#3,3:151\n1295#4,2:145\n*S KotlinDebug\n*F\n+ 1 BuiltinPluginsRegistry.kt\norg/jetbrains/intellij/dependency/BuiltinPluginsRegistry\n*L\n28#1:143,2\n90#1:147\n90#1:148,2\n90#1:150\n90#1:151,3\n45#1:145,2\n*E\n"})
public final class BuiltinPluginsRegistry
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File pluginsDirectory;
    @Nullable
    private final String context;
    @NotNull
    private final Map<String, PluginsCachePlugin> plugins;
    @NotNull
    private final Map<String, String> directoryNameMapping;
    public static final int version = 1;

    public BuiltinPluginsRegistry(@NotNull File pluginsDirectory, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)pluginsDirectory, (String)"pluginsDirectory");
        this.pluginsDirectory = pluginsDirectory;
        this.context = context;
        this.plugins = new LinkedHashMap();
        this.directoryNameMapping = new LinkedHashMap();
    }

    private final boolean fillFromCache(XmlExtractor<PluginsCache> extractor) {
        boolean bl;
        Path path;
        Path p0 = path = this.cacheFile();
        boolean bl2 = false;
        Path path2 = FileUtilKt.exists((Path)p0) ? path : null;
        if (path2 == null) {
            return false;
        }
        Path cache = path2;
        Utils.debug$default(this.context, "Builtin registry cache is found. Loading from: " + cache, null, 4, null);
        try {
            Iterable $this$forEach$iv = extractor.unmarshal(cache).getPlugins();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginsCachePlugin it = (PluginsCachePlugin)element$iv;
                boolean bl3 = false;
                this.plugins.put(it.getId(), it);
                this.directoryNameMapping.put(it.getDirectoryName(), it.getId());
            }
            bl = true;
        }
        catch (Throwable t) {
            Utils.warn(this.context, "Cannot read builtin registry cache", t);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillFromDirectory() {
        Object[] objectArray = this.pluginsDirectory.listFiles();
        if (objectArray != null) {
            void $this$forEach$iv;
            Object[] objectArray2;
            Object[] $this$fillFromDirectory_u24lambda_u242 = objectArray2 = objectArray;
            boolean bl = false;
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])$this$fillFromDirectory_u24lambda_u242), (Function1)fillFromDirectory.1.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File p0 = (File)element$iv;
                boolean bl2 = false;
                this.add(p0);
            }
        }
        Utils.debug$default(this.context, "Builtin registry populated with " + this.plugins.size() + " plugins", null, 4, null);
    }

    private final void dumpToCache(XmlExtractor<PluginsCache> extractor) {
        Utils.debug$default(this.context, "Dumping cache for builtin plugin", null, 4, null);
        try {
            PluginsCache pluginsCache = new PluginsCache(CollectionsKt.toList((Iterable)this.plugins.values()));
            Path path = this.cacheFile();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cacheFile()");
            extractor.marshal(pluginsCache, path);
        }
        catch (Throwable t) {
            Utils.warn(this.context, "Failed to dump cache for builtin plugin", t);
        }
    }

    private final Path cacheFile() {
        return this.pluginsDirectory.toPath().resolve("builtinRegistry-1.xml");
    }

    @Nullable
    public final File findPlugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PluginsCachePlugin pluginsCachePlugin = this.plugins.get(name);
        if (pluginsCachePlugin == null && (pluginsCachePlugin = this.plugins.get(this.directoryNameMapping.get(name))) == null) {
            return null;
        }
        PluginsCachePlugin plugin = pluginsCachePlugin;
        File result2 = new File(this.pluginsDirectory, plugin.getDirectoryName());
        return result2.exists() && result2.isDirectory() ? result2 : null;
    }

    @NotNull
    public final Collection<String> collectBuiltinDependencies(@NotNull Collection<String> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        List idsToProcess = CollectionsKt.toMutableList(pluginIds);
        Set result2 = new LinkedHashSet();
        while (!((Collection)idsToProcess).isEmpty()) {
            String id = (String)idsToProcess.remove(0);
            PluginsCachePlugin pluginsCachePlugin = this.plugins.get(id);
            if (pluginsCachePlugin == null && (pluginsCachePlugin = this.plugins.get(this.directoryNameMapping.get(id))) == null) continue;
            PluginsCachePlugin plugin = pluginsCachePlugin;
            if (!result2.add(id)) continue;
            idsToProcess.addAll(CollectionsKt.minus((Iterable)plugin.getDependencies(), (Iterable)result2));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull File artifact) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PluginDependency it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Utils.debug$default(this.context, "Adding directory to plugins index: " + artifact + ")", null, 4, null);
        IdePlugin idePlugin = Utils.createPlugin(artifact, false, this.context);
        if (idePlugin == null) {
            return;
        }
        IdePlugin intellijPlugin = idePlugin;
        String string = intellijPlugin.getPluginId();
        if (string == null) {
            return;
        }
        String id = string;
        Iterable $this$filter$iv = intellijPlugin.getDependencies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PluginDependency)element$iv$iv;
            boolean bl = false;
            if (!(!it.isOptional())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PluginDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List dependencies = (List)destination$iv$iv;
        String string2 = artifact.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artifact.name");
        PluginsCachePlugin plugin = new PluginsCachePlugin(id, string2, dependencies);
        this.plugins.put(id, plugin);
        if (!Intrinsics.areEqual((Object)plugin.getDirectoryName(), (Object)id)) {
            this.directoryNameMapping.put(plugin.getDirectoryName(), id);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.intellij.dependency.BuiltinPluginsRegistry");
        BuiltinPluginsRegistry cfr_ignored_0 = (BuiltinPluginsRegistry)other;
        if (!Intrinsics.areEqual((Object)this.pluginsDirectory, (Object)((BuiltinPluginsRegistry)other).pluginsDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.plugins, ((BuiltinPluginsRegistry)other).plugins)) {
            return false;
        }
        return Intrinsics.areEqual(this.directoryNameMapping, ((BuiltinPluginsRegistry)other).directoryNameMapping);
    }

    public int hashCode() {
        int result2 = this.pluginsDirectory.hashCode();
        result2 = 31 * result2 + ((Object)this.plugins).hashCode();
        result2 = 31 * result2 + ((Object)this.directoryNameMapping).hashCode();
        return result2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry$Companion;", "", "()V", "version", "", "fromDirectory", "Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "pluginsDirectory", "Ljava/nio/file/Path;", "context", "", "resolveBundledPlugins", "", "ideDir", "gradle-intellij-plugin"})
    @SourceDebugExtension(value={"SMAP\nBuiltinPluginsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinPluginsRegistry.kt\norg/jetbrains/intellij/dependency/BuiltinPluginsRegistry$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuiltinPluginsRegistry fromDirectory(@NotNull Path pluginsDirectory, @Nullable String context) {
            BuiltinPluginsRegistry builtinPluginsRegistry;
            Intrinsics.checkNotNullParameter((Object)pluginsDirectory, (String)"pluginsDirectory");
            File file = pluginsDirectory.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"pluginsDirectory.toFile()");
            BuiltinPluginsRegistry $this$fromDirectory_u24lambda_u240 = builtinPluginsRegistry = new BuiltinPluginsRegistry(file, context);
            boolean bl = false;
            XmlExtractor extractor = new XmlExtractor(context);
            if (!$this$fromDirectory_u24lambda_u240.fillFromCache(extractor)) {
                Utils.debug$default(context, "Builtin registry cache is missing", null, 4, null);
                $this$fromDirectory_u24lambda_u240.fillFromDirectory();
                $this$fromDirectory_u24lambda_u240.dumpToCache(extractor);
            }
            return builtinPluginsRegistry;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Collection<String> resolveBundledPlugins(@NotNull Path ideDir, @Nullable String context) {
            Set set;
            Collection collection;
            List<String> list;
            Intrinsics.checkNotNullParameter((Object)ideDir, (String)"ideDir");
            ProductInfo productInfo = Utils.ideProductInfo(ideDir);
            if (productInfo != null && (list = productInfo.getBundledPlugins()) != null) {
                List<String> list2;
                List<String> list3;
                List<String> it = list3 = list;
                boolean bl = false;
                List<String> list4 = list2 = !((Collection)it).isEmpty() ? list3 : null;
                if (list2 != null) {
                    collection = list2;
                    return collection;
                }
            }
            Path path = ideDir.resolve("plugins");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ideDir.resolve(\"plugins\")");
            Set it = set = this.fromDirectory(path, context).plugins.keySet();
            boolean bl = false;
            Set<Object> set2 = !((Collection)it).isEmpty() ? set : null;
            if (set2 == null) throw new GradleException("Unable to resolve bundled plugins");
            collection = set2;
            return collection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

