/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.xml.SimpleXmlWriter;
import org.gradle.internal.xml.XmlTransformer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdePluginSourceZipFilesProvider;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.PluginDependency;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0007J\u001e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\tJ(\u0010\u001b\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0017H\u0007J\u000e\u0010$\u001a\u00020!2\u0006\u0010&\u001a\u00020'J\f\u0010(\u001a\u00020!*\u00020)H\u0002J\f\u0010*\u001a\u00020!*\u00020)H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator;", "", "projectIdentity", "Lorg/gradle/api/publish/ivy/internal/publisher/IvyPublicationIdentity;", "(Lorg/gradle/api/publish/ivy/internal/publisher/IvyPublicationIdentity;)V", "artifacts", "", "Lorg/gradle/api/publish/ivy/IvyArtifact;", "configurations", "Lorg/gradle/api/publish/ivy/IvyConfiguration;", "ivyDateFormat", "Ljava/text/SimpleDateFormat;", "ivyDatePattern", "", "ivyFileEncoding", "xmlTransformer", "Lorg/gradle/internal/xml/XmlTransformer;", "addArtifact", "ivyArtifact", "addCompileArtifacts", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "baseDir", "Ljava/io/File;", "groupId", "addConfiguration", "ivyConfiguration", "addSourceArtifacts", "ideaDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "usesClassifier", "", "writeDescriptor", "", "writer", "Ljava/io/Writer;", "writeTo", "file", "path", "Ljava/nio/file/Path;", "writeConfigurations", "Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$OptionalAttributeXmlWriter;", "writePublications", "OptionalAttributeXmlWriter", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nIntelliJIvyDescriptorFileGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJIvyDescriptorFileGenerator.kt\norg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1855#2,2:175\n1855#2,2:177\n1747#2,3:180\n1855#2,2:183\n1855#2,2:185\n1#3:179\n*S KotlinDebug\n*F\n+ 1 IntelliJIvyDescriptorFileGenerator.kt\norg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator\n*L\n47#1:175,2\n64#1:177,2\n127#1:180,3\n132#1:183,2\n147#1:185,2\n*E\n"})
public final class IntelliJIvyDescriptorFileGenerator {
    @NotNull
    private final IvyPublicationIdentity projectIdentity;
    @NotNull
    private final String ivyFileEncoding;
    @NotNull
    private final String ivyDatePattern;
    @NotNull
    private final SimpleDateFormat ivyDateFormat;
    @NotNull
    private final XmlTransformer xmlTransformer;
    @NotNull
    private final List<IvyConfiguration> configurations;
    @NotNull
    private final List<IvyArtifact> artifacts;

    public IntelliJIvyDescriptorFileGenerator(@NotNull IvyPublicationIdentity projectIdentity) {
        Intrinsics.checkNotNullParameter((Object)projectIdentity, (String)"projectIdentity");
        this.projectIdentity = projectIdentity;
        this.ivyFileEncoding = "UTF-8";
        this.ivyDatePattern = "yyyyMMddHHmmss";
        this.ivyDateFormat = new SimpleDateFormat(this.ivyDatePattern);
        this.xmlTransformer = new XmlTransformer();
        this.configurations = new ArrayList();
        this.artifacts = new ArrayList();
    }

    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addConfiguration(@NotNull IvyConfiguration ivyConfiguration) {
        Intrinsics.checkNotNullParameter((Object)ivyConfiguration, (String)"ivyConfiguration");
        this.configurations.add(ivyConfiguration);
        return this;
    }

    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addArtifact(@NotNull IvyArtifact ivyArtifact) {
        Intrinsics.checkNotNullParameter((Object)ivyArtifact, (String)"ivyArtifact");
        this.artifacts.add(ivyArtifact);
        return this;
    }

    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addCompileArtifacts(@NotNull PluginDependency plugin, @NotNull File baseDir, @NotNull String groupId) {
        block2: {
            File it;
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            DefaultIvyConfiguration compileConfiguration = new DefaultIvyConfiguration("compile");
            this.addConfiguration((IvyConfiguration)compileConfiguration);
            Iterable $this$forEach$iv = plugin.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl = false;
                String string = compileConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
                this.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it2, string, baseDir, groupId));
            }
            File file = plugin.getClassesDirectory();
            if (file != null) {
                it = file;
                boolean bl = false;
                String string = compileConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
                this.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(it, string, baseDir, groupId));
            }
            File file2 = plugin.getMetaInfDirectory();
            if (file2 == null) break block2;
            it = file2;
            boolean bl = false;
            String string = compileConfiguration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
            this.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(it, string, baseDir, groupId));
        }
        return this;
    }

    @NotNull
    public final IntelliJIvyDescriptorFileGenerator addSourceArtifacts(@Nullable IdeaDependency ideaDependency, @NotNull PluginDependency plugin, @NotNull File baseDir, @NotNull String groupId) {
        block7: {
            Object object;
            Object it;
            Object object2;
            Object object3;
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            DefaultIvyConfiguration sourcesConfiguration = new DefaultIvyConfiguration("sources");
            this.addConfiguration((IvyConfiguration)sourcesConfiguration);
            if (!plugin.getSourceJarFiles().isEmpty()) {
                Iterable $this$forEach$iv = plugin.getSourceJarFiles();
                boolean $i$f$forEach = false;
                object3 = $this$forEach$iv.iterator();
                while (object3.hasNext()) {
                    Object element$iv = object3.next();
                    File it2 = (File)element$iv;
                    boolean bl = false;
                    String string = sourcesConfiguration.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcesConfiguration.name");
                    this.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it2, string, baseDir, groupId));
                }
            } else if (ideaDependency != null && (object2 = ideaDependency.getSourceZipFiles()) != null) {
                it = object2;
                boolean bl = false;
                File file = IdePluginSourceZipFilesProvider.INSTANCE.getSourceZips((Collection<? extends File>)it, plugin.getPlatformPluginId());
                if (file != null) {
                    File it3 = file;
                    boolean bl2 = false;
                    String string = sourcesConfiguration.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcesConfiguration.name");
                    object3 = IntellijIvyArtifact.Companion.createZipDependency$default(IntellijIvyArtifact.Companion, it3, string, ideaDependency.getClasses(), null, 8, null);
                    if (object3 != null) {
                        Object p0 = object3;
                        boolean bl3 = false;
                        this.addArtifact((IvyArtifact)p0);
                    }
                }
            }
            if (ideaDependency == null || (object2 = ideaDependency.getSources()) == null) break block7;
            it = object3 = object2;
            boolean bl = false;
            Object object4 = object = plugin.getBuiltin() ? object3 : null;
            if (object != null) {
                it = object;
                boolean bl4 = false;
                String name = Utils.isDependencyOnPyCharm(ideaDependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact artifact = new IntellijIvyArtifact((File)it, name, "jar", "sources", "sources");
                artifact.setConf(sourcesConfiguration.getName());
                this.addArtifact(artifact);
            }
        }
        return this;
    }

    @Deprecated(message="Use writeTo(path: Path) instead")
    public final void writeTo(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.xmlTransformer.transform(file, this.ivyFileEncoding, new Action(this){
            final /* synthetic */ IntelliJIvyDescriptorFileGenerator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull Writer $this$transform) {
                Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$this$transform");
                try {
                    IntelliJIvyDescriptorFileGenerator.access$writeDescriptor(this.this$0, $this$transform);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    public final void writeTo(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.xmlTransformer.transform(path.toFile(), this.ivyFileEncoding, new Action(this){
            final /* synthetic */ IntelliJIvyDescriptorFileGenerator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull Writer $this$transform) {
                Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$this$transform");
                try {
                    IntelliJIvyDescriptorFileGenerator.access$writeDescriptor(this.this$0, $this$transform);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    private final void writeDescriptor(Writer writer) throws IOException {
        OptionalAttributeXmlWriter $this$writeDescriptor_u24lambda_u248 = new OptionalAttributeXmlWriter(writer, "  ", this.ivyFileEncoding);
        boolean bl = false;
        $this$writeDescriptor_u24lambda_u248.startElement("ivy-module").attribute("version", "2.0");
        if (this.usesClassifier()) {
            $this$writeDescriptor_u24lambda_u248.attribute("xmlns:m", "https://ant.apache.org/ivy/maven");
        }
        $this$writeDescriptor_u24lambda_u248.startElement("info").attribute("organisation", this.projectIdentity.getOrganisation()).attribute("module", this.projectIdentity.getModule()).attribute("revision", this.projectIdentity.getRevision()).attribute("publication", this.ivyDateFormat.format(new Date()));
        $this$writeDescriptor_u24lambda_u248.endElement();
        this.writeConfigurations($this$writeDescriptor_u24lambda_u248);
        this.writePublications($this$writeDescriptor_u24lambda_u248);
        $this$writeDescriptor_u24lambda_u248.endElement();
    }

    private final boolean usesClassifier() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.artifacts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IvyArtifact it = (IvyArtifact)element$iv;
                    boolean bl2 = false;
                    if (!(it.getClassifier() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void writeConfigurations(OptionalAttributeXmlWriter $this$writeConfigurations) throws IOException {
        $this$writeConfigurations.startElement("configurations");
        Iterable $this$forEach$iv = this.configurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IvyConfiguration it = (IvyConfiguration)element$iv;
            boolean bl = false;
            $this$writeConfigurations.startElement("conf").attribute("name", it.getName()).attribute("visibility", "public");
            if (it.getExtends().size() > 0) {
                Set set = it.getExtends();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.extends");
                $this$writeConfigurations.attribute("extends", CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            $this$writeConfigurations.endElement();
        }
        $this$writeConfigurations.endElement();
    }

    private final void writePublications(OptionalAttributeXmlWriter $this$writePublications) throws IOException {
        $this$writePublications.startElement("publications");
        Iterable $this$forEach$iv = this.artifacts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IvyArtifact it = (IvyArtifact)element$iv;
            boolean bl = false;
            $this$writePublications.startElement("artifact").attribute("name", it.getName()).attribute("type", it.getType()).attribute("ext", it.getExtension()).attribute("conf", it.getConf()).attribute("m:classifier", it.getClassifier()).endElement();
        }
        $this$writePublications.endElement();
    }

    public static final /* synthetic */ void access$writeDescriptor(IntelliJIvyDescriptorFileGenerator $this, Writer writer) {
        $this.writeDescriptor(writer);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u000b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$OptionalAttributeXmlWriter;", "Lorg/gradle/internal/xml/SimpleXmlWriter;", "writer", "Ljava/io/Writer;", "indent", "", "encoding", "(Ljava/io/Writer;Ljava/lang/String;Ljava/lang/String;)V", "attribute", "name", "value", "startElement", "gradle-intellij-plugin"})
    public static final class OptionalAttributeXmlWriter
    extends SimpleXmlWriter {
        public OptionalAttributeXmlWriter(@NotNull Writer writer, @NotNull String indent, @NotNull String encoding) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            super(writer, indent, encoding);
        }

        @NotNull
        public OptionalAttributeXmlWriter startElement(@Nullable String name) {
            super.startElement(name);
            return this;
        }

        @NotNull
        public OptionalAttributeXmlWriter attribute(@Nullable String name, @Nullable String value) {
            if (value != null) {
                super.attribute(name, value);
            }
            return this;
        }
    }
}

