/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.pluginRepository.PluginRepository;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryFactory;
import org.jetbrains.intellij.pluginRepository.PluginUploader;
import org.jetbrains.intellij.utils.ToolboxEnterprisePluginRepositoryService;

@UntrackedTask(because="Output is stored remotely")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0017H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/intellij/tasks/PublishPluginTask;", "Lorg/gradle/api/DefaultTask;", "()V", "channels", "Lorg/gradle/api/provider/ListProperty;", "", "getChannels", "()Lorg/gradle/api/provider/ListProperty;", "context", "distributionFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDistributionFile", "()Lorg/gradle/api/file/RegularFileProperty;", "host", "Lorg/gradle/api/provider/Property;", "getHost", "()Lorg/gradle/api/provider/Property;", "token", "getToken", "toolboxEnterprise", "", "getToolboxEnterprise", "publishPlugin", "", "validateInput", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nPublishPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishPluginTask.kt\norg/jetbrains/intellij/tasks/PublishPluginTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1855#2:129\n1856#2:131\n766#2:132\n857#2,2:133\n1#3:130\n*S KotlinDebug\n*F\n+ 1 PublishPluginTask.kt\norg/jetbrains/intellij/tasks/PublishPluginTask\n*L\n90#1:129\n90#1:131\n112#1:132\n112#1:133,2\n*E\n"})
public abstract class PublishPluginTask
extends DefaultTask {
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public PublishPluginTask() {
        this.setGroup("intellij");
        this.setDescription("Publishes plugin to the remote Marketplace repository.");
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getDistributionFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getHost();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getToken();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getChannels();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getToolboxEnterprise();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void publishPlugin() {
        this.validateInput();
        Object object = this.getDistributionFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"distributionFile.get()");
        Path path = Utils.getAsPath((FileSystemLocation)object);
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path);
        if (creationResult instanceof PluginCreationSuccess) {
            if (!((Collection)((PluginCreationSuccess)creationResult).getUnacceptableWarnings()).isEmpty()) {
                String problems = CollectionsKt.joinToString$default((Iterable)((PluginCreationSuccess)creationResult).getUnacceptableWarnings(), null, null, null, (int)0, null, null, (int)63, null);
                throw new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot upload plugin: " + problems));
            }
            String pluginId = ((IdePlugin)((PluginCreationSuccess)creationResult).getPlugin()).getPluginId();
            Object object2 = this.getChannels().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"channels.get()");
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String channel = (String)element$iv;
                boolean bl = false;
                Utils.info$default(this.context, "Uploading plugin '" + pluginId + "' from '" + path + "' to '" + this.getHost().get() + "', channel: '" + channel + "'", null, 4, null);
                try {
                    File file;
                    void it;
                    PluginRepository pluginRepository;
                    Object object3 = (Boolean)this.getToolboxEnterprise().get();
                    if (Intrinsics.areEqual((Object)object3, (Object)true)) {
                        Object object4 = this.getHost().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"host.get()");
                        pluginRepository = PluginRepositoryFactory.createWithImplementationClass((String)((String)object4), (String)((String)this.getToken().get()), (String)"Automation", ToolboxEnterprisePluginRepositoryService.class);
                    } else if (Intrinsics.areEqual((Object)object3, (Object)false)) {
                        Object object5 = this.getHost().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"host.get()");
                        pluginRepository = PluginRepositoryFactory.create$default((String)((String)object5), (String)((String)this.getToken().get()), null, (int)4, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    PluginRepository repositoryClient = pluginRepository;
                    PluginUploader pluginUploader = repositoryClient.getUploader();
                    Intrinsics.checkNotNull((Object)pluginId, (String)"null cannot be cast to non-null type kotlin.String{ org.jetbrains.intellij.pluginRepository.model.TypeAliasesKt.StringPluginId }");
                    Intrinsics.checkNotNullExpressionValue((Object)path.toFile(), (String)"path.toFile()");
                    Object object6 = object3 = channel;
                    String string = pluginId;
                    PluginUploader pluginUploader2 = pluginUploader;
                    boolean bl2 = false;
                    boolean bl3 = !Intrinsics.areEqual((Object)it, (Object)"default");
                    pluginUploader2.upload(string, file, (String)(bl3 ? object3 : null), null);
                    Utils.info$default(this.context, "Uploaded successfully", null, 4, null);
                }
                catch (Exception exception) {
                    throw new TaskExecutionException((Task)this, (Throwable)new GradleException("Failed to upload plugin: " + exception.getMessage(), (Throwable)exception));
                }
            }
        } else {
            if (creationResult instanceof PluginCreationFail) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginProblem it = (PluginProblem)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String problems = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
                throw new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot upload plugin: " + problems));
            }
            throw new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot upload plugin: " + creationResult));
        }
    }

    private final void validateInput() {
        CharSequence charSequence = (CharSequence)this.getToken().getOrNull();
        if (charSequence == null || charSequence.length() == 0) {
            throw new TaskExecutionException((Task)this, (Throwable)new GradleException("token property must be specified for plugin publishing"));
        }
    }
}

