/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u001fH\u0007J \u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006)"}, d2={"Lorg/jetbrains/intellij/tasks/PatchPluginXmlTask;", "Lorg/gradle/api/DefaultTask;", "()V", "changeNotes", "Lorg/gradle/api/provider/Property;", "", "getChangeNotes", "()Lorg/gradle/api/provider/Property;", "context", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputFiles", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getOutputFiles", "()Lorg/gradle/api/provider/ListProperty;", "pluginDescription", "getPluginDescription", "pluginId", "getPluginId", "pluginXmlFiles", "getPluginXmlFiles", "sinceBuild", "getSinceBuild", "untilBuild", "getUntilBuild", "version", "getVersion", "patchAttribute", "", "document", "Lorg/jdom2/Document;", "tagName", "attributeName", "attributeValue", "patchPluginXml", "patchTag", "name", "content", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nPatchPluginXmlTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchPluginXmlTask.kt\norg/jetbrains/intellij/tasks/PatchPluginXmlTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1549#2:175\n1620#2,3:176\n1855#2:179\n1856#2:181\n1#3:180\n*S KotlinDebug\n*F\n+ 1 PatchPluginXmlTask.kt\norg/jetbrains/intellij/tasks/PatchPluginXmlTask\n*L\n105#1:175\n105#1:176,3\n106#1:179\n106#1:181\n*E\n"})
public abstract class PatchPluginXmlTask
extends DefaultTask {
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public PatchPluginXmlTask() {
        this.setGroup("intellij");
        this.setDescription("Patches `plugin.xml` files with values provided to the task.");
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getDestinationDir();

    @OutputFiles
    @NotNull
    public abstract ListProperty<File> getOutputFiles();

    @SkipWhenEmpty
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ListProperty<File> getPluginXmlFiles();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPluginDescription();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSinceBuild();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getUntilBuild();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getChangeNotes();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPluginId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void patchPluginXml() {
        Serializable serializable;
        void $this$mapTo$iv$iv;
        Object object = this.getPluginXmlFiles().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginXmlFiles.get()");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            serializable = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toPath());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            Closeable closeable = FileUtilKt.inputStream((Path)path);
            serializable = null;
            try {
                Document document;
                String it;
                InputStream inputStream = (InputStream)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)JDOMUtil.loadDocument((InputStream)inputStream), (String)"loadDocument(inputStream)");
                String string = (String)this.getSinceBuild().getOrNull();
                if (string != null) {
                    it = string;
                    boolean bl3 = false;
                    this.patchAttribute(document, "idea-version", "since-build", it);
                }
                string = (String)this.getUntilBuild().getOrNull();
                if (string != null) {
                    it = string;
                    boolean bl4 = false;
                    this.patchAttribute(document, "idea-version", "until-build", it);
                }
                string = (String)this.getPluginDescription().getOrNull();
                if (string != null) {
                    it = string;
                    boolean bl5 = false;
                    this.patchTag(document, "description", it);
                }
                string = (String)this.getChangeNotes().getOrNull();
                if (string != null) {
                    it = string;
                    boolean bl6 = false;
                    this.patchTag(document, "change-notes", it);
                }
                Object object2 = this.getVersion().getOrNull();
                it = (String)object2;
                boolean bl7 = false;
                string = (String)(!Intrinsics.areEqual((Object)it, (Object)"unspecified") ? object2 : null);
                if (string != null) {
                    it = string;
                    boolean bl8 = false;
                    this.patchTag(document, "version", it);
                }
                string = (String)this.getPluginId().getOrNull();
                if (string != null) {
                    it = string;
                    boolean bl9 = false;
                    this.patchTag(document, "id", it);
                }
                Object object3 = this.getDestinationDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"destinationDir.get()");
                Path it2 = Utils.getAsPath((FileSystemLocation)object3).resolve(FileUtilKt.getSimpleName((Path)path));
                boolean bl10 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                Utils.transformXml(document, it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchTag(Document document, String name, String content) {
        Element element;
        if (((CharSequence)content).length() == 0) {
            return;
        }
        Element it = element = document.getRootElement();
        boolean bl = false;
        Object object = Intrinsics.areEqual((Object)it.getName(), (Object)"idea-plugin") ? element : null;
        if (object == null) {
            return;
        }
        Element pluginXml = object;
        Element tag = pluginXml.getChild(name);
        if (tag != null) {
            String existingValue = tag.getText();
            Intrinsics.checkNotNullExpressionValue((Object)existingValue, (String)"existingValue");
            if (((CharSequence)existingValue).length() > 0) {
                Utils.warn$default(this.context, "Patching plugin.xml: value of '" + name + "[" + existingValue + "]' tag will be set to '" + content + "'", null, 4, null);
            }
            tag.setText(content);
        } else {
            void $this$patchTag_u24lambda_u2411;
            it = element = new Element(name);
            int n = 0;
            Element element2 = pluginXml;
            boolean bl2 = false;
            $this$patchTag_u24lambda_u2411.setText(content);
            Unit unit = Unit.INSTANCE;
            element2.addContent(n, (Content)element);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchAttribute(Document document, String tagName, String attributeName, String attributeValue) {
        if (((CharSequence)attributeValue).length() == 0) {
            return;
        }
        Element element = document.getRootElement();
        Object it = element;
        boolean bl = false;
        Object object = Intrinsics.areEqual((Object)it.getName(), (Object)"idea-plugin") ? element : null;
        if (object == null) {
            return;
        }
        Element pluginXml = object;
        Element tag = pluginXml.getChild(tagName);
        if (tag != null) {
            Attribute attribute = tag.getAttribute(attributeName);
            String existingValue = attribute != null ? attribute.getValue() : null;
            it = existingValue;
            if (!(it == null || it.length() == 0)) {
                Utils.warn$default(this.context, "Patching plugin.xml: attribute '" + attributeName + "=[" + existingValue + "]' of '" + tagName + "' tag will be set to '" + attributeValue + "'", null, 4, null);
            }
            tag.setAttribute(attributeName, attributeValue);
        } else {
            void $this$patchAttribute_u24lambda_u2413;
            element = new Element(tagName);
            it = element;
            int n = 0;
            Element element2 = pluginXml;
            boolean bl2 = false;
            $this$patchAttribute_u24lambda_u2413.setAttribute(attributeName, attributeValue);
            Unit unit = Unit.INSTANCE;
            element2.addContent(n, (Content)element);
        }
    }
}

