/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.utils.LatestVersionResolver;
import org.jetbrains.kotlin.konan.file.FileKt;

@DisableCachingByDefault(because="Resolves value from remote source")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0017\u0010\u0010\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\u0011J\u0017\u0010\u0012\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\u0013R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadZipSignerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "cli", "Lorg/gradle/api/file/RegularFileProperty;", "getCli", "()Lorg/gradle/api/file/RegularFileProperty;", "cliPath", "Lorg/gradle/api/provider/Property;", "", "getCliPath", "()Lorg/gradle/api/provider/Property;", "version", "getVersion", "downloadZipSigner", "", "resolveCliUrl", "resolveCliUrl$gradle_intellij_plugin", "resolveCliVersion", "resolveCliVersion$gradle_intellij_plugin", "Companion", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nDownloadZipSignerTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadZipSignerTask.kt\norg/jetbrains/intellij/tasks/DownloadZipSignerTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public abstract class DownloadZipSignerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MARKETPLACE_ZIP_SIGNER_URL = "https://github.com/JetBrains/marketplace-zip-signer";
    @NotNull
    private static final String RELEASE_DOWNLOAD_URL = "https://github.com/JetBrains/marketplace-zip-signer/releases/download/%VERSION%/marketplace-zip-signer-cli.jar";

    public DownloadZipSignerTask() {
        this.setGroup("intellij");
        this.setDescription("Downloads marketplace-zip-signer library.");
    }

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCliPath();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getCli();

    @TaskAction
    public final void downloadZipSigner() {
        Path path = Path.of((String)this.getCliPath().get(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(cliPath.get())");
        Path path2 = ((File)this.getCli().getAsFile().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"cli.asFile.get().toPath()");
        FileKt.recursiveCopyTo$default((Path)path, (Path)path2, (boolean)false, (int)2, null);
    }

    @NotNull
    public final String resolveCliVersion$gradle_intellij_plugin(@Nullable String version2) {
        String string;
        block3: {
            block2: {
                String string2;
                string = version2;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"latest") ? string2 : null;
                if (string != null) break block3;
            }
            string = Companion.resolveLatestVersion();
        }
        return string;
    }

    @NotNull
    public final String resolveCliUrl$gradle_intellij_plugin(@Nullable String version2) {
        String it = this.resolveCliVersion$gradle_intellij_plugin(version2);
        boolean bl = false;
        return StringsKt.replace$default((String)RELEASE_DOWNLOAD_URL, (String)"%VERSION%", (String)it, (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadZipSignerTask$Companion;", "", "()V", "MARKETPLACE_ZIP_SIGNER_URL", "", "RELEASE_DOWNLOAD_URL", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLatestVersion() {
            return LatestVersionResolver.Companion.fromGitHub("Marketplace ZIP Signer CLI", DownloadZipSignerTask.MARKETPLACE_ZIP_SIGNER_URL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

