/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.LatestVersionResolver;

@DisableCachingByDefault(because="Resolves value from remote source")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0017J\u0017\u0010\u0018\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "context", "", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginArchive", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getPluginArchive", "()Lorg/gradle/api/provider/Property;", "version", "getVersion", "downloadRobotServerPlugin", "", "getDependency", "getDependency$gradle_intellij_plugin", "resolveRobotServerPluginVersion", "resolveRobotServerPluginVersion$gradle_intellij_plugin", "Companion", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nDownloadRobotServerPluginTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadRobotServerPluginTask.kt\norg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n50#2:96\n1#3:97\n*S KotlinDebug\n*F\n+ 1 DownloadRobotServerPluginTask.kt\norg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask\n*L\n54#1:96\n*E\n"})
public abstract class DownloadRobotServerPluginTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArchiveUtils archiveUtils;
    @NotNull
    private final String context;
    @NotNull
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/intellij-dependencies/com/intellij/remoterobot/robot-server-plugin/maven-metadata.xml";
    @NotNull
    private static final String OLD_ROBOT_SERVER_DEPENDENCY = "org.jetbrains.test:robot-server-plugin";
    @NotNull
    private static final String NEW_ROBOT_SERVER_DEPENDENCY = "com.intellij.remoterobot:robot-server-plugin";
    @NotNull
    private static final String NEW_ROBOT_SERVER_VERSION = "0.11.0";

    /*
     * WARNING - void declaration
     */
    @Inject
    public DownloadRobotServerPluginTask(@NotNull ObjectFactory objectFactory) {
        void $this$newInstance$iv;
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ObjectFactory objectFactory2 = objectFactory;
        Object[] parameters$iv = new Object[]{};
        boolean $i$f$newInstance = false;
        this.archiveUtils = (ArchiveUtils)$this$newInstance$iv.newInstance(ArchiveUtils.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
        this.context = Utils.logCategory((Task)this);
        this.setGroup("intellij");
        this.setDescription("Download `robot-server` plugin.");
    }

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @NotNull
    public abstract Property<File> getPluginArchive();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void downloadRobotServerPlugin() {
        Path archive = ((File)this.getPluginArchive().get()).toPath();
        Object object = this.getOutputDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
        Path target = Utils.getAsPath((FileSystemLocation)object);
        Intrinsics.checkNotNullExpressionValue((Object)archive, (String)"archive");
        Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
        ArchiveUtils.extract$default(this.archiveUtils, archive, target, this.context, null, null, 24, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String resolveRobotServerPluginVersion$gradle_intellij_plugin(@Nullable String version2) {
        String string;
        if (version2 != null) {
            String string2;
            String string3;
            String it = string3 = version2;
            boolean bl = false;
            String string4 = string2 = !Intrinsics.areEqual((Object)it, (Object)"latest") ? string3 : null;
            if (string2 != null) {
                string = string2;
                return string;
            }
        }
        string = Companion.resolveLatestVersion();
        return string;
    }

    @NotNull
    public final String getDependency$gradle_intellij_plugin(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return Version.Companion.parse(version2).compareTo(Version.Companion.parse(NEW_ROBOT_SERVER_VERSION)) >= 0 ? NEW_ROBOT_SERVER_DEPENDENCY : OLD_ROBOT_SERVER_DEPENDENCY;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask$Companion;", "", "()V", "METADATA_URL", "", "NEW_ROBOT_SERVER_DEPENDENCY", "NEW_ROBOT_SERVER_VERSION", "OLD_ROBOT_SERVER_DEPENDENCY", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLatestVersion() {
            return LatestVersionResolver.Companion.fromMaven("Robot Server Plugin", DownloadRobotServerPluginTask.METADATA_URL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

