/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@DisableCachingByDefault(because="Deletion cannot be cached")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/intellij/tasks/ClasspathIndexCleanupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "classpathIndexFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspathIndexFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "context", "", "classpathIndexCleanup", "", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nClasspathIndexCleanupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathIndexCleanupTask.kt\norg/jetbrains/intellij/tasks/ClasspathIndexCleanupTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1855#2,2:44\n*S KotlinDebug\n*F\n+ 1 ClasspathIndexCleanupTask.kt\norg/jetbrains/intellij/tasks/ClasspathIndexCleanupTask\n*L\n37#1:44,2\n*E\n"})
public abstract class ClasspathIndexCleanupTask
extends DefaultTask {
    @NotNull
    private final String context = Utils.logCategory((Task)this);

    public ClasspathIndexCleanupTask() {
        this.setGroup("intellij");
        this.setDescription("Removes classpath index files created by PathClassLoader");
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getClasspathIndexFiles();

    @TaskAction
    public final void classpathIndexCleanup() {
        Iterable $this$forEach$iv = (Iterable)this.getClasspathIndexFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
            FileUtilKt.deleteQuietly((Path)path);
            Utils.info$default(this.context, "Removed classpath.index file: " + it, null, 4, null);
        }
    }
}

