/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingParser;
import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/dependency/CustomPluginsRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "repositoryUrl", "", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "(Ljava/lang/String;Lorg/jetbrains/intellij/utils/DependenciesDownloader;)V", "downloadZipArtifact", "Ljava/io/File;", "url", "Ljava/net/URL;", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "context", "postResolve", "", "project", "Lorg/gradle/api/Project;", "resolve", "resolveDownloadUrl", "type", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "gradle-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomPluginsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomPluginsRepository.kt\norg/jetbrains/intellij/dependency/CustomPluginsRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class CustomPluginsRepository
implements PluginsRepository {
    @NotNull
    private final String repositoryUrl;
    @NotNull
    private final DependenciesDownloader dependenciesDownloader;

    public CustomPluginsRepository(@NotNull String repositoryUrl, @NotNull DependenciesDownloader dependenciesDownloader) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.repositoryUrl = repositoryUrl;
        this.dependenciesDownloader = dependenciesDownloader;
    }

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Utils.debug$default(context, "Loading list of plugins from: " + this.repositoryUrl, null, 4, null);
        URL url = new URL(this.repositoryUrl);
        URL uRL = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.PLUGIN_REPOSITORY);
        if (uRL == null && (uRL = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.SIMPLE)) == null) {
            return null;
        }
        URL downloadUrl = uRL;
        return this.downloadZipArtifact(downloadUrl, plugin, context);
    }

    private final URL resolveDownloadUrl(URL url, PluginDependencyNotation plugin, CustomPluginRepositoryListingType type) {
        Object v0;
        URL uRL;
        block1: {
            uRL = url;
            Object object = Charsets.UTF_8;
            Object object2 = TextStreamsKt.readBytes((URL)uRL);
            object = CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(new String((byte[])object2, (Charset)object), url, url, type);
            object2 = object.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                CustomPluginRepositoryListingParser.PluginInfo it = (CustomPluginRepositoryListingParser.PluginInfo)e;
                boolean bl = false;
                if (!(StringsKt.equals((String)it.getPluginId(), (String)plugin.getId(), (boolean)true) && StringsKt.equals((String)it.getVersion(), (String)plugin.getVersion(), (boolean)true))) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        CustomPluginRepositoryListingParser.PluginInfo pluginInfo = v0;
        return pluginInfo != null && (uRL = pluginInfo.getDownloadUrl()) != null ? Utils.resolveRedirection(uRL) : null;
    }

    private final File downloadZipArtifact(URL url, PluginDependencyNotation plugin, String context) {
        return (File)CollectionsKt.first((List)DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, context, (Function1)new Function1<DependencyHandler, Dependency>(plugin){
            final /* synthetic */ PluginDependencyNotation $plugin;
            {
                this.$plugin = $plugin;
                super(1);
            }

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains.plugins", (String)this.$plugin.getId(), (String)this.$plugin.getVersion(), null, null, (String)"zip", (int)24, null);
            }
        }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
            final /* synthetic */ URL $url;
            {
                this.$url = $url;
                super(1);
            }

            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, this.$url, null, null, 6, null);
            }
        }, false, 8, null));
    }

    @Override
    public void postResolve(@NotNull Project project, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

