/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.util.TeeOutputStream;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.utils.LatestVersionResolver;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 32\u00020\u0001:\u00013B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0*H\u0002J\b\u0010+\u001a\u00020\tH\u0002J\u0017\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b.J\u0017\u0010/\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b0J\b\u00101\u001a\u000202H\u0007R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000bR\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000bR\u0014\u0010'\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000f\u00a8\u00064"}, d2={"Lorg/jetbrains/intellij/tasks/SignPluginTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "certificateChain", "Lorg/gradle/api/provider/Property;", "", "getCertificateChain", "()Lorg/gradle/api/provider/Property;", "certificateChainFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCertificateChainFile", "()Lorg/gradle/api/file/RegularFileProperty;", "cliPath", "getCliPath", "cliVersion", "getCliVersion", "context", "inputArchiveFile", "getInputArchiveFile", "keyStore", "getKeyStore", "keyStoreKeyAlias", "getKeyStoreKeyAlias", "keyStorePassword", "getKeyStorePassword", "keyStoreProviderName", "getKeyStoreProviderName", "keyStoreType", "getKeyStoreType", "outputArchiveFile", "getOutputArchiveFile", "password", "getPassword", "privateKey", "getPrivateKey", "privateKeyFile", "getPrivateKeyFile", "getOptions", "", "resolveCliPath", "resolveCliUrl", "version", "resolveCliUrl$gradle_intellij_plugin", "resolveCliVersion", "resolveCliVersion$gradle_intellij_plugin", "signPlugin", "", "Companion", "gradle-intellij-plugin"})
public abstract class SignPluginTask
extends DefaultTask {
    private final String context;
    private final ObjectFactory objectFactory;
    private final ExecOperations execOperations;
    private static final String MARKETPLACE_ZIP_SIGNER_URL = "https://github.com/JetBrains/marketplace-zip-signer";
    private static final String RELEASE_DOWNLOAD_URL = "https://github.com/JetBrains/marketplace-zip-signer/releases/download/%VERSION%/marketplace-zip-signer-cli.jar";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @InputFile
    @SkipWhenEmpty
    @NotNull
    public abstract RegularFileProperty getInputArchiveFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputArchiveFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCliVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCliPath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStore();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStorePassword();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreKeyAlias();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreType();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getKeyStoreProviderName();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPrivateKey();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getPrivateKeyFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPassword();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCertificateChain();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getCertificateChainFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void signPlugin() {
        Path file;
        RegularFile regularFile = (RegularFile)this.getInputArchiveFile().getOrNull();
        Path path = file = regularFile != null ? Utils.getAsPath((FileSystemLocation)regularFile) : null;
        if (file == null || !FileUtilKt.exists((Path)file)) {
            throw (Throwable)new IllegalStateException("Plugin file does not exist: " + file);
        }
        if (this.getPrivateKey().getOrNull() == null && this.getPrivateKeyFile().getOrNull() == null) {
            throw (Throwable)new InvalidUserDataException("Private key not found. One of the 'signPlugin.privateKey' or 'signPlugin.privateKeyFile' properties has to be provided.");
        }
        if (this.getCertificateChain().getOrNull() == null && this.getCertificateChainFile().getOrNull() == null) {
            throw (Throwable)new InvalidUserDataException("Certificate chain not found. One of the 'signPlugin.certificateChain' or 'signPlugin.certificateChainFile' properties has to be provided.");
        }
        String cliPath = this.resolveCliPath();
        List cliArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"sign"), (Iterable)this.getOptions());
        Utils.debug$default(this.context, "Distribution file: " + file, null, 4, null);
        Utils.debug$default(this.context, "Marketplace ZIP Signer CLI path: " + cliPath, null, 4, null);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ExecResult execResult;
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            try {
                execResult = this.execOperations.javaexec(new Action(os, this, cliPath, cliArgs){
                    final /* synthetic */ ByteArrayOutputStream $os;
                    final /* synthetic */ SignPluginTask this$0;
                    final /* synthetic */ String $cliPath$inlined;
                    final /* synthetic */ List $cliArgs$inlined;
                    {
                        this.$os = byteArrayOutputStream;
                        this.this$0 = signPluginTask;
                        this.$cliPath$inlined = string;
                        this.$cliArgs$inlined = list2;
                    }

                    public final void execute(@NotNull JavaExecSpec $this$javaexec) {
                        Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$receiver");
                        $this$javaexec.setClasspath((FileCollection)SignPluginTask.access$getObjectFactory$p(this.this$0).fileCollection().from(new Object[]{this.$cliPath$inlined}));
                        $this$javaexec.getMainClass().set((Object)"org.jetbrains.zip.signer.ZipSigningTool");
                        $this$javaexec.setArgs(this.$cliArgs$inlined);
                        $this$javaexec.setStandardOutput((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)this.$os));
                        $this$javaexec.setErrorOutput((OutputStream)new TeeOutputStream((OutputStream)System.err, (OutputStream)this.$os));
                    }
                });
            }
            catch (ExecException e) {
                Utils.error$default(this.context, "Error during Marketplace ZIP Signer CLI execution:\n" + os, null, 4, null);
                throw (Throwable)e;
            }
            ExecResult execResult2 = execResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String resolveCliPath() {
        File verifier;
        String path = (String)this.getCliPath().getOrNull();
        CharSequence charSequence = path;
        if (!(charSequence == null || charSequence.length() == 0) && (verifier = new File(path)).exists()) {
            return path;
        }
        throw (Throwable)new InvalidUserDataException("Provided Marketplace ZIP Signer path doesn't exist: '" + path + "'. Downloading Marketplace ZIP Signer: " + this.getCliVersion());
    }

    private final List<String> getOptions() {
        List args;
        block9: {
            SignPluginTask $this$run;
            String it;
            Object object;
            Object[] objectArray = new String[4];
            objectArray[0] = "-in";
            Object object2 = this.getInputArchiveFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inputArchiveFile.get()");
            objectArray[1] = ((Object)Utils.getAsPath((FileSystemLocation)object2).toAbsolutePath()).toString();
            objectArray[2] = "-out";
            Object object3 = this.getOutputArchiveFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"outputArchiveFile.get()");
            objectArray[3] = ((Object)Utils.getAsPath((FileSystemLocation)object3).toAbsolutePath()).toString();
            args = CollectionsKt.mutableListOf((Object[])objectArray);
            String string = (String)this.getPrivateKey().getOrNull();
            if (string != null) {
                it = object = string;
                boolean bl = false;
                args.add("-key");
                String string2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                args.add(string2);
                Utils.debug$default(this.context, "Using private key passed as content", null, 4, null);
            } else {
                object = this;
                $this$run = (SignPluginTask)((Object)object);
                boolean bl = false;
                args.add("-key-file");
                Object object4 = $this$run.getPrivateKeyFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"privateKeyFile.get()");
                args.add(((Object)Utils.getAsPath((FileSystemLocation)object4).toAbsolutePath()).toString());
                Utils.debug$default($this$run.context, "Using private key passed as file", null, 4, null);
            }
            String string3 = (String)this.getCertificateChain().getOrNull();
            if (string3 != null) {
                it = object = string3;
                boolean bl = false;
                args.add("-cert");
                String string4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
                args.add(string4);
                Utils.debug$default(this.context, "Using certificate chain passed as content", null, 4, null);
            } else {
                object = this;
                $this$run = (SignPluginTask)((Object)object);
                boolean bl = false;
                args.add("-cert-file");
                Object object5 = $this$run.getCertificateChainFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"certificateChainFile.get()");
                args.add(((Object)Utils.getAsPath((FileSystemLocation)object5).toAbsolutePath()).toString());
                Utils.debug$default($this$run.context, "Using certificate chain passed as file", null, 4, null);
            }
            String string5 = (String)this.getPassword().getOrNull();
            if (string5 != null) {
                it = object = string5;
                boolean bl = false;
                args.add("-key-pass");
                String string6 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it");
                args.add(string6);
                Utils.debug$default(this.context, "Using private key password", null, 4, null);
            }
            String string7 = (String)this.getKeyStore().getOrNull();
            if (string7 != null) {
                it = object = string7;
                boolean bl = false;
                args.add("-ks");
                String string8 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it");
                args.add(string8);
            }
            String string9 = (String)this.getKeyStorePassword().getOrNull();
            if (string9 != null) {
                it = object = string9;
                boolean bl = false;
                args.add("-ks-pass");
                String string10 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"it");
                args.add(string10);
            }
            String string11 = (String)this.getKeyStoreKeyAlias().getOrNull();
            if (string11 != null) {
                it = object = string11;
                boolean bl = false;
                args.add("-ks-key-alias");
                String string12 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"it");
                args.add(string12);
            }
            String string13 = (String)this.getKeyStoreType().getOrNull();
            if (string13 != null) {
                it = object = string13;
                boolean bl = false;
                args.add("-ks-type");
                String string14 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"it");
                args.add(string14);
            }
            String string15 = (String)this.getKeyStoreProviderName().getOrNull();
            if (string15 == null) break block9;
            it = object = string15;
            boolean bl = false;
            args.add("-ks-provider-name");
            String string16 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"it");
            args.add(string16);
        }
        return args;
    }

    @NotNull
    public final String resolveCliVersion$gradle_intellij_plugin(@Nullable String version2) {
        String string;
        block3: {
            block2: {
                String string2;
                string = version2;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = Intrinsics.areEqual((Object)it, (Object)"latest") ^ true ? string2 : null;
                if (string != null) break block3;
            }
            string = Companion.resolveLatestVersion();
        }
        return string;
    }

    @NotNull
    public final String resolveCliUrl$gradle_intellij_plugin(@Nullable String version2) {
        String string;
        String it = string = this.resolveCliVersion$gradle_intellij_plugin(version2);
        boolean bl = false;
        return StringsKt.replace$default((String)RELEASE_DOWNLOAD_URL, (String)"%VERSION%", (String)it, (boolean)false, (int)4, null);
    }

    @Inject
    public SignPluginTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        this.context = Utils.logCategory((Task)this);
    }

    public static final /* synthetic */ ObjectFactory access$getObjectFactory$p(SignPluginTask $this) {
        return $this.objectFactory;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/intellij/tasks/SignPluginTask$Companion;", "", "()V", "MARKETPLACE_ZIP_SIGNER_URL", "", "RELEASE_DOWNLOAD_URL", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        @NotNull
        public final String resolveLatestVersion() {
            return LatestVersionResolver.Companion.fromGitHub("Marketplace ZIP Signer CLI", SignPluginTask.MARKETPLACE_ZIP_SIGNER_URL);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

