/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.tasks.RunIdeBase;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b&\u0018\u0000 G2\u00020\u0001:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u001508H\u0014J\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020:H\u0002J\b\u0010<\u001a\u00020:H\u0002J\b\u0010=\u001a\u00020:H\u0017J\n\u0010>\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\u0015H\u0002J,\u0010A\u001a\u00020:2\u0006\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020D0FH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R#\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\r\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\r\u001a\u0004\b \u0010!R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0007R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0007R\u0014\u0010)\u001a\u00020*8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0007R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0007R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u0015028gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0007\u00a8\u0006H"}, d2={"Lorg/jetbrains/intellij/tasks/RunIdeBase;", "Lorg/gradle/api/tasks/JavaExec;", "()V", "autoReloadPlugins", "Lorg/gradle/api/provider/Property;", "", "getAutoReloadPlugins", "()Lorg/gradle/api/provider/Property;", "build221", "Lorg/jetbrains/intellij/Version;", "getBuild221", "()Lorg/jetbrains/intellij/Version;", "build221$delegate", "Lkotlin/Lazy;", "buildNumber", "getBuildNumber", "buildNumber$delegate", "configDir", "Ljava/io/File;", "getConfigDir", "context", "", "ideDir", "getIdeDir", "ideDirPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getIdeDirPath", "()Ljava/nio/file/Path;", "ideDirPath$delegate", "infoPlist", "Lcom/dd/plist/NSDictionary;", "getInfoPlist", "()Lcom/dd/plist/NSDictionary;", "infoPlist$delegate", "jbrArch", "getJbrArch", "jbrVariant", "getJbrVariant", "jbrVersion", "getJbrVersion", "pluginsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPluginsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectExecutable", "getProjectExecutable", "projectWorkingDir", "getProjectWorkingDir", "requiredPluginIds", "Lorg/gradle/api/provider/ListProperty;", "getRequiredPluginIds", "()Lorg/gradle/api/provider/ListProperty;", "systemDir", "getSystemDir", "collectJvmArgs", "", "configureClasspath", "", "configureJvmArgs", "configureSystemProperties", "exec", "findIdePrefix", "resolveToolsJar", "javaExec", "systemPropertyIfNotDefined", "name", "value", "", "userDefinedSystemProperties", "", "Companion", "gradle-intellij-plugin"})
public abstract class RunIdeBase
extends JavaExec {
    private final String context = Utils.logCategory((Task)this);
    private final Lazy ideDirPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
        final /* synthetic */ RunIdeBase this$0;

        public final Path invoke() {
            return ((File)this.this$0.getIdeDir().get()).toPath();
        }
        {
            this.this$0 = runIdeBase;
            super(0);
        }
    }));
    private final Lazy infoPlist$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NSDictionary>(this){
        final /* synthetic */ RunIdeBase this$0;

        @Nullable
        public final NSDictionary invoke() {
            NSDictionary nSDictionary;
            Path path;
            Path p1 = path = RunIdeBase.access$getIdeDirPath$p(this.this$0).resolve("Info.plist");
            boolean bl = false;
            Path path2 = FileUtilKt.exists((Path)p1) ? path : null;
            if (path2 != null) {
                Path it = path = path2;
                boolean bl2 = false;
                NSObject nSObject = PropertyListParser.parse((Path)it);
                if (nSObject == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.dd.plist.NSDictionary");
                }
                nSDictionary = (NSDictionary)nSObject;
            } else {
                nSDictionary = null;
            }
            return nSDictionary;
        }
        {
            this.this$0 = runIdeBase;
            super(0);
        }
    }));
    private final Lazy buildNumber$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Version>(this){
        final /* synthetic */ RunIdeBase this$0;

        @NotNull
        public final Version invoke() {
            Object object = RunIdeBase.access$getIdeDirPath$p(this.this$0);
            Path p1 = object;
            boolean bl = false;
            object = CollectionsKt.last((List)StringsKt.split$default((CharSequence)Utils.ideBuildNumber(p1), (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null));
            Version.Companion companion = Version.Companion;
            String p12 = (String)object;
            boolean bl2 = false;
            return companion.parse(p12);
        }
        {
            this.this$0 = runIdeBase;
            super(0);
        }
    }));
    private final Lazy build221$delegate = LazyKt.lazy((Function0)build221.2.INSTANCE);
    private static final Regex platformPrefixSystemPropertyRegex;
    @NotNull
    public static final Companion Companion;

    @Input
    @NotNull
    public abstract Property<File> getIdeDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrVariant();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrArch();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getPluginsDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getAutoReloadPlugins();

    @Internal
    @NotNull
    public abstract ListProperty<String> getRequiredPluginIds();

    @Internal
    @NotNull
    public abstract Property<File> getConfigDir();

    @Internal
    @NotNull
    public abstract Property<File> getSystemDir();

    @Internal
    @NotNull
    public abstract Property<File> getProjectWorkingDir();

    @Internal
    @NotNull
    public abstract Property<String> getProjectExecutable();

    private final Path getIdeDirPath() {
        Lazy lazy = this.ideDirPath$delegate;
        RunIdeBase runIdeBase = this;
        Object var3_3 = null;
        return (Path)lazy.getValue();
    }

    private final NSDictionary getInfoPlist() {
        Lazy lazy = this.infoPlist$delegate;
        RunIdeBase runIdeBase = this;
        Object var3_3 = null;
        return (NSDictionary)lazy.getValue();
    }

    private final Version getBuildNumber() {
        Lazy lazy = this.buildNumber$delegate;
        RunIdeBase runIdeBase = this;
        Object var3_3 = null;
        return (Version)lazy.getValue();
    }

    private final Version getBuild221() {
        Lazy lazy = this.build221$delegate;
        RunIdeBase runIdeBase = this;
        Object var3_3 = null;
        return (Version)lazy.getValue();
    }

    @TaskAction
    public void exec() {
        this.setWorkingDir((File)this.getProjectWorkingDir().get());
        this.configureSystemProperties();
        this.configureJvmArgs();
        this.executable(this.getProjectExecutable().get());
        this.configureClasspath();
        super.exec();
    }

    private final void configureClasspath() {
        Object it;
        Object object = this.getExecutable();
        String p1 = object;
        boolean bl = false;
        Object object2 = p1;
        Object object3 = !(object2 == null || object2.length() == 0) ? object : null;
        if (object3 != null) {
            it = object = object3;
            boolean bl2 = false;
            Object p12 = object2 = this.resolveToolsJar((String)it);
            boolean bl3 = false;
            Object object4 = ((File)p12).exists() ? object2 : null;
            Jvm jvm = Jvm.current();
            Intrinsics.checkNotNullExpressionValue((Object)jvm, (String)"Jvm.current()");
            object3 = Utils.or(object4, jvm.getToolsJar());
            if (object3 != null) {
                it = object = object3;
                boolean bl4 = false;
                RunIdeBase runIdeBase = this;
                runIdeBase.setClasspath(runIdeBase.getClasspath().plus((FileCollection)this.getObjectFactory().fileCollection().from(new Object[]{it})));
            }
        }
        RunIdeBase runIdeBase = this;
        FileCollection fileCollection = runIdeBase.getClasspath();
        Path path = this.getIdeDirPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ideDirPath");
        it = object = Utils.getIdeaClasspath(path);
        FileCollection fileCollection2 = fileCollection;
        RunIdeBase runIdeBase2 = runIdeBase;
        boolean bl5 = false;
        ConfigurableFileCollection configurableFileCollection = this.getObjectFactory().fileCollection().from(new Object[]{it});
        runIdeBase2.setClasspath(fileCollection2.plus((FileCollection)configurableFileCollection));
    }

    private final void configureSystemProperties() {
        this.systemProperties(this.getSystemProperties());
        Path path = this.getIdeDirPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ideDirPath");
        Object object = this.getConfigDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configDir.get()");
        File file = (File)object;
        Object object2 = this.getSystemDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"systemDir.get()");
        File file2 = (File)object2;
        Object object3 = this.getPluginsDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"pluginsDir.get()");
        File file3 = ((Directory)object3).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"pluginsDir.get().asFile");
        Object object4 = this.getRequiredPluginIds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"requiredPluginIds.get()");
        this.systemProperties(Utils.getIdeaSystemProperties(path, file, file2, file3, (List)object4));
        OperatingSystem operatingSystem = OperatingSystem.current();
        Map map2 = this.getSystemProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"systemProperties");
        Map userDefinedSystemProperties = map2;
        OperatingSystem operatingSystem2 = operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem2, (String)"operatingSystem");
        if (operatingSystem2.isMacOsX()) {
            this.systemPropertyIfNotDefined("idea.smooth.progress", false, userDefinedSystemProperties);
            this.systemPropertyIfNotDefined("apple.laf.useScreenMenuBar", true, userDefinedSystemProperties);
            this.systemPropertyIfNotDefined("apple.awt.fileDialogForDirectories", true, userDefinedSystemProperties);
        } else if (operatingSystem.isUnix()) {
            this.systemPropertyIfNotDefined("sun.awt.disablegrab", true, userDefinedSystemProperties);
        }
        this.systemPropertyIfNotDefined("idea.classpath.index.enabled", false, userDefinedSystemProperties);
        this.systemPropertyIfNotDefined("idea.is.internal", true, userDefinedSystemProperties);
        this.systemPropertyIfNotDefined("jdk.module.illegalAccess.silent", true, userDefinedSystemProperties);
        if (!userDefinedSystemProperties.containsKey("idea.auto.reload.plugins")) {
            Object object5 = this.getAutoReloadPlugins().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"autoReloadPlugins.get()");
            if (((Boolean)object5).booleanValue()) {
                this.systemProperty("idea.auto.reload.plugins", "true");
            }
        }
        if (!this.getSystemProperties().containsKey("idea.platform.prefix")) {
            String prefix2 = this.findIdePrefix();
            if (prefix2 == null) {
                Path path2 = ((File)this.getIdeDir().get()).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"ideDir.get().toPath()");
                if (!StringsKt.startsWith$default((String)Utils.ideBuildNumber(path2), (String)"IU-", (boolean)false, (int)2, null)) {
                    throw (Throwable)new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot find IDE platform prefix. Please create a bug report at https://github.com/jetbrains/gradle-intellij-plugin. " + "As a workaround specify `idea.platform.prefix` system property for task `" + this.getName() + "` manually."));
                }
            }
            if (prefix2 != null) {
                this.systemProperty("idea.platform.prefix", prefix2);
            }
            Utils.info$default(this.context, "Using idea.platform.prefix=" + prefix2, null, 4, null);
        }
        if (this.getBuildNumber().compareTo(this.getBuild221()) >= 0) {
            this.systemProperty("java.system.class.loader", "com.intellij.util.lang.PathClassLoader");
        }
        this.systemPropertyIfNotDefined("idea.vendor.name", "JetBrains", userDefinedSystemProperties);
        this.systemPropertyIfNotDefined("idea.plugin.in.sandbox.mode", true, userDefinedSystemProperties);
    }

    private final String findIdePrefix() {
        String string;
        Utils.info$default(this.context, "Looking for platform prefix", null, 4, null);
        Stream<Path> stream = Files.list(this.getIdeDirPath().resolve("bin"));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.list(ideDirPath.resolve(\"bin\"))");
        String prefix2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), (Function1)findIdePrefix.prefix.1.INSTANCE), (Function1)findIdePrefix.prefix.2.INSTANCE), (Function1)findIdePrefix.prefix.3.INSTANCE));
        if (prefix2 != null) {
            string = prefix2;
        } else {
            NSDictionary nSDictionary;
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            string = operatingSystem.isMacOsX() ? (String)Utils.ifNull((nSDictionary = this.getInfoPlist()) != null && (nSDictionary = Utils.getDictionary(nSDictionary, "JVMOptions")) != null && (nSDictionary = Utils.getDictionary(nSDictionary, "Properties")) != null ? Utils.getValue(nSDictionary, "idea.platform.prefix") : null, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ RunIdeBase this$0;

                public final void invoke() {
                    Utils.error$default(RunIdeBase.access$getContext$p(this.this$0), "Cannot find prefix in " + RunIdeBase.access$getInfoPlist$p(this.this$0), null, 4, null);
                }
                {
                    this.this$0 = runIdeBase;
                    super(0);
                }
            })) : null;
        }
        return string;
    }

    private final void systemPropertyIfNotDefined(String name, Object value, Map<String, ? extends Object> userDefinedSystemProperties) {
        if (!userDefinedSystemProperties.containsKey(name)) {
            this.systemProperty(name, value);
        }
    }

    private final void configureJvmArgs() {
        this.setJvmArgs(this.collectJvmArgs());
    }

    @NotNull
    protected List<String> collectJvmArgs() {
        JavaForkOptions javaForkOptions = (JavaForkOptions)this;
        List list2 = this.getJvmArgs();
        Path path = ((File)this.getIdeDir().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ideDir.get().toPath()");
        return Utils.getIdeaJvmArgs(javaForkOptions, list2, path);
    }

    private final File resolveToolsJar(String javaExec) {
        String binDir = new File(javaExec).getParent();
        OperatingSystem operatingSystem = OperatingSystem.current();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
        String path = operatingSystem.isMacOsX() ? "../../lib/tools.jar" : "../lib/tools.jar";
        return new File(binDir, path);
    }

    public RunIdeBase() {
        this.getMainClass().set((Object)"com.intellij.idea.Main");
        this.setEnableAssertions(true);
    }

    static {
        Companion = new Companion(null);
        platformPrefixSystemPropertyRegex = new Regex("-Didea.platform.prefix=([A-z]+)");
    }

    public static final /* synthetic */ Regex access$getPlatformPrefixSystemPropertyRegex$cp() {
        return platformPrefixSystemPropertyRegex;
    }

    public static final /* synthetic */ String access$getContext$p(RunIdeBase $this) {
        return $this.context;
    }

    public static final /* synthetic */ NSDictionary access$getInfoPlist$p(RunIdeBase $this) {
        return $this.getInfoPlist();
    }

    public static final /* synthetic */ Path access$getIdeDirPath$p(RunIdeBase $this) {
        return $this.getIdeDirPath();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/intellij/tasks/RunIdeBase$Companion;", "", "()V", "platformPrefixSystemPropertyRegex", "Lkotlin/text/Regex;", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

