/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.LatestVersionResolver;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0017J\u0017\u0010\u0018\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "context", "", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginArchive", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getPluginArchive", "()Lorg/gradle/api/provider/Property;", "version", "getVersion", "downloadPlugin", "", "getDependency", "getDependency$gradle_intellij_plugin", "resolveRobotServerPluginVersion", "resolveRobotServerPluginVersion$gradle_intellij_plugin", "Companion", "gradle-intellij-plugin"})
public abstract class DownloadRobotServerPluginTask
extends DefaultTask {
    private final ArchiveUtils archiveUtils;
    private final String context;
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/intellij-dependencies/com/intellij/remoterobot/robot-server-plugin/maven-metadata.xml";
    private static final String OLD_ROBOT_SERVER_DEPENDENCY = "org.jetbrains.test:robot-server-plugin";
    private static final String NEW_ROBOT_SERVER_DEPENDENCY = "com.intellij.remoterobot:robot-server-plugin";
    private static final String NEW_ROBOT_SERVER_VERSION = "0.11.0";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @NotNull
    public abstract Property<File> getPluginArchive();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void downloadPlugin() {
        Path archive = ((File)this.getPluginArchive().get()).toPath();
        Object object = this.getOutputDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
        Path target = Utils.getAsPath((FileSystemLocation)object);
        Path path = archive;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"archive");
        Path path2 = target;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"target");
        ArchiveUtils.extract$default(this.archiveUtils, path, path2, this.context, null, null, 24, null);
    }

    @NotNull
    public final String resolveRobotServerPluginVersion$gradle_intellij_plugin(@Nullable String version2) {
        String string;
        block3: {
            block2: {
                String string2;
                string = version2;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = Intrinsics.areEqual((Object)it, (Object)"latest") ^ true ? string2 : null;
                if (string != null) break block3;
            }
            string = Companion.resolveLatestVersion();
        }
        return string;
    }

    @NotNull
    public final String getDependency$gradle_intellij_plugin(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return Version.Companion.parse(version2).compareTo(Version.Companion.parse(NEW_ROBOT_SERVER_VERSION)) >= 0 ? NEW_ROBOT_SERVER_DEPENDENCY : OLD_ROBOT_SERVER_DEPENDENCY;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public DownloadRobotServerPluginTask(@NotNull ObjectFactory objectFactory) {
        void $this$newInstance$iv;
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ObjectFactory objectFactory2 = objectFactory;
        Object[] parameters$iv = new Object[]{};
        boolean $i$f$newInstance = false;
        this.archiveUtils = (ArchiveUtils)$this$newInstance$iv.newInstance(ArchiveUtils.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
        this.context = Utils.logCategory((Task)this);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask$Companion;", "", "()V", "METADATA_URL", "", "NEW_ROBOT_SERVER_DEPENDENCY", "NEW_ROBOT_SERVER_VERSION", "OLD_ROBOT_SERVER_DEPENDENCY", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        @NotNull
        public final String resolveLatestVersion() {
            return LatestVersionResolver.Companion.fromMaven("Robot Server Plugin", DownloadRobotServerPluginTask.METADATA_URL);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

