/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.jbr;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.Properties;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.provider.Provider;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.Jbr;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001-B/\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J&\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004Js\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010%\u001a\u00020&2#\b\u0002\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020&0(Ji\u0010,\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00172#\b\u0002\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020&0(R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver;", "", "jreRepository", "Lorg/gradle/api/provider/Provider;", "", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Lorg/gradle/api/provider/Provider;Lorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "kotlin.jvm.PlatformType", "findJavaExecutable", "Ljava/nio/file/Path;", "javaHome", "fromDir", "Lorg/jetbrains/intellij/jbr/Jbr;", "javaDir", "version", "getBuiltinJbrVersion", "ideDirectory", "Ljava/io/File;", "getJavaArchive", "jbrArtifact", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "getJbrRoot", "resolve", "variant", "arch", "resolveRuntime", "runtimeDir", "jbrVersion", "jbrVariant", "jbrArch", "ideDir", "resolveExecutable", "", "validate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "executable", "resolveRuntimeDir", "JbrArtifact", "gradle-intellij-plugin"})
public abstract class JbrResolver {
    private final OperatingSystem operatingSystem;
    private final Provider<String> jreRepository;
    private final ArchiveUtils archiveUtils;
    private final DependenciesDownloader dependenciesDownloader;
    private final String context;

    @Nullable
    public final Path resolveRuntimeDir(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable String jbrVariant, @Nullable String jbrArch, @Nullable File ideDir, @NotNull Function1<? super Path, Boolean> validate) {
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        return this.resolveRuntime(runtimeDir, jbrVersion, jbrVariant, jbrArch, ideDir, false, validate);
    }

    public static /* synthetic */ Path resolveRuntimeDir$default(JbrResolver jbrResolver, String string, String string2, String string3, String string4, File file, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntimeDir");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            file = null;
        }
        if ((n & 0x20) != 0) {
            function1 = resolveRuntimeDir.1.INSTANCE;
        }
        return jbrResolver.resolveRuntimeDir(string, string2, string3, string4, file, (Function1<? super Path, Boolean>)function1);
    }

    @Nullable
    public final Path resolveRuntime(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable String jbrVariant, @Nullable String jbrArch, @Nullable File ideDir, boolean resolveExecutable, @NotNull Function1<? super Path, Boolean> validate) {
        Path path;
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        Utils.debug$default(this.context, "Resolving runtime directory.", null, 4, null);
        Path path2 = (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])new Function0[]{(Function0)new Function0<Path>(this, runtimeDir, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $runtimeDir;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final Path invoke() {
                Path path;
                String string = this.$runtimeDir;
                if (string != null) {
                    String string2;
                    String path2 = string2 = string;
                    boolean bl = false;
                    Path path3 = Path.of(path2, new String[0]);
                    JbrResolver jbrResolver = this.this$0;
                    Path p1 = path3;
                    boolean bl2 = false;
                    Path $this$run = path3 = JbrResolver.access$getJbrRoot(jbrResolver, p1);
                    boolean bl3 = false;
                    boolean bl4 = this.$resolveExecutable;
                    Path p12 = path3 = bl4 ? $this$run.resolve("bin/java") : $this$run;
                    boolean bl5 = false;
                    Path it = path3 = FileUtilKt.exists((Path)p12) ? path3 : null;
                    boolean bl6 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with runtimeDir='" + path2 + "' resolved as: " + it, null, 4, null);
                    path = Utils.ifNull(path3, (Function0<Unit>)((Function0)new Function0<Unit>(path2, this){
                        final /* synthetic */ String $path;
                        final /* synthetic */ resolveRuntime.2 this$0;
                        {
                            this.$path = string;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with runtimeDir='" + this.$path + '\'', null, 4, null);
                        }
                    }));
                } else {
                    path = null;
                }
                return path;
            }
            {
                this.this$0 = jbrResolver;
                this.$runtimeDir = string;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<Path>(this, jbrVersion, jbrVariant, jbrArch, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $jbrVersion;
            final /* synthetic */ String $jbrVariant;
            final /* synthetic */ String $jbrArch;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final Path invoke() {
                Path path;
                String string = this.$jbrVersion;
                if (string != null) {
                    Path path2;
                    Jbr jbr;
                    String string2;
                    String version2 = string2 = string;
                    boolean bl = false;
                    Jbr jbr2 = this.this$0.resolve(version2, this.$jbrVariant, this.$jbrArch);
                    if (jbr2 != null) {
                        Jbr $this$run = jbr = jbr2;
                        boolean bl2 = false;
                        boolean bl3 = this.$resolveExecutable;
                        if (bl3) {
                            String string3 = $this$run.getJavaExecutable();
                            if (string3 != null) {
                                String string4;
                                String it = string4 = string3;
                                boolean bl4 = false;
                                path2 = Path.of(it, new String[0]);
                            } else {
                                path2 = null;
                            }
                        } else {
                            Path path3 = $this$run.getJavaHome();
                            JbrResolver jbrResolver = this.this$0;
                            Path p1 = path3;
                            boolean bl5 = false;
                            path2 = JbrResolver.access$getJbrRoot(jbrResolver, p1);
                        }
                    } else {
                        path2 = null;
                    }
                    Jbr it = jbr = path2;
                    boolean bl6 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with jbrVersion='" + version2 + "', jbrVariant='" + this.$jbrVariant + "', jbrArch='" + this.$jbrArch + "' resolved as: " + it, null, 4, null);
                    path = (Path)((Object)Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(version2, this){
                        final /* synthetic */ String $version;
                        final /* synthetic */ resolveRuntime.3 this$0;
                        {
                            this.$version = string;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with jbrVersion='" + this.$version + "', jbrVariant='" + this.this$0.$jbrVariant + "', jbrArch='" + this.this$0.$jbrArch + '\'', null, 4, null);
                        }
                    })));
                } else {
                    path = null;
                }
                return path;
            }
            {
                this.this$0 = jbrResolver;
                this.$jbrVersion = string;
                this.$jbrVariant = string2;
                this.$jbrArch = string3;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<Path>(this, ideDir, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ File $ideDir;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final Path invoke() {
                Path path;
                File file = this.$ideDir;
                if (file != null) {
                    Path path2;
                    Path path3;
                    File file2;
                    File file3 = file2 = file;
                    boolean bl = false;
                    Path path4 = file3.toPath();
                    JbrResolver jbrResolver = this.this$0;
                    Path p1 = path4;
                    boolean bl2 = false;
                    Path $this$run = path4 = JbrResolver.access$getJbrRoot(jbrResolver, p1);
                    boolean bl3 = false;
                    Path p12 = path3 = $this$run.resolve("bin/java");
                    boolean bl4 = false;
                    Path path5 = FileUtilKt.exists((Path)p12) ? path3 : null;
                    if (path5 != null) {
                        Path executable = path3 = path5;
                        boolean bl5 = false;
                        boolean bl6 = this.$resolveExecutable;
                        if (bl6) {
                            path2 = executable;
                        } else {
                            Path path6;
                            Path it = path6 = $this$run;
                            boolean bl7 = false;
                            path2 = FileUtilKt.exists((Path)executable) ? path6 : null;
                        }
                    } else {
                        path2 = null;
                    }
                    Path it = path4 = path2;
                    boolean bl8 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with ideDir='" + file3 + "' resolved as: " + it, null, 4, null);
                    path = Utils.ifNull(path4, (Function0<Unit>)((Function0)new Function0<Unit>(file3, this){
                        final /* synthetic */ File $file;
                        final /* synthetic */ resolveRuntime.4 this$0;
                        {
                            this.$file = file;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file + '\'', null, 4, null);
                        }
                    }));
                } else {
                    path = null;
                }
                return path;
            }
            {
                this.this$0 = jbrResolver;
                this.$ideDir = file;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<Path>(this, ideDir, jbrVariant, jbrArch, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ File $ideDir;
            final /* synthetic */ String $jbrVariant;
            final /* synthetic */ String $jbrArch;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final Path invoke() {
                Path path;
                File file = this.$ideDir;
                if (file != null) {
                    Path path2;
                    File file2;
                    File file3 = file2 = file;
                    boolean bl = false;
                    String string = JbrResolver.access$getBuiltinJbrVersion(this.this$0, file3);
                    if (string != null) {
                        Path path3;
                        Jbr jbr;
                        String string2;
                        String version2 = string2 = string;
                        boolean bl2 = false;
                        Jbr jbr2 = this.this$0.resolve(version2, this.$jbrVariant, this.$jbrArch);
                        if (jbr2 != null) {
                            Jbr $this$run = jbr = jbr2;
                            boolean bl3 = false;
                            boolean bl4 = this.$resolveExecutable;
                            if (bl4) {
                                String string3 = $this$run.getJavaExecutable();
                                if (string3 != null) {
                                    String string4;
                                    String it = string4 = string3;
                                    boolean bl5 = false;
                                    path3 = Path.of(it, new String[0]);
                                } else {
                                    path3 = null;
                                }
                            } else {
                                Path path4 = $this$run.getJavaHome();
                                JbrResolver jbrResolver = this.this$0;
                                Path p1 = path4;
                                boolean bl6 = false;
                                path3 = JbrResolver.access$getJbrRoot(jbrResolver, p1);
                            }
                        } else {
                            path3 = null;
                        }
                        Jbr it = jbr = path3;
                        boolean bl7 = false;
                        Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with ideDir='" + file3 + "', version='" + version2 + "' resolved as: " + it, null, 4, null);
                        path2 = (Path)((Object)Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(version2, file3, this){
                            final /* synthetic */ String $version;
                            final /* synthetic */ File $file$inlined;
                            final /* synthetic */ resolveRuntime.5 this$0;
                            {
                                this.$version = string;
                                this.$file$inlined = file;
                                this.this$0 = var3_3;
                                super(0);
                            }

                            public final void invoke() {
                                Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file$inlined + "', version='" + this.$version + '\'', null, 4, null);
                            }
                        })));
                    } else {
                        path2 = null;
                    }
                    path = Utils.ifNull(path2, (Function0<Unit>)((Function0)new Function0<Unit>(file3, this){
                        final /* synthetic */ File $file;
                        final /* synthetic */ resolveRuntime.5 this$0;
                        {
                            this.$file = file;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file + '\'', null, 4, null);
                        }
                    }));
                } else {
                    path = null;
                }
                return path;
            }
            {
                this.this$0 = jbrResolver;
                this.$ideDir = file;
                this.$jbrVariant = string;
                this.$jbrArch = string2;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<Path>(this, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final Path invoke() {
                Path path;
                Object object;
                Jvm $this$run = object = Jvm.current();
                boolean bl = false;
                boolean bl2 = this.$resolveExecutable;
                if (bl2) {
                    path = $this$run.getJavaExecutable().toPath();
                } else if (!bl2) {
                    Path path2 = $this$run.getJavaHome().toPath();
                    JbrResolver jbrResolver = this.this$0;
                    Path p1 = path2;
                    boolean bl3 = false;
                    path = JbrResolver.access$getJbrRoot(jbrResolver, p1);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Object it = object = path;
                boolean bl4 = false;
                Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Using current JVM: " + it, null, 4, null);
                return (Path)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ resolveRuntime.6 this$0;

                    public final void invoke() {
                        Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve current JVM", null, 4, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = jbrResolver;
                this.$resolveExecutable = bl;
                super(0);
            }
        }})), (Function1)((Function1)new Function1<Function0<? extends Path>, Path>(validate){
            final /* synthetic */ Function1 $validate;

            @Nullable
            public final Path invoke(@NotNull Function0<? extends Path> it) {
                Path path;
                Function1 function1;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Path path2 = (Path)it.invoke();
                return path2 != null ? (((Boolean)(function1 = this.$validate).invoke((Object)(path = path2))).booleanValue() ? path : null) : null;
            }
            {
                this.$validate = function1;
                super(1);
            }
        })));
        if (path2 != null) {
            Path path3;
            Path it = path3 = path2;
            boolean bl = false;
            Utils.info$default(this.context, "Resolved JVM Runtime directory: " + it, null, 4, null);
            path = path3;
        } else {
            path = null;
        }
        return path;
    }

    public static /* synthetic */ Path resolveRuntime$default(JbrResolver jbrResolver, String string, String string2, String string3, String string4, File file, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntime");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            file = null;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        if ((n & 0x40) != 0) {
            function1 = resolveRuntime.1.INSTANCE;
        }
        return jbrResolver.resolveRuntime(string, string2, string3, string4, file, bl, (Function1<? super Path, Boolean>)function1);
    }

    @Nullable
    public final Jbr resolve(@Nullable String version2, @Nullable String variant, @Nullable String arch) {
        Jbr jbr;
        CharSequence charSequence = version2;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        JbrArtifact jbrArtifact = JbrArtifact.Companion.from(version2, variant, arch, operatingSystem);
        Path path = this.getJavaArchive(jbrArtifact);
        if (path != null) {
            Path javaDir;
            Path path2;
            Path it = path2 = path;
            boolean bl = false;
            Path path3 = javaDir = Path.of(StringsKt.replaceAfter$default((String)((Object)it).toString(), (String)jbrArtifact.getName(), (String)"", null, (int)4, null), new String[0]).resolve("extracted");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"javaDir");
            ArchiveUtils.extract$default(this.archiveUtils, it, path3, this.context, null, null, 24, null);
            jbr = this.fromDir(javaDir, version2);
        } else {
            jbr = null;
        }
        return jbr;
    }

    private final Jbr fromDir(Path javaDir, String version2) {
        Jbr jbr;
        Path path = this.findJavaExecutable(javaDir);
        if (path != null) {
            Path path2;
            Path it = path2 = path;
            boolean bl = false;
            File file = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.toFile()");
            jbr = new Jbr(version2, javaDir, file.getCanonicalPath());
        } else {
            jbr = null;
        }
        return Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(this, javaDir){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ Path $javaDir;

            public final void invoke() {
                Utils.warn$default(JbrResolver.access$getContext$p(this.this$0), "Cannot find java executable in: " + this.$javaDir, null, 4, null);
            }
            {
                this.this$0 = jbrResolver;
                this.$javaDir = path;
                super(0);
            }
        }));
    }

    private final Path getJavaArchive(JbrArtifact jbrArtifact) {
        Object object = this.jreRepository.getOrNull();
        String it = (String)object;
        boolean bl = false;
        CharSequence charSequence = it;
        String string = Utils.or(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? object : null, jbrArtifact.getRepositoryUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jreRepository\n          \u2026brArtifact.repositoryUrl)");
        String url = string;
        try {
            object = ((File)CollectionsKt.first(this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(jbrArtifact){
                final /* synthetic */ JbrArtifact $jbrArtifact;

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains", (String)"jbre", (String)this.$jbrArtifact.getName(), null, null, (String)"tar.gz", (int)24, null);
                }
                {
                    this.$jbrArtifact = jbrArtifact;
                    super(1);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
                final /* synthetic */ String $url;

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, this.$url, "[revision].tar.gz", null, 4, null);
                }
                {
                    this.$url = string;
                    super(1);
                }
            }), true))).toPath();
        }
        catch (Exception e) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + '\'', null, 4, null);
            object = null;
        }
        return object;
    }

    private final Path findJavaExecutable(Path javaHome) {
        Object object;
        Path root = this.getJbrRoot(javaHome);
        Path jre = root.resolve("jre");
        Object it = object = jre;
        boolean bl = false;
        Path path = it;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
        Object object2 = FileUtilKt.exists((Path)path) ? object : null;
        it = object = ".exe";
        StringBuilder stringBuilder = new StringBuilder().append("bin/java");
        Path path2 = Utils.or(object2, root);
        boolean bl2 = false;
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        boolean bl3 = operatingSystem.isWindows();
        object = bl3 ? object : null;
        Object object3 = object;
        if (object3 == null) {
            object3 = "";
        }
        Path java = path2.resolve(stringBuilder.append((String)object3).toString());
        it = object = java;
        boolean bl4 = false;
        Path path3 = java;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"java");
        return FileUtilKt.exists((Path)path3) ? object : null;
    }

    private final Path getJbrRoot(Path javaHome) {
        Path path;
        Path path2;
        Object v0;
        block5: {
            Iterable $this$firstOrNull$iv = FileUtilKt.listFiles((Path)javaHome);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)FileUtilKt.getSimpleName((Path)it), (String)"jbr", (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Path path3 = v0;
        if (path3 != null) {
            Path path4;
            Path p1 = path4 = path3;
            boolean bl = false;
            path2 = FileUtilKt.exists((Path)p1) ? path4 : null;
        } else {
            path2 = null;
        }
        Path jbr = path2;
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        if (operatingSystem.isMacOsX()) {
            Path path5 = javaHome.endsWith("Contents/Home") ? javaHome : (jbr != null ? jbr.resolve("Contents/Home") : javaHome.resolve("jdk/Contents/Home"));
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"when {\n                j\u2026ents/Home\")\n            }");
        } else {
            path = jbr != null ? jbr : javaHome;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getBuiltinJbrVersion(File ideDirectory) {
        File dependenciesFile = new File(ideDirectory, "dependencies.txt");
        if (dependenciesFile.exists()) {
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(dependenciesFile);){
                properties.load(reader);
                String string = properties.getProperty("runtimeBuild");
                if (string == null) {
                    string = properties.getProperty("jdkBuild");
                }
                String string2 = string;
                return string2;
            }
        }
        return null;
    }

    @Inject
    public JbrResolver(@NotNull Provider<String> jreRepository, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkNotNullParameter(jreRepository, (String)"jreRepository");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.jreRepository = jreRepository;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        this.operatingSystem = OperatingSystem.current();
    }

    public static final /* synthetic */ Path access$getJbrRoot(JbrResolver $this, Path javaHome) {
        return $this.getJbrRoot(javaHome);
    }

    public static final /* synthetic */ String access$getContext$p(JbrResolver $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getBuiltinJbrVersion(JbrResolver $this, File ideDirectory) {
        return $this.getBuiltinJbrVersion(ideDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "", "name", "", "repositoryUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRepositoryUrl", "Companion", "gradle-intellij-plugin"})
    public static final class JbrArtifact {
        @NotNull
        private final String name;
        @NotNull
        private final String repositoryUrl;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public JbrArtifact(@NotNull String name, @NotNull String repositoryUrl) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
            this.name = name;
            this.repositoryUrl = repositoryUrl;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002J\u0015\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact$Companion;", "", "()V", "arch", "", "newFormat", "", "arch$gradle_intellij_plugin", "from", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "jbrVersion", "jbrVariant", "jbrArch", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "getPrefix", "version", "variant", "platform", "platform$gradle_intellij_plugin", "gradle-intellij-plugin"})
        public static final class Companion {
            @NotNull
            public final JbrArtifact from(@NotNull String jbrVersion, @Nullable String jbrVariant, @Nullable String jbrArch, @NotNull OperatingSystem operatingSystem) {
                CharSequence charSequence;
                String arch;
                boolean oldFormat;
                String string;
                int n;
                String string2;
                String string3;
                String string4;
                boolean bl;
                String string5;
                Intrinsics.checkNotNullParameter((Object)jbrVersion, (String)"jbrVersion");
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                String string6 = string5 = "8";
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                boolean bl3 = StringsKt.startsWith$default((CharSequence)jbrVersion, (char)'u', (boolean)false, (int)2, null);
                string5 = bl3 ? string5 : null;
                String string7 = string5;
                if (string7 == null) {
                    string7 = "";
                }
                String version2 = stringBuilder.append(string7).append(jbrVersion).toString();
                String prefix2 = this.getPrefix(version2, jbrVariant);
                int lastIndexOfB = StringsKt.lastIndexOf$default((CharSequence)version2, (char)'b', (int)0, (boolean)false, (int)6, null);
                int lastIndexOfDash = StringsKt.lastIndexOf$default((CharSequence)version2, (char)'-', (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl4 = bl = lastIndexOfB > -1;
                if (bl) {
                    string4 = version2;
                    String string8 = string4.substring(lastIndexOfDash, lastIndexOfB);
                    string3 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else if (!bl) {
                    string4 = version2;
                    String string9 = string4.substring(lastIndexOfDash);
                    string3 = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String majorVersion = string3;
                boolean bl5 = lastIndexOfB > -1;
                if (bl5 == (lastIndexOfDash == lastIndexOfB)) {
                    string2 = version2;
                    n = 0;
                    int n2 = lastIndexOfDash - 1;
                    String string10 = string2.substring(n, n2);
                    string = string10;
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else if (bl5) {
                    string2 = version2;
                    n = lastIndexOfB + 1;
                    String string11 = string2.substring(n);
                    string = string11;
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String buildNumberString = string;
                Version buildNumber2 = Version.Companion.parse(buildNumberString);
                boolean isJava8 = StringsKt.startsWith$default((String)majorVersion, (String)"8", (boolean)false, (int)2, null);
                boolean isJava17 = StringsKt.startsWith$default((String)majorVersion, (String)"17", (boolean)false, (int)2, null);
                boolean bl6 = oldFormat = Intrinsics.areEqual((Object)prefix2, (Object)"jbrex") || isJava8 && buildNumber2.compareTo(Version.Companion.parse("1483.24")) < 0;
                if (oldFormat) {
                    return new JbrArtifact("jbrex" + majorVersion + 'b' + buildNumberString + '_' + this.platform$gradle_intellij_plugin(operatingSystem) + '_' + this.arch$gradle_intellij_plugin(false), "https://cache-redirector.jetbrains.com/intellij-jbr");
                }
                String string12 = jbrArch;
                if (string12 == null) {
                    string12 = arch = this.arch$gradle_intellij_plugin(isJava8);
                }
                if ((charSequence = (CharSequence)prefix2).length() == 0) {
                    prefix2 = isJava17 ? "jbr_jcef-" : (isJava8 ? "jbrx-" : (operatingSystem.isMacOsX() && Intrinsics.areEqual((Object)arch, (Object)"aarch64") ? "jbr_jcef-" : (buildNumber2.compareTo(Version.Companion.parse("1319.6")) < 0 ? "jbr-" : "jbr_jcef-")));
                }
                return new JbrArtifact(prefix2 + majorVersion + '-' + this.platform$gradle_intellij_plugin(operatingSystem) + '-' + arch + "-b" + buildNumberString, "https://cache-redirector.jetbrains.com/intellij-jbr");
            }

            /*
             * Enabled aggressive block sorting
             */
            private final String getPrefix(String version2, String variant) {
                CharSequence charSequence = variant;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    String string = variant;
                    if (string != null) {
                        charSequence = string;
                        switch (((String)charSequence).hashCode()) {
                            case 113722: {
                                if (!((String)charSequence).equals("sdk")) break;
                                return "jbrsdk-";
                            }
                        }
                    }
                    String string2 = "jbr_" + variant + '-';
                    return string2;
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbrsdk-", (boolean)false, (int)2, null)) {
                    return "jbrsdk-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_jcef-", (boolean)false, (int)2, null)) {
                    return "jbr_jcef-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_dcevm-", (boolean)false, (int)2, null)) {
                    return "jbr_dcevm-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_fd-", (boolean)false, (int)2, null)) {
                    return "jbr_fd-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_nomod-", (boolean)false, (int)2, null)) {
                    return "jbr_nomod-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr-", (boolean)false, (int)2, null)) {
                    return "jbr-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbrx-", (boolean)false, (int)2, null)) {
                    return "jbrx-";
                }
                if (!StringsKt.startsWith$default((String)version2, (String)"jbrex8", (boolean)false, (int)2, null)) return "";
                return "jbrex";
            }

            @NotNull
            public final String platform$gradle_intellij_plugin(@NotNull OperatingSystem operatingSystem) {
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                return operatingSystem.isWindows() ? "windows" : (operatingSystem.isMacOsX() ? "osx" : "linux");
            }

            @NotNull
            public final String arch$gradle_intellij_plugin(boolean newFormat) {
                String string;
                String name;
                String arch = System.getProperty("os.arch");
                if (Intrinsics.areEqual((Object)"aarch64", (Object)arch) || Intrinsics.areEqual((Object)"arm64", (Object)arch)) {
                    return "aarch64";
                }
                if (Intrinsics.areEqual((Object)"x86_64", (Object)arch) || Intrinsics.areEqual((Object)"amd64", (Object)arch)) {
                    return "x64";
                }
                String string2 = name = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Windows", (boolean)false, (int)2, null) && System.getenv("ProgramFiles(x86)") != null) {
                    return "x64";
                }
                boolean bl = newFormat;
                if (bl) {
                    string = "i586";
                } else if (!bl) {
                    string = "x86";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return string;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

