/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.dependency.CustomPluginsRepository;
import org.jetbrains.intellij.dependency.MavenRepositoryPlugin;
import org.jetbrains.intellij.dependency.MavenRepositoryPluginByAction;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.DependenciesDownloader;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\t2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/intellij/dependency/PluginsRepositoryConfiguration;", "", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "(Lorg/jetbrains/intellij/utils/DependenciesDownloader;)V", "pluginsRepositories", "", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "custom", "", "url", "", "getRepositories", "", "marketplace", "maven", "action", "Lorg/gradle/api/Action;", "Lorg/gradle/api/artifacts/repositories/MavenArtifactRepository;", "gradle-intellij-plugin"})
public abstract class PluginsRepositoryConfiguration {
    private final List<PluginsRepository> pluginsRepositories;
    private final DependenciesDownloader dependenciesDownloader;

    public final void marketplace() {
        this.pluginsRepositories.add(new MavenRepositoryPlugin("https://cache-redirector.jetbrains.com/plugins.jetbrains.com/maven", this.dependenciesDownloader));
    }

    public final void maven(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.pluginsRepositories.add(new MavenRepositoryPlugin(url, this.dependenciesDownloader));
    }

    public final void maven(@NotNull Action<? super MavenArtifactRepository> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.pluginsRepositories.add(new MavenRepositoryPluginByAction(action, this.dependenciesDownloader));
    }

    public final void custom(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.pluginsRepositories.add(new CustomPluginsRepository(url, this.dependenciesDownloader));
    }

    @NotNull
    public final List<PluginsRepository> getRepositories() {
        return CollectionsKt.toList((Iterable)this.pluginsRepositories);
    }

    @Inject
    public PluginsRepositoryConfiguration(@NotNull DependenciesDownloader dependenciesDownloader) {
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.dependenciesDownloader = dependenciesDownloader;
        this.pluginsRepositories = new ArrayList();
    }
}

