/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.dependency.IdeaExtraDependency;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u0013\u0010&\u001a\u00020\n2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\u0006\u0010)\u001a\u00020\u0003J\n\u0010*\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010+\u001a\u00020\u0018H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependency;", "Ljava/io/Serializable;", "name", "", "version", "buildNumber", "classes", "Ljava/io/File;", "sources", "withKotlin", "", "pluginsRegistry", "Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "extraDependencies", "", "Lorg/jetbrains/intellij/dependency/IdeaExtraDependency;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/io/File;ZLorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;Ljava/util/Collection;)V", "getBuildNumber", "()Ljava/lang/String;", "getClasses", "()Ljava/io/File;", "getExtraDependencies", "()Ljava/util/Collection;", "formatVersion", "", "jarFiles", "getJarFiles", "getName", "getPluginsRegistry", "()Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "sourceZipFiles", "getSourceZipFiles", "getSources", "getVersion", "getWithKotlin", "()Z", "collectJarFiles", "collectSourceZipFiles", "equals", "other", "", "getFqn", "getIvyRepositoryDirectory", "hashCode", "gradle-intellij-plugin"})
public class IdeaDependency
implements Serializable {
    private final int formatVersion;
    @NotNull
    private final Collection<File> jarFiles;
    @NotNull
    private final Collection<File> sourceZipFiles;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final String buildNumber;
    @NotNull
    private final File classes;
    @Nullable
    private final File sources;
    private final boolean withKotlin;
    @NotNull
    private final BuiltinPluginsRegistry pluginsRegistry;
    @NotNull
    private final Collection<IdeaExtraDependency> extraDependencies;

    @NotNull
    public final Collection<File> getJarFiles() {
        return this.jarFiles;
    }

    @NotNull
    public final Collection<File> getSourceZipFiles() {
        return this.sourceZipFiles;
    }

    @NotNull
    protected Collection<File> collectJarFiles() {
        File lib;
        if (this.classes.isDirectory() && (lib = new File(this.classes, "lib")).isDirectory()) {
            List baseFiles2 = CollectionsKt.sorted((Iterable)Utils.collectJars(lib, new Predicate(this){
                final /* synthetic */ IdeaDependency this$0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean test(@NotNull File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!this.this$0.getWithKotlin()) {
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                        if (Utils.isKotlinRuntime(StringsKt.removeSuffix((String)string, (CharSequence)".jar"))) return false;
                    }
                    if (!(Intrinsics.areEqual((Object)file.getName(), (Object)"junit.jar") ^ true)) return false;
                    if (!(Intrinsics.areEqual((Object)file.getName(), (Object)"annotations.jar") ^ true)) return false;
                    return true;
                }
                {
                    this.this$0 = ideaDependency;
                }
            }));
            List antFiles = CollectionsKt.sorted((Iterable)Utils.collectJars$default(new File(lib, "ant/lib"), null, 2, null));
            return CollectionsKt.plus((Collection)baseFiles2, (Iterable)antFiles);
        }
        return CollectionsKt.emptyList();
    }

    private final Collection<File> collectSourceZipFiles() {
        if (this.classes.isDirectory()) {
            return Utils.collectZips$default(new File(this.classes, "lib/src"), null, 2, null);
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public File getIvyRepositoryDirectory() {
        return this.classes;
    }

    @NotNull
    public final String getFqn() {
        String fqn = this.name + '-' + this.version + '-' + this.formatVersion;
        if (this.withKotlin) {
            fqn = fqn + "-withKotlin";
        }
        if (this.sources != null) {
            fqn = fqn + "-withSources";
        }
        return fqn;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.intellij.dependency.IdeaDependency");
        }
        IdeaDependency cfr_ignored_0 = (IdeaDependency)object2;
        if (Intrinsics.areEqual((Object)this.name, (Object)((IdeaDependency)other).name) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.version, (Object)((IdeaDependency)other).version) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.buildNumber, (Object)((IdeaDependency)other).buildNumber) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.classes, (Object)((IdeaDependency)other).classes) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.sources, (Object)((IdeaDependency)other).sources) ^ true) {
            return false;
        }
        if (this.withKotlin != ((IdeaDependency)other).withKotlin) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.pluginsRegistry, (Object)((IdeaDependency)other).pluginsRegistry) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.extraDependencies, ((IdeaDependency)other).extraDependencies) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.jarFiles, ((IdeaDependency)other).jarFiles) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.sourceZipFiles, ((IdeaDependency)other).sourceZipFiles) ^ true);
    }

    public int hashCode() {
        File file;
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.version.hashCode();
        result2 = 31 * result2 + this.buildNumber.hashCode();
        result2 = 31 * result2 + this.classes.hashCode();
        File file2 = file = this.sources;
        result2 = 31 * result2 + (file2 != null ? ((Object)file2).hashCode() : 0);
        result2 = 31 * result2 + Boolean.hashCode(this.withKotlin);
        result2 = 31 * result2 + this.pluginsRegistry.hashCode();
        result2 = 31 * result2 + ((Object)this.extraDependencies).hashCode();
        result2 = 31 * result2 + ((Object)this.jarFiles).hashCode();
        result2 = 31 * result2 + ((Object)this.sourceZipFiles).hashCode();
        return result2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final File getClasses() {
        return this.classes;
    }

    @Nullable
    public final File getSources() {
        return this.sources;
    }

    public final boolean getWithKotlin() {
        return this.withKotlin;
    }

    @NotNull
    public final BuiltinPluginsRegistry getPluginsRegistry() {
        return this.pluginsRegistry;
    }

    @NotNull
    public final Collection<IdeaExtraDependency> getExtraDependencies() {
        return this.extraDependencies;
    }

    public IdeaDependency(@NotNull String name, @NotNull String version2, @NotNull String buildNumber2, @NotNull File classes, @Nullable File sources, boolean withKotlin, @NotNull BuiltinPluginsRegistry pluginsRegistry, @NotNull Collection<IdeaExtraDependency> extraDependencies) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)buildNumber2, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)pluginsRegistry, (String)"pluginsRegistry");
        Intrinsics.checkNotNullParameter(extraDependencies, (String)"extraDependencies");
        this.name = name;
        this.version = version2;
        this.buildNumber = buildNumber2;
        this.classes = classes;
        this.sources = sources;
        this.withKotlin = withKotlin;
        this.pluginsRegistry = pluginsRegistry;
        this.extraDependencies = extraDependencies;
        this.formatVersion = 2;
        this.jarFiles = this.collectJarFiles();
        this.sourceZipFiles = this.collectSourceZipFiles();
    }
}

