/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingParser;
import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/dependency/CustomPluginsRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "repositoryUrl", "", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "(Ljava/lang/String;Lorg/jetbrains/intellij/utils/DependenciesDownloader;)V", "downloadZipArtifact", "Ljava/io/File;", "url", "Ljava/net/URL;", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "context", "postResolve", "", "project", "Lorg/gradle/api/Project;", "resolve", "resolveDownloadUrl", "type", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "gradle-intellij-plugin"})
public final class CustomPluginsRepository
implements PluginsRepository {
    private final String repositoryUrl;
    private final DependenciesDownloader dependenciesDownloader;

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Utils.debug$default(context, "Loading list of plugins from: " + this.repositoryUrl, null, 4, null);
        URL url = new URL(this.repositoryUrl);
        URL uRL = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.PLUGIN_REPOSITORY);
        if (uRL == null) {
            uRL = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.SIMPLE);
        }
        if (uRL == null) {
            return null;
        }
        URL downloadUrl = uRL;
        return this.downloadZipArtifact(downloadUrl, plugin, context);
    }

    private final URL resolveDownloadUrl(URL url, PluginDependencyNotation plugin, CustomPluginRepositoryListingType type) {
        Object object;
        Object v0;
        block1: {
            Object object2 = url;
            Object object3 = Charsets.UTF_8;
            Object object4 = TextStreamsKt.readBytes((URL)object2);
            object3 = object2 = (Iterable)CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(new String((byte[])object4, (Charset)object3), url, url, type);
            object4 = object3.iterator();
            while (object4.hasNext()) {
                Object e = object4.next();
                CustomPluginRepositoryListingParser.PluginInfo it = (CustomPluginRepositoryListingParser.PluginInfo)e;
                boolean bl = false;
                if (!(StringsKt.equals((String)it.getPluginId(), (String)plugin.getId(), (boolean)true) && StringsKt.equals((String)it.getVersion(), (String)plugin.getVersion(), (boolean)true))) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return (object = (CustomPluginRepositoryListingParser.PluginInfo)v0) != null && (object = object.getDownloadUrl()) != null ? Utils.resolveRedirection((URL)object) : null;
    }

    private final File downloadZipArtifact(URL url, PluginDependencyNotation plugin, String context) {
        return (File)CollectionsKt.first((List)DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, context, (Function1)new Function1<DependencyHandler, Dependency>(plugin){
            final /* synthetic */ PluginDependencyNotation $plugin;

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains.plugins", (String)this.$plugin.getId(), (String)this.$plugin.getVersion(), null, null, (String)"zip", (int)24, null);
            }
            {
                this.$plugin = pluginDependencyNotation;
                super(1);
            }
        }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
            final /* synthetic */ URL $url;

            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, this.$url, null, null, 6, null);
            }
            {
                this.$url = uRL;
                super(1);
            }
        }, false, 8, null));
    }

    @Override
    public void postResolve(@NotNull Project project, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public CustomPluginsRepository(@NotNull String repositoryUrl, @NotNull DependenciesDownloader dependenciesDownloader) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.repositoryUrl = repositoryUrl;
        this.dependenciesDownloader = dependenciesDownloader;
    }
}

