/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/tasks/VerifyPluginTask;", "Lorg/gradle/api/DefaultTask;", "()V", "context", "", "ignoreFailures", "Lorg/gradle/api/provider/Property;", "", "getIgnoreFailures", "()Lorg/gradle/api/provider/Property;", "ignoreUnacceptableWarnings", "getIgnoreUnacceptableWarnings", "ignoreWarnings", "getIgnoreWarnings", "pluginDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPluginDir", "()Lorg/gradle/api/file/DirectoryProperty;", "verifyPlugin", "", "gradle-intellij-plugin"})
public abstract class VerifyPluginTask
extends DefaultTask {
    private final String context = Utils.logCategory((Task)this);

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreFailures();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreUnacceptableWarnings();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreWarnings();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getPluginDir();

    @TaskAction
    public final void verifyPlugin() {
        boolean failBuild;
        Collection collection;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object object = this.getPluginDir().get();
        Directory it = (Directory)object;
        boolean bl = false;
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
        Directory directory = it;
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"it");
        Path path = directory.getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.asFile.toPath()");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path);
        object = creationResult;
        if (object instanceof PluginCreationSuccess) {
            PluginProblem it2;
            $this$forEach$iv = ((PluginCreationSuccess)creationResult).getWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (PluginProblem)element$iv;
                boolean bl2 = false;
                Utils.warn$default(this.context, it2.getMessage(), null, 4, null);
            }
            $this$forEach$iv = ((PluginCreationSuccess)creationResult).getUnacceptableWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (PluginProblem)element$iv;
                boolean bl3 = false;
                Utils.error$default(this.context, it2.getMessage(), null, 4, null);
            }
        } else if (object instanceof PluginCreationFail) {
            $this$forEach$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginProblem it3 = (PluginProblem)element$iv;
                boolean bl4 = false;
                if (it3.getLevel() == PluginProblem.Level.ERROR) {
                    Utils.error$default(this.context, it3.getMessage(), null, 4, null);
                    continue;
                }
                Utils.warn$default(this.context, it3.getMessage(), null, 4, null);
            }
        } else {
            Utils.error$default(this.context, creationResult.toString(), null, 4, null);
        }
        boolean bl5 = !(creationResult instanceof PluginCreationSuccess) || (Boolean)this.getIgnoreUnacceptableWarnings().get() == false && !(collection = (Collection)((PluginCreationSuccess)creationResult).getUnacceptableWarnings()).isEmpty() || (Boolean)this.getIgnoreWarnings().get() == false && !(collection = (Collection)((PluginCreationSuccess)creationResult).getWarnings()).isEmpty() ? true : (failBuild = false);
        if (failBuild && !((Boolean)this.getIgnoreFailures().get()).booleanValue()) {
            throw (Throwable)new GradleException("Plugin verification failed.");
        }
    }
}

