/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/tasks/JarSearchableOptionsTask;", "Lorg/gradle/jvm/tasks/Jar;", "()V", "context", "", "noSearchableOptionsWarning", "Lorg/gradle/api/provider/Property;", "", "getNoSearchableOptionsWarning", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginName", "getPluginName", "sandboxDir", "getSandboxDir", "copy", "", "gradle-intellij-plugin"})
public abstract class JarSearchableOptionsTask
extends Jar {
    private final String context = Utils.logCategory((Task)this);

    @OutputDirectory
    @Optional
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPluginName();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSandboxDir();

    @Internal
    @NotNull
    public abstract Property<Boolean> getNoSearchableOptionsWarning();

    @TaskAction
    protected void copy() {
        super.copy();
        Object object = this.getNoSearchableOptionsWarning().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"noSearchableOptionsWarning.get()");
        if (((Boolean)object).booleanValue()) {
            boolean noSearchableOptions;
            block5: {
                boolean bl;
                FileCollection fileCollection = this.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"source");
                Iterable $this$none$iv = (Iterable)fileCollection;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        File it = (File)element$iv;
                        boolean bl2 = false;
                        File file = it;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        if (!StringsKt.endsWith$default((String)string, (String)".searchableOptions.xml", (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = noSearchableOptions = true;
                }
            }
            if (noSearchableOptions) {
                Utils.warn$default(this.context, "No searchable options found. If plugin is not supposed to provide custom settings exposed in UI, disable building searchable options to decrease the build time. See: https://plugins.jetbrains.com/docs/intellij/tools-gradle-intellij-plugin-faq.html#how-to-disable-building-searchable-options", null, 4, null);
            }
        }
    }

    public JarSearchableOptionsTask() {
        final Set pluginJarFiles = new LinkedHashSet();
        this.from(new Object[]{new Function0<String>(){

            public final String invoke() {
                this.include(new Spec(){

                    public final boolean isSatisfiedBy(FileTreeElement it) {
                        boolean bl;
                        FileTreeElement fileTreeElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)fileTreeElement, (String)"it");
                        if (fileTreeElement.isDirectory()) {
                            bl = true;
                        } else {
                            Object[] objectArray;
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            if (StringsKt.endsWith$default((String)string, (String)".searchableOptions.xml", (boolean)false, (int)2, null) && pluginJarFiles.isEmpty()) {
                                Object[] objectArray2 = new File((String)this.getSandboxDir().get(), (String)this.getPluginName().get() + "/lib").list();
                                if (objectArray2 != null) {
                                    Object[] files2 = objectArray = objectArray2;
                                    boolean bl2 = false;
                                    CollectionsKt.addAll((Collection)pluginJarFiles, (Object[])files2);
                                }
                            }
                            String string2 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                            objectArray = StringsKt.replace$default((String)string2, (String)".searchableOptions.xml", (String)"", (boolean)false, (int)4, null);
                            Set set = pluginJarFiles;
                            Object[] p1 = objectArray;
                            boolean bl3 = false;
                            bl = set.contains(p1);
                        }
                        return bl;
                    }
                });
                Object object = this.getOutputDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
                File file = ((Directory)object).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDir.get().asFile");
                return file.getCanonicalPath();
            }
        }});
        this.eachFile(2.INSTANCE);
        this.setIncludeEmptyDirs(false);
    }
}

