/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import groovy.lang.Closure;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.BuildException;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.tasks.IntelliJInstrumentCodeTask;
import org.jetbrains.intellij.tasks.IntelliJInstrumentCodeTask$WhenMappings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010!\u001a\u0010\u0012\f\u0012\n #*\u0004\u0018\u00010\t0\t0\"H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007J\u001e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0,H\u0002J\u0016\u0010-\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006\u00a8\u00060"}, d2={"Lorg/jetbrains/intellij/tasks/IntelliJInstrumentCodeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "classesDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassesDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "compilerClassPathFromMaven", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getCompilerClassPathFromMaven", "()Lorg/gradle/api/provider/ListProperty;", "compilerVersion", "Lorg/gradle/api/provider/Property;", "", "getCompilerVersion", "()Lorg/gradle/api/provider/Property;", "context", "formsDirs", "getFormsDirs", "ideaDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "getIdeaDependency", "javac2", "getJavac2", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sourceDirs", "getSourceDirs", "sourceSetCompileClasspath", "getSourceSetCompileClasspath", "compilerClassPath", "", "kotlin.jvm.PlatformType", "instrumentClasses", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "instrumentCode", "instrumentNotNull", "", "block", "Lkotlin/Function0;", "prepareNotNullInstrumenting", "classpath", "Companion", "gradle-intellij-plugin"})
public abstract class IntelliJInstrumentCodeTask
extends DefaultTask {
    private final String context = Utils.logCategory((Task)this);
    @NotNull
    public static final String FILTER_ANNOTATION_REGEXP_CLASS = "com.intellij.ant.ClassFilterAnnotationRegexp";
    @NotNull
    public static final String LOADER_REF = "java2.loader";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getSourceSetCompileClasspath();

    @Input
    @Optional
    @NotNull
    public abstract Property<IdeaDependency> getIdeaDependency();

    @Input
    @Optional
    @NotNull
    public abstract Property<File> getJavac2();

    @Input
    @NotNull
    public abstract Property<String> getCompilerVersion();

    @Incremental
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClassesDirs();

    @Incremental
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getFormsDirs();

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getSourceDirs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Input
    @NotNull
    public abstract ListProperty<File> getCompilerClassPathFromMaven();

    @TaskAction
    public final void instrumentClasses(@NotNull InputChanges inputChanges) {
        Object compiledClassRelativePath;
        Iterable<Path> relativePath;
        Comparable<File> sourceDir;
        Iterable iterable;
        Path path;
        FileChange change;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        List<File> classpath = this.compilerClassPath();
        this.getAnt().invokeMethod("taskdef", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)"instrumentIdeaExtensions"), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)classpath, (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"loaderref", (Object)LOADER_REF), TuplesKt.to((Object)"classname", (Object)"com.intellij.ant.InstrumentIdeaExtensions")}));
        Utils.info$default(this.context, "Compiling forms and instrumenting code with nullability preconditions", null, 4, null);
        boolean instrumentNotNull = this.prepareNotNullInstrumenting(classpath);
        Object object = this.getOutputDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
        Path outputDirPath = ((Directory)object).getAsFile().toPath();
        Path it = path2 = this.getTemporaryDir().toPath();
        boolean bl = false;
        Path path3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it");
        FileUtilKt.deleteQuietly((Path)path3);
        FileUtilKt.createDir((Path)it);
        Path temporaryDirPath = path2;
        Iterable iterable2 = inputChanges.getFileChanges((FileCollection)this.getFormsDirs());
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"inputChanges.getFileChanges(formsDirs)");
        Iterable $this$forEach$iv = iterable2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object2;
            Object v8;
            Object it2;
            Object object32;
            block11: {
                Comparable<File> comparable;
                Object v4;
                block10: {
                    Iterable iterable3;
                    change = (FileChange)element$iv;
                    boolean bl2 = false;
                    FileChange fileChange = change;
                    Intrinsics.checkNotNullExpressionValue((Object)fileChange, (String)"change");
                    path = fileChange.getFile().toPath();
                    iterable = iterable3 = (Iterable)this.getSourceDirs();
                    for (Object object32 : iterable) {
                        it2 = (File)object32;
                        boolean bl3 = false;
                        if (!path.startsWith(((File)it2).toPath())) continue;
                        v4 = object32;
                        break block10;
                    }
                    v4 = null;
                }
                if ((comparable = (File)v4) == null || (comparable = ((File)comparable).toPath()) == null) continue;
                sourceDir = comparable;
                relativePath = sourceDir.relativize(path);
                compiledClassRelativePath = StringsKt.replace$default((String)relativePath.toString(), (String)".form", (String)".class", (boolean)false, (int)4, null);
                FileTree fileTree = this.getClassesDirs().getAsFileTree();
                Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"classesDirs.asFileTree");
                object32 = (Iterable)fileTree;
                it2 = object32;
                Iterator bl3 = it2.iterator();
                while (bl3.hasNext()) {
                    Object t = bl3.next();
                    File it3 = (File)t;
                    boolean bl4 = false;
                    File file = it3;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                    if (!FilesKt.endsWith((File)file, (String)compiledClassRelativePath)) continue;
                    v8 = t;
                    break block11;
                }
                v8 = null;
            }
            if ((object2 = (File)v8) == null) continue;
            object32 = object2;
            it2 = object32;
            boolean bl5 = false;
            object2 = ((File)it2).exists() ? object32 : null;
            if (object2 == null || (object2 = ((File)object2).toPath()) == null) {
                continue;
            }
            Object compiledClassPath = object2;
            Object it4 = it2 = temporaryDirPath.resolve((String)compiledClassRelativePath);
            boolean bl6 = false;
            Object object4 = it4;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
            Utils.ifFalse(FileUtilKt.exists((Path)object4), (Function0<Unit>)((Function0)new Function0<Unit>((Path)it4){

                public final void invoke() {
                    FileUtilKt.create((Path)((Path)this.receiver));
                }
            }));
            Object instrumentedClassPath2 = it2;
            Files.copy((Path)compiledClassPath, (Path)instrumentedClassPath2, StandardCopyOption.REPLACE_EXISTING);
        }
        Iterable iterable4 = inputChanges.getFileChanges((FileCollection)this.getClassesDirs());
        Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"inputChanges.getFileChanges(classesDirs)");
        $this$forEach$iv = iterable4;
        $i$f$forEach = false;
        block6: for (Object element$iv : $this$forEach$iv) {
            Comparable<File> comparable;
            Path path4;
            block12: {
                change = (FileChange)element$iv;
                boolean bl7 = false;
                FileChange fileChange = change;
                Intrinsics.checkNotNullExpressionValue((Object)fileChange, (String)"change");
                if (fileChange.getFileType() != FileType.FILE) continue;
                path = change.getFile().toPath();
                relativePath = (Iterable)this.getClassesDirs();
                compiledClassRelativePath = relativePath;
                Iterator<Path> compiledClassPath = compiledClassRelativePath.iterator();
                while (compiledClassPath.hasNext()) {
                    Path instrumentedClassPath2 = compiledClassPath.next();
                    File classesDir = (File)((Object)instrumentedClassPath2);
                    boolean bl8 = false;
                    if (!path.startsWith(classesDir.toPath())) continue;
                    path4 = instrumentedClassPath2;
                    break block12;
                }
                path4 = null;
            }
            if ((comparable = (File)((Object)path4)) == null || (comparable = comparable.toPath()) == null) continue;
            sourceDir = comparable;
            relativePath = sourceDir.relativize(path);
            switch (IntelliJInstrumentCodeTask$WhenMappings.$EnumSwitchMapping$0[change.getChangeType().ordinal()]) {
                case 1: {
                    Iterable $this$forEach$iv2 = CollectionsKt.listOf((Object[])new Path[]{outputDirPath, temporaryDirPath});
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Path it5 = (Path)element$iv2;
                        boolean bl9 = false;
                        Path path5 = it5.resolve((Path)relativePath);
                        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"it.resolve(relativePath)");
                        FileUtilKt.deleteLogged((Path)path5);
                    }
                    continue block6;
                }
                default: {
                    Iterable $this$apply = iterable = temporaryDirPath.resolve((Path)relativePath);
                    boolean bl10 = false;
                    FileUtilKt.createParentDirs((Path)$this$apply);
                    Files.copy(path, (Path)$this$apply, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        this.instrumentCode(instrumentNotNull, (Function0<Unit>)((Function0)new Function0<Unit>(temporaryDirPath, outputDirPath){
            final /* synthetic */ Path $temporaryDirPath;
            final /* synthetic */ Path $outputDirPath;

            public final void invoke() {
                Files.walk(this.$temporaryDirPath, new FileVisitOption[0]).filter(instrumentClasses.1.INSTANCE).forEach(new Consumer(this){
                    final /* synthetic */ instrumentClasses.3 this$0;

                    public final void accept(Path file) {
                        Path path;
                        Path relativePath = this.this$0.$temporaryDirPath.relativize(file);
                        Path $this$apply = path = this.this$0.$outputDirPath.resolve(relativePath);
                        boolean bl = false;
                        FileUtilKt.createParentDirs((Path)$this$apply);
                        Files.copy(file, $this$apply, StandardCopyOption.REPLACE_EXISTING);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$temporaryDirPath = path;
                this.$outputDirPath = path2;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<File> compilerClassPath() {
        List list2;
        File file = (File)this.getJavac2().getOrNull();
        if (file != null) {
            File file2;
            File p1 = file2 = file;
            boolean bl = false;
            file = p1.exists() ? file2 : null;
            if (file != null) {
                void $this$orEmpty$iv;
                File file3 = file2 = file;
                boolean bl2 = false;
                File[] fileArray = new File(((IdeaDependency)this.getIdeaDependency().get()).getClasses() + "/lib").listFiles(compilerClassPath.2.1.INSTANCE);
                boolean $i$f$orEmpty = false;
                Object[] objectArray = $this$orEmpty$iv;
                if (objectArray == null) {
                    boolean $i$f$emptyArray = false;
                    objectArray = new File[0];
                }
                list2 = CollectionsKt.plus((Collection)ArraysKt.filterNotNull((Object[])objectArray), (Object)file3);
                return Utils.or(list2, (Function0)new Function0<List<? extends File>>(this){
                    final /* synthetic */ IntelliJInstrumentCodeTask this$0;

                    @NotNull
                    public final List<File> invoke() {
                        Object object = this.this$0.getCompilerClassPathFromMaven().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compilerClassPathFromMaven.get()");
                        return (List)object;
                    }
                    {
                        this.this$0 = intelliJInstrumentCodeTask;
                        super(0);
                    }
                });
            }
        }
        list2 = null;
        return Utils.or(list2, (Function0)new /* invalid duplicate definition of identical inner class */);
    }

    private final boolean prepareNotNullInstrumenting(List<? extends File> classpath) {
        try {
            this.getAnt().invokeMethod("typedef", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)"skip"), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)classpath, (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"loaderref", (Object)LOADER_REF), TuplesKt.to((Object)"classname", (Object)FILTER_ANNOTATION_REGEXP_CLASS)}));
        }
        catch (BuildException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException && Intrinsics.areEqual((Object)FILTER_ANNOTATION_REGEXP_CLASS, (Object)cause.getMessage())) {
                Utils.info$default(this.context, "Old version of Javac2 is used, instrumenting code with nullability will be skipped. Use IDEA >14 SDK (139.*) to fix this", null, 4, null);
                return false;
            }
            throw (Throwable)((Object)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentCode(boolean instrumentNotNull, Function0<Unit> block) {
        String headlessOldValue = System.setProperty("java.awt.headless", "true");
        try {
            FileCollection fileCollection = this.getSourceDirs().filter((Spec)instrumentCode.dirs.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceDirs.filter { it.exists() }");
            FileCollection dirs2 = fileCollection;
            if (!dirs2.isEmpty()) {
                this.getAnt().invokeMethod("instrumentIdeaExtensions", (Object)new Object[]{MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"srcdir", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)dirs2), (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"destdir", (Object)this.getTemporaryDir()), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)this.getSourceSetCompileClasspath()), (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"includeantruntime", (Object)false), TuplesKt.to((Object)"instrumentNotNull", (Object)instrumentNotNull)}), new Closure<Object>(this, instrumentNotNull, (Object)this, (Object)this){
                    final /* synthetic */ IntelliJInstrumentCodeTask this$0;
                    final /* synthetic */ boolean $instrumentNotNull;

                    @Nullable
                    public final Object doCall() {
                        return this.$instrumentNotNull ? this.this$0.getAnt().invokeMethod("skip", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"pattern", (Object)"kotlin/Metadata"))) : null;
                    }
                    {
                        this.this$0 = this$0;
                        this.$instrumentNotNull = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3);
                    }
                }});
            }
        }
        finally {
            block.invoke();
            if (headlessOldValue != null) {
                System.setProperty("java.awt.headless", headlessOldValue);
            } else {
                System.clearProperty("java.awt.headless");
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/intellij/tasks/IntelliJInstrumentCodeTask$Companion;", "", "()V", "FILTER_ANNOTATION_REGEXP_CLASS", "", "LOADER_REF", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

