/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyImpl;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.ArchiveUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ(\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0012\u0010 \u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0002J\u001e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u0010'\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)J\u001a\u0010*\u001a\u0004\u0018\u00010\u00152\u0006\u0010+\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/intellij/dependency/PluginDependencyManager;", "", "gradleHomePath", "", "ideaDependencyProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "pluginsRepositories", "", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "context", "(Ljava/lang/String;Lorg/gradle/api/provider/Provider;Ljava/util/List;Lorg/jetbrains/intellij/utils/ArchiveUtils;Ljava/lang/String;)V", "cacheDirectoryPath", "ivyArtifactRepository", "Lorg/gradle/api/artifacts/repositories/IvyArtifactRepository;", "mavenCacheDirectoryPath", "pluginSources", "", "externalPluginDependency", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "artifact", "Ljava/io/File;", "channel", "maven", "", "findSingleDirectory", "dir", "generateIvyFile", "", "plugin", "groupId", "register", "project", "Lorg/gradle/api/Project;", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "registerRepositoryIfNeeded", "resolve", "dependency", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "zippedPluginDependency", "pluginFile", "gradle-intellij-plugin"})
public abstract class PluginDependencyManager {
    private final String mavenCacheDirectoryPath;
    private final String cacheDirectoryPath;
    private final Set<String> pluginSources;
    private IvyArtifactRepository ivyArtifactRepository;
    private final Provider<IdeaDependency> ideaDependencyProvider;
    private final List<PluginsRepository> pluginsRepositories;
    private final ArchiveUtils archiveUtils;
    private final String context;

    @Nullable
    public final PluginDependency resolve(@NotNull Project project, @NotNull PluginDependencyNotation dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Object object = this.ideaDependencyProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaDependencyProvider.get()");
        IdeaDependency ideaDependency = (IdeaDependency)object;
        Object object2 = dependency.getVersion();
        if ((object2 == null || object2.length() == 0) && ((object2 = (CharSequence)dependency.getChannel()) == null || object2.length() == 0)) {
            Serializable serializable;
            Path path = Paths.get(dependency.getId(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(dependency.id)");
            if (path.isAbsolute()) {
                return PluginDependencyManager.externalPluginDependency$default(this, new File(dependency.getId()), null, false, 6, null);
            }
            if (ideaDependency != null) {
                Utils.info$default(this.context, "Looking for builtin '" + dependency.getId() + "' in: " + ideaDependency.getClasses().getCanonicalPath(), null, 4, null);
                File file = ideaDependency.getPluginsRegistry().findPlugin(dependency.getId());
                if (file != null) {
                    String string;
                    Object it = object2 = file;
                    boolean bl = false;
                    String string2 = string = "-withSources";
                    StringBuilder stringBuilder = new StringBuilder().append(ideaDependency.getName()).append('-').append(ideaDependency.getBuildNumber());
                    boolean bl2 = false;
                    boolean bl3 = ideaDependency.getSources() != null;
                    string = bl3 ? string : null;
                    String string3 = string;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String builtinPluginVersion = stringBuilder.append(string3).toString();
                    String string4 = ((File)it).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.name");
                    return new PluginDependencyImpl(string4, dependency.getId(), builtinPluginVersion, (File)it, true, false, 32, null);
                }
            }
            throw (Throwable)new BuildException("Cannot find builtin plugin '" + dependency.getId() + "' for IDE: " + ((serializable = ideaDependency) != null && (serializable = ((IdeaDependency)serializable).getClasses()) != null ? ((File)serializable).getCanonicalPath() : null), null);
        }
        Iterable $this$forEach$iv = this.pluginsRepositories;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginDependency pluginDependency2;
            File file;
            PluginsRepository repository = (PluginsRepository)element$iv;
            boolean bl = false;
            File file2 = repository.resolve(project, dependency, this.context);
            if (file2 == null) continue;
            File it = file = file2;
            boolean bl4 = false;
            Path file3 = it.toPath();
            Path path = file3;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            if (FileUtilKt.isZip((Path)path)) {
                pluginDependency2 = this.zippedPluginDependency(it, dependency);
            } else if (FileUtilKt.isJar((Path)file3)) {
                pluginDependency2 = this.externalPluginDependency(it, dependency.getChannel(), true);
            } else {
                throw (Throwable)new BuildException("Invalid type of downloaded plugin: " + FileUtilKt.getSimpleName((Path)file3), null);
            }
            return pluginDependency2;
        }
        object2 = " from channel '" + dependency.getChannel() + '\'';
        CharSequence $i$f$forEach22 = object2;
        StringBuilder stringBuilder = new StringBuilder().append("Cannot resolve plugin '").append(dependency.getId()).append("' in version '").append(dependency.getVersion()).append('\'');
        boolean bl = false;
        boolean bl5 = dependency.getChannel() != null;
        object2 = bl5 ? object2 : null;
        Object object3 = object2;
        if (object3 == null) {
            object3 = "";
        }
        Throwable throwable = null;
        String string = stringBuilder.append((String)object3).toString();
        throw (Throwable)new BuildException(string, throwable);
    }

    public final void register(@NotNull Project project, @NotNull PluginDependency plugin, @NotNull DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (plugin.getMaven()) {
            Path path = plugin.getArtifact().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"plugin.artifact.toPath()");
            if (FileUtilKt.isJar((Path)path)) {
                dependencies.add((Object)plugin.getNotation().toDependency(project));
                return;
            }
        }
        this.registerRepositoryIfNeeded(project, plugin);
        this.generateIvyFile(plugin);
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        dependencies.add((Object)DependencyHandlerExtensionsKt.create$default((DependencyHandler)dependencyHandler, (String)this.groupId(plugin.getChannel()), (String)plugin.getId(), (String)plugin.getVersion(), (String)"compile", null, null, (int)48, null));
    }

    private final PluginDependency zippedPluginDependency(File pluginFile, PluginDependencyNotation dependency) {
        File pluginDir = this.findSingleDirectory(ArchiveUtils.extract$default(this.archiveUtils, pluginFile, FilesKt.resolve((File)new File(this.cacheDirectoryPath, this.groupId(dependency.getChannel())), (String)(dependency.getId() + '-' + dependency.getVersion())), this.context, null, null, 24, null));
        return this.externalPluginDependency(pluginDir, dependency.getChannel(), true);
    }

    private final String groupId(String channel) {
        CharSequence charSequence = channel;
        return charSequence == null || charSequence.length() == 0 ? "unzipped.com.jetbrains.plugins" : "unzipped." + channel + ".com.jetbrains.plugins";
    }

    private final File findSingleDirectory(File dir) {
        File[] fileArray;
        block7: {
            block6: {
                File[] fileArray2;
                block5: {
                    fileArray = dir.listFiles();
                    if (fileArray == null) break block6;
                    File[] $this$singleOrNull$iv = fileArray;
                    boolean $i$f$singleOrNull = false;
                    File[] single$iv = null;
                    boolean found$iv = false;
                    int n = $this$singleOrNull$iv.length;
                    for (int j = 0; j < n; ++j) {
                        File[] element$iv;
                        File[] it = element$iv = $this$singleOrNull$iv[j];
                        boolean bl = false;
                        File[] fileArray3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)fileArray3, (String)"it");
                        if (!fileArray3.isDirectory()) continue;
                        if (found$iv) {
                            fileArray2 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    fileArray2 = fileArray = !found$iv ? null : single$iv;
                }
                if (fileArray2 != null) break block7;
            }
            throw (Throwable)new BuildException("Single directory expected in: " + dir, null);
        }
        return fileArray;
    }

    private final void registerRepositoryIfNeeded(Project project, PluginDependency plugin) {
        block4: {
            File artifactParent;
            Object object = this.ideaDependencyProvider.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaDependencyProvider.get()");
            IdeaDependency ideaDependency = (IdeaDependency)object;
            if (this.ivyArtifactRepository == null) {
                this.ivyArtifactRepository = project.getRepositories().ivy(new Action(this, plugin, ideaDependency){
                    final /* synthetic */ PluginDependencyManager this$0;
                    final /* synthetic */ PluginDependency $plugin;
                    final /* synthetic */ IdeaDependency $ideaDependency;

                    public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                        Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$receiver");
                        Object object = this.$plugin.getFqn();
                        int n = (this.$plugin.getId() + '-' + this.$plugin.getVersion()).length();
                        String string = ((String)object).substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        String ivyFileSuffix = string;
                        $this$ivy.ivyPattern(PluginDependencyManager.access$getCacheDirectoryPath$p(this.this$0) + "/[organisation]/[module]-[revision]" + ivyFileSuffix + ".[ext]");
                        Serializable serializable = this.$ideaDependency;
                        if (serializable != null && (serializable = serializable.getClasses()) != null) {
                            Object it = object = serializable;
                            boolean bl = false;
                            $this$ivy.artifactPattern(it + "/plugins/[module]/[artifact](.[ext])");
                            $this$ivy.artifactPattern(it + "/[artifact](.[ext])");
                        }
                        $this$ivy.artifactPattern(PluginDependencyManager.access$getCacheDirectoryPath$p(this.this$0) + "(/[classifier])/[module]-[revision]/[artifact](.[ext])");
                        IdeaDependency ideaDependency = this.$ideaDependency;
                        if ((ideaDependency != null ? ideaDependency.getSources() : null) != null) {
                            $this$ivy.artifactPattern(this.$ideaDependency.getSources().getParent() + "/[artifact]-" + this.$ideaDependency.getVersion() + "(-[classifier]).[ext]");
                        }
                    }
                    {
                        this.this$0 = pluginDependencyManager;
                        this.$plugin = pluginDependency2;
                        this.$ideaDependency = ideaDependency;
                    }
                });
            }
            if (plugin.getBuiltin() || plugin.getMaven()) break block4;
            File file = artifactParent = plugin.getArtifact().getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifactParent");
            String pluginSource = file.getCanonicalPath();
            File file2 = artifactParent.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"artifactParent.parentFile");
            if (Intrinsics.areEqual((Object)file2.getCanonicalPath(), (Object)this.cacheDirectoryPath) ^ true) {
                String string = pluginSource;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginSource");
                if (this.pluginSources.add(string)) {
                    IvyArtifactRepository ivyArtifactRepository = this.ivyArtifactRepository;
                    if (ivyArtifactRepository != null) {
                        ivyArtifactRepository.artifactPattern(pluginSource + "/[artifact](.[ext])");
                    }
                }
            }
        }
    }

    private final void generateIvyFile(PluginDependency plugin) {
        Path path;
        Object object = this.ideaDependencyProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaDependencyProvider.get()");
        IdeaDependency ideaDependency = (IdeaDependency)object;
        File baseDir = plugin.getBuiltin() ? plugin.getArtifact() : plugin.getArtifact().getParentFile();
        String pluginFqn = plugin.getFqn();
        String groupId = this.groupId(plugin.getChannel());
        Path it = path = Path.of(this.cacheDirectoryPath, new String[0]).resolve(groupId).resolve(pluginFqn + ".xml");
        boolean bl = false;
        Path path2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it");
        Path path3 = !FileUtilKt.exists((Path)path2) ? path : null;
        if (path3 == null) {
            return;
        }
        Path ivyFile = path3;
        DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity(groupId, plugin.getId(), plugin.getVersion());
        IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity).addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
        File file = baseDir;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"baseDir");
        intelliJIvyDescriptorFileGenerator.addCompileArtifacts(plugin, file, groupId).addSourceArtifacts(ideaDependency, plugin, baseDir, groupId).writeTo(ivyFile);
    }

    private final PluginDependency externalPluginDependency(File artifact, String channel, boolean maven) {
        Path path = artifact.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"artifact.toPath()");
        if (!FileUtilKt.isJar((Path)path) && !artifact.isDirectory()) {
            Utils.warn$default(this.context, "Cannot create plugin from file '" + artifact + "' - only directories or jars are supported", null, 4, null);
        }
        IdePlugin idePlugin = Utils.createPlugin(artifact, true, this.context);
        if (idePlugin != null) {
            PluginDependencyImpl pluginDependencyImpl;
            IdePlugin idePlugin2;
            IdePlugin it = idePlugin2 = idePlugin;
            boolean bl = false;
            String string = it.getPluginId();
            if (string == null) {
                return null;
            }
            String pluginId = string;
            String string2 = it.getPluginVersion();
            if (string2 == null) {
                return null;
            }
            String pluginVersion = string2;
            PluginDependencyImpl $this$apply = pluginDependencyImpl = new PluginDependencyImpl(pluginId, pluginId, pluginVersion, artifact, false, maven);
            boolean bl2 = false;
            $this$apply.setChannel(channel);
            IdeVersion ideVersion = it.getSinceBuild();
            $this$apply.setSinceBuild(ideVersion != null ? ideVersion.asStringWithoutProductCode() : null);
            IdeVersion ideVersion2 = it.getUntilBuild();
            $this$apply.setUntilBuild(ideVersion2 != null ? ideVersion2.asStringWithoutProductCode() : null);
            return pluginDependencyImpl;
        }
        return null;
    }

    static /* synthetic */ PluginDependency externalPluginDependency$default(PluginDependencyManager pluginDependencyManager, File file, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: externalPluginDependency");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pluginDependencyManager.externalPluginDependency(file, string, bl);
    }

    @Inject
    public PluginDependencyManager(@NotNull String gradleHomePath, @NotNull Provider<IdeaDependency> ideaDependencyProvider, @NotNull List<? extends PluginsRepository> pluginsRepositories, @NotNull ArchiveUtils archiveUtils, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)gradleHomePath, (String)"gradleHomePath");
        Intrinsics.checkNotNullParameter(ideaDependencyProvider, (String)"ideaDependencyProvider");
        Intrinsics.checkNotNullParameter(pluginsRepositories, (String)"pluginsRepositories");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        this.ideaDependencyProvider = ideaDependencyProvider;
        this.pluginsRepositories = pluginsRepositories;
        this.archiveUtils = archiveUtils;
        this.context = context;
        this.mavenCacheDirectoryPath = ((Object)Paths.get(gradleHomePath, "caches/modules-2/files-2.1")).toString();
        this.cacheDirectoryPath = ((Object)Paths.get(this.mavenCacheDirectoryPath, "com.jetbrains.intellij.idea")).toString();
        this.pluginSources = new LinkedHashSet();
    }

    public static final /* synthetic */ String access$getCacheDirectoryPath$p(PluginDependencyManager $this) {
        return $this.cacheDirectoryPath;
    }
}

