/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingParser;
import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.model.ObjectFactory;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/dependency/CustomPluginsRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "repositoryUrl", "", "(Ljava/lang/String;)V", "pluginsXmlUri", "Ljava/net/URI;", "downloadZipArtifact", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "url", "Ljava/net/URL;", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "context", "postResolve", "", "resolve", "resolveDownloadUrl", "type", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "gradle-intellij-plugin"})
public final class CustomPluginsRepository
implements PluginsRepository {
    private final URI pluginsXmlUri;
    private final String repositoryUrl;

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin, @Nullable String context) {
        URL url;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Utils.debug$default(context, "Loading list of plugins from: " + this.pluginsXmlUri, null, 4, null);
        URL uRL = url = this.pluginsXmlUri.toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
        URL uRL2 = this.resolveDownloadUrl(uRL, plugin, CustomPluginRepositoryListingType.PLUGIN_REPOSITORY);
        if (uRL2 == null) {
            uRL2 = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.SIMPLE);
        }
        if (uRL2 == null) {
            return null;
        }
        URL downloadUrl = uRL2;
        return this.downloadZipArtifact(project, downloadUrl, plugin, context);
    }

    private final URL resolveDownloadUrl(URL url, PluginDependencyNotation plugin, CustomPluginRepositoryListingType type) {
        Object v0;
        block1: {
            Object object = url;
            Object object2 = Charsets.UTF_8;
            Object object3 = TextStreamsKt.readBytes((URL)object);
            object2 = object = (Iterable)CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(new String((byte[])object3, (Charset)object2), url, new URL(this.repositoryUrl), type);
            object3 = object2.iterator();
            while (object3.hasNext()) {
                Object e = object3.next();
                CustomPluginRepositoryListingParser.PluginInfo it = (CustomPluginRepositoryListingParser.PluginInfo)e;
                boolean bl = false;
                if (!(StringsKt.equals((String)it.getPluginId(), (String)plugin.getId(), (boolean)true) && StringsKt.equals((String)it.getVersion(), (String)plugin.getVersion(), (boolean)true))) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        CustomPluginRepositoryListingParser.PluginInfo pluginInfo = v0;
        return pluginInfo != null ? pluginInfo.getDownloadUrl() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final File downloadZipArtifact(Project project, URL url, PluginDependencyNotation plugin, String context) {
        void $this$newInstance$iv;
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory objectFactory2 = objectFactory;
        Object[] parameters$iv = new Object[]{};
        boolean $i$f$newInstance = false;
        return (File)CollectionsKt.first((List)DependenciesDownloader.downloadFromRepository$default((DependenciesDownloader)$this$newInstance$iv.newInstance(DependenciesDownloader.class, Arrays.copyOf(parameters$iv, parameters$iv.length)), context, (Function1)new Function1<DependencyHandler, Dependency>(plugin){
            final /* synthetic */ PluginDependencyNotation $plugin;

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains.plugins", (String)this.$plugin.getId(), (String)this.$plugin.getVersion(), null, null, (String)"zip", (int)24, null);
            }
            {
                this.$plugin = pluginDependencyNotation;
                super(1);
            }
        }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
            final /* synthetic */ URL $url;

            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                String string = this.$url.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
                return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, string, null, null, 6, null);
            }
            {
                this.$url = uRL;
                super(1);
            }
        }, false, 8, null));
    }

    @Override
    public void postResolve(@NotNull Project project, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    /*
     * WARNING - void declaration
     */
    public CustomPluginsRepository(@NotNull String repositoryUrl) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        URI uri = new URI(repositoryUrl);
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.path");
        if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
            String string2 = repositoryUrl;
            int n = 0;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)repositoryUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.repositoryUrl = string3;
            this.pluginsXmlUri = uri;
        } else {
            void $this$run;
            URI uRI;
            URI uRI2;
            this.repositoryUrl = repositoryUrl;
            URI uRI3 = uRI2 = uri;
            CustomPluginsRepository customPluginsRepository = this;
            boolean bl = false;
            URI uRI4 = uRI = new URI($this$run.getScheme(), $this$run.getUserInfo(), $this$run.getHost(), $this$run.getPort(), $this$run.getPath() + '/', $this$run.getQuery(), $this$run.getFragment()).resolve("updatePlugins.xml");
            Intrinsics.checkNotNullExpressionValue((Object)uRI4, (String)"uri.run { URI(scheme, us\u2026ve(\"updatePlugins.xml\") }");
            customPluginsRepository.pluginsXmlUri = uRI4;
        }
    }
}

