/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.utils;

import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.model.MavenMetadata;
import org.jetbrains.intellij.model.MavenMetadataVersioning;
import org.jetbrains.intellij.model.XmlExtractor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/intellij/utils/LatestVersionResolver;", "", "()V", "Companion", "gradle-intellij-plugin"})
public final class LatestVersionResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/intellij/utils/LatestVersionResolver$Companion;", "", "()V", "fromGitHub", "", "subject", "url", "fromMaven", "gradle-intellij-plugin"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String fromMaven(@NotNull String subject, @NotNull String url) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Utils.debug$default(null, "Resolving latest " + subject + " version", null, 5, null);
            Closeable closeable = new URL(url).openStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                XmlExtractor xmlExtractor = new XmlExtractor(null, 1, null);
                InputStream inputStream = it;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                Object object2 = ((MavenMetadata)xmlExtractor.unmarshal(inputStream)).getVersioning();
                if (object2 == null || (object2 = ((MavenMetadataVersioning)object2).getLatest()) == null) {
                    throw (Throwable)new GradleException("Cannot resolve the latest " + subject + " version");
                }
                object = object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return object;
        }

        @NotNull
        public final String fromGitHub(@NotNull String subject, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Utils.debug$default(null, "Resolving latest " + subject + " version", null, 5, null);
            try {
                URLConnection uRLConnection;
                URLConnection $this$run = uRLConnection = new URL(url + "/releases/latest").openConnection();
                boolean bl = false;
                URLConnection uRLConnection2 = $this$run;
                if (uRLConnection2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                ((HttpURLConnection)uRLConnection2).setInstanceFollowRedirects(false);
                String string = $this$run.getHeaderField("Location");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHeaderField(\"Location\")");
                return StringsKt.removePrefix((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null))), (CharSequence)"v");
            }
            catch (Exception e) {
                throw (Throwable)new GradleException("Cannot resolve the latest " + subject + " version", (Throwable)e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

