/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.tools.ant.util.TeeOutputStream;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.tasks.RunPluginVerifierTask;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.LatestVersionResolver;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 Y2\u00020\u0001:\u0002YZB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0;H\u0002J\u001b\u0010<\u001a\u0010\u0012\f\u0012\n ?*\u0004\u0018\u00010>0>0=H\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020*H\u0002Jt\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020>2\b\u0010\t\u001a\u0004\u0018\u00010\n2K\u0010E\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bG\u0012\b\bH\u0012\u0004\b\b(I\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bG\u0012\b\bH\u0012\u0004\b\b(J\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bG\u0012\b\bH\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020>0FH\u0000\u00a2\u0006\u0002\bLJ/\u0010M\u001a\u00020\n2\u0006\u0010I\u001a\u00020\n2\u0006\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\bNJ\b\u0010O\u001a\u00020\nH\u0002J\b\u0010P\u001a\u00020>H\u0002J\u0017\u0010Q\u001a\u00020\n2\b\u0010J\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\bRJ\b\u0010S\u001a\u00020TH\u0007J\u0010\u0010U\u001a\u00020*2\u0006\u0010V\u001a\u00020\nH\u0002J\u0016\u0010W\u001a\u0010\u0012\f\u0012\n ?*\u0004\u0018\u00010>0>0=H\u0002J\u0010\u0010X\u001a\u00020\n2\u0006\u0010J\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0012R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0012R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0012R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020*0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0012R\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0012R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0012R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0012\u00a8\u0006["}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;Lorg/gradle/api/provider/ProviderFactory;)V", "context", "", "distributionFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDistributionFile", "()Lorg/gradle/api/file/RegularFileProperty;", "downloadDir", "Lorg/gradle/api/provider/Property;", "getDownloadDir", "()Lorg/gradle/api/provider/Property;", "externalPrefixes", "Lorg/gradle/api/provider/ListProperty;", "getExternalPrefixes", "()Lorg/gradle/api/provider/ListProperty;", "failureLevel", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "getFailureLevel", "ideDir", "Ljava/io/File;", "getIdeDir", "ideVersions", "getIdeVersions", "ides", "getIdes", "jbrVariant", "getJbrVariant", "jbrVersion", "getJbrVersion", "jreRepository", "getJreRepository", "localPaths", "getLocalPaths", "offline", "", "getOffline", "productsReleasesFile", "getProductsReleasesFile", "runtimeDir", "getRuntimeDir", "subsystemsToCheck", "getSubsystemsToCheck", "teamCityOutputFormat", "getTeamCityOutputFormat", "verificationReportsDir", "getVerificationReportsDir", "verifierPath", "getVerifierPath", "verifierVersion", "getVerifierVersion", "getOptions", "", "ideDownloadDir", "Lorg/gradle/api/provider/Provider;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "ideDownloadDir$gradle_intellij_plugin", "requiresJava11", "resolveIdePath", "ideVersion", "downloadPath", "block", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "type", "version", "buildType", "resolveIdePath$gradle_intellij_plugin", "resolveIdeUrl", "resolveIdeUrl$gradle_intellij_plugin", "resolveRuntimeDir", "resolveVerifierPath", "resolveVerifierVersion", "resolveVerifierVersion$gradle_intellij_plugin", "runPluginVerifier", "", "validateRuntimeDir", "runtimeDirPath", "verifierHomeDir", "versionParameterName", "Companion", "FailureLevel", "gradle-intellij-plugin"})
public abstract class RunPluginVerifierTask
extends DefaultTask {
    private final String context;
    private final ObjectFactory objectFactory;
    private final ExecOperations execOperations;
    private final ProviderFactory providers;
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/packages.jetbrains.team/maven/p/intellij-plugin-verifier/intellij-plugin-verifier/org/jetbrains/intellij/plugins/verifier-cli/maven-metadata.xml";
    private static final String IDEA_DOWNLOAD_URL = "https://data.services.jetbrains.com/products/download";
    private static final String ANDROID_STUDIO_DOWNLOAD_URL = "https://redirector.gvt1.com/edgedl/android/studio/ide-zips";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public abstract ListProperty<FailureLevel> getFailureLevel();

    @Input
    @Optional
    @NotNull
    public abstract Property<File> getProductsReleasesFile();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getIdeVersions();

    @Input
    @NotNull
    public abstract ListProperty<File> getIdes();

    @Input
    @NotNull
    public abstract ListProperty<File> getLocalPaths();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVerifierVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVerifierPath();

    @InputFile
    @SkipWhenEmpty
    @NotNull
    public abstract RegularFileProperty getDistributionFile();

    @OutputDirectory
    @Optional
    @NotNull
    public abstract Property<String> getVerificationReportsDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getDownloadDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJbrVariant();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJreRepository();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getRuntimeDir();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getExternalPrefixes();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getTeamCityOutputFormat();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSubsystemsToCheck();

    @Internal
    @NotNull
    public abstract Property<File> getIdeDir();

    @Internal
    @NotNull
    public abstract Property<Boolean> getOffline();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void runPluginVerifier() {
        void $this$mapNotNullTo$iv$iv;
        RegularFile file = (RegularFile)this.getDistributionFile().getOrNull();
        if (file == null || !file.getAsFile().exists()) {
            throw (Throwable)new IllegalStateException("Plugin file does not exist: " + file);
        }
        Object object = this.getIdes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ides.get()");
        Collection collection = (Collection)object;
        Object object2 = this.getLocalPaths().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"localPaths.get()");
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object2));
        boolean $i$f$mapNotNull = false;
        Object object3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File p1 = (File)element$iv$iv;
            boolean bl2 = false;
            if (p1.getCanonicalPath() == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        if (paths.isEmpty()) {
            throw (Throwable)new GradleException("'ideVersions' and 'localPaths' properties should not be empty");
        }
        Path verifierPath = this.resolveVerifierPath();
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"check-plugin"), (Iterable)this.getOptions());
        File file2 = file.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.asFile");
        List verifierArgs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Object)file2.getCanonicalPath()), (Iterable)paths);
        StringBuilder stringBuilder = new StringBuilder().append("Distribution file: ");
        File file3 = file.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.asFile");
        Utils.debug$default(this.context, stringBuilder.append(file3.getCanonicalPath()).toString(), null, 4, null);
        Utils.debug$default(this.context, "Verifier path: " + verifierPath, null, 4, null);
        object3 = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)object3;
            boolean bl = false;
            try {
                this.execOperations.javaexec(new Action(os, this, verifierPath, verifierArgs){
                    final /* synthetic */ ByteArrayOutputStream $os;
                    final /* synthetic */ RunPluginVerifierTask this$0;
                    final /* synthetic */ Path $verifierPath$inlined;
                    final /* synthetic */ List $verifierArgs$inlined;
                    {
                        this.$os = byteArrayOutputStream;
                        this.this$0 = runPluginVerifierTask;
                        this.$verifierPath$inlined = path;
                        this.$verifierArgs$inlined = list2;
                    }

                    public final void execute(@NotNull JavaExecSpec $this$javaexec) {
                        Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$receiver");
                        $this$javaexec.setClasspath((FileCollection)RunPluginVerifierTask.access$getObjectFactory$p(this.this$0).fileCollection().from(new Object[]{this.$verifierPath$inlined}));
                        $this$javaexec.getMainClass().set((Object)"com.jetbrains.pluginverifier.PluginVerifierMain");
                        $this$javaexec.setArgs(this.$verifierArgs$inlined);
                        $this$javaexec.setStandardOutput((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)this.$os));
                    }
                });
            }
            catch (ExecException e) {
                Utils.error$default(this.context, "Error during Plugin Verifier CLI execution:\n" + os, null, 4, null);
                throw (Throwable)e;
            }
            Utils.debug$default(this.context, "Current failure levels: " + ArraysKt.joinToString$default((Object[])FailureLevel.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
            FailureLevel[] $this$forEach$iv = FailureLevel.values();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                FailureLevel element$iv;
                FailureLevel level = element$iv = $this$forEach$iv[j];
                boolean bl4 = false;
                if (!((List)this.getFailureLevel().get()).contains((Object)level)) continue;
                String string = os.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"os.toString()");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)level.getSectionHeading(), (boolean)false, (int)2, null)) continue;
                Utils.debug$default(this.context, "Failing task on '" + this.getFailureLevel() + "' failure level", null, 4, null);
                throw (Throwable)new GradleException((Object)((Object)level) + ": " + level.getMessage() + " Check Plugin Verifier report for more details.\n" + "Incompatible API Changes: https://jb.gg/intellij-api-changes");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
        }
    }

    private final Path resolveVerifierPath() {
        Object object;
        block3: {
            block2: {
                Object object2;
                object = (String)this.getVerifierPath().getOrNull();
                if (object == null) break block2;
                Object p1 = object2 = object;
                boolean bl = false;
                object = Path.of((String)p1, new String[0]);
                if (object == null) break block2;
                p1 = object2 = object;
                boolean bl2 = false;
                object = FileUtilKt.exists((Path)p1) ? object2 : null;
                if (object != null) break block3;
            }
            throw (Throwable)new InvalidUserDataException("Provided Plugin Verifier path doesn't exist: '" + this.getPath() + "'. Downloading Plugin Verifier: " + this.getVerifierVersion());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveRuntimeDir() {
        void $this$newInstance$iv;
        void parameters$iv;
        void $this$newInstance$iv2;
        void $this$newInstance$iv3;
        ObjectFactory objectFactory = this.objectFactory;
        ObjectFactory parameters$iv2 = new ObjectFactory[]{};
        boolean $i$f$newInstance = false;
        ObjectFactory objectFactory2 = parameters$iv2;
        ArchiveUtils archiveUtils = (ArchiveUtils)$this$newInstance$iv3.newInstance(ArchiveUtils.class, Arrays.copyOf(objectFactory2, ((Object[])objectFactory2).length));
        parameters$iv2 = this.objectFactory;
        ObjectFactory parameters$iv3 = new ObjectFactory[]{};
        boolean $i$f$newInstance22 = false;
        ObjectFactory objectFactory3 = parameters$iv3;
        DependenciesDownloader dependenciesDownloader = (DependenciesDownloader)$this$newInstance$iv2.newInstance(DependenciesDownloader.class, Arrays.copyOf(objectFactory3, ((Object[])objectFactory3).length));
        parameters$iv3 = this.objectFactory;
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = $i$f$newInstance22 = (Object[])this.getJreRepository().getOrNull();
        if ($i$f$newInstance22 == null) {
            objectArray2 = "";
        }
        objectArray[0] = objectArray2;
        Object object = this.getOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"offline.get()");
        objectArray[1] = object;
        objectArray[2] = archiveUtils;
        objectArray[3] = dependenciesDownloader;
        objectArray[4] = this.context;
        Object[] $i$f$newInstance22 = objectArray;
        boolean $i$f$newInstance3 = false;
        void v5 = parameters$iv;
        JbrResolver jbrResolver = (JbrResolver)$this$newInstance$iv.newInstance(JbrResolver.class, (Object[])Arrays.copyOf(v5, ((void)v5).length));
        String string = jbrResolver.resolveRuntimeDir((String)this.getRuntimeDir().getOrNull(), (String)this.getJbrVersion().getOrNull(), (String)this.getJbrVariant().getOrNull(), (File)this.getIdeDir().getOrNull(), (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ RunPluginVerifierTask this$0;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RunPluginVerifierTask.access$validateRuntimeDir(this.this$0, it);
            }
            {
                this.this$0 = runPluginVerifierTask;
                super(1);
            }
        }));
        if (string == null) {
            throw (Throwable)new InvalidUserDataException(this.requiresJava11() ? "Java Runtime directory couldn't be resolved. Note: Plugin Verifier 1.260+ requires Java 11" : "Java Runtime directory couldn't be resolved");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validateRuntimeDir(String runtimeDirPath) {
        boolean bl;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            Utils.debug$default(this.context, "Plugin Verifier JRE verification: " + runtimeDirPath, null, 4, null);
            if (!this.requiresJava11()) {
                boolean bl3 = true;
                return bl3;
            }
            this.execOperations.exec(new Action(os, this, runtimeDirPath){
                final /* synthetic */ ByteArrayOutputStream $os;
                final /* synthetic */ RunPluginVerifierTask this$0;
                final /* synthetic */ String $runtimeDirPath$inlined;
                {
                    this.$os = byteArrayOutputStream;
                    this.this$0 = runPluginVerifierTask;
                    this.$runtimeDirPath$inlined = string;
                }

                public final void execute(@NotNull ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$receiver");
                    $this$exec.setExecutable(FilesKt.resolve((File)new File(this.$runtimeDirPath$inlined), (String)"bin/java").getCanonicalPath());
                    $this$exec.setArgs(CollectionsKt.listOf((Object)"-version"));
                    $this$exec.setErrorOutput((OutputStream)this.$os);
                }
            });
            String string = os.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"os.toString()");
            Version version2 = Version.Companion.parse(string);
            boolean result2 = version2.compareTo(new Version(11, 0, 0, null, 14, null)) >= 0;
            bl = Utils.ifFalse(result2, (Function0<Unit>)((Function0)new Function0<Unit>(version2, this, runtimeDirPath){
                final /* synthetic */ Version $version;
                final /* synthetic */ RunPluginVerifierTask this$0;
                final /* synthetic */ String $runtimeDirPath$inlined;
                {
                    this.$version = version2;
                    this.this$0 = runPluginVerifierTask;
                    this.$runtimeDirPath$inlined = string;
                    super(0);
                }

                public final void invoke() {
                    Utils.debug$default(RunPluginVerifierTask.access$getContext$p(this.this$0), "Plugin Verifier 1.260+ requires Java 11, but '" + this.$version + "' was provided with 'runtimeDir': " + this.$runtimeDirPath$inlined, null, 4, null);
                }
            }));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    private final boolean requiresJava11() {
        String string = this.resolveVerifierVersion$gradle_intellij_plugin((String)this.getVerifierVersion().getOrNull());
        Version.Companion companion = Version.Companion;
        String p1 = string;
        boolean bl = false;
        return companion.parse(p1).compareTo(new Version(1, 260, 0, null, 12, null)) >= 0;
    }

    private final List<String> getOptions() {
        Object[] objectArray = new String[4];
        objectArray[0] = "-verification-reports-dir";
        Object object = this.getVerificationReportsDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"verificationReportsDir.get()");
        objectArray[1] = (String)object;
        objectArray[2] = "-runtime-dir";
        objectArray[3] = this.resolveRuntimeDir();
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        Object object2 = this.getExternalPrefixes().get();
        Object it = (List)object2;
        boolean bl = false;
        List list2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it");
        Collection collection = list2;
        List list3 = (List)(!collection.isEmpty() ? object2 : null);
        if (list3 != null) {
            it = object2 = list3;
            boolean bl2 = false;
            args.add("-external-prefixes");
            Object object3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it");
            args.add(CollectionsKt.joinToString$default((Iterable)((Iterable)object3), (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
        }
        Object object4 = this.getTeamCityOutputFormat().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"teamCityOutputFormat.get()");
        if (((Boolean)object4).booleanValue()) {
            args.add("-team-city");
        }
        if (this.getSubsystemsToCheck().getOrNull() != null) {
            args.add("-subsystems-to-check");
            Object object5 = this.getSubsystemsToCheck().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"subsystemsToCheck.get()");
            args.add(object5);
        }
        Object object6 = this.getOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"offline.get()");
        if (((Boolean)object6).booleanValue()) {
            args.add("-offline");
        }
        return args;
    }

    private final Provider<Path> verifierHomeDir() {
        Provider provider = this.providers.systemProperty("plugin.verifier.home.dir").forUseAtConfigurationTime().map((Transformer)verifierHomeDir.1.INSTANCE).orElse(this.providers.environmentVariable("XDG_CACHE_HOME").forUseAtConfigurationTime().map((Transformer)verifierHomeDir.2.INSTANCE)).orElse(this.providers.systemProperty("user.home").forUseAtConfigurationTime().map((Transformer)verifierHomeDir.3.INSTANCE)).orElse((Object)this.getTemporaryDir().toPath().resolve("pluginVerifier"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.systemProperty\u2026esolve(\"pluginVerifier\"))");
        return provider;
    }

    @NotNull
    public final String resolveVerifierVersion$gradle_intellij_plugin(@Nullable String version2) {
        String string;
        block3: {
            block2: {
                String string2;
                string = version2;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = Intrinsics.areEqual((Object)it, (Object)"latest") ^ true ? string2 : null;
                if (string != null) break block3;
            }
            string = Companion.resolveLatestVersion();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Path resolveIdePath$gradle_intellij_plugin(@NotNull String ideVersion, @NotNull Path downloadPath, @Nullable String context, @NotNull Function3<? super String, ? super String, ? super String, ? extends Path> block) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)downloadPath, (String)"downloadPath");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Utils.debug$default(context, "Resolving IDE path for: " + ideVersion, null, 4, null);
        var8_5 = ideVersion;
        var7_6 = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)StringsKt.trim((CharSequence)((CharSequence)var8_5)).toString(), (char[])new char[]{'-'}, (boolean)false, (int)2, (int)2, null), null);
        var8_5 = var7_6;
        var5_7 = (String)var8_5.get(0);
        var8_5 = var7_6;
        version = (String)var8_5.get(1);
        if (version == null) {
            Utils.debug$default(context, "IDE type not specified, setting type to IC", null, 4, null);
            version = type;
            type = "IC";
        }
        name = type + '-' + version;
        v0 = ideDirPath = downloadPath.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ideDirPath");
        if (FileUtilKt.exists((Path)v0)) {
            Utils.debug$default(context, "IDE already available in: " + ideDirPath, null, 4, null);
            return ideDirPath;
        }
        v1 = type;
        if (v1 == null) ** GOTO lbl-1000
        var10_9 = v1;
        switch (var10_9.hashCode()) {
            case 2088: {
                if (var10_9.equals("AI")) {
                    v2 = CollectionsKt.listOf((Object)"");
                    break;
                }
            }
            default: lbl-1000:
            // 2 sources

            {
                v2 = CollectionsKt.listOf((Object[])new String[]{"release", "rc", "eap", "beta"});
            }
        }
        buildTypes = v2;
        $this$forEach$iv = buildTypes;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            buildType = (String)element$iv;
            $i$a$-forEach-RunPluginVerifierTask$resolveIdePath$1 = false;
            Utils.debug$default(context, "Downloading IDE '" + type + '-' + version + "' from '" + buildType + "' channel to: " + downloadPath, null, 4, null);
            try {
                v3 = type;
                Intrinsics.checkNotNull((Object)v3);
                v4 = version;
                Intrinsics.checkNotNull((Object)v4);
                var16_17 = block.invoke((Object)v3, (Object)v4, (Object)buildType);
                it = (Path)var16_17;
                $i$a$-also-RunPluginVerifierTask$resolveIdePath$1$1 = false;
                Utils.debug$default(context, "Resolved IDE '" + type + '-' + version + "' path: " + it, null, 4, null);
                return (Path)var16_17;
            }
            catch (IOException e) {
                Utils.debug(context, "Cannot download IDE '" + type + '-' + version + "' from '" + buildType + "' channel. Trying another channel...", e);
            }
        }
        throw (Throwable)new GradleException("IDE '" + ideVersion + "' cannot be downloaded. Please verify the specified IDE version against the products available for testing: https://jb.gg/intellij-platform-builds-list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String resolveIdeUrl$gradle_intellij_plugin(@NotNull String type, @NotNull String version2, @NotNull String buildType, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        boolean isAndroidStudio = Intrinsics.areEqual((Object)type, (Object)"AI");
        String url = isAndroidStudio ? "https://redirector.gvt1.com/edgedl/android/studio/ide-zips/" + version2 + "/android-studio-" + version2 + "-linux.tar.gz" : "https://data.services.jetbrains.com/products/download?code=" + type + "&platform=linux&type=" + buildType + '&' + this.versionParameterName(version2) + '=' + version2;
        Utils.debug$default(context, "Resolving direct IDE download URL for: " + url, null, 4, null);
        HttpURLConnection connection = null;
        try {
            HttpURLConnection httpURLConnection;
            URLConnection uRLConnection = new URL(url).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection $this$with = httpURLConnection = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            connection = $this$with;
            $this$with.setInstanceFollowRedirects(false);
            Closeable closeable = $this$with.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                if (!($this$with.getResponseCode() != 301 && $this$with.getResponseCode() != 302 || isAndroidStudio)) {
                    URL redirectUrl = new URL($this$with.getHeaderField("Location"));
                    $this$with.disconnect();
                    Utils.debug$default(context, "Resolved IDE download URL: " + url, null, 4, null);
                    String string = "https://cache-redirector.jetbrains.com/" + redirectUrl.getHost() + redirectUrl.getFile();
                    String string2 = string;
                    return string2;
                }
                Utils.debug$default(context, "IDE download URL has no redirection provided. Skipping", null, 4, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Utils.info$default(context, "Cannot resolve direct download URL for: " + url, null, 4, null);
            Utils.debug(context, "Download exception stacktrace:", e);
            throw (Throwable)e;
        }
        finally {
            HttpURLConnection httpURLConnection = connection;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return url;
    }

    private final String versionParameterName(String version2) {
        CharSequence charSequence = version2;
        String string = "\\d{3}(\\.\\d+)+";
        return (string = new Regex(string)).matches(charSequence) ? "build" : "version";
    }

    @NotNull
    public final Provider<Path> ideDownloadDir$gradle_intellij_plugin() {
        Provider provider = this.verifierHomeDir().map((Transformer)ideDownloadDir.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"verifierHomeDir().map { \u2026lve(\"ides\").createDir() }");
        return provider;
    }

    @Inject
    public RunPluginVerifierTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations, @NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        this.providers = providers;
        this.context = Utils.logCategory((Task)this);
    }

    public static final /* synthetic */ ObjectFactory access$getObjectFactory$p(RunPluginVerifierTask $this) {
        return $this.objectFactory;
    }

    public static final /* synthetic */ boolean access$validateRuntimeDir(RunPluginVerifierTask $this, String runtimeDirPath) {
        return $this.validateRuntimeDir(runtimeDirPath);
    }

    public static final /* synthetic */ String access$getContext$p(RunPluginVerifierTask $this) {
        return $this.context;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0001\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "", "sectionHeading", "", "message", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getSectionHeading", "COMPATIBILITY_WARNINGS", "COMPATIBILITY_PROBLEMS", "DEPRECATED_API_USAGES", "SCHEDULED_FOR_REMOVAL_API_USAGES", "EXPERIMENTAL_API_USAGES", "INTERNAL_API_USAGES", "OVERRIDE_ONLY_API_USAGES", "NON_EXTENDABLE_API_USAGES", "PLUGIN_STRUCTURE_WARNINGS", "MISSING_DEPENDENCIES", "INVALID_PLUGIN", "NOT_DYNAMIC", "Companion", "gradle-intellij-plugin"})
    public static final class FailureLevel
    extends Enum<FailureLevel> {
        public static final /* enum */ FailureLevel COMPATIBILITY_WARNINGS;
        public static final /* enum */ FailureLevel COMPATIBILITY_PROBLEMS;
        public static final /* enum */ FailureLevel DEPRECATED_API_USAGES;
        public static final /* enum */ FailureLevel SCHEDULED_FOR_REMOVAL_API_USAGES;
        public static final /* enum */ FailureLevel EXPERIMENTAL_API_USAGES;
        public static final /* enum */ FailureLevel INTERNAL_API_USAGES;
        public static final /* enum */ FailureLevel OVERRIDE_ONLY_API_USAGES;
        public static final /* enum */ FailureLevel NON_EXTENDABLE_API_USAGES;
        public static final /* enum */ FailureLevel PLUGIN_STRUCTURE_WARNINGS;
        public static final /* enum */ FailureLevel MISSING_DEPENDENCIES;
        public static final /* enum */ FailureLevel INVALID_PLUGIN;
        public static final /* enum */ FailureLevel NOT_DYNAMIC;
        private static final /* synthetic */ FailureLevel[] $VALUES;
        @NotNull
        private final String sectionHeading;
        @NotNull
        private final String message;
        @NotNull
        private static final EnumSet<FailureLevel> ALL;
        @NotNull
        private static final EnumSet<FailureLevel> NONE;
        @NotNull
        public static final Companion Companion;

        static {
            FailureLevel[] failureLevelArray = new FailureLevel[12];
            FailureLevel[] failureLevelArray2 = failureLevelArray;
            failureLevelArray[0] = COMPATIBILITY_WARNINGS = new FailureLevel("Compatibility warnings", "Compatibility warnings detected against the specified IDE version.");
            failureLevelArray[1] = COMPATIBILITY_PROBLEMS = new FailureLevel("Compatibility problems", "Compatibility problems detected against the specified IDE version.");
            failureLevelArray[2] = DEPRECATED_API_USAGES = new FailureLevel("Deprecated API usages", "Plugin uses API marked as deprecated (@Deprecated).");
            failureLevelArray[3] = SCHEDULED_FOR_REMOVAL_API_USAGES = new FailureLevel("scheduled for removal API", "Plugin uses API marked as scheduled for removal (ApiStatus.@ScheduledForRemoval).");
            failureLevelArray[4] = EXPERIMENTAL_API_USAGES = new FailureLevel("Experimental API usages", "Plugin uses API marked as experimental (ApiStatus.@Experimental).");
            failureLevelArray[5] = INTERNAL_API_USAGES = new FailureLevel("Internal API usages", "Plugin uses API marked as internal (ApiStatus.@get:Internal).");
            failureLevelArray[6] = OVERRIDE_ONLY_API_USAGES = new FailureLevel("Override-only API usages", "Override-only API is used incorrectly (ApiStatus.@OverrideOnly).");
            failureLevelArray[7] = NON_EXTENDABLE_API_USAGES = new FailureLevel("Non-extendable API usages", "Non-extendable API is used incorrectly (ApiStatus.@NonExtendable).");
            failureLevelArray[8] = PLUGIN_STRUCTURE_WARNINGS = new FailureLevel("Plugin structure warnings", "The structure of the plugin is not valid.");
            failureLevelArray[9] = MISSING_DEPENDENCIES = new FailureLevel("Missing dependencies", "Plugin has some dependencies missing.");
            failureLevelArray[10] = INVALID_PLUGIN = new FailureLevel("The following files specified for the verification are not valid plugins", "Provided plugin artifact is not valid.");
            failureLevelArray[11] = NOT_DYNAMIC = new FailureLevel("Plugin cannot be loaded/unloaded without IDE restart", "Plugin cannot be loaded/unloaded without IDE restart.");
            $VALUES = failureLevelArray;
            Companion = new Companion(null);
            EnumSet<FailureLevel> enumSet = EnumSet.allOf(FailureLevel.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.allOf(FailureLevel::class.java)");
            ALL = enumSet;
            EnumSet<FailureLevel> enumSet2 = EnumSet.noneOf(FailureLevel.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"EnumSet.noneOf(FailureLevel::class.java)");
            NONE = enumSet2;
        }

        @NotNull
        public final String getSectionHeading() {
            return this.sectionHeading;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        private FailureLevel(String sectionHeading, String message) {
            this.sectionHeading = sectionHeading;
            this.message = message;
        }

        public static FailureLevel[] values() {
            return (FailureLevel[])$VALUES.clone();
        }

        public static FailureLevel valueOf(String string) {
            return Enum.valueOf(FailureLevel.class, string);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel$Companion;", "", "()V", "ALL", "Ljava/util/EnumSet;", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "getALL", "()Ljava/util/EnumSet;", "NONE", "getNONE", "gradle-intellij-plugin"})
        public static final class Companion {
            @NotNull
            public final EnumSet<FailureLevel> getALL() {
                return ALL;
            }

            @NotNull
            public final EnumSet<FailureLevel> getNONE() {
                return NONE;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$Companion;", "", "()V", "ANDROID_STUDIO_DOWNLOAD_URL", "", "IDEA_DOWNLOAD_URL", "METADATA_URL", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        @NotNull
        public final String resolveLatestVersion() {
            return LatestVersionResolver.Companion.fromMaven("Plugin Verifier", RunPluginVerifierTask.METADATA_URL);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

