/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u001fH\u0007J \u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006)"}, d2={"Lorg/jetbrains/intellij/tasks/PatchPluginXmlTask;", "Lorg/gradle/api/DefaultTask;", "()V", "changeNotes", "Lorg/gradle/api/provider/Property;", "", "getChangeNotes", "()Lorg/gradle/api/provider/Property;", "context", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputFiles", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getOutputFiles", "()Lorg/gradle/api/provider/ListProperty;", "pluginDescription", "getPluginDescription", "pluginId", "getPluginId", "pluginXmlFiles", "getPluginXmlFiles", "sinceBuild", "getSinceBuild", "untilBuild", "getUntilBuild", "version", "getVersion", "patchAttribute", "", "document", "Lorg/jdom2/Document;", "tagName", "attributeName", "attributeValue", "patchPluginXmlFiles", "patchTag", "name", "content", "gradle-intellij-plugin"})
public abstract class PatchPluginXmlTask
extends DefaultTask {
    private final String context = Utils.logCategory((Task)this);

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getDestinationDir();

    @OutputFiles
    @NotNull
    public abstract ListProperty<File> getOutputFiles();

    @SkipWhenEmpty
    @InputFiles
    @NotNull
    public abstract ListProperty<File> getPluginXmlFiles();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPluginDescription();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSinceBuild();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getUntilBuild();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getChangeNotes();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getPluginId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void patchPluginXmlFiles() {
        Object object = this.getPluginXmlFiles().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginXmlFiles.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            Object object2 = file2;
            object2 = new FileInputStream((File)object2);
            Throwable throwable = null;
            try {
                Document document;
                Object it;
                Object object3;
                FileInputStream inputStream = (FileInputStream)object2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)JDOMUtil.loadDocument((InputStream)inputStream), (String)"JDOMUtil.loadDocument(inputStream)");
                String string = (String)this.getSinceBuild().getOrNull();
                if (string != null) {
                    it = object3 = string;
                    boolean bl3 = false;
                    String string2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                    this.patchAttribute(document, "idea-version", "since-build", string2);
                }
                String string3 = (String)this.getUntilBuild().getOrNull();
                if (string3 != null) {
                    it = object3 = string3;
                    boolean bl4 = false;
                    String string4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
                    this.patchAttribute(document, "idea-version", "until-build", string4);
                }
                String string5 = (String)this.getPluginDescription().getOrNull();
                if (string5 != null) {
                    it = object3 = string5;
                    boolean bl5 = false;
                    String string6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it");
                    this.patchTag(document, "description", string6);
                }
                String string7 = (String)this.getChangeNotes().getOrNull();
                if (string7 != null) {
                    it = object3 = string7;
                    boolean bl6 = false;
                    String string8 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it");
                    this.patchTag(document, "change-notes", string8);
                }
                object3 = this.getVersion().getOrNull();
                it = (String)object3;
                boolean bl7 = false;
                String string9 = (String)(Intrinsics.areEqual((Object)it, (Object)"unspecified") ^ true ? object3 : null);
                if (string9 != null) {
                    it = object3 = string9;
                    boolean bl8 = false;
                    Object object4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
                    this.patchTag(document, "version", (String)object4);
                }
                String string10 = (String)this.getPluginId().getOrNull();
                if (string10 != null) {
                    it = object3 = string10;
                    boolean bl9 = false;
                    Object object5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"it");
                    this.patchTag(document, "id", (String)object5);
                }
                Object object6 = this.getDestinationDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"destinationDir.get()");
                File file3 = ((Directory)object6).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"destinationDir.get()\n                    .asFile");
                String string11 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"file.name");
                it = object3 = FilesKt.resolve((File)file3, (String)string11);
                boolean bl10 = false;
                Utils.transformXml(document, (File)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchTag(Document document, String name, String content) {
        Element element;
        CharSequence charSequence = content;
        if (charSequence.length() == 0) {
            return;
        }
        Element it = element = document.getRootElement();
        boolean bl2 = false;
        Element element2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"it");
        Object object = Intrinsics.areEqual((Object)element2.getName(), (Object)"idea-plugin") ? element : null;
        if (object == null) {
            return;
        }
        Element pluginXml = object;
        Element tag = pluginXml.getChild(name);
        if (tag != null) {
            String existingValue;
            String string = existingValue = tag.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"existingValue");
            CharSequence bl2 = string;
            if (bl2.length() > 0) {
                Utils.warn$default(this.context, "Patching plugin.xml: value of '" + name + '[' + existingValue + "]' tag will be set to '" + content + '\'', null, 4, null);
            }
            tag.setText(content);
        } else {
            void $this$apply;
            Element element3;
            Element bl2 = element3 = new Element(name);
            int n = 0;
            Element element4 = pluginXml;
            boolean bl3 = false;
            $this$apply.setText(content);
            Unit unit = Unit.INSTANCE;
            element4.addContent(n, (Content)element3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchAttribute(Document document, String tagName, String attributeName, String attributeValue) {
        Element element;
        CharSequence charSequence = attributeValue;
        if (charSequence.length() == 0) {
            return;
        }
        Element it = element = document.getRootElement();
        boolean bl2 = false;
        Element element2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"it");
        Object object = Intrinsics.areEqual((Object)element2.getName(), (Object)"idea-plugin") ? element : null;
        if (object == null) {
            return;
        }
        Element pluginXml = object;
        Element tag = pluginXml.getChild(tagName);
        if (tag != null) {
            Attribute attribute = tag.getAttribute(attributeName);
            String existingValue = attribute != null ? attribute.getValue() : null;
            CharSequence bl2 = existingValue;
            if (!(bl2 == null || bl2.length() == 0)) {
                Utils.warn$default(this.context, "Patching plugin.xml: attribute '" + attributeName + "=[" + existingValue + "]' of '" + tagName + "' tag will be set to '" + attributeValue + '\'', null, 4, null);
            }
            tag.setAttribute(attributeName, attributeValue);
        } else {
            void $this$apply;
            Element element3;
            Element bl2 = element3 = new Element(tagName);
            int n = 0;
            Element element4 = pluginXml;
            boolean bl3 = false;
            $this$apply.setAttribute(attributeName, attributeValue);
            Unit unit = Unit.INSTANCE;
            element4.addContent(n, (Content)element3);
        }
    }
}

