/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.jbr;

import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.Jbr;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001+B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003Jg\u0010\u001f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010$\u001a\u00020\u00052#\b\u0002\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00050&J]\u0010*\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00122#\b\u0002\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00050&R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver;", "", "jreRepository", "", "isOffline", "", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Ljava/lang/String;ZLorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "kotlin.jvm.PlatformType", "findJavaExecutable", "Ljava/nio/file/Path;", "javaHome", "Ljava/io/File;", "fromDir", "Lorg/jetbrains/intellij/jbr/Jbr;", "javaDir", "version", "getBuiltinJbrVersion", "ideDirectory", "getJavaArchive", "jbrArtifact", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "getJbrRoot", "resolve", "variant", "resolveRuntime", "runtimeDir", "jbrVersion", "jbrVariant", "ideDir", "resolveExecutable", "validate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "executable", "resolveRuntimeDir", "JbrArtifact", "gradle-intellij-plugin"})
public abstract class JbrResolver {
    private final OperatingSystem operatingSystem;
    private final String jreRepository;
    private final boolean isOffline;
    private final ArchiveUtils archiveUtils;
    private final DependenciesDownloader dependenciesDownloader;
    private final String context;

    @Nullable
    public final String resolveRuntimeDir(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable String jbrVariant, @Nullable File ideDir, @NotNull Function1<? super String, Boolean> validate) {
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        return this.resolveRuntime(runtimeDir, jbrVersion, jbrVariant, ideDir, false, validate);
    }

    public static /* synthetic */ String resolveRuntimeDir$default(JbrResolver jbrResolver, String string, String string2, String string3, File file, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntimeDir");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            file = null;
        }
        if ((n & 0x10) != 0) {
            function1 = resolveRuntimeDir.1.INSTANCE;
        }
        return jbrResolver.resolveRuntimeDir(string, string2, string3, file, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public final String resolveRuntime(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable String jbrVariant, @Nullable File ideDir, boolean resolveExecutable, @NotNull Function1<? super String, Boolean> validate) {
        String string;
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        Utils.debug$default(this.context, "Resolving runtime directory.", null, 4, null);
        String string2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])new Function0[]{(Function0)new Function0<String>(this, runtimeDir, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $runtimeDir;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                String string2 = this.$runtimeDir;
                if (string2 != null) {
                    Object object;
                    String string3;
                    String path = string3 = string2;
                    boolean bl = false;
                    Object p1 = object = path;
                    boolean bl2 = false;
                    object = new File((String)p1);
                    p1 = this.this$0;
                    Object p12 = object;
                    boolean bl3 = false;
                    Object $this$run = object = JbrResolver.access$getJbrRoot((JbrResolver)p1, (File)p12);
                    boolean bl4 = false;
                    boolean bl5 = this.$resolveExecutable;
                    p1 = object = bl5 ? FilesKt.resolve((File)$this$run, (String)"bin/java") : $this$run;
                    boolean bl6 = false;
                    Object object2 = ((File)p1).exists() ? object : null;
                    Object it = object = object2 != null ? ((File)object2).getCanonicalPath() : null;
                    boolean bl7 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with runtimeDir='" + path + "' resolved as: " + (String)it, null, 4, null);
                    string = (String)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(path, this){
                        final /* synthetic */ String $path;
                        final /* synthetic */ resolveRuntime.2 this$0;
                        {
                            this.$path = string;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with runtimeDir='" + this.$path + '\'', null, 4, null);
                        }
                    }));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$runtimeDir = string;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, jbrVersion, jbrVariant, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $jbrVersion;
            final /* synthetic */ String $jbrVariant;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                String string2 = this.$jbrVersion;
                if (string2 != null) {
                    String string3;
                    Jbr jbr;
                    String string4;
                    String version2 = string4 = string2;
                    boolean bl = false;
                    Jbr jbr2 = this.this$0.resolve(version2, this.$jbrVariant);
                    if (jbr2 != null) {
                        Jbr $this$run = jbr = jbr2;
                        boolean bl2 = false;
                        boolean bl3 = this.$resolveExecutable;
                        if (bl3) {
                            string3 = $this$run.getJavaExecutable();
                        } else {
                            File file = $this$run.getJavaHome();
                            JbrResolver jbrResolver = this.this$0;
                            File p1 = file;
                            boolean bl4 = false;
                            string3 = JbrResolver.access$getJbrRoot(jbrResolver, p1).getCanonicalPath();
                        }
                    } else {
                        string3 = null;
                    }
                    Jbr it = jbr = string3;
                    boolean bl5 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with jbrVersion='" + version2 + "', jbrVariant='" + this.$jbrVariant + "' resolved as: " + (String)((Object)it), null, 4, null);
                    string = (String)((Object)Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(version2, this){
                        final /* synthetic */ String $version;
                        final /* synthetic */ resolveRuntime.3 this$0;
                        {
                            this.$version = string;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with jbrVersion='" + this.$version + "', jbrVariant='" + this.this$0.$jbrVariant + '\'', null, 4, null);
                        }
                    })));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$jbrVersion = string;
                this.$jbrVariant = string2;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, ideDir, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ File $ideDir;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                File file = this.$ideDir;
                if (file != null) {
                    String string2;
                    File file2;
                    File file3;
                    File file4 = file3 = file;
                    boolean bl = false;
                    File file5 = file4;
                    JbrResolver jbrResolver = this.this$0;
                    File p1 = file5;
                    boolean bl2 = false;
                    File $this$run = file5 = JbrResolver.access$getJbrRoot(jbrResolver, p1);
                    boolean bl3 = false;
                    File p12 = file2 = FilesKt.resolve((File)$this$run, (String)"bin/java");
                    boolean bl4 = false;
                    File file6 = p12.exists() ? file2 : null;
                    if (file6 != null) {
                        File executable = file2 = file6;
                        boolean bl5 = false;
                        boolean bl6 = this.$resolveExecutable;
                        if (bl6) {
                            string2 = executable.getCanonicalPath();
                        } else {
                            String string3;
                            String it = string3 = $this$run.getCanonicalPath();
                            boolean bl7 = false;
                            string2 = executable.exists() ? string3 : null;
                        }
                    } else {
                        string2 = null;
                    }
                    File it = file5 = string2;
                    boolean bl8 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with ideDir='" + file4 + "' resolved as: " + (String)((Object)it), null, 4, null);
                    string = (String)((Object)Utils.ifNull(file5, (Function0<Unit>)((Function0)new Function0<Unit>(file4, this){
                        final /* synthetic */ File $file;
                        final /* synthetic */ resolveRuntime.4 this$0;
                        {
                            this.$file = file;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file + '\'', null, 4, null);
                        }
                    })));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$ideDir = file;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, ideDir, jbrVariant, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ File $ideDir;
            final /* synthetic */ String $jbrVariant;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                File file = this.$ideDir;
                if (file != null) {
                    String string2;
                    File file2;
                    File file3 = file2 = file;
                    boolean bl = false;
                    String string3 = JbrResolver.access$getBuiltinJbrVersion(this.this$0, file3);
                    if (string3 != null) {
                        String string4;
                        Jbr jbr;
                        String string5;
                        String version2 = string5 = string3;
                        boolean bl2 = false;
                        Jbr jbr2 = this.this$0.resolve(version2, this.$jbrVariant);
                        if (jbr2 != null) {
                            Jbr $this$run = jbr = jbr2;
                            boolean bl3 = false;
                            boolean bl4 = this.$resolveExecutable;
                            if (bl4) {
                                string4 = $this$run.getJavaExecutable();
                            } else {
                                File file4 = $this$run.getJavaHome();
                                JbrResolver jbrResolver = this.this$0;
                                File p1 = file4;
                                boolean bl5 = false;
                                string4 = JbrResolver.access$getJbrRoot(jbrResolver, p1).getCanonicalPath();
                            }
                        } else {
                            string4 = null;
                        }
                        Jbr it = jbr = string4;
                        boolean bl6 = false;
                        Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with ideDir='" + file3 + "', version='" + version2 + "' resolved as: " + (String)((Object)it), null, 4, null);
                        string2 = (String)((Object)Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(version2, file3, this){
                            final /* synthetic */ String $version;
                            final /* synthetic */ File $file$inlined;
                            final /* synthetic */ resolveRuntime.5 this$0;
                            {
                                this.$version = string;
                                this.$file$inlined = file;
                                this.this$0 = var3_3;
                                super(0);
                            }

                            public final void invoke() {
                                Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file$inlined + "', version='" + this.$version + '\'', null, 4, null);
                            }
                        })));
                    } else {
                        string2 = null;
                    }
                    string = Utils.ifNull(string2, (Function0<Unit>)((Function0)new Function0<Unit>(file3, this){
                        final /* synthetic */ File $file;
                        final /* synthetic */ resolveRuntime.5 this$0;
                        {
                            this.$file = file;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file + '\'', null, 4, null);
                        }
                    }));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$ideDir = file;
                this.$jbrVariant = string;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                Object object;
                Jvm $this$run = object = Jvm.current();
                boolean bl = false;
                boolean bl2 = this.$resolveExecutable;
                if (bl2) {
                    File file = $this$run.getJavaExecutable();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"javaExecutable");
                    string = file.getCanonicalPath();
                } else if (!bl2) {
                    File file = $this$run.getJavaHome();
                    JbrResolver jbrResolver = this.this$0;
                    File p1 = file;
                    boolean bl3 = false;
                    string = JbrResolver.access$getJbrRoot(jbrResolver, p1).getCanonicalPath();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Object it = object = string;
                boolean bl4 = false;
                Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Using current JVM: " + (String)it, null, 4, null);
                return (String)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ resolveRuntime.6 this$0;

                    public final void invoke() {
                        Utils.debug$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve current JVM", null, 4, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = jbrResolver;
                this.$resolveExecutable = bl;
                super(0);
            }
        }})), (Function1)((Function1)new Function1<Function0<? extends String>, String>(validate){
            final /* synthetic */ Function1 $validate;

            @Nullable
            public final String invoke(@NotNull Function0<String> it) {
                String string;
                Function1 function1;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String string2 = (String)it.invoke();
                return string2 != null ? (((Boolean)(function1 = this.$validate).invoke((Object)(string = string2))).booleanValue() ? string : null) : null;
            }
            {
                this.$validate = function1;
                super(1);
            }
        })));
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            Utils.info$default(this.context, "Resolved JVM Runtime directory: " + it, null, 4, null);
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String resolveRuntime$default(JbrResolver jbrResolver, String string, String string2, String string3, File file, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntime");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            file = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            function1 = resolveRuntime.1.INSTANCE;
        }
        return jbrResolver.resolveRuntime(string, string2, string3, file, bl, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public final Jbr resolve(@Nullable String version2, @Nullable String variant) {
        Jbr jbr;
        CharSequence charSequence = version2;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        JbrArtifact jbrArtifact = JbrArtifact.Companion.from(version2, variant, operatingSystem);
        File file = this.getJavaArchive(jbrArtifact);
        if (file != null) {
            File file2;
            File it = file2 = file;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            File javaDir = FilesKt.resolve((File)new File(StringsKt.replaceAfter$default((String)string, (String)jbrArtifact.getName(), (String)"", null, (int)4, null)), (String)"extracted");
            ArchiveUtils.extract$default(this.archiveUtils, it, javaDir, this.context, null, null, 24, null);
            jbr = this.fromDir(javaDir, version2);
        } else {
            jbr = null;
        }
        return jbr;
    }

    private final Jbr fromDir(File javaDir, String version2) {
        Jbr jbr;
        Path path = this.findJavaExecutable(javaDir);
        if (path != null) {
            Path path2;
            Path it = path2 = path;
            boolean bl = false;
            File file = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.toFile()");
            jbr = new Jbr(version2, javaDir, file.getCanonicalPath());
        } else {
            jbr = null;
        }
        return Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(this, javaDir){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ File $javaDir;

            public final void invoke() {
                Utils.warn$default(JbrResolver.access$getContext$p(this.this$0), "Cannot find java executable in: " + this.$javaDir, null, 4, null);
            }
            {
                this.this$0 = jbrResolver;
                this.$javaDir = file;
                super(0);
            }
        }));
    }

    private final File getJavaArchive(JbrArtifact jbrArtifact) {
        if (this.isOffline) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + "'. Gradle runs in offline mode.", null, 4, null);
            return null;
        }
        Object object = this.jreRepository;
        String p1 = object;
        boolean bl = false;
        CharSequence charSequence = p1;
        String url = Utils.or(charSequence.length() > 0 ? object : null, jbrArtifact.getRepositoryUrl());
        try {
            object = (File)CollectionsKt.first((List)DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, this.context, (Function1)new Function1<DependencyHandler, Dependency>(jbrArtifact){
                final /* synthetic */ JbrArtifact $jbrArtifact;

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains", (String)"jbre", (String)this.$jbrArtifact.getName(), null, null, (String)"tar.gz", (int)24, null);
                }
                {
                    this.$jbrArtifact = jbrArtifact;
                    super(1);
                }
            }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
                final /* synthetic */ String $url;

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, this.$url, "[revision].tar.gz", null, 4, null);
                }
                {
                    this.$url = string;
                    super(1);
                }
            }, false, 8, null));
        }
        catch (Exception e) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + '\'', null, 4, null);
            object = null;
        }
        return object;
    }

    private final Path findJavaExecutable(File javaHome) {
        Object object;
        File root = this.getJbrRoot(javaHome);
        File jre = new File(root, "jre");
        Object it = object = jre;
        boolean bl = false;
        boolean bl2 = ((File)it).exists();
        Object object2 = bl2 ? object : null;
        if (object2 == null) {
            object2 = root;
        }
        it = object = ".exe";
        StringBuilder stringBuilder = new StringBuilder().append("bin/java");
        File file = object2;
        boolean bl3 = false;
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        boolean bl4 = operatingSystem.isWindows();
        object = bl4 ? object : null;
        Object object3 = object;
        if (object3 == null) {
            object3 = "";
        }
        String string = stringBuilder.append((String)object3).toString();
        File file2 = file;
        File java = new File(file2, string);
        it = object = java.toPath();
        boolean bl5 = false;
        return java.exists() ? object : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final File getJbrRoot(File javaHome) {
        block3: {
            v0 = javaHome.listFiles();
            if (v0 == null) ** GOTO lbl-1000
            $this$firstOrNull$iv = v0;
            $i$f$firstOrNull = false;
            var6_6 = $this$firstOrNull$iv.length;
            for (var5_5 = 0; var5_5 < var6_6; ++var5_5) {
                it = element$iv = $this$firstOrNull$iv[var5_5];
                $i$a$-firstOrNull-JbrResolver$getJbrRoot$jbr$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                v1 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.name");
                if (!StringsKt.startsWith$default((String)v1, (String)"jbr", (boolean)false, (int)2, null)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = v0 = null;
        }
        if (v2 != null) {
            p1 = var3_2 = v0;
            $i$a$-unknown-JbrResolver$getJbrRoot$jbr$2 = false;
            v3 /* !! */  = p1.exists() ? var3_2 : null;
        } else lbl-1000:
        // 2 sources

        {
            v3 /* !! */  = null;
        }
        jbr = v3 /* !! */ ;
        v4 = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"operatingSystem");
        return v4.isMacOsX() ? (FilesKt.endsWith((File)javaHome, (String)"Contents/Home") ? javaHome : (jbr != null ? FilesKt.resolve((File)jbr, (String)"Contents/Home") : FilesKt.resolve((File)javaHome, (String)"jdk/Contents/Home"))) : (jbr != null ? jbr : javaHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getBuiltinJbrVersion(File ideDirectory) {
        File dependenciesFile = new File(ideDirectory, "dependencies.txt");
        if (dependenciesFile.exists()) {
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(dependenciesFile);){
                properties.load(reader);
                String string = properties.getProperty("runtimeBuild");
                if (string == null) {
                    string = properties.getProperty("jdkBuild");
                }
                String string2 = string;
                return string2;
            }
        }
        return null;
    }

    @Inject
    public JbrResolver(@NotNull String jreRepository, boolean isOffline, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)jreRepository, (String)"jreRepository");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.jreRepository = jreRepository;
        this.isOffline = isOffline;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        this.operatingSystem = OperatingSystem.current();
    }

    public static final /* synthetic */ File access$getJbrRoot(JbrResolver $this, File javaHome) {
        return $this.getJbrRoot(javaHome);
    }

    public static final /* synthetic */ String access$getContext$p(JbrResolver $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getBuiltinJbrVersion(JbrResolver $this, File ideDirectory) {
        return $this.getBuiltinJbrVersion(ideDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "", "name", "", "repositoryUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRepositoryUrl", "Companion", "gradle-intellij-plugin"})
    public static final class JbrArtifact {
        @NotNull
        private final String name;
        @NotNull
        private final String repositoryUrl;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public JbrArtifact(@NotNull String name, @NotNull String repositoryUrl) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
            this.name = name;
            this.repositoryUrl = repositoryUrl;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact$Companion;", "", "()V", "arch", "", "newFormat", "", "arch$gradle_intellij_plugin", "from", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "jbrVersion", "jbrVariant", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "getPrefix", "version", "variant", "platform", "platform$gradle_intellij_plugin", "gradle-intellij-plugin"})
        public static final class Companion {
            @NotNull
            public final JbrArtifact from(@NotNull String jbrVersion, @Nullable String jbrVariant, @NotNull OperatingSystem operatingSystem) {
                boolean oldFormat;
                String string;
                int n;
                String string2;
                String string3;
                String string4;
                boolean bl;
                String string5;
                Intrinsics.checkNotNullParameter((Object)jbrVersion, (String)"jbrVersion");
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                String string6 = string5 = "8";
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                boolean bl3 = StringsKt.startsWith$default((CharSequence)jbrVersion, (char)'u', (boolean)false, (int)2, null);
                string5 = bl3 ? string5 : null;
                String string7 = string5;
                if (string7 == null) {
                    string7 = "";
                }
                String version2 = stringBuilder.append(string7).append(jbrVersion).toString();
                String prefix2 = this.getPrefix(version2, jbrVariant);
                int lastIndexOfB = StringsKt.lastIndexOf$default((CharSequence)version2, (char)'b', (int)0, (boolean)false, (int)6, null);
                int lastIndexOfDash = StringsKt.lastIndexOf$default((CharSequence)version2, (char)'-', (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl4 = bl = lastIndexOfB > -1;
                if (bl) {
                    string4 = version2;
                    String string8 = string4.substring(lastIndexOfDash, lastIndexOfB);
                    string3 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else if (!bl) {
                    string4 = version2;
                    String string9 = string4.substring(lastIndexOfDash);
                    string3 = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String majorVersion = string3;
                boolean bl5 = lastIndexOfB > -1;
                if (bl5 == (lastIndexOfDash == lastIndexOfB)) {
                    string2 = version2;
                    n = 0;
                    int n2 = lastIndexOfDash - 1;
                    String string10 = string2.substring(n, n2);
                    string = string10;
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else if (bl5) {
                    string2 = version2;
                    n = lastIndexOfB + 1;
                    String string11 = string2.substring(n);
                    string = string11;
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String buildNumberString = string;
                Version buildNumber2 = Version.Companion.parse(buildNumberString);
                boolean isJava8 = StringsKt.startsWith$default((String)majorVersion, (String)"8", (boolean)false, (int)2, null);
                boolean isJava17 = StringsKt.startsWith$default((String)majorVersion, (String)"17", (boolean)false, (int)2, null);
                boolean bl6 = oldFormat = Intrinsics.areEqual((Object)prefix2, (Object)"jbrex") || isJava8 && buildNumber2.compareTo(Version.Companion.parse("1483.24")) < 0;
                if (oldFormat) {
                    return new JbrArtifact("jbrex" + majorVersion + 'b' + buildNumberString + '_' + this.platform$gradle_intellij_plugin(operatingSystem) + '_' + this.arch$gradle_intellij_plugin(false), "https://cache-redirector.jetbrains.com/intellij-jbr");
                }
                String arch = this.arch$gradle_intellij_plugin(isJava8);
                CharSequence charSequence = prefix2;
                if (charSequence.length() == 0) {
                    prefix2 = isJava17 ? "jbr_jcef-" : (isJava8 ? "jbrx-" : (operatingSystem.isMacOsX() && Intrinsics.areEqual((Object)arch, (Object)"aarch64") ? "jbr_jcef-" : (buildNumber2.compareTo(Version.Companion.parse("1319.6")) < 0 ? "jbr-" : "jbr_jcef-")));
                }
                return new JbrArtifact(prefix2 + majorVersion + '-' + this.platform$gradle_intellij_plugin(operatingSystem) + '-' + arch + "-b" + buildNumberString, "https://cache-redirector.jetbrains.com/intellij-jbr");
            }

            /*
             * Enabled aggressive block sorting
             */
            private final String getPrefix(String version2, String variant) {
                CharSequence charSequence = variant;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    String string = variant;
                    if (string != null) {
                        charSequence = string;
                        switch (((String)charSequence).hashCode()) {
                            case 113722: {
                                if (!((String)charSequence).equals("sdk")) break;
                                return "jbrsdk-";
                            }
                        }
                    }
                    String string2 = "jbr_" + variant + '-';
                    return string2;
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbrsdk-", (boolean)false, (int)2, null)) {
                    return "jbrsdk-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_jcef-", (boolean)false, (int)2, null)) {
                    return "jbr_jcef-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_dcevm-", (boolean)false, (int)2, null)) {
                    return "jbr_dcevm-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_fd-", (boolean)false, (int)2, null)) {
                    return "jbr_fd-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr_nomod-", (boolean)false, (int)2, null)) {
                    return "jbr_nomod-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbr-", (boolean)false, (int)2, null)) {
                    return "jbr-";
                }
                if (StringsKt.startsWith$default((String)version2, (String)"jbrx-", (boolean)false, (int)2, null)) {
                    return "jbrx-";
                }
                if (!StringsKt.startsWith$default((String)version2, (String)"jbrex8", (boolean)false, (int)2, null)) return "";
                return "jbrex";
            }

            @NotNull
            public final String platform$gradle_intellij_plugin(@NotNull OperatingSystem operatingSystem) {
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                return operatingSystem.isWindows() ? "windows" : (operatingSystem.isMacOsX() ? "osx" : "linux");
            }

            @NotNull
            public final String arch$gradle_intellij_plugin(boolean newFormat) {
                String string;
                String name;
                String arch = System.getProperty("os.arch");
                if (Intrinsics.areEqual((Object)"aarch64", (Object)arch) || Intrinsics.areEqual((Object)"arm64", (Object)arch)) {
                    return "aarch64";
                }
                if (Intrinsics.areEqual((Object)"x86_64", (Object)arch) || Intrinsics.areEqual((Object)"amd64", (Object)arch)) {
                    return "x64";
                }
                String string2 = name = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Windows", (boolean)false, (int)2, null) && System.getenv("ProgramFiles(x86)") != null) {
                    return "x64";
                }
                boolean bl = newFormat;
                if (bl) {
                    string = "i586";
                } else if (!bl) {
                    string = "x86";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return string;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

