/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdePluginSourceZipFilesProvider;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyImpl;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.ArchiveUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0012\u0010\u001f\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\u001e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0018\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(J\u001a\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010*\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0002J$\u0010+\u001a\u00020\u001d*\u00020,2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J$\u0010.\u001a\u00020\u001d*\u00020,2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/intellij/dependency/PluginDependencyManager;", "", "gradleHomePath", "", "ideaDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "pluginsRepositories", "", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "context", "(Ljava/lang/String;Lorg/jetbrains/intellij/dependency/IdeaDependency;Ljava/util/List;Lorg/jetbrains/intellij/utils/ArchiveUtils;Ljava/lang/String;)V", "cacheDirectoryPath", "ivyArtifactRepository", "Lorg/gradle/api/artifacts/repositories/IvyArtifactRepository;", "mavenCacheDirectoryPath", "pluginSources", "", "externalPluginDependency", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "artifact", "Ljava/io/File;", "channel", "maven", "", "findSingleDirectory", "dir", "generateIvyFile", "", "plugin", "groupId", "register", "project", "Lorg/gradle/api/Project;", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "registerRepositoryIfNeeded", "resolve", "dependency", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "zippedPluginDependency", "pluginFile", "addCompileArtifacts", "Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator;", "baseDir", "addSourceArtifacts", "gradle-intellij-plugin"})
public abstract class PluginDependencyManager {
    private final String mavenCacheDirectoryPath;
    private final String cacheDirectoryPath;
    private final Set<String> pluginSources;
    private IvyArtifactRepository ivyArtifactRepository;
    private final IdeaDependency ideaDependency;
    private final List<PluginsRepository> pluginsRepositories;
    private final ArchiveUtils archiveUtils;
    private final String context;

    @Nullable
    public final PluginDependency resolve(@NotNull Project project, @NotNull PluginDependencyNotation dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Object object = dependency.getVersion();
        if ((object == null || object.length() == 0) && ((object = (CharSequence)dependency.getChannel()) == null || object.length() == 0)) {
            Serializable serializable;
            Path path = Paths.get(dependency.getId(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(dependency.id)");
            if (path.isAbsolute()) {
                return PluginDependencyManager.externalPluginDependency$default(this, new File(dependency.getId()), null, false, 6, null);
            }
            if (this.ideaDependency != null) {
                Utils.info$default(this.context, "Looking for builtin '" + dependency.getId() + "' in: " + this.ideaDependency.getClasses().getCanonicalPath(), null, 4, null);
                File file = this.ideaDependency.getPluginsRegistry().findPlugin(dependency.getId());
                if (file != null) {
                    String string;
                    Object it = object = file;
                    boolean bl = false;
                    String string2 = string = "-withSources";
                    StringBuilder stringBuilder = new StringBuilder().append(this.ideaDependency.getName()).append('-').append(this.ideaDependency.getBuildNumber());
                    boolean bl2 = false;
                    boolean bl3 = this.ideaDependency.getSources() != null;
                    string = bl3 ? string : null;
                    String string3 = string;
                    if (string3 == null) {
                        string3 = "";
                    }
                    String builtinPluginVersion = stringBuilder.append(string3).toString();
                    String string4 = ((File)it).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.name");
                    return new PluginDependencyImpl(string4, dependency.getId(), builtinPluginVersion, (File)it, true, false, 32, null);
                }
            }
            throw (Throwable)new BuildException("Cannot find builtin plugin '" + dependency.getId() + "' for IDE: " + ((serializable = this.ideaDependency) != null && (serializable = ((IdeaDependency)serializable).getClasses()) != null ? ((File)serializable).getCanonicalPath() : null), null);
        }
        Iterable $this$forEach$iv = this.pluginsRepositories;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginDependency pluginDependency2;
            File file;
            PluginsRepository repository = (PluginsRepository)element$iv;
            boolean bl = false;
            File file2 = repository.resolve(project, dependency, this.context);
            if (file2 == null) continue;
            File it = file = file2;
            boolean bl4 = false;
            Path file3 = it.toPath();
            Path path = file3;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            if (FileUtilKt.isZip((Path)path)) {
                pluginDependency2 = this.zippedPluginDependency(it, dependency);
            } else if (FileUtilKt.isJar((Path)file3)) {
                pluginDependency2 = this.externalPluginDependency(it, dependency.getChannel(), true);
            } else {
                throw (Throwable)new BuildException("Invalid type of downloaded plugin: " + FileUtilKt.getSimpleName((Path)file3), null);
            }
            return pluginDependency2;
        }
        object = " from channel '" + dependency.getChannel() + '\'';
        CharSequence $i$f$forEach22 = object;
        StringBuilder stringBuilder = new StringBuilder().append("Cannot resolve plugin '").append(dependency.getId()).append("' in version '").append(dependency.getVersion()).append('\'');
        boolean bl = false;
        boolean bl5 = dependency.getChannel() != null;
        object = bl5 ? object : null;
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        Throwable throwable = null;
        String string = stringBuilder.append((String)object2).toString();
        throw (Throwable)new BuildException(string, throwable);
    }

    public final void register(@NotNull Project project, @NotNull PluginDependency plugin, @NotNull DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (plugin.getMaven()) {
            Path path = plugin.getArtifact().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"plugin.artifact.toPath()");
            if (FileUtilKt.isJar((Path)path)) {
                dependencies.add((Object)plugin.getNotation().toDependency(project));
                return;
            }
        }
        this.registerRepositoryIfNeeded(project, plugin);
        this.generateIvyFile(plugin);
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        dependencies.add((Object)DependencyHandlerExtensionsKt.create$default((DependencyHandler)dependencyHandler, (String)this.groupId(plugin.getChannel()), (String)plugin.getId(), (String)plugin.getVersion(), (String)"compile", null, null, (int)48, null));
    }

    private final PluginDependency zippedPluginDependency(File pluginFile, PluginDependencyNotation dependency) {
        File pluginDir = this.findSingleDirectory(ArchiveUtils.extract$default(this.archiveUtils, pluginFile, FilesKt.resolve((File)new File(this.cacheDirectoryPath, this.groupId(dependency.getChannel())), (String)(dependency.getId() + '-' + dependency.getVersion())), this.context, null, null, 24, null));
        return this.externalPluginDependency(pluginDir, dependency.getChannel(), true);
    }

    private final String groupId(String channel) {
        CharSequence charSequence = channel;
        return charSequence == null || charSequence.length() == 0 ? "unzipped.com.jetbrains.plugins" : "unzipped." + channel + ".com.jetbrains.plugins";
    }

    private final File findSingleDirectory(File dir) {
        File[] fileArray;
        block7: {
            block6: {
                File[] fileArray2;
                block5: {
                    fileArray = dir.listFiles();
                    if (fileArray == null) break block6;
                    File[] $this$singleOrNull$iv = fileArray;
                    boolean $i$f$singleOrNull = false;
                    File[] single$iv = null;
                    boolean found$iv = false;
                    int n = $this$singleOrNull$iv.length;
                    for (int j = 0; j < n; ++j) {
                        File[] element$iv;
                        File[] it = element$iv = $this$singleOrNull$iv[j];
                        boolean bl = false;
                        File[] fileArray3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)fileArray3, (String)"it");
                        if (!fileArray3.isDirectory()) continue;
                        if (found$iv) {
                            fileArray2 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    fileArray2 = fileArray = !found$iv ? null : single$iv;
                }
                if (fileArray2 != null) break block7;
            }
            throw (Throwable)new BuildException("Single directory expected in: " + dir, null);
        }
        return fileArray;
    }

    private final void registerRepositoryIfNeeded(Project project, PluginDependency plugin) {
        block4: {
            File artifactParent;
            if (this.ivyArtifactRepository == null) {
                this.ivyArtifactRepository = project.getRepositories().ivy(new Action(this, plugin){
                    final /* synthetic */ PluginDependencyManager this$0;
                    final /* synthetic */ PluginDependency $plugin;

                    public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                        Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$receiver");
                        Object object = this.$plugin.getFqn();
                        int n = (this.$plugin.getId() + '-' + this.$plugin.getVersion()).length();
                        String string = ((String)object).substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        String ivyFileSuffix = string;
                        $this$ivy.ivyPattern(PluginDependencyManager.access$getCacheDirectoryPath$p(this.this$0) + "/[organisation]/[module]-[revision]" + ivyFileSuffix + ".[ext]");
                        Serializable serializable = PluginDependencyManager.access$getIdeaDependency$p(this.this$0);
                        if (serializable != null && (serializable = serializable.getClasses()) != null) {
                            Object it = object = serializable;
                            boolean bl = false;
                            $this$ivy.artifactPattern(it + "/plugins/[module]/[artifact](.[ext])");
                            $this$ivy.artifactPattern(it + "/[artifact](.[ext])");
                        }
                        $this$ivy.artifactPattern(PluginDependencyManager.access$getCacheDirectoryPath$p(this.this$0) + "(/[classifier])/[module]-[revision]/[artifact](.[ext])");
                        IdeaDependency ideaDependency = PluginDependencyManager.access$getIdeaDependency$p(this.this$0);
                        if ((ideaDependency != null ? ideaDependency.getSources() : null) != null) {
                            $this$ivy.artifactPattern(PluginDependencyManager.access$getIdeaDependency$p(this.this$0).getSources().getParent() + "/[artifact]-" + PluginDependencyManager.access$getIdeaDependency$p(this.this$0).getVersion() + "(-[classifier]).[ext]");
                        }
                    }
                    {
                        this.this$0 = pluginDependencyManager;
                        this.$plugin = pluginDependency2;
                    }
                });
            }
            if (plugin.getBuiltin() || plugin.getMaven()) break block4;
            File file = artifactParent = plugin.getArtifact().getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifactParent");
            String pluginSource = file.getCanonicalPath();
            File file2 = artifactParent.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"artifactParent.parentFile");
            if (Intrinsics.areEqual((Object)file2.getCanonicalPath(), (Object)this.cacheDirectoryPath) ^ true) {
                String string = pluginSource;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginSource");
                if (this.pluginSources.add(string)) {
                    IvyArtifactRepository ivyArtifactRepository = this.ivyArtifactRepository;
                    if (ivyArtifactRepository != null) {
                        ivyArtifactRepository.artifactPattern(pluginSource + "/[artifact](.[ext])");
                    }
                }
            }
        }
    }

    private final void generateIvyFile(PluginDependency plugin) {
        IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator;
        File file;
        File baseDir = plugin.getBuiltin() ? plugin.getArtifact() : plugin.getArtifact().getParentFile();
        String pluginFqn = plugin.getFqn();
        String groupId = this.groupId(plugin.getChannel());
        File it = file = new File(new File(this.cacheDirectoryPath, groupId), pluginFqn + ".xml");
        boolean bl = false;
        File file2 = !it.exists() ? file : null;
        if (file2 == null) {
            return;
        }
        File ivyFile = file2;
        DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity(groupId, plugin.getId(), plugin.getVersion());
        IntelliJIvyDescriptorFileGenerator $this$apply = intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity);
        boolean bl2 = false;
        $this$apply.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
        File file3 = baseDir;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"baseDir");
        this.addCompileArtifacts($this$apply, plugin, file3, groupId);
        this.addSourceArtifacts($this$apply, plugin, baseDir, groupId);
        $this$apply.writeTo(ivyFile);
    }

    private final void addCompileArtifacts(IntelliJIvyDescriptorFileGenerator $this$addCompileArtifacts, PluginDependency plugin, File baseDir, String groupId) {
        block2: {
            File file;
            DefaultIvyConfiguration compileConfiguration = new DefaultIvyConfiguration("compile");
            $this$addCompileArtifacts.addConfiguration((IvyConfiguration)compileConfiguration);
            Iterable $this$forEach$iv = plugin.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                String string = compileConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
                $this$addCompileArtifacts.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, string, baseDir, groupId));
            }
            File file2 = plugin.getClassesDirectory();
            if (file2 != null) {
                File it = file = file2;
                boolean bl = false;
                String string = compileConfiguration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
                $this$addCompileArtifacts.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(it, string, baseDir, groupId));
            }
            File file3 = plugin.getMetaInfDirectory();
            if (file3 == null) break block2;
            File it = file = file3;
            boolean bl = false;
            String string = compileConfiguration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compileConfiguration.name");
            $this$addCompileArtifacts.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(it, string, baseDir, groupId));
        }
    }

    private final void addSourceArtifacts(IntelliJIvyDescriptorFileGenerator $this$addSourceArtifacts, PluginDependency plugin, File baseDir, String groupId) {
        block7: {
            Object object;
            DefaultIvyConfiguration sourcesConfiguration = new DefaultIvyConfiguration("sources");
            $this$addSourceArtifacts.addConfiguration((IvyConfiguration)sourcesConfiguration);
            Object object2 = plugin.getSourceJarFiles();
            if (!object2.isEmpty()) {
                Iterable $this$forEach$iv = plugin.getSourceJarFiles();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    String string = sourcesConfiguration.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcesConfiguration.name");
                    $this$addSourceArtifacts.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, string, baseDir, groupId));
                }
            } else {
                Object object3 = this.ideaDependency;
                if (object3 != null && (object3 = ((IdeaDependency)object3).getSourceZipFiles()) != null) {
                    Object it = object2 = object3;
                    boolean bl = false;
                    object3 = IdePluginSourceZipFilesProvider.INSTANCE.getSourceZips((Collection<? extends File>)it, plugin.getPlatformPluginId());
                    if (object3 != null) {
                        it = object2 = object3;
                        boolean bl2 = false;
                        String string = sourcesConfiguration.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourcesConfiguration.name");
                        object3 = IntellijIvyArtifact.Companion.createZipDependency$default(IntellijIvyArtifact.Companion, (File)it, string, this.ideaDependency.getClasses(), null, 8, null);
                        if (object3 != null) {
                            Object p1 = object2 = object3;
                            boolean bl3 = false;
                            $this$addSourceArtifacts.addArtifact((IvyArtifact)p1);
                        }
                    }
                }
            }
            if ((object = this.ideaDependency) == null || (object = ((IdeaDependency)object).getSources()) == null) break block7;
            Object it = object2 = object;
            boolean bl = false;
            object = plugin.getBuiltin() ? object2 : null;
            if (object != null) {
                it = object2 = object;
                boolean bl4 = false;
                String name = Utils.isDependencyOnPyCharm(this.ideaDependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact artifact = new IntellijIvyArtifact((File)it, name, "jar", "sources", "sources");
                artifact.setConf(sourcesConfiguration.getName());
                $this$addSourceArtifacts.addArtifact(artifact);
            }
        }
    }

    private final PluginDependency externalPluginDependency(File artifact, String channel, boolean maven) {
        Path path = artifact.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"artifact.toPath()");
        if (!FileUtilKt.isJar((Path)path) && !artifact.isDirectory()) {
            Utils.warn$default(this.context, "Cannot create plugin from file '" + artifact + "' - only directories or jars are supported", null, 4, null);
        }
        IdePlugin idePlugin = Utils.createPlugin(artifact, true, this.context);
        if (idePlugin != null) {
            PluginDependencyImpl pluginDependencyImpl;
            IdePlugin idePlugin2;
            IdePlugin it = idePlugin2 = idePlugin;
            boolean bl = false;
            String string = it.getPluginId();
            if (string == null) {
                return null;
            }
            String pluginId = string;
            String string2 = it.getPluginVersion();
            if (string2 == null) {
                return null;
            }
            String pluginVersion = string2;
            PluginDependencyImpl $this$apply = pluginDependencyImpl = new PluginDependencyImpl(pluginId, pluginId, pluginVersion, artifact, false, maven);
            boolean bl2 = false;
            $this$apply.setChannel(channel);
            IdeVersion ideVersion = it.getSinceBuild();
            $this$apply.setSinceBuild(ideVersion != null ? ideVersion.asStringWithoutProductCode() : null);
            IdeVersion ideVersion2 = it.getUntilBuild();
            $this$apply.setUntilBuild(ideVersion2 != null ? ideVersion2.asStringWithoutProductCode() : null);
            return pluginDependencyImpl;
        }
        return null;
    }

    static /* synthetic */ PluginDependency externalPluginDependency$default(PluginDependencyManager pluginDependencyManager, File file, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: externalPluginDependency");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pluginDependencyManager.externalPluginDependency(file, string, bl);
    }

    @Inject
    public PluginDependencyManager(@NotNull String gradleHomePath, @Nullable IdeaDependency ideaDependency, @NotNull List<? extends PluginsRepository> pluginsRepositories, @NotNull ArchiveUtils archiveUtils, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)gradleHomePath, (String)"gradleHomePath");
        Intrinsics.checkNotNullParameter(pluginsRepositories, (String)"pluginsRepositories");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        this.ideaDependency = ideaDependency;
        this.pluginsRepositories = pluginsRepositories;
        this.archiveUtils = archiveUtils;
        this.context = context;
        this.mavenCacheDirectoryPath = ((Object)Paths.get(gradleHomePath, "caches/modules-2/files-2.1")).toString();
        this.cacheDirectoryPath = ((Object)Paths.get(this.mavenCacheDirectoryPath, "com.jetbrains.intellij.idea")).toString();
        this.pluginSources = new LinkedHashSet();
    }

    public static final /* synthetic */ String access$getCacheDirectoryPath$p(PluginDependencyManager $this) {
        return $this.cacheDirectoryPath;
    }

    public static final /* synthetic */ IdeaDependency access$getIdeaDependency$p(PluginDependencyManager $this) {
        return $this.ideaDependency;
    }
}

