/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.IntelliJPluginConstants;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IdeaDependencyManager;
import org.jetbrains.intellij.dependency.IdeaExtraDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.JpsIdeaDependency;
import org.jetbrains.intellij.dependency.LocalIdeaDependency;
import org.jetbrains.intellij.model.AndroidStudioReleases;
import org.jetbrains.intellij.model.Download;
import org.jetbrains.intellij.model.Item;
import org.jetbrains.intellij.model.XmlExtractor;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b&\u0018\u00002\u00020\u0001:\u00019B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJR\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020 H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J,\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\"\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010,\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00032\b\u0010.\u001a\u0004\u0018\u00010\u0003J4\u0010/\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u00100\u001a\u00020 2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u001a\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\"\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0002J(\u00107\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u00108\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependencyManager;", "", "repositoryUrl", "", "ideaDependencyCachePath", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "mainDependencies", "", "createDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "name", "type", "version", "buildNumber", "classesDirectory", "Ljava/io/File;", "sourcesDirectory", "project", "Lorg/gradle/api/Project;", "extraDependencies", "", "Lorg/jetbrains/intellij/dependency/IdeaExtraDependency;", "getOrCreateIvyXml", "dependency", "getZipCacheDirectory", "zipFile", "hasKotlinDependency", "", "isCacheUpToDate", "markerFile", "checkVersion", "register", "", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "resetExecutablePermissions", "cacheDirectory", "resolveExtraDependencies", "resolveExtraDependency", "resolveLocal", "localPath", "localPathSources", "resolveRemote", "sources", "resolveSources", "setExecutable", "parent", "child", "storeCache", "directoryToCache", "unzipDependencyFile", "checkVersionChange", "RemoteIdeaDependency", "gradle-intellij-plugin"})
public abstract class IdeaDependencyManager {
    private final List<String> mainDependencies;
    private final String repositoryUrl;
    private final String ideaDependencyCachePath;
    private final ArchiveUtils archiveUtils;
    private final DependenciesDownloader dependenciesDownloader;
    private final String context;

    public final void register(@NotNull Project project, @NotNull IdeaDependency dependency, @NotNull DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        File ivyFile = this.getOrCreateIvyXml(dependency);
        String string = ivyFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ivyFile.name");
        String string2 = string;
        int n = (dependency.getName() + '-' + dependency.getVersion()).length();
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String ivyFileSuffix = StringsKt.removeSuffix((String)string3, (CharSequence)".xml");
        project.getRepositories().ivy(new Action(dependency, ivyFile, ivyFileSuffix){
            final /* synthetic */ IdeaDependency $dependency;
            final /* synthetic */ File $ivyFile;
            final /* synthetic */ String $ivyFileSuffix;

            public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$receiver");
                $this$ivy.setUrl(this.$dependency.getClasses().toURI());
                $this$ivy.ivyPattern(this.$ivyFile.getParent() + "/[module]-[revision]" + this.$ivyFileSuffix + ".[ext]");
                $this$ivy.artifactPattern(this.$dependency.getClasses().getPath() + "/[artifact].[ext]");
                if (this.$dependency.getSources() != null) {
                    $this$ivy.artifactPattern(this.$dependency.getSources().getParent() + "/[artifact]-[revision]-[classifier].[ext]");
                }
            }
            {
                this.$dependency = ideaDependency;
                this.$ivyFile = file;
                this.$ivyFileSuffix = string;
            }
        });
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        dependencies.add((Object)DependencyHandlerExtensionsKt.create$default((DependencyHandler)dependencyHandler, (String)"com.jetbrains", (String)dependency.getName(), (String)dependency.getVersion(), (String)"compile", null, null, (int)48, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IdeaDependency createDependency(String name, String type, String version2, String buildNumber2, File classesDirectory2, File sourcesDirectory, Project project, Collection<IdeaExtraDependency> extraDependencies) {
        IdeaDependency ideaDependency;
        String string = type;
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 73677: {
                    if (!string2.equals("JPS")) break;
                    ideaDependency = new JpsIdeaDependency(version2, buildNumber2, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), this.context);
                    return ideaDependency;
                }
            }
        }
        BuiltinPluginsRegistry pluginsRegistry = BuiltinPluginsRegistry.Companion.fromDirectory(new File(classesDirectory2, "plugins"), this.context);
        String string3 = type;
        if (string3 == null) {
            ideaDependency = new LocalIdeaDependency(name, version2, buildNumber2, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies);
            return ideaDependency;
        }
        ideaDependency = new IdeaDependency(name, version2, buildNumber2, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies);
        return ideaDependency;
    }

    private final File resolveSources(String version2, String type) {
        Utils.info$default(this.context, "Adding IDE sources repository", null, 4, null);
        try {
            String releaseType = Utils.releaseType(version2);
            boolean forPyCharm = Utils.isPyCharmType(type);
            List sourcesFiles2 = DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, this.context, (Function1)new Function1<DependencyHandler, Dependency>(forPyCharm, version2){
                final /* synthetic */ boolean $forPyCharm;
                final /* synthetic */ String $version;

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)(this.$forPyCharm ? "com.jetbrains.intellij.pycharm" : "com.jetbrains.intellij.idea"), (String)(this.$forPyCharm ? "pycharmPC" : "ideaIC"), (String)this.$version, null, (String)"sources", (String)"jar", (int)8, null);
                }
                {
                    this.$forPyCharm = bl;
                    this.$version = string;
                    super(1);
                }
            }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (ArtifactRepository)DependenciesDownloaderKt.mavenRepository$default($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + '/' + this.$releaseType, null, 2, null);
                }
                {
                    this.this$0 = ideaDependencyManager;
                    this.$releaseType = string;
                    super(1);
                }
            }, false, 8, null);
            if (sourcesFiles2.size() == 1) {
                File sourcesDirectory = (File)CollectionsKt.first((List)sourcesFiles2);
                Utils.debug$default(this.context, "IDE sources jar: " + sourcesDirectory.getPath(), null, 4, null);
                return sourcesDirectory;
            }
            Utils.warn$default(this.context, "Cannot attach IDE sources. Found files: " + sourcesFiles2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE sources dependency", e);
        }
        return null;
    }

    private final File unzipDependencyFile(File cacheDirectory, File zipFile, String type, boolean checkVersionChange) {
        String string = zipFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zipFile\n                .name");
        return this.archiveUtils.extract(zipFile, FilesKt.resolve((File)cacheDirectory, (String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)".zip"), (CharSequence)".tar.gz")), this.context, new Predicate(this, zipFile, checkVersionChange){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ File $zipFile;
            final /* synthetic */ boolean $checkVersionChange;

            public final boolean test(@NotNull File markerFile) {
                Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
                return IdeaDependencyManager.access$isCacheUpToDate(this.this$0, this.$zipFile, markerFile, this.$checkVersionChange);
            }
            {
                this.this$0 = ideaDependencyManager;
                this.$zipFile = file;
                this.$checkVersionChange = bl;
            }
        }, new BiConsumer(this, type){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ String $type;

            public final void accept(@NotNull File unzippedDirectory, @NotNull File markerFile) {
                Intrinsics.checkNotNullParameter((Object)unzippedDirectory, (String)"unzippedDirectory");
                Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
                IdeaDependencyManager.access$resetExecutablePermissions(this.this$0, unzippedDirectory, this.$type);
                IdeaDependencyManager.access$storeCache(this.this$0, unzippedDirectory, markerFile);
            }
            {
                this.this$0 = ideaDependencyManager;
                this.$type = string;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isCacheUpToDate(File zipFile, File markerFile, boolean checkVersion) {
        if (!checkVersion) {
            return markerFile.exists();
        }
        if (!markerFile.exists()) {
            return false;
        }
        Closeable closeable = new ZipFile(zipFile);
        Throwable throwable = null;
        try {
            String string;
            ZipEntry zipEntry;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            if (zip.getEntry("build.txt") == null) {
                boolean bl2 = false;
                return bl2;
            }
            ZipEntry entry = zipEntry;
            Closeable closeable2 = zip.getInputStream(entry);
            Throwable throwable2 = null;
            try {
                InputStream it = (InputStream)closeable2;
                boolean bl3 = false;
                InputStream inputStream = it;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader(inputStream2, charset);
                int n = 8192;
                string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String entryContent = string;
            if (Intrinsics.areEqual((Object)entryContent, (Object)FilesKt.readText$default((File)markerFile, null, (int)1, null)) ^ true) {
                boolean bl4 = false;
                return bl4;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    private final void storeCache(File directoryToCache, File markerFile) {
        block0: {
            File file;
            File p1 = file = new File(directoryToCache, "build.txt");
            boolean bl = false;
            File file2 = p1.exists() ? file : null;
            if (file2 == null) break block0;
            File it = file = file2;
            boolean bl2 = false;
            String string = FilesKt.readText$default((File)it, null, (int)1, null);
            FilesKt.writeText$default((File)markerFile, (String)((Object)StringsKt.trim((CharSequence)string)).toString(), null, (int)2, null);
        }
    }

    private final void resetExecutablePermissions(File cacheDirectory, String type) {
        if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            if (!operatingSystem.isWindows()) {
                for (File file : FilesKt.walkTopDown((File)cacheDirectory)) {
                    if (!file.isFile() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"dylib") && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"py") && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"sh") && !StringsKt.startsWith$default((String)FilesKt.getExtension((File)file), (String)"so", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)file.getName(), (Object)"dotnet") && !Intrinsics.areEqual((Object)file.getName(), (Object)"env-wrapper") && !Intrinsics.areEqual((Object)file.getName(), (Object)"mono-sgen") && !Intrinsics.areEqual((Object)file.getName(), (Object)"BridgeService") && !Intrinsics.areEqual((Object)file.getName(), (Object)"JetBrains.Profiler.PdbServer") && !Intrinsics.areEqual((Object)file.getName(), (Object)"JBDeviceService") && !Intrinsics.areEqual((Object)file.getName(), (Object)"Rider.Backend")) continue;
                    String string = FilesKt.relativeTo((File)file, (File)cacheDirectory).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.relativeTo(cacheDirectory).toString()");
                    this.setExecutable(cacheDirectory, string, this.context);
                }
            }
        }
    }

    private final void setExecutable(File parent, String child, String context) {
        File file;
        File $this$apply = file = new File(parent, child);
        boolean bl = false;
        Utils.debug$default(context, "Resetting executable permissions for: " + $this$apply.getPath(), null, 4, null);
        $this$apply.setExecutable(true, true);
    }

    private final File getOrCreateIvyXml(IdeaDependency dependency) {
        File ivyFile;
        File directory = dependency.getIvyRepositoryDirectory();
        File file = ivyFile = directory != null ? new File(directory, dependency.getFqn() + ".xml") : File.createTempFile(dependency.getFqn(), ".xml");
        if (directory == null || !ivyFile.exists()) {
            IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator;
            DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity("com.jetbrains", dependency.getName(), dependency.getVersion());
            IntelliJIvyDescriptorFileGenerator $this$apply = intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity);
            boolean bl = false;
            $this$apply.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
            $this$apply.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("compile"));
            $this$apply.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("sources"));
            Iterable $this$forEach$iv = dependency.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                $this$apply.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, "compile", dependency.getClasses(), null));
            }
            if (dependency.getSources() != null) {
                IntellijIvyArtifact intellijIvyArtifact;
                String name = Utils.isDependencyOnPyCharm(dependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact $this$apply2 = intellijIvyArtifact = new IntellijIvyArtifact(dependency.getSources(), name, "jar", "sources", "sources");
                boolean bl3 = false;
                $this$apply2.setConf("sources");
                $this$apply.addArtifact($this$apply2);
            }
            File file2 = ivyFile;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"ivyFile");
            $this$apply.writeTo(file2);
        }
        File file3 = ivyFile;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"ivyFile");
        return file3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasKotlinDependency(Project project) {
        boolean bl;
        Configuration configuration = project.getConfigurations().getByName("runtimeClasspath");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026SPATH_CONFIGURATION_NAME)");
        DependencySet dependencySet = configuration.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"project.configurations.g\u2026         .allDependencies");
        Iterable $this$any$iv = (Iterable)dependencySet;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Dependency it = (Dependency)element$iv;
            boolean bl2 = false;
            Dependency dependency = it;
            Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"it");
            if (Intrinsics.areEqual((Object)"org.jetbrains.kotlin", (Object)dependency.getGroup())) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (Utils.isKotlinRuntime(string)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public final IdeaDependency resolveRemote(@NotNull Project project, @NotNull String version2, @NotNull String type, boolean sources, @NotNull List<String> extraDependencies) {
        RemoteIdeaDependency remoteIdeaDependency2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(extraDependencies, (String)"extraDependencies");
        String releaseType = Utils.releaseType(version2);
        Utils.debug$default(this.context, "Adding IDE repository: " + this.repositoryUrl + '/' + releaseType, null, 4, null);
        Utils.debug$default(this.context, "Adding IDE dependency", null, 4, null);
        if (Intrinsics.areEqual((Object)type, (Object)"IU")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.idea", "ideaIU", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"IC")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.idea", "ideaIC", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"CL")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.clion", "clion", null, null, null, 28, null);
        } else if (Utils.isPyCharmType(type)) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.pycharm", "pycharm" + type, null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"GO")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.goland", "goland", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"PS")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.phpstorm", "phpstorm", null, null, null, 28, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.intellij.rider", "riderRD", !Utils.ifFalse(sources && Intrinsics.areEqual((Object)releaseType, (Object)"snapshots"), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ IdeaDependencyManager this$0;

                public final void invoke() {
                    Utils.warn$default(IdeaDependencyManager.access$getContext$p(this.this$0), "IDE sources are not available for Rider SNAPSHOTS", null, 4, null);
                }
                {
                    this.this$0 = ideaDependencyManager;
                    super(0);
                }
            })), null, null, 24, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"GW")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.jetbrains.gateway", "JetBrainsGateway", false, null, null, 24, null);
        } else if (Intrinsics.areEqual((Object)type, (Object)"AI")) {
            remoteIdeaDependency2 = new RemoteIdeaDependency("com.google.android.studio", "android-studio", false, "tar.gz", (Function1<? super File, Unit>)((Function1)resolveRemote.remoteIdeaDependency.2.INSTANCE));
        } else {
            throw (Throwable)new BuildException("Specified type '" + type + "' is unknown. Supported values: " + CollectionsKt.joinToString$default((Iterable)IntelliJPluginConstants.INSTANCE.getPLATFORM_TYPES(), null, null, null, (int)0, null, null, (int)63, null), null);
        }
        RemoteIdeaDependency remoteIdeaDependency3 = remoteIdeaDependency2;
        Object object = CollectionsKt.first((List)DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, this.context, (Function1)new Function1<DependencyHandler, Dependency>(remoteIdeaDependency3, version2){
            final /* synthetic */ RemoteIdeaDependency $remoteIdeaDependency;
            final /* synthetic */ String $version;

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)this.$remoteIdeaDependency.getGroup(), (String)this.$remoteIdeaDependency.getName(), (String)this.$version, null, null, (String)this.$remoteIdeaDependency.getArtifactExtension(), (int)24, null);
            }
            {
                this.$remoteIdeaDependency = remoteIdeaDependency2;
                this.$version = string;
                super(1);
            }
        }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, type, version2, releaseType){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ String $type;
            final /* synthetic */ String $version;
            final /* synthetic */ String $releaseType;

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                var2_2 = this.$type;
                switch (var2_2.hashCode()) {
                    case 2088: {
                        if (!var2_2.equals("AI")) ** GOTO lbl41
                        v0 = new XmlExtractor<T>(IdeaDependencyManager.access$getContext$p(this.this$0));
                        v1 = DependenciesDownloaderKt.getAndroidStudioReleases(IdeaDependencyManager.access$getDependenciesDownloader$p(this.this$0), IdeaDependencyManager.access$getContext$p(this.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"dependenciesDownloader.g\u2026idStudioReleases(context)");
                        v2 = (AndroidStudioReleases)v0.fetch(v1);
                        if (v2 == null) {
                            throw (Throwable)new GradleException("Cannot resolve Android Studio Releases list");
                        }
                        androidStudioReleases = v2;
                        var6_5 = var5_4 = (Iterable)androidStudioReleases.getItems();
                        for (Object var8_7 : var6_5) {
                            it = (Item)var8_7;
                            $i$a$-find-IdeaDependencyManager$resolveRemote$classesDirectory$2$release$1 = false;
                            if (!(Intrinsics.areEqual((Object)it.getVersion(), (Object)this.$version) != false || Intrinsics.areEqual((Object)it.getBuild(), (Object)("AI-" + this.$version)) != false)) continue;
                            v3 = var8_7;
                            ** GOTO lbl21
                        }
                        v3 = null;
lbl21:
                        // 2 sources

                        v4 = (Item)v3;
                        if (v4 == null) {
                            throw (Throwable)new GradleException("Cannot resolve Android Studio with provided version: " + this.$version);
                        }
                        release = v4;
                        var6_5 = release.getDownloads();
                        var7_6 = var6_5;
                        var8_7 = var7_6.iterator();
                        while (var8_7.hasNext()) {
                            var9_8 = var8_7.next();
                            it = (Download)var9_8;
                            $i$a$-find-IdeaDependencyManager$resolveRemote$classesDirectory$2$url$1 = false;
                            if (!StringsKt.endsWith$default((String)it.getLink(), (String)"-linux.tar.gz", (boolean)false, (int)2, null)) continue;
                            v5 = var9_8;
                            ** GOTO lbl36
                        }
                        v5 = null;
lbl36:
                        // 2 sources

                        if ((v6 = (Download)v5) == null || (v6 = v6.getLink()) == null) {
                            throw (Throwable)new GradleException("Cannot resolve Android Studio with provided version: " + this.$version);
                        }
                        url = v6;
                        v7 = (ArtifactRepository)DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, (String)url, null, null, 6, null);
                        break;
                    }
lbl41:
                    // 2 sources

                    default: {
                        v7 = (ArtifactRepository)DependenciesDownloaderKt.mavenRepository$default($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + '/' + this.$releaseType, null, 2, null);
                    }
                }
                return v7;
            }
            {
                this.this$0 = ideaDependencyManager;
                this.$type = string;
                this.$version = string2;
                this.$releaseType = string3;
                super(1);
            }
        }, false, 8, null));
        File it = (File)object;
        boolean bl = false;
        Utils.debug$default(this.context, "IDE zip: " + it.getPath(), null, 4, null);
        File file = this.unzipDependencyFile(this.getZipCacheDirectory(it, project, type), it, type, StringsKt.endsWith$default((String)version2, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
        Function1<File, Unit> function1 = remoteIdeaDependency3.getPostProcess();
        function1.invoke((Object)file);
        File classesDirectory2 = file;
        Utils.info$default(this.context, "IDE dependency cache directory: " + classesDirectory2, null, 4, null);
        String buildNumber2 = Utils.ideBuildNumber(classesDirectory2);
        Boolean bl2 = remoteIdeaDependency3.getHasSources();
        File sourcesDirectory = (bl2 != null ? bl2 : sources) ? this.resolveSources(version2, type) : null;
        Collection<IdeaExtraDependency> resolvedExtraDependencies = this.resolveExtraDependencies(project, version2, extraDependencies);
        return this.createDependency(remoteIdeaDependency3.getName(), type, version2, buildNumber2, classesDirectory2, sourcesDirectory, project, resolvedExtraDependencies);
    }

    @NotNull
    public final IdeaDependency resolveLocal(@NotNull Project project, @NotNull String localPath, @Nullable String localPathSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Utils.debug$default(this.context, "Adding local IDE dependency", null, 4, null);
        File ideaDir = Utils.ideaDir(localPath);
        if (!ideaDir.exists() || !ideaDir.isDirectory()) {
            throw (Throwable)new BuildException("Specified localPath '" + localPath + "' doesn't exist or is not a directory", null);
        }
        String buildNumber2 = Utils.ideBuildNumber(ideaDir);
        CharSequence charSequence = localPathSources;
        File sources = !(charSequence == null || charSequence.length() == 0) ? new File(localPathSources) : null;
        return this.createDependency("ideaLocal", null, buildNumber2, buildNumber2, ideaDir, sources, project, CollectionsKt.emptyList());
    }

    private final File getZipCacheDirectory(File zipFile, Project project, String type) {
        Object object = this.ideaDependencyCachePath;
        if (object.length() > 0) {
            Object $this$apply = object = new File(this.ideaDependencyCachePath);
            boolean bl = false;
            ((File)$this$apply).mkdirs();
            return object;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            if (operatingSystem.isWindows()) {
                File file = project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                return file;
            }
        }
        File file = zipFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"zipFile.parentFile");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<IdeaExtraDependency> resolveExtraDependencies(Project project, String version2, List<String> extraDependencies) {
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        if (extraDependencies.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Utils.info$default(this.context, "Configuring IDE extra dependencies: " + extraDependencies, null, 4, null);
        Iterable iterable = extraDependencies;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                String dep = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = this.mainDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)dep)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        Collection collection = it;
        List list2 = !collection.isEmpty() ? $this$filter$iv : null;
        if (list2 != null) {
            it = $this$filter$iv = list2;
            boolean bl4 = false;
            throw (Throwable)new GradleException("The items '" + it + "' cannot be used as extra dependencies");
        }
        List resolvedExtraDependencies = new ArrayList();
        Iterable $this$forEach$iv = extraDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl5 = false;
            if (this.resolveExtraDependency(project, version2, it2) != null) {
                File file;
                File dependencyFile = file;
                boolean bl6 = false;
                IdeaExtraDependency extraDependency = new IdeaExtraDependency(it2, dependencyFile);
                Utils.debug$default(this.context, "IDE extra dependency '" + it2 + "' in '" + dependencyFile + "' files: " + extraDependency.getJarFiles(), null, 4, null);
                resolvedExtraDependencies.add(extraDependency);
                continue;
            }
            Utils.debug$default(this.context, "IDE extra dependency for '" + it2 + "' was resolved as null", null, 4, null);
        }
        return resolvedExtraDependencies;
    }

    private final File resolveExtraDependency(Project project, String version2, String name) {
        try {
            String releaseType = Utils.releaseType(version2);
            List files2 = DependenciesDownloader.downloadFromRepository$default(this.dependenciesDownloader, this.context, (Function1)new Function1<DependencyHandler, Dependency>(name, version2){
                final /* synthetic */ String $name;
                final /* synthetic */ String $version;

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains.intellij.idea", (String)this.$name, (String)this.$version, null, null, null, (int)56, null);
                }
                {
                    this.$name = string;
                    this.$version = string2;
                    super(1);
                }
            }, (Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (ArtifactRepository)DependenciesDownloaderKt.mavenRepository$default($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + '/' + this.$releaseType, null, 2, null);
                }
                {
                    this.this$0 = ideaDependencyManager;
                    this.$releaseType = string;
                    super(1);
                }
            }, false, 8, null);
            if (files2.size() == 1) {
                File file;
                File dependencyFile = (File)CollectionsKt.first((List)files2);
                Path dependency = dependencyFile.toPath();
                Path path = dependency;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dependency");
                if (FileUtilKt.isZip((Path)path)) {
                    File cacheDirectory = this.getZipCacheDirectory(dependencyFile, project, "IC");
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + cacheDirectory.getPath(), null, 4, null);
                    file = this.unzipDependencyFile(cacheDirectory, dependencyFile, "IC", StringsKt.endsWith$default((String)version2, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
                } else {
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + dependencyFile.getPath(), null, 4, null);
                    file = dependencyFile;
                }
                return file;
            }
            Utils.warn$default(this.context, "Cannot attach IDE extra dependency '" + name + "'. Found files: " + files2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE extra dependency '" + name + '\'', e);
        }
        return null;
    }

    @Inject
    public IdeaDependencyManager(@NotNull String repositoryUrl, @NotNull String ideaDependencyCachePath, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)ideaDependencyCachePath, (String)"ideaDependencyCachePath");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.repositoryUrl = repositoryUrl;
        this.ideaDependencyCachePath = ideaDependencyCachePath;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        this.mainDependencies = CollectionsKt.listOf((Object[])new String[]{"ideaIC", "ideaIU", "riderRD", "riderRS"});
    }

    public static final /* synthetic */ String access$getRepositoryUrl$p(IdeaDependencyManager $this) {
        return $this.repositoryUrl;
    }

    public static final /* synthetic */ boolean access$isCacheUpToDate(IdeaDependencyManager $this, File zipFile, File markerFile, boolean checkVersion) {
        return $this.isCacheUpToDate(zipFile, markerFile, checkVersion);
    }

    public static final /* synthetic */ void access$resetExecutablePermissions(IdeaDependencyManager $this, File cacheDirectory, String type) {
        $this.resetExecutablePermissions(cacheDirectory, type);
    }

    public static final /* synthetic */ void access$storeCache(IdeaDependencyManager $this, File directoryToCache, File markerFile) {
        $this.storeCache(directoryToCache, markerFile);
    }

    public static final /* synthetic */ String access$getContext$p(IdeaDependencyManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ DependenciesDownloader access$getDependenciesDownloader$p(IdeaDependencyManager $this) {
        return $this.dependenciesDownloader;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0003JN\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependencyManager$RemoteIdeaDependency;", "", "group", "", "name", "hasSources", "", "artifactExtension", "postProcess", "Lkotlin/Function1;", "Ljava/io/File;", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getArtifactExtension", "()Ljava/lang/String;", "getGroup", "getHasSources", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getName", "getPostProcess", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/intellij/dependency/IdeaDependencyManager$RemoteIdeaDependency;", "equals", "other", "hashCode", "", "toString", "gradle-intellij-plugin"})
    private static final class RemoteIdeaDependency {
        @NotNull
        private final String group;
        @NotNull
        private final String name;
        @Nullable
        private final Boolean hasSources;
        @NotNull
        private final String artifactExtension;
        @NotNull
        private final Function1<File, Unit> postProcess;

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Boolean getHasSources() {
            return this.hasSources;
        }

        @NotNull
        public final String getArtifactExtension() {
            return this.artifactExtension;
        }

        @NotNull
        public final Function1<File, Unit> getPostProcess() {
            return this.postProcess;
        }

        public RemoteIdeaDependency(@NotNull String group, @NotNull String name, @Nullable Boolean hasSources, @NotNull String artifactExtension, @NotNull Function1<? super File, Unit> postProcess) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)artifactExtension, (String)"artifactExtension");
            Intrinsics.checkNotNullParameter(postProcess, (String)"postProcess");
            this.group = group;
            this.name = name;
            this.hasSources = hasSources;
            this.artifactExtension = artifactExtension;
            this.postProcess = postProcess;
        }

        public /* synthetic */ RemoteIdeaDependency(String string, String string2, Boolean bl, String string3, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = null;
            }
            if ((n & 8) != 0) {
                string3 = "zip";
            }
            if ((n & 0x10) != 0) {
                function1 = 1.INSTANCE;
            }
            this(string, string2, bl, string3, (Function1<? super File, Unit>)function1);
        }

        @NotNull
        public final String component1() {
            return this.group;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final Boolean component3() {
            return this.hasSources;
        }

        @NotNull
        public final String component4() {
            return this.artifactExtension;
        }

        @NotNull
        public final Function1<File, Unit> component5() {
            return this.postProcess;
        }

        @NotNull
        public final RemoteIdeaDependency copy(@NotNull String group, @NotNull String name, @Nullable Boolean hasSources, @NotNull String artifactExtension, @NotNull Function1<? super File, Unit> postProcess) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)artifactExtension, (String)"artifactExtension");
            Intrinsics.checkNotNullParameter(postProcess, (String)"postProcess");
            return new RemoteIdeaDependency(group, name, hasSources, artifactExtension, postProcess);
        }

        public static /* synthetic */ RemoteIdeaDependency copy$default(RemoteIdeaDependency remoteIdeaDependency2, String string, String string2, Boolean bl, String string3, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = remoteIdeaDependency2.group;
            }
            if ((n & 2) != 0) {
                string2 = remoteIdeaDependency2.name;
            }
            if ((n & 4) != 0) {
                bl = remoteIdeaDependency2.hasSources;
            }
            if ((n & 8) != 0) {
                string3 = remoteIdeaDependency2.artifactExtension;
            }
            if ((n & 0x10) != 0) {
                function1 = remoteIdeaDependency2.postProcess;
            }
            return remoteIdeaDependency2.copy(string, string2, bl, string3, function1);
        }

        @NotNull
        public String toString() {
            return "RemoteIdeaDependency(group=" + this.group + ", name=" + this.name + ", hasSources=" + this.hasSources + ", artifactExtension=" + this.artifactExtension + ", postProcess=" + this.postProcess + ")";
        }

        public int hashCode() {
            String string = this.group;
            String string2 = this.name;
            Boolean bl = this.hasSources;
            String string3 = this.artifactExtension;
            Function1<File, Unit> function1 = this.postProcess;
            return ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (bl != null ? ((Object)bl).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (function1 != null ? function1.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RemoteIdeaDependency)) break block3;
                    RemoteIdeaDependency remoteIdeaDependency2 = (RemoteIdeaDependency)object;
                    if (!Intrinsics.areEqual((Object)this.group, (Object)remoteIdeaDependency2.group) || !Intrinsics.areEqual((Object)this.name, (Object)remoteIdeaDependency2.name) || !Intrinsics.areEqual((Object)this.hasSources, (Object)remoteIdeaDependency2.hasSources) || !Intrinsics.areEqual((Object)this.artifactExtension, (Object)remoteIdeaDependency2.artifactExtension) || !Intrinsics.areEqual(this.postProcess, remoteIdeaDependency2.postProcess)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

