/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.xml.SimpleXmlWriter;
import org.gradle.internal.xml.XmlTransformer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\u00020\u0012*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\u0012*\u00020\u001fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator;", "", "projectIdentity", "Lorg/gradle/api/publish/ivy/internal/publisher/IvyPublicationIdentity;", "(Lorg/gradle/api/publish/ivy/internal/publisher/IvyPublicationIdentity;)V", "artifacts", "", "Lorg/gradle/api/publish/ivy/IvyArtifact;", "configurations", "Lorg/gradle/api/publish/ivy/IvyConfiguration;", "ivyDateFormat", "Ljava/text/SimpleDateFormat;", "ivyDatePattern", "", "ivyFileEncoding", "xmlTransformer", "Lorg/gradle/internal/xml/XmlTransformer;", "addArtifact", "", "ivyArtifact", "addConfiguration", "ivyConfiguration", "usesClassifier", "", "writeDescriptor", "writer", "Ljava/io/Writer;", "writeTo", "file", "Ljava/io/File;", "writeConfigurations", "Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$OptionalAttributeXmlWriter;", "writePublications", "OptionalAttributeXmlWriter", "gradle-intellij-plugin"})
public final class IntelliJIvyDescriptorFileGenerator {
    private final String ivyFileEncoding;
    private final String ivyDatePattern;
    private final SimpleDateFormat ivyDateFormat;
    private final XmlTransformer xmlTransformer;
    private final List<IvyConfiguration> configurations;
    private final List<IvyArtifact> artifacts;
    private final IvyPublicationIdentity projectIdentity;

    public final void addConfiguration(@NotNull IvyConfiguration ivyConfiguration) {
        Intrinsics.checkNotNullParameter((Object)ivyConfiguration, (String)"ivyConfiguration");
        this.configurations.add(ivyConfiguration);
    }

    public final void addArtifact(@NotNull IvyArtifact ivyArtifact) {
        Intrinsics.checkNotNullParameter((Object)ivyArtifact, (String)"ivyArtifact");
        this.artifacts.add(ivyArtifact);
    }

    public final void writeTo(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.xmlTransformer.transform(file, this.ivyFileEncoding, new Action(this){
            final /* synthetic */ IntelliJIvyDescriptorFileGenerator this$0;

            public final void execute(@NotNull Writer $this$transform) {
                Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"$receiver");
                try {
                    IntelliJIvyDescriptorFileGenerator.access$writeDescriptor(this.this$0, $this$transform);
                }
                catch (IOException e) {
                    throw (Throwable)new UncheckedIOException(e);
                }
            }
            {
                this.this$0 = intelliJIvyDescriptorFileGenerator;
            }
        });
    }

    private final void writeDescriptor(Writer writer) throws IOException {
        OptionalAttributeXmlWriter optionalAttributeXmlWriter;
        OptionalAttributeXmlWriter $this$run = optionalAttributeXmlWriter = new OptionalAttributeXmlWriter(writer, "  ", this.ivyFileEncoding);
        boolean bl = false;
        $this$run.startElement("ivy-module").attribute("version", "2.0");
        if (this.usesClassifier()) {
            $this$run.attribute("xmlns:m", "https://ant.apache.org/ivy/maven");
        }
        $this$run.startElement("info").attribute("organisation", this.projectIdentity.getOrganisation()).attribute("module", this.projectIdentity.getModule()).attribute("revision", this.projectIdentity.getRevision()).attribute("publication", this.ivyDateFormat.format(new Date()));
        $this$run.endElement();
        this.writeConfigurations($this$run);
        this.writePublications($this$run);
        $this$run.endElement();
    }

    private final boolean usesClassifier() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.artifacts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IvyArtifact it = (IvyArtifact)element$iv;
                    boolean bl2 = false;
                    if (!(it.getClassifier() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void writeConfigurations(OptionalAttributeXmlWriter $this$writeConfigurations) throws IOException {
        $this$writeConfigurations.startElement("configurations");
        Iterable $this$forEach$iv = this.configurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IvyConfiguration it = (IvyConfiguration)element$iv;
            boolean bl = false;
            $this$writeConfigurations.startElement("conf").attribute("name", it.getName()).attribute("visibility", "public");
            if (it.getExtends().size() > 0) {
                Set set = it.getExtends();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.extends");
                $this$writeConfigurations.attribute("extends", CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            $this$writeConfigurations.endElement();
        }
        $this$writeConfigurations.endElement();
    }

    private final void writePublications(OptionalAttributeXmlWriter $this$writePublications) throws IOException {
        $this$writePublications.startElement("publications");
        Iterable $this$forEach$iv = this.artifacts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IvyArtifact it = (IvyArtifact)element$iv;
            boolean bl = false;
            $this$writePublications.startElement("artifact").attribute("name", it.getName()).attribute("type", it.getType()).attribute("ext", it.getExtension()).attribute("conf", it.getConf()).attribute("m:classifier", it.getClassifier()).endElement();
        }
        $this$writePublications.endElement();
    }

    public IntelliJIvyDescriptorFileGenerator(@NotNull IvyPublicationIdentity projectIdentity) {
        Intrinsics.checkNotNullParameter((Object)projectIdentity, (String)"projectIdentity");
        this.projectIdentity = projectIdentity;
        this.ivyFileEncoding = "UTF-8";
        this.ivyDatePattern = "yyyyMMddHHmmss";
        this.ivyDateFormat = new SimpleDateFormat(this.ivyDatePattern);
        this.xmlTransformer = new XmlTransformer();
        this.configurations = new ArrayList();
        this.artifacts = new ArrayList();
    }

    public static final /* synthetic */ void access$writeDescriptor(IntelliJIvyDescriptorFileGenerator $this, Writer writer) {
        $this.writeDescriptor(writer);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u000b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/intellij/IntelliJIvyDescriptorFileGenerator$OptionalAttributeXmlWriter;", "Lorg/gradle/internal/xml/SimpleXmlWriter;", "writer", "Ljava/io/Writer;", "indent", "", "encoding", "(Ljava/io/Writer;Ljava/lang/String;Ljava/lang/String;)V", "attribute", "name", "value", "startElement", "gradle-intellij-plugin"})
    public static final class OptionalAttributeXmlWriter
    extends SimpleXmlWriter {
        @NotNull
        public OptionalAttributeXmlWriter startElement(@Nullable String name) {
            super.startElement(name);
            return this;
        }

        @NotNull
        public OptionalAttributeXmlWriter attribute(@Nullable String name, @Nullable String value) {
            if (value != null) {
                super.attribute(name, value);
            }
            return this;
        }

        public OptionalAttributeXmlWriter(@NotNull Writer writer, @NotNull String indent, @NotNull String encoding) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            super(writer, indent, encoding);
        }
    }
}

